/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.table.utils.TypeStringUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class DescriptorProperties {
    public static final String TABLE_SCHEMA_NAME = "name";
    public static final String TABLE_SCHEMA_TYPE = "type";
    private static final Consumer<String> EMPTY_CONSUMER = value -> {};
    private final boolean normalizeKeys;
    private final Map<String, String> properties = new HashMap<String, String>();

    public DescriptorProperties(boolean normalizeKeys) {
        this.normalizeKeys = normalizeKeys;
    }

    public DescriptorProperties() {
        this(true);
    }

    public void putProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.put(property.getKey(), property.getValue());
        }
    }

    public void putProperties(DescriptorProperties otherProperties) {
        for (Map.Entry<String, String> otherProperty : otherProperties.properties.entrySet()) {
            this.put(otherProperty.getKey(), otherProperty.getValue());
        }
    }

    public void putClass(String key, Class<?> clazz) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(clazz);
        String error = InstantiationUtil.checkForInstantiationError(clazz);
        if (error != null) {
            throw new ValidationException("Class '" + clazz.getName() + "' is not supported: " + error);
        }
        this.put(key, clazz.getName());
    }

    public void putString(String key, String str) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(str);
        this.put(key, str);
    }

    public void putBoolean(String key, boolean b) {
        Preconditions.checkNotNull(key);
        this.put(key, Boolean.toString(b));
    }

    public void putLong(String key, long l) {
        Preconditions.checkNotNull(key);
        this.put(key, Long.toString(l));
    }

    public void putInt(String key, int i) {
        Preconditions.checkNotNull(key);
        this.put(key, Integer.toString(i));
    }

    public void putCharacter(String key, char c) {
        Preconditions.checkNotNull(key);
        this.put(key, Character.toString(c));
    }

    public void putTableSchema(String key, TableSchema schema2) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(schema2);
        String[] fieldNames = schema2.getFieldNames();
        InternalType[] fieldTypes2 = schema2.getFieldTypes();
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (int i = 0; i < schema2.getFieldCount(); ++i) {
            values.add(Arrays.asList(fieldNames[i], TypeStringUtils.writeDataType(fieldTypes2[i])));
        }
        this.putIndexedFixedProperties(key, Arrays.asList(TABLE_SCHEMA_NAME, TABLE_SCHEMA_TYPE), values);
    }

    public void putMemorySize(String key, MemorySize size) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(size);
        this.put(key, size.toString());
    }

    public void putIndexedFixedProperties(String key, List<String> subKeys, List<List<String>> subKeyValues) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(subKeys);
        Preconditions.checkNotNull(subKeyValues);
        for (int idx = 0; idx < subKeyValues.size(); ++idx) {
            List<String> values = subKeyValues.get(idx);
            if (values == null || values.size() != subKeys.size()) {
                throw new ValidationException("Values must have same arity as keys.");
            }
            for (int keyIdx = 0; keyIdx < values.size(); ++keyIdx) {
                this.put(key + '.' + idx + '.' + subKeys.get(keyIdx), values.get(keyIdx));
            }
        }
    }

    public void putIndexedVariableProperties(String key, List<Map<String, String>> subKeyValues) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(subKeyValues);
        for (int idx = 0; idx < subKeyValues.size(); ++idx) {
            Map<String, String> values = subKeyValues.get(idx);
            for (Map.Entry<String, String> value : values.entrySet()) {
                this.put(key + '.' + idx + '.' + value.getKey(), value.getValue());
            }
        }
    }

    public Optional<String> getOptionalString(String key) {
        return this.optionalGet(key);
    }

    public String getString(String key) {
        return this.getOptionalString(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Character> getOptionalCharacter(String key) {
        return this.optionalGet(key).map(c -> {
            if (c.length() != 1) {
                throw new ValidationException("The value of '" + key + "' must only contain one character.");
            }
            return Character.valueOf(c.charAt(0));
        });
    }

    public Character getCharacter(String key) {
        return this.getOptionalCharacter(key).orElseThrow(this.exceptionSupplier(key));
    }

    public <T> Optional<Class<T>> getOptionalClass(String key, Class<T> superClass) {
        return this.optionalGet(key).map(name -> {
            try {
                Class<?> clazz = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
                if (!superClass.isAssignableFrom(clazz)) {
                    throw new ValidationException("Class '" + name + "' does not extend from the required class '" + superClass.getName() + "' for key '" + key + "'.");
                }
                return clazz;
            }
            catch (Exception e2) {
                throw new ValidationException("Could not get class '" + name + "' for key '" + key + "'.", e2);
            }
        });
    }

    public <T> Class<T> getClass(String key, Class<T> superClass) {
        return this.getOptionalClass(key, superClass).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<BigDecimal> getOptionalBigDecimal(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return new BigDecimal((String)value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid decimal value for key '" + key + "'.", e2);
            }
        });
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getOptionalBigDecimal(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Boolean> getOptionalBoolean(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid boolean value for key '" + key + "'.", e2);
            }
        });
    }

    public boolean getBoolean(String key) {
        return this.getOptionalBoolean(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Byte> getOptionalByte(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Byte.valueOf(value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid byte value for key '" + key + "'.", e2);
            }
        });
    }

    public byte getByte(String key) {
        return this.getOptionalByte(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Double> getOptionalDouble(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Double.valueOf(value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid double value for key '" + key + "'.", e2);
            }
        });
    }

    public double getDouble(String key) {
        return this.getOptionalDouble(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Float> getOptionalFloat(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Float.valueOf(value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid float value for key '" + key + "'.", e2);
            }
        });
    }

    public float getFloat(String key) {
        return this.getOptionalFloat(key).orElseThrow(this.exceptionSupplier(key)).floatValue();
    }

    public Optional<Integer> getOptionalInt(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid integer value for key '" + key + "'.", e2);
            }
        });
    }

    public int getInt(String key) {
        return this.getOptionalInt(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Long> getOptionalLong(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Long.valueOf(value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid long value for key '" + key + "'.", e2);
            }
        });
    }

    public long getLong(String key) {
        return this.getOptionalLong(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Short> getOptionalShort(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Short.valueOf(value);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid short value for key '" + key + "'.", e2);
            }
        });
    }

    public short getShort(String key) {
        return this.getOptionalShort(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<TypeInformation<?>> getOptionalType(String key) {
        return this.optionalGet(key).map(TypeStringUtils::readTypeInfo);
    }

    public TypeInformation<?> getType(String key) {
        return this.getOptionalType(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<TableSchema> getOptionalTableSchema(String key) {
        int fieldCount = this.properties.keySet().stream().filter(k -> k.startsWith(key) && k.endsWith(".name")).mapToInt(k -> 1).sum();
        if (fieldCount == 0) {
            return Optional.empty();
        }
        TableSchema.Builder schemaBuilder = TableSchema.builder();
        for (int i = 0; i < fieldCount; ++i) {
            String nameKey = key + '.' + i + '.' + TABLE_SCHEMA_NAME;
            String typeKey = key + '.' + i + '.' + TABLE_SCHEMA_TYPE;
            String name = this.optionalGet(nameKey).orElseThrow(this.exceptionSupplier(nameKey));
            InternalType type = this.optionalGet(typeKey).map(TypeStringUtils::readDataType).orElseThrow(this.exceptionSupplier(typeKey));
            schemaBuilder.field(name, type);
        }
        return Optional.of(schemaBuilder.build());
    }

    public TableSchema getTableSchema(String key) {
        return this.getOptionalTableSchema(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<MemorySize> getOptionalMemorySize(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return MemorySize.parse(value, MemorySize.MemoryUnit.BYTES);
            }
            catch (Exception e2) {
                throw new ValidationException("Invalid memory size value for key '" + key + "'.", e2);
            }
        });
    }

    public MemorySize getMemorySize(String key) {
        return this.getOptionalMemorySize(key).orElseThrow(this.exceptionSupplier(key));
    }

    public List<Map<String, String>> getFixedIndexedProperties(String key, List<String> subKeys) {
        int maxIndex = this.extractMaxIndex(key, "\\.(.*)");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= maxIndex; ++i) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            for (String subKey : subKeys) {
                String fullKey = key + '.' + i + '.' + subKey;
                if (!this.containsKey(fullKey)) {
                    throw this.exceptionSupplier(fullKey).get();
                }
                map2.put(subKey, fullKey);
            }
            list.add(map2);
        }
        return list;
    }

    public List<Map<String, String>> getVariableIndexedProperties(String key, List<String> requiredSubKeys) {
        int maxIndex = this.extractMaxIndex(key, "(\\.)?(.*)");
        String escapedKey = Pattern.quote(key);
        Pattern pattern = Pattern.compile(escapedKey + "\\.(\\d+)(\\.)?(.*)");
        Set optionalSubKeys = this.properties.keySet().stream().flatMap(k -> {
            Matcher matcher = pattern.matcher((CharSequence)k);
            if (matcher.find()) {
                return Stream.of(matcher.group(3));
            }
            return Stream.empty();
        }).filter(k -> k.length() > 0).collect(Collectors.toSet());
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= maxIndex; ++i) {
            String fullKey;
            HashMap<String, String> map2 = new HashMap<String, String>();
            for (String subKey : requiredSubKeys) {
                fullKey = key + '.' + i + '.' + subKey;
                if (!this.containsKey(fullKey)) {
                    throw this.exceptionSupplier(fullKey).get();
                }
                map2.put(subKey, fullKey);
            }
            for (String subKey : optionalSubKeys) {
                fullKey = key + '.' + i + '.' + subKey;
                this.optionalGet(fullKey).ifPresent(value -> map2.put(subKey, fullKey));
            }
            list.add(map2);
        }
        return list;
    }

    public Map<String, String> getIndexedProperty(String key, String subKey) {
        String escapedKey = Pattern.quote(key);
        String escapedSubKey = Pattern.quote(subKey);
        return this.properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).matches(escapedKey + "\\.\\d+\\." + escapedSubKey)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public <E> Optional<List<E>> getOptionalArray(String key, Function<String, E> keyMapper) {
        int maxIndex = this.extractMaxIndex(key, "");
        if (maxIndex < 0) {
            if (this.containsKey(key)) {
                return Optional.of(Collections.singletonList(keyMapper.apply(key)));
            }
            return Optional.empty();
        }
        ArrayList<E> list = new ArrayList<E>();
        for (int i = 0; i < maxIndex + 1; ++i) {
            String fullKey = key + '.' + i;
            E value = keyMapper.apply(fullKey);
            list.add(value);
        }
        return Optional.of(list);
    }

    public <E> List<E> getArray(String key, Function<String, E> keyMapper) {
        return this.getOptionalArray(key, keyMapper).orElseThrow(this.exceptionSupplier(key));
    }

    public boolean isValue(String key, String value) {
        return this.optionalGet(key).orElseThrow(this.exceptionSupplier(key)).equals(value);
    }

    public void validateString(String key, boolean isOptional) {
        this.validateString(key, isOptional, 0, Integer.MAX_VALUE);
    }

    public void validateString(String key, boolean isOptional, int minLen) {
        this.validateString(key, isOptional, minLen, Integer.MAX_VALUE);
    }

    public void validateString(String key, boolean isOptional, int minLen, int maxLen) {
        this.validateOptional(key, isOptional, value -> {
            int length = value.length();
            if (length < minLen || length > maxLen) {
                throw new ValidationException("Property '" + key + "' must have a length between " + minLen + " and " + maxLen + " but was: " + value);
            }
        });
    }

    public void validateInt(String key, boolean isOptional) {
        this.validateInt(key, isOptional, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void validateInt(String key, boolean isOptional, int min) {
        this.validateInt(key, isOptional, min, Integer.MAX_VALUE);
    }

    public void validateInt(String key, boolean isOptional, int min, int max) {
        this.validateComparable(key, isOptional, min, max, "integer", Integer::valueOf);
    }

    public void validateLong(String key, boolean isOptional) {
        this.validateLong(key, isOptional, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public void validateLong(String key, boolean isOptional, long min) {
        this.validateLong(key, isOptional, min, Long.MAX_VALUE);
    }

    public void validateLong(String key, boolean isOptional, long min, long max) {
        this.validateComparable(key, isOptional, min, max, "long", Long::valueOf);
    }

    public void validateValue(String key, String value, boolean isOptional) {
        this.validateOptional(key, isOptional, v -> {
            if (!v.equals(value)) {
                throw new ValidationException("Could not find required value '" + value + "' for property '" + key + "'.");
            }
        });
    }

    public void validateBoolean(String key, boolean isOptional) {
        this.validateOptional(key, isOptional, value -> {
            if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                throw new ValidationException("Property '" + key + "' must be a boolean value (true/false) but was: " + value);
            }
        });
    }

    public void validateDouble(String key, boolean isOptional) {
        this.validateDouble(key, isOptional, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public void validateDouble(String key, boolean isOptional, double min) {
        this.validateDouble(key, isOptional, min, Double.MAX_VALUE);
    }

    public void validateDouble(String key, boolean isOptional, double min, double max) {
        this.validateComparable(key, isOptional, min, max, "double", Double::valueOf);
    }

    public void validateBigDecimal(String key, boolean isOptional) {
        this.validateOptional(key, isOptional, value -> {
            try {
                new BigDecimal((String)value);
            }
            catch (Exception e2) {
                throw new ValidationException("Property '" + key + "' must be a big decimal value but was: " + value);
            }
        });
    }

    public void validateBigDecimal(String key, boolean isOptional, BigDecimal min, BigDecimal max) {
        this.validateComparable(key, isOptional, min, max, "decimal", BigDecimal::new);
    }

    public void validateByte(String key, boolean isOptional) {
        this.validateByte(key, isOptional, (byte)-128, (byte)127);
    }

    public void validateByte(String key, boolean isOptional, byte min) {
        this.validateByte(key, isOptional, min, (byte)127);
    }

    public void validateByte(String key, boolean isOptional, byte min, byte max) {
        this.validateComparable(key, isOptional, min, max, "byte", Byte::valueOf);
    }

    public void validateFloat(String key, boolean isOptional) {
        this.validateFloat(key, isOptional, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public void validateFloat(String key, boolean isOptional, float min) {
        this.validateFloat(key, isOptional, min, Float.MAX_VALUE);
    }

    public void validateFloat(String key, boolean isOptional, float min, float max) {
        this.validateComparable(key, isOptional, Float.valueOf(min), Float.valueOf(max), "float", Float::valueOf);
    }

    public void validateShort(String key, boolean isOptional) {
        this.validateShort(key, isOptional, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    public void validateShort(String key, boolean isOptional, short min) {
        this.validateShort(key, isOptional, min, (short)Short.MAX_VALUE);
    }

    public void validateShort(String key, boolean isOptional, short min, short max) {
        this.validateComparable(key, isOptional, min, max, "short", Short::valueOf);
    }

    public void validateFixedIndexedProperties(String key, boolean allowEmpty, Map<String, Consumer<String>> subKeyValidation) {
        int maxIndex = this.extractMaxIndex(key, "\\.(.*)");
        if (maxIndex < 0 && !allowEmpty) {
            throw new ValidationException("Property key '" + key + "' must not be empty.");
        }
        for (int i = 0; i < maxIndex; ++i) {
            for (Map.Entry<String, Consumer<String>> subKey : subKeyValidation.entrySet()) {
                String fullKey = key + '.' + i + '.' + subKey.getKey();
                if (this.properties.containsKey(fullKey)) {
                    subKey.getValue().accept(fullKey);
                    continue;
                }
                throw new ValidationException("Required property key '" + fullKey + "' is missing.");
            }
        }
    }

    public void validateTableSchema(String key, boolean isOptional) {
        Consumer<String> nameValidation = name -> this.validateString((String)name, false, 1);
        Consumer<String> typeValidation = name -> this.validateType((String)name, false, false);
        HashMap<String, Consumer<String>> subKeys = new HashMap<String, Consumer<String>>();
        subKeys.put(TABLE_SCHEMA_NAME, nameValidation);
        subKeys.put(TABLE_SCHEMA_TYPE, typeValidation);
        this.validateFixedIndexedProperties(key, isOptional, subKeys);
    }

    public void validateMemorySize(String key, boolean isOptional, int precision) {
        this.validateMemorySize(key, isOptional, precision, 0L, Long.MAX_VALUE);
    }

    public void validateMemorySize(String key, boolean isOptional, int precision, long min) {
        this.validateMemorySize(key, isOptional, precision, min, Long.MAX_VALUE);
    }

    public void validateMemorySize(String key, boolean isOptional, int precision, long min, long max) {
        Preconditions.checkArgument(precision > 0);
        this.validateComparable(key, isOptional, min, max, "memory size (in bytes)", value -> {
            long bytes = MemorySize.parse(value, MemorySize.MemoryUnit.BYTES).getBytes();
            if (bytes % (long)precision != 0L) {
                throw new ValidationException("Memory size for key '" + key + "' must be a multiple of " + precision + " bytes but was: " + value);
            }
            return bytes;
        });
    }

    public void validateEnum(String key, boolean isOptional, Map<String, Consumer<String>> enumValidation) {
        this.validateOptional(key, isOptional, value -> {
            if (!enumValidation.containsKey(value)) {
                throw new ValidationException("Unknown value for property '" + key + "'.\nSupported values are " + enumValidation.keySet() + " but was: " + value);
            }
            ((Consumer)enumValidation.get(value)).accept(key);
        });
    }

    public void validateEnumValues(String key, boolean isOptional, List<String> values) {
        this.validateEnum(key, isOptional, values.stream().collect(Collectors.toMap(v -> v, v -> DescriptorProperties.noValidation())));
    }

    public void validateType(String key, boolean isOptional, boolean requireRow) {
        this.validateOptional(key, isOptional, value -> {
            TypeInformation<?> typeInfo = TypeStringUtils.readTypeInfo(value);
            if (requireRow && !(typeInfo instanceof RowTypeInfo)) {
                throw new ValidationException("Row type information expected for key '" + key + "' but was: " + value);
            }
        });
    }

    public void validateArray(String key, Consumer<String> elementValidation, int minLength) {
        this.validateArray(key, elementValidation, minLength, Integer.MAX_VALUE);
    }

    public void validateArray(String key, Consumer<String> elementValidation, int minLength, int maxLength) {
        int maxIndex = this.extractMaxIndex(key, "");
        if (maxIndex < 0) {
            if (this.properties.containsKey(key)) {
                elementValidation.accept(key);
            } else if (minLength > 0) {
                throw new ValidationException("Could not find required property array for key '" + key + "'.");
            }
        } else {
            if (this.properties.containsKey(key)) {
                throw new ValidationException("Invalid property array for key '" + key + "'.");
            }
            int size = maxIndex + 1;
            if (size < minLength) {
                throw new ValidationException("Array for key '" + key + "' must not have less than " + minLength + " elements but was: " + size);
            }
            if (size > maxLength) {
                throw new ValidationException("Array for key '" + key + "' must not have more than " + maxLength + " elements but was: " + size);
            }
        }
        for (int i = 0; i < maxIndex; ++i) {
            String fullKey = key + '.' + i;
            if (!this.properties.containsKey(fullKey)) {
                throw new ValidationException("Required array element at index '" + i + "' for key '" + key + "' is missing.");
            }
            elementValidation.accept(fullKey);
        }
    }

    public void validatePrefixExclusion(String prefix) {
        this.properties.keySet().stream().filter(k -> k.startsWith(prefix)).findFirst().ifPresent(k -> {
            throw new ValidationException("Properties with prefix '" + prefix + "' are not allowed in this context. But property '" + k + "' was found.");
        });
    }

    public void validateExclusion(String key) {
        if (this.properties.containsKey(key)) {
            throw new ValidationException("Property '" + key + "' is not allowed in this context.");
        }
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean hasPrefix(String prefix) {
        return this.properties.keySet().stream().anyMatch(k -> k.startsWith(prefix));
    }

    public Map<String, String> asMap() {
        HashMap<String, String> copy2 = new HashMap<String, String>(this.properties);
        return Collections.unmodifiableMap(copy2);
    }

    public Map<String, String> asPrefixedMap(String prefix) {
        return this.properties.entrySet().stream().collect(Collectors.toMap(e2 -> prefix + (String)e2.getKey(), Map.Entry::getValue));
    }

    public DescriptorProperties withoutKeys(List<String> keys) {
        HashSet<String> keySet = new HashSet<String>(keys);
        DescriptorProperties copy2 = new DescriptorProperties(this.normalizeKeys);
        this.properties.entrySet().stream().filter(e2 -> !keySet.contains(e2.getKey())).forEach(e2 -> copy2.properties.put((String)e2.getKey(), (String)e2.getValue()));
        return copy2;
    }

    public String toString() {
        return DescriptorProperties.toString(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorProperties that = (DescriptorProperties)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    private void put(String key, String value) {
        if (this.properties.containsKey(key)) {
            throw new ValidationException("Property already present: " + key);
        }
        if (this.normalizeKeys) {
            this.properties.put(key.toLowerCase(), value);
        } else {
            this.properties.put(key, value);
        }
    }

    private Optional<String> optionalGet(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    private void validateOptional(String key, boolean isOptional, Consumer<String> valueValidation) {
        if (!this.properties.containsKey(key)) {
            if (!isOptional) {
                throw new ValidationException("Could not find required property '" + key + "'.");
            }
        } else {
            String value = this.properties.get(key);
            valueValidation.accept(value);
        }
    }

    private Supplier<TableException> exceptionSupplier(String key) {
        return () -> {
            throw new TableException("Property with key '" + key + "' could not be found. This is a bug because the validation logic should have checked that before.");
        };
    }

    private int extractMaxIndex(String key, String suffixPattern) {
        String escapedKey = Pattern.quote(key);
        Pattern pattern = Pattern.compile(escapedKey + "\\.(\\d+)" + suffixPattern);
        IntStream indexes = this.properties.keySet().stream().flatMapToInt(k -> {
            Matcher matcher = pattern.matcher((CharSequence)k);
            if (matcher.find()) {
                return IntStream.of((int)Integer.valueOf(matcher.group(1)));
            }
            return IntStream.empty();
        });
        return indexes.max().orElse(-1);
    }

    private <T extends Comparable<T>> void validateComparable(String key, boolean isOptional, T min, T max, String typeName, Function<String, T> parseFunction) {
        if (!this.properties.containsKey(key)) {
            if (!isOptional) {
                throw new ValidationException("Could not find required property '" + key + "'.");
            }
        } else {
            String value = this.properties.get(key);
            try {
                Comparable parsed = (Comparable)parseFunction.apply(value);
                if (parsed.compareTo(min) < 0 || parsed.compareTo(max) > 0) {
                    throw new ValidationException("Property '" + key + "' must be a " + typeName + " value between " + min + " and " + max + " but was: " + parsed);
                }
            }
            catch (Exception e2) {
                throw new ValidationException("Property '" + key + "' must be a " + typeName + " value but was: " + value);
            }
        }
    }

    public static Consumer<String> noValidation() {
        return EMPTY_CONSUMER;
    }

    public static String toString(String str) {
        return EncodingUtils.escapeJava(str);
    }

    public static String toString(String key, String value) {
        return DescriptorProperties.toString(key) + '=' + DescriptorProperties.toString(value);
    }

    public static String toString(Map<String, String> propertyMap) {
        return propertyMap.entrySet().stream().map(e2 -> DescriptorProperties.toString((String)e2.getKey(), (String)e2.getValue())).sorted().collect(Collectors.joining("\n"));
    }
}

