/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ArrayConstructor;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.expressions.Mul;
import org.apache.flink.table.expressions.Proctime;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.IntervalRowsType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.TimestampType;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ExpressionUtils$ {
    public static final ExpressionUtils$ MODULE$;

    static {
        new ExpressionUtils$();
    }

    public InternalType getResultType(Expression expr) {
        return expr.resultType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTimeIntervalLiteral(Expression expr) {
        Expression expression2 = expr;
        if (!(expression2 instanceof Literal)) return false;
        Literal literal = (Literal)expression2;
        InternalType internalType = literal.resultType();
        TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
        InternalType internalType2 = internalType;
        if (timestampType != null) {
            if (!((Object)timestampType).equals(internalType2)) return false;
            return true;
        }
        if (internalType2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowCountLiteral(Expression expr) {
        Expression expression2 = expr;
        if (!(expression2 instanceof Literal)) return false;
        Literal literal = (Literal)expression2;
        InternalType internalType = literal.resultType();
        IntervalRowsType intervalRowsType = DataTypes.INTERVAL_ROWS;
        InternalType internalType2 = internalType;
        if (intervalRowsType != null) {
            if (!((Object)intervalRowsType).equals(internalType2)) return false;
            return true;
        }
        if (internalType2 == null) return true;
        return false;
    }

    public boolean isTimeAttribute(Expression expr) {
        return this.isRowtimeAttribute(expr) || this.isProctimeAttribute(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowtimeAttribute(Expression expr) {
        Expression expression2 = expr;
        if (!(expression2 instanceof ResolvedFieldReference)) return false;
        ResolvedFieldReference resolvedFieldReference = (ResolvedFieldReference)expression2;
        InternalType internalType = resolvedFieldReference.resultType();
        TimestampType timestampType = DataTypes.ROWTIME_INDICATOR;
        if (internalType != null) {
            if (!internalType.equals(timestampType)) return false;
            return true;
        }
        if (timestampType == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isProctimeAttribute(Expression expr) {
        Expression expression2 = expr;
        if (expression2 instanceof ResolvedFieldReference) {
            ResolvedFieldReference resolvedFieldReference = (ResolvedFieldReference)expression2;
            InternalType internalType = resolvedFieldReference.resultType();
            TimestampType timestampType = DataTypes.PROCTIME_INDICATOR;
            if (internalType == null) {
                if (timestampType == null) return true;
            } else if (internalType.equals(timestampType)) {
                return true;
            }
        }
        if (!(expression2 instanceof Proctime)) return false;
        return true;
    }

    public Time toTime(Expression expr) {
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            InternalType internalType = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
                InternalType internalType2 = internalType;
                if (!(timestampType != null ? !((Object)timestampType).equals(internalType2) : internalType2 != null)) {
                    Time time = Time.milliseconds((long)l);
                    return time;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public Duration toDuration(Expression expr) {
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            InternalType internalType = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
                InternalType internalType2 = internalType;
                if (!(timestampType != null ? !((Object)timestampType).equals(internalType2) : internalType2 != null)) {
                    Duration duration = Duration.ofMillis(l);
                    return duration;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public long toLong(Expression expr) {
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            InternalType internalType = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                IntervalRowsType intervalRowsType = DataTypes.INTERVAL_ROWS;
                InternalType internalType2 = internalType;
                if (!(intervalRowsType != null ? !((Object)intervalRowsType).equals(internalType2) : internalType2 != null)) {
                    long l2 = l;
                    return l2;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMonthInterval(Expression expr, int multiplier) {
        void var9_11;
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            InternalType internalType = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                IntType intType = DataTypes.INT;
                InternalType internalType2 = internalType;
                if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToInteger((int)(n * multiplier)), DataTypes.INTERVAL_MONTHS);
                    return var9_11;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)multiplier))), DataTypes.INTERVAL_MONTHS);
        return var9_11;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMilliInterval(Expression expr, long multiplier) {
        void var11_13;
        boolean bl = false;
        Literal literal = null;
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            bl = true;
            literal = (Literal)expression2;
            Object value = literal.value();
            InternalType internalType = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                IntType intType = DataTypes.INT;
                InternalType internalType2 = internalType;
                if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToLong((long)((long)n * multiplier)), DataTypes.INTERVAL_MILLIS);
                    return var11_13;
                }
            }
        }
        if (bl) {
            Object value = literal.value();
            InternalType internalType = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                LongType longType = DataTypes.LONG;
                InternalType internalType3 = internalType;
                if (!(longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null)) {
                    Literal literal3 = new Literal(BoxesRunTime.boxToLong((long)(l * multiplier)), DataTypes.INTERVAL_MILLIS);
                    return var11_13;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)multiplier))), DataTypes.INTERVAL_MILLIS);
        return var11_13;
    }

    public Expression toRowInterval(Expression expr) {
        block4: {
            Literal literal;
            block3: {
                Literal literal2;
                boolean bl;
                block2: {
                    bl = false;
                    literal2 = null;
                    Expression expression2 = expr;
                    if (!(expression2 instanceof Literal)) break block2;
                    bl = true;
                    literal2 = (Literal)expression2;
                    Object value = literal2.value();
                    InternalType internalType = literal2.resultType();
                    if (!(value instanceof Integer)) break block2;
                    int n = BoxesRunTime.unboxToInt((Object)value);
                    IntType intType = DataTypes.INT;
                    InternalType internalType2 = internalType;
                    if (intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null) break block2;
                    literal = new Literal(BoxesRunTime.boxToLong((long)n), DataTypes.INTERVAL_ROWS);
                    break block3;
                }
                if (!bl) break block4;
                Object value = literal2.value();
                InternalType internalType = literal2.resultType();
                if (!(value instanceof Long)) break block4;
                long l = BoxesRunTime.unboxToLong((Object)value);
                LongType longType = DataTypes.LONG;
                InternalType internalType3 = internalType;
                if (longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null) break block4;
                literal = new Literal(BoxesRunTime.boxToLong((long)l), DataTypes.INTERVAL_ROWS);
            }
            return literal;
        }
        throw new IllegalArgumentException("Invalid value for row interval literal.");
    }

    public Expression toRangeInterval(Expression expr) {
        block6: {
            Literal literal;
            block3: {
                Literal literal2;
                boolean bl;
                block5: {
                    block4: {
                        block2: {
                            bl = false;
                            literal2 = null;
                            Expression expression2 = expr;
                            if (!(expression2 instanceof Literal)) break block2;
                            bl = true;
                            literal2 = (Literal)expression2;
                            Object value = literal2.value();
                            InternalType internalType = literal2.resultType();
                            if (!(value instanceof Integer)) break block2;
                            int n = BoxesRunTime.unboxToInt((Object)value);
                            IntType intType = DataTypes.INT;
                            InternalType internalType2 = internalType;
                            if (intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null) break block2;
                            literal = new Literal(BoxesRunTime.boxToLong((long)n), DataTypes.INTERVAL_RANGE);
                            break block3;
                        }
                        if (!bl) break block4;
                        Object value = literal2.value();
                        InternalType internalType = literal2.resultType();
                        if (!(value instanceof Long)) break block4;
                        long l = BoxesRunTime.unboxToLong((Object)value);
                        LongType longType = DataTypes.LONG;
                        InternalType internalType3 = internalType;
                        if (longType != null ? !((Object)longType).equals(internalType3) : internalType3 != null) break block4;
                        literal = new Literal(BoxesRunTime.boxToLong((long)l), DataTypes.INTERVAL_RANGE);
                        break block3;
                    }
                    if (!bl) break block5;
                    Object value = literal2.value();
                    InternalType internalType = literal2.resultType();
                    if (!(value instanceof Float)) break block5;
                    float f = BoxesRunTime.unboxToFloat((Object)value);
                    FloatType floatType = DataTypes.FLOAT;
                    InternalType internalType4 = internalType;
                    if (floatType != null ? !((Object)floatType).equals(internalType4) : internalType4 != null) break block5;
                    literal = new Literal(BoxesRunTime.boxToFloat((float)f), DataTypes.INTERVAL_RANGE);
                    break block3;
                }
                if (!bl) break block6;
                Object value = literal2.value();
                InternalType internalType = literal2.resultType();
                if (!(value instanceof Double)) break block6;
                double d = BoxesRunTime.unboxToDouble((Object)value);
                DoubleType doubleType = DataTypes.DOUBLE;
                InternalType internalType5 = internalType;
                if (doubleType != null ? !((Object)doubleType).equals(internalType5) : internalType5 != null) break block6;
                literal = new Literal(BoxesRunTime.boxToDouble((double)d), DataTypes.INTERVAL_RANGE);
            }
            return literal;
        }
        throw new IllegalArgumentException("Invalid value for range interval literal.");
    }

    public Expression convertArray(Object array2) {
        block23: {
            Expression expression2;
            block3: {
                block22: {
                    Object object;
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block5: {
                                                                                        block4: {
                                                                                            block2: {
                                                                                                object = array2;
                                                                                                if (!(object instanceof boolean[])) break block2;
                                                                                                expression2 = this.createArray$1(array2);
                                                                                                break block3;
                                                                                            }
                                                                                            if (!(object instanceof byte[])) break block4;
                                                                                            expression2 = this.createArray$1(array2);
                                                                                            break block3;
                                                                                        }
                                                                                        if (!(object instanceof short[])) break block5;
                                                                                        expression2 = this.createArray$1(array2);
                                                                                        break block3;
                                                                                    }
                                                                                    if (!(object instanceof int[])) break block6;
                                                                                    expression2 = this.createArray$1(array2);
                                                                                    break block3;
                                                                                }
                                                                                if (!(object instanceof long[])) break block7;
                                                                                expression2 = this.createArray$1(array2);
                                                                                break block3;
                                                                            }
                                                                            if (!(object instanceof float[])) break block8;
                                                                            expression2 = this.createArray$1(array2);
                                                                            break block3;
                                                                        }
                                                                        if (!(object instanceof double[])) break block9;
                                                                        expression2 = this.createArray$1(array2);
                                                                        break block3;
                                                                    }
                                                                    if (!(object instanceof Boolean[])) break block10;
                                                                    expression2 = this.createArray$1(array2);
                                                                    break block3;
                                                                }
                                                                if (!(object instanceof Byte[])) break block11;
                                                                expression2 = this.createArray$1(array2);
                                                                break block3;
                                                            }
                                                            if (!(object instanceof Short[])) break block12;
                                                            expression2 = this.createArray$1(array2);
                                                            break block3;
                                                        }
                                                        if (!(object instanceof Integer[])) break block13;
                                                        expression2 = this.createArray$1(array2);
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Long[])) break block14;
                                                    expression2 = this.createArray$1(array2);
                                                    break block3;
                                                }
                                                if (!(object instanceof Float[])) break block15;
                                                expression2 = this.createArray$1(array2);
                                                break block3;
                                            }
                                            if (!(object instanceof Double[])) break block16;
                                            expression2 = this.createArray$1(array2);
                                            break block3;
                                        }
                                        if (!(object instanceof String[])) break block17;
                                        expression2 = this.createArray$1(array2);
                                        break block3;
                                    }
                                    if (!(object instanceof BigDecimal[])) break block18;
                                    expression2 = this.createArray$1(array2);
                                    break block3;
                                }
                                if (!(object instanceof Date[])) break block19;
                                expression2 = this.createArray$1(array2);
                                break block3;
                            }
                            if (!(object instanceof java.sql.Time[])) break block20;
                            expression2 = this.createArray$1(array2);
                            break block3;
                        }
                        if (!(object instanceof Timestamp[])) break block21;
                        expression2 = this.createArray$1(array2);
                        break block3;
                    }
                    if (!(object instanceof scala.math.BigDecimal[])) break block22;
                    scala.math.BigDecimal[] bigDecimalArray = (scala.math.BigDecimal[])object;
                    expression2 = new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.refArrayOps((Object[])bigDecimalArray).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Literal apply(scala.math.BigDecimal bd) {
                            return Literal$.MODULE$.apply(bd.bigDecimal());
                        }
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                    break block3;
                }
                if (ScalaRunTime$.MODULE$.array_length(array2) <= 0 || !ScalaRunTime$.MODULE$.isArray(Predef$.MODULE$.genericArrayOps(array2).head(), 1)) break block23;
                expression2 = new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array2).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Object na) {
                        return ExpressionUtils$.MODULE$.convertArray(na);
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            }
            return expression2;
        }
        throw new ValidationException("Unsupported array type.");
    }

    private final Expression createArray$1(Object array$1) {
        return new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array$1).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Literal apply(Object x$1) {
                return Literal$.MODULE$.apply(x$1);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
    }

    private ExpressionUtils$() {
        MODULE$ = this;
    }
}

