/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.table.expressions.LeafExpression;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.plan.logical.LogicalExprVisitor;
import org.apache.flink.table.types.AtomicType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.IntervalRowsType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimeType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.util.TimeConvertUtils;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ev!B\u0001\u0003\u0011\u0003i\u0011a\u0002'ji\u0016\u0014\u0018\r\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"a\u0002'ji\u0016\u0014\u0018\r\\\n\u0004\u001fIA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00069=!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035A\u0001bH\bC\u0002\u0013\u0005a\u0001I\u0001\u0004\u000f6#V#A\u0011\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001B;uS2T\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\tAA+[7f5>tW\r\u0003\u0004+\u001f\u0001\u0006I!I\u0001\u0005\u000f6#\u0006\u0005\u0003\u0004-\u001f\u0011\u0005a!L\u0001\u0006CB\u0004H.\u001f\u000b\u0004]\u0005\r\u0005C\u0001\b0\r\u0011\u0001\"\u0001\u0011\u0019\u0014\t=\nD\u0007\u0007\t\u0003\u001dIJ!a\r\u0002\u0003\u001d1+\u0017MZ#yaJ,7o]5p]B\u00111#N\u0005\u0003mQ\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u00059_\tU\r\u0011\"\u0001:\u0003\u00151\u0018\r\\;f+\u0005Q\u0004CA\n<\u0013\taDCA\u0002B]fD\u0001BP\u0018\u0003\u0012\u0003\u0006IAO\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\u0001{#Q3A\u0005\u0002\u0005\u000b!B]3tk2$H+\u001f9f+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0005\u0003\u0015!\u0018\u0010]3t\u0013\t9EI\u0001\u0007J]R,'O\\1m)f\u0004X\r\u0003\u0005J_\tE\t\u0015!\u0003C\u0003-\u0011Xm];miRK\b/\u001a\u0011\t\u000bqyC\u0011A&\u0015\u00079bU\nC\u00039\u0015\u0002\u0007!\bC\u0003A\u0015\u0002\u0007!\tC\u0003P_\u0011\u0005\u0003+\u0001\u0005u_N#(/\u001b8h)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+&\u0003\u0011a\u0017M\\4\n\u0005Y\u001b&AB*ue&tw\r\u0003\u0004Y_\u0011\u0005c!W\u0001\ni>\u0014V\r\u001f(pI\u0016$\"A\u00172\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016a\u0001:fq*\u0011q\fC\u0001\bG\u0006d7-\u001b;f\u0013\t\tGLA\u0004SKbtu\u000eZ3\t\u000b\r<\u00069\u00013\u0002\u0015I,GNQ;jY\u0012,'\u000f\u0005\u0002fQ6\taM\u0003\u0002h=\u0006)Ao\\8mg&\u0011\u0011N\u001a\u0002\u000b%\u0016d')^5mI\u0016\u0014\b\"B60\t\u0013a\u0017A\u00043bi\u0016$vnQ1mK:$\u0017M]\u000b\u0002[B\u0011!E\\\u0005\u0003_\u000e\u0012\u0001bQ1mK:$\u0017M\u001d\u0005\u0006c>\"\tE]\u0001\u0007C\u000e\u001cW\r\u001d;\u0016\u0005M4HC\u0001;}!\t)h\u000f\u0004\u0001\u0005\u000b]\u0004(\u0019\u0001=\u0003\u0003Q\u000b\"!\u001f\u001e\u0011\u0005MQ\u0018BA>\u0015\u0005\u001dqu\u000e\u001e5j]\u001eDQ! 9A\u0002y\f!\u0003\\8hS\u000e\fG.\u0012=qeZK7/\u001b;peB!q0!\u0003u\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0004\u0003\u000f!\u0011\u0001\u00029mC:LA!a\u0003\u0002\u0002\t\u0011Bj\\4jG\u0006dW\t\u001f9s-&\u001c\u0018\u000e^8s\u0011%\tyaLA\u0001\n\u0003\t\t\"\u0001\u0003d_BLH#\u0002\u0018\u0002\u0014\u0005U\u0001\u0002\u0003\u001d\u0002\u000eA\u0005\t\u0019\u0001\u001e\t\u0011\u0001\u000bi\u0001%AA\u0002\tC\u0011\"!\u00070#\u0003%\t!a\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0004\u0016\u0004u\u0005}1FAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-B#\u0001\u0006b]:|G/\u0019;j_:LA!a\f\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005Mr&%A\u0005\u0002\u0005U\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003oQ3AQA\u0010\u0011%\tYdLA\u0001\n\u0003\ni$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002#\"I\u0011\u0011I\u0018\u0002\u0002\u0013\u0005\u00111I\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000b\u00022aEA$\u0013\r\tI\u0005\u0006\u0002\u0004\u0013:$\b\"CA'_\u0005\u0005I\u0011AA(\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AOA)\u0011)\t\u0019&a\u0013\u0002\u0002\u0003\u0007\u0011QI\u0001\u0004q\u0012\n\u0004\"CA,_\u0005\u0005I\u0011IA-\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA.!\u0015\ti&a\u0019;\u001b\t\tyFC\u0002\u0002bQ\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)'a\u0018\u0003\u0011%#XM]1u_JD\u0011\"!\u001b0\u0003\u0003%\t!a\u001b\u0002\u0011\r\fg.R9vC2$B!!\u001c\u0002tA\u00191#a\u001c\n\u0007\u0005EDCA\u0004C_>dW-\u00198\t\u0013\u0005M\u0013qMA\u0001\u0002\u0004Q\u0004\"CA<_\u0005\u0005I\u0011IA=\u0003!A\u0017m\u001d5D_\u0012,GCAA#\u0011%\tihLA\u0001\n\u0003\ny(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003[\n\t\tC\u0005\u0002T\u0005m\u0014\u0011!a\u0001u!1\u0011QQ\u0016A\u0002i\n\u0011\u0001\u001c\u0005\tY=\t\t\u0011\"!\u0002\nR)a&a#\u0002\u000e\"1\u0001(a\"A\u0002iBa\u0001QAD\u0001\u0004\u0011\u0005\"CAI\u001f\u0005\u0005I\u0011QAJ\u0003\u001d)h.\u00199qYf$B!!&\u0002\"B)1#a&\u0002\u001c&\u0019\u0011\u0011\u0014\u000b\u0003\r=\u0003H/[8o!\u0015\u0019\u0012Q\u0014\u001eC\u0013\r\ty\n\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005\r\u0016qRA\u0001\u0002\u0004q\u0013a\u0001=%a!I\u0011qU\b\u0002\u0002\u0013%\u0011\u0011V\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002,B\u0019!+!,\n\u0007\u0005=6K\u0001\u0004PE*,7\r\u001e")
public class Literal
extends LeafExpression
implements Serializable {
    private final Object value;
    private final InternalType resultType;

    public static Option<Tuple2<Object, InternalType>> unapply(Literal literal) {
        return Literal$.MODULE$.unapply(literal);
    }

    public static Literal apply(Object object, InternalType internalType) {
        return Literal$.MODULE$.apply(object, internalType);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public InternalType resultType() {
        return this.resultType;
    }

    public String toString() {
        String string;
        InternalType internalType = this.resultType();
        DateType dateType = DataTypes.DATE;
        InternalType internalType2 = internalType;
        if (!(dateType != null ? !((Object)dateType).equals(internalType2) : internalType2 != null)) {
            string = new StringBuilder().append((Object)TimeConvertUtils.unixDateTimeToString(this.value())).append((Object)".toDate").toString();
        } else {
            TimeType timeType = DataTypes.TIME;
            InternalType internalType3 = internalType;
            if (!(timeType != null ? !((Object)timeType).equals(internalType3) : internalType3 != null)) {
                string = new StringBuilder().append((Object)TimeConvertUtils.unixDateTimeToString(this.value())).append((Object)".toTime").toString();
            } else {
                TimestampType timestampType = DataTypes.TIMESTAMP;
                InternalType internalType4 = internalType;
                if (!(timestampType != null ? !((Object)timestampType).equals(internalType4) : internalType4 != null)) {
                    string = new StringBuilder().append((Object)TimeConvertUtils.unixDateTimeToString(this.value())).append((Object)".toTimestamp").toString();
                } else {
                    TimestampType timestampType2 = DataTypes.INTERVAL_MILLIS;
                    InternalType internalType5 = internalType;
                    if (!(timestampType2 != null ? !((Object)timestampType2).equals(internalType5) : internalType5 != null)) {
                        string = new StringBuilder().append((Object)this.value().toString()).append((Object)".millis").toString();
                    } else {
                        DateType dateType2 = DataTypes.INTERVAL_MONTHS;
                        InternalType internalType6 = internalType;
                        if (!(dateType2 != null ? !((Object)dateType2).equals(internalType6) : internalType6 != null)) {
                            string = new StringBuilder().append((Object)this.value().toString()).append((Object)".months").toString();
                        } else {
                            IntervalRowsType intervalRowsType = DataTypes.INTERVAL_ROWS;
                            InternalType internalType7 = internalType;
                            string = !(intervalRowsType != null ? !((Object)intervalRowsType).equals(internalType7) : internalType7 != null) ? new StringBuilder().append((Object)this.value().toString()).append((Object)".rows").toString() : (internalType instanceof AtomicType ? this.value().toString() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Literal(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value(), this.resultType()})));
                        }
                    }
                }
            }
        }
        return string;
    }

    @Override
    public RexNode toRexNode(RelBuilder relBuilder) {
        RexNode rexNode;
        InternalType internalType = this.resultType();
        if (internalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)internalType;
            BigDecimal bigDecValue = (BigDecimal)this.value();
            RelDataType decType = relBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, decimalType.precision(), decimalType.scale());
            rexNode = relBuilder.getRexBuilder().makeExactLiteral(bigDecValue, decType);
        } else {
            LongType longType = DataTypes.LONG;
            InternalType internalType2 = internalType;
            if (!(longType != null ? !((Object)longType).equals(internalType2) : internalType2 != null)) {
                BigDecimal bigDecimal;
                Object object = this.value();
                BigDecimal bigDecimal2 = object instanceof BigDecimal ? (bigDecimal = (BigDecimal)object) : BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)this.value()));
                BigDecimal bigint = bigDecimal2;
                rexNode = relBuilder.getRexBuilder().makeBigintLiteral(bigint);
            } else {
                FloatType floatType = DataTypes.FLOAT;
                InternalType internalType3 = internalType;
                if (!(floatType != null ? !((Object)floatType).equals(internalType3) : internalType3 != null)) {
                    rexNode = relBuilder.getRexBuilder().makeApproxLiteral(BigDecimal.valueOf(((Number)this.value()).floatValue()), relBuilder.getTypeFactory().createSqlType(SqlTypeName.FLOAT));
                } else {
                    DoubleType doubleType = DataTypes.DOUBLE;
                    InternalType internalType4 = internalType;
                    if (!(doubleType != null ? !((Object)doubleType).equals(internalType4) : internalType4 != null)) {
                        rexNode = relBuilder.getRexBuilder().makeApproxLiteral(BigDecimal.valueOf(((Number)this.value()).doubleValue()), relBuilder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE));
                    } else {
                        DateType dateType = DataTypes.DATE;
                        InternalType internalType5 = internalType;
                        if (!(dateType != null ? !((Object)dateType).equals(internalType5) : internalType5 != null)) {
                            rexNode = relBuilder.getRexBuilder().makeDateLiteral(this.dateToCalendar());
                        } else {
                            TimeType timeType = DataTypes.TIME;
                            InternalType internalType6 = internalType;
                            if (!(timeType != null ? !((Object)timeType).equals(internalType6) : internalType6 != null)) {
                                rexNode = relBuilder.getRexBuilder().makeTimeLiteral(this.dateToCalendar(), 0);
                            } else {
                                TimestampType timestampType = DataTypes.TIMESTAMP;
                                InternalType internalType7 = internalType;
                                if (!(timestampType != null ? !((Object)timestampType).equals(internalType7) : internalType7 != null)) {
                                    rexNode = relBuilder.getRexBuilder().makeTimestampLiteral(this.dateToCalendar(), 3);
                                } else {
                                    DateType dateType2 = DataTypes.INTERVAL_MONTHS;
                                    InternalType internalType8 = internalType;
                                    if (!(dateType2 != null ? !((Object)dateType2).equals(internalType8) : internalType8 != null)) {
                                        BigDecimal interval = BigDecimal.valueOf(BoxesRunTime.unboxToInt((Object)this.value()));
                                        SqlIntervalQualifier intervalQualifier = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
                                        rexNode = relBuilder.getRexBuilder().makeIntervalLiteral(interval, intervalQualifier);
                                    } else {
                                        TimestampType timestampType2 = DataTypes.INTERVAL_MILLIS;
                                        InternalType internalType9 = internalType;
                                        if (!(timestampType2 != null ? !((Object)timestampType2).equals(internalType9) : internalType9 != null)) {
                                            BigDecimal interval = BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)this.value()));
                                            SqlIntervalQualifier intervalQualifier = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
                                            rexNode = relBuilder.getRexBuilder().makeIntervalLiteral(interval, intervalQualifier);
                                        } else {
                                            ByteType byteType = DataTypes.BYTE;
                                            InternalType internalType10 = internalType;
                                            if (!(byteType != null ? !((Object)byteType).equals(internalType10) : internalType10 != null)) {
                                                rexNode = relBuilder.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(((Number)this.value()).byteValue()), relBuilder.getTypeFactory().createSqlType(SqlTypeName.TINYINT));
                                            } else {
                                                ShortType shortType = DataTypes.SHORT;
                                                InternalType internalType11 = internalType;
                                                if (!(shortType != null ? !((Object)shortType).equals(internalType11) : internalType11 != null)) {
                                                    rexNode = relBuilder.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(((Number)this.value()).shortValue()), relBuilder.getTypeFactory().createSqlType(SqlTypeName.SMALLINT));
                                                } else {
                                                    StringType stringType = DataTypes.STRING;
                                                    InternalType internalType12 = internalType;
                                                    if (!(stringType != null ? !((Object)stringType).equals(internalType12) : internalType12 != null)) {
                                                        String string;
                                                        Object object = this.value();
                                                        if (object instanceof NlsString) {
                                                            NlsString nlsString = (NlsString)object;
                                                            string = nlsString.getValue();
                                                        } else {
                                                            string = (String)this.value();
                                                        }
                                                        String strValue = string;
                                                        rexNode = relBuilder.literal(StringEscapeUtils.escapeJava((String)strValue));
                                                    } else {
                                                        rexNode = relBuilder.literal(this.value());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return rexNode;
    }

    private Calendar dateToCalendar() {
        Calendar calendar;
        Object object = this.value();
        if (object instanceof Calendar) {
            Calendar calendar2;
            calendar = calendar2 = (Calendar)object;
        } else {
            Date date = (Date)this.value();
            Calendar cal = Calendar.getInstance(Literal$.MODULE$.GMT());
            long t = date.getTime();
            cal.setTimeInMillis(t);
            calendar = cal;
        }
        return calendar;
    }

    @Override
    public <T> T accept(LogicalExprVisitor<T> logicalExprVisitor) {
        return logicalExprVisitor.visit(this);
    }

    public Literal copy(Object value, InternalType resultType2) {
        return new Literal(value, resultType2);
    }

    public Object copy$default$1() {
        return this.value();
    }

    public InternalType copy$default$2() {
        return this.resultType();
    }

    @Override
    public String productPrefix() {
        return "Literal";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.resultType();
                break;
            }
            case 0: {
                object = this.value();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Literal;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Literal)) return false;
        boolean bl = true;
        if (!bl) return false;
        Literal literal = (Literal)x$1;
        if (!BoxesRunTime.equals((Object)this.value(), (Object)literal.value())) return false;
        InternalType internalType = this.resultType();
        InternalType internalType2 = literal.resultType();
        if (internalType == null) {
            if (internalType2 != null) {
                return false;
            }
        } else if (!internalType.equals(internalType2)) return false;
        if (!literal.canEqual(this)) return false;
        return true;
    }

    public Literal(Object value, InternalType resultType2) {
        this.value = value;
        this.resultType = resultType2;
    }
}

