/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.parquet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.factories.BatchTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSourceFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.parquet.ParquetOptions;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.parquet.ParquetTableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.parquet.ParquetVectorizedColumnRowTableSource;
import org.apache.flink.table.util.TableProperties;
import org.apache.flink.util.StringUtils;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import scala.Option;
import scala.Some;

public class ParquetTableFactory
implements StreamTableSourceFactory<ColumnarRow>,
BatchTableSourceFactory<ColumnarRow>,
BatchTableSinkFactory<BaseRow> {
    private static final String DEFAULT_WRITE_MODE = "None";

    private ParquetVectorizedColumnRowTableSource getSource(Map<String, String> props) {
        TableProperties tableProperties = new TableProperties();
        tableProperties.putProperties(props);
        RichTableSchema richTableSchema = tableProperties.readSchemaFromProperties(null);
        String filePath = tableProperties.getString(ParquetOptions.FILE_PATH);
        if (StringUtils.isNullOrWhitespaceOnly(filePath)) {
            throw new RuntimeException(ParquetOptions.PARAMS_HELP_MSG);
        }
        boolean enumerateNestedFiles = tableProperties.getBoolean(ParquetOptions.ENUMERATE_NESTED_FILES);
        boolean supportUpdate = tableProperties.getBoolean(ParquetOptions.SUPPORT_UPDATE);
        return new ParquetVectorizedColumnRowTableSource(new Path(filePath), richTableSchema.getColumnTypes(), richTableSchema.getColumnNames(), richTableSchema.getNullables(), enumerateNestedFiles, 1, "", null, supportUpdate);
    }

    @Override
    public StreamTableSource<ColumnarRow> createStreamTableSource(Map<String, String> props) {
        return this.getSource(props);
    }

    @Override
    public BatchTableSource<ColumnarRow> createBatchTableSource(Map<String, String> props) {
        return this.getSource(props);
    }

    @Override
    public List<String> supportedProperties() {
        return ParquetOptions.SUPPORTED_KEYS;
    }

    @Override
    public BatchTableSink<BaseRow> createBatchTableSink(Map<String, String> props) {
        TableProperties tableProperties = new TableProperties();
        tableProperties.putProperties(props);
        TableSchema schema2 = tableProperties.readTableSchemaFromProperties(Thread.currentThread().getContextClassLoader());
        String filePath = tableProperties.getString(ParquetOptions.FILE_PATH);
        if (StringUtils.isNullOrWhitespaceOnly(filePath)) {
            throw new RuntimeException(ParquetOptions.PARAMS_HELP_MSG);
        }
        Some writeModeOption = null;
        String writeMode = tableProperties.getString(ParquetOptions.WRITE_MODE);
        if (!DEFAULT_WRITE_MODE.equals(writeMode)) {
            writeModeOption = new Some((Object)FileSystem.WriteMode.valueOf(tableProperties.getString(ParquetOptions.WRITE_MODE)));
        }
        CompressionCodecName compressionCodecName = CompressionCodecName.valueOf((String)tableProperties.getString(ParquetOptions.COMPRESSION_CODEC_NAME));
        boolean supportUpdate = tableProperties.getBoolean(ParquetOptions.SUPPORT_UPDATE);
        ParquetTableSink sink = new ParquetTableSink(filePath, (Option<FileSystem.WriteMode>)writeModeOption, compressionCodecName, supportUpdate);
        return (BatchTableSink)sink.configure(schema2.getFieldNames(), schema2.getFieldTypes());
    }

    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "PARQUET");
        context.put("connector.property-version", "1");
        return context;
    }
}

