/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.calcite;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlRankFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NumberUtil;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.nodes.calcite.Rank$;
import org.apache.flink.table.plan.util.ConstantRankRange;
import org.apache.flink.table.plan.util.FlinkRelMdUtil$;
import org.apache.flink.table.plan.util.FlinkRelOptUtil$;
import org.apache.flink.table.plan.util.RankRange;
import org.apache.flink.table.plan.util.VariableRankRange;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!B\u0001\u0003\u0003\u0003\t\"\u0001\u0002*b].T!a\u0001\u0003\u0002\u000f\r\fGnY5uK*\u0011QAB\u0001\u0006]>$Wm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019r#D\u0001\u0015\u0015\t)b#A\u0002sK2T!a\u0001\u0007\n\u0005a!\"!C*j]\u001edWMU3m\u0011!Q\u0002A!A!\u0002\u0013Y\u0012aB2mkN$XM\u001d\t\u00039yi\u0011!\b\u0006\u0003\u000fYI!aH\u000f\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005q\u0019\u0013B\u0001\u0013\u001e\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nQ!\u001b8qkR\u0004\"a\u0005\u0015\n\u0005%\"\"a\u0002*fY:{G-\u001a\u0005\tW\u0001\u0011)\u0019!C\u0001Y\u0005a!/\u00198l\rVt7\r^5p]V\tQ\u0006\u0005\u0002/c5\tqF\u0003\u00021-\u0005\u00191/\u001d7\n\u0005Iz#aD*rYJ\u000bgn\u001b$v]\u000e$\u0018n\u001c8\t\u0011Q\u0002!\u0011!Q\u0001\n5\nQB]1oW\u001a+hn\u0019;j_:\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\u0002\u0019A\f'\u000f^5uS>t7*Z=\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\f\u0002\tU$\u0018\u000e\\\u0005\u0003{i\u0012q\"S7nkR\f'\r\\3CSR\u001cV\r\u001e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005q\u0005i\u0001/\u0019:uSRLwN\\&fs\u0002B\u0001\"\u0011\u0001\u0003\u0006\u0004%\tAQ\u0001\u000eg>\u0014HoQ8mY\u0006$\u0018n\u001c8\u0016\u0003\r\u0003\"a\u0005#\n\u0005\u0015#\"\u0001\u0004*fY\u000e{G\u000e\\1uS>t\u0007\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011B\"\u0002\u001dM|'\u000f^\"pY2\fG/[8oA!A\u0011\n\u0001BC\u0002\u0013\u0005!*A\u0005sC:\\'+\u00198hKV\t1\n\u0005\u0002M\u001d6\tQJ\u0003\u0002<\r%\u0011q*\u0014\u0002\n%\u0006t7NU1oO\u0016D\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IaS\u0001\u000be\u0006t7NU1oO\u0016\u0004\u0003\"B*\u0001\t\u0003!\u0016A\u0002\u001fj]&$h\b\u0006\u0005V/bK&l\u0017/^!\t1\u0006!D\u0001\u0003\u0011\u0015Q\"\u000b1\u0001\u001c\u0011\u0015\t#\u000b1\u0001#\u0011\u00151#\u000b1\u0001(\u0011\u0015Y#\u000b1\u0001.\u0011\u00151$\u000b1\u00019\u0011\u0015\t%\u000b1\u0001D\u0011\u0015I%\u000b1\u0001L\u0011\u0015y\u0006\u0001\"\u0011a\u00035!WM]5wKJ{w\u000fV=qKR\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002e)\u0005!A/\u001f9f\u0013\t17MA\u0006SK2$\u0015\r^1UsB,\u0007\"\u00025\u0001\t\u0003J\u0017\u0001D3ya2\f\u0017N\u001c+fe6\u001cHC\u00016n!\t\u00192.\u0003\u0002m)\tI!+\u001a7Xe&$XM\u001d\u0005\u0006]\u001e\u0004\rA[\u0001\u0003a^DQ\u0001\u001d\u0001\u0005BE\f\u0001#Z:uS6\fG/\u001a*po\u000e{WO\u001c;\u0015\u0005ID\bCA:w\u001b\u0005!(\"A;\u0002\u000bM\u001c\u0017\r\\1\n\u0005]$(A\u0002#pk\ndW\rC\u0003z_\u0002\u0007!0\u0001\u0002ncB\u00111P`\u0007\u0002y*\u0011Q\u0010F\u0001\t[\u0016$\u0018\rZ1uC&\u0011q\u0010 \u0002\u0011%\u0016dW*\u001a;bI\u0006$\u0018-U;fefDq!a\u0001\u0001\t\u0003\n)!A\bd_6\u0004X\u000f^3TK247i\\:u)\u0019\t9!!\u0004\u0002\u0018A\u0019A$!\u0003\n\u0007\u0005-QD\u0001\u0006SK2|\u0005\u000f^\"pgRD\u0001\"a\u0004\u0002\u0002\u0001\u0007\u0011\u0011C\u0001\ba2\fgN\\3s!\ra\u00121C\u0005\u0004\u0003+i\"!\u0004*fY>\u0003H\u000f\u00157b]:,'\u000f\u0003\u0004z\u0003\u0003\u0001\rA_\u0004\b\u00037\u0011\u0001\u0012AA\u000f\u0003\u0011\u0011\u0016M\\6\u0011\u0007Y\u000byB\u0002\u0004\u0002\u0005!\u0005\u0011\u0011E\n\u0005\u0003?\t\u0019\u0003E\u0002t\u0003KI1!a\nu\u0005\u0019\te.\u001f*fM\"91+a\b\u0005\u0002\u0005-BCAA\u000f\u0011!\ty#a\b\u0005\u0002\u0005E\u0012AE:peR4\u0015.\u001a7egR{7\u000b\u001e:j]\u001e$B!a\r\u0002BA!\u0011QGA\u001e\u001d\r\u0019\u0018qG\u0005\u0004\u0003s!\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0005}\"AB*ue&twMC\u0002\u0002:QDq!a\u0011\u0002.\u0001\u00071)A\u0007d_2d\u0017\r^5p]N{'\u000f\u001e\u0005\t\u0003_\ty\u0002\"\u0001\u0002HQ1\u00111GA%\u0003\u0017Bq!a\u0011\u0002F\u0001\u00071\tC\u0004\u0002N\u0005\u0015\u0003\u0019A1\u0002\u0013%t\u0007/\u001e;UsB,\u0007")
public abstract class Rank
extends SingleRel {
    private final RelOptCluster cluster;
    private final RelNode input;
    private final SqlRankFunction rankFunction;
    private final ImmutableBitSet partitionKey;
    private final RelCollation sortCollation;
    private final RankRange rankRange;

    public static String sortFieldsToString(RelCollation relCollation, RelDataType relDataType) {
        return Rank$.MODULE$.sortFieldsToString(relCollation, relDataType);
    }

    public static String sortFieldsToString(RelCollation relCollation) {
        return Rank$.MODULE$.sortFieldsToString(relCollation);
    }

    public SqlRankFunction rankFunction() {
        return this.rankFunction;
    }

    public ImmutableBitSet partitionKey() {
        return this.partitionKey;
    }

    public RelCollation sortCollation() {
        return this.sortCollation;
    }

    public RankRange rankRange() {
        return this.rankRange;
    }

    @Override
    public RelDataType deriveRowType() {
        RelDataTypeFactory typeFactory = this.cluster.getRexBuilder().getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
        JavaConversions$.MODULE$.asScalaBuffer(this.input.getRowType().getFieldList()).foreach((Function1)new Serializable(this, typeBuilder){
            public static final long serialVersionUID = 0L;
            private final RelDataTypeFactory.FieldInfoBuilder typeBuilder$1;

            public final RelDataTypeFactory.FieldInfoBuilder apply(RelDataTypeField x$1) {
                return this.typeBuilder$1.add(x$1);
            }
            {
                this.typeBuilder$1 = typeBuilder$1;
            }
        });
        Set allFieldNames = (Set)Set$.MODULE$.apply((Seq)JavaConversions$.MODULE$.asScalaBuffer(this.input.getRowType().getFieldNames()));
        String rankFieldName = FlinkRelOptUtil$.MODULE$.buildUniqueFieldName((Set<String>)allFieldNames, "rk");
        RelDataType bigIntType = typeFactory.createSqlType(SqlTypeName.BIGINT);
        typeBuilder.add(rankFieldName, typeFactory.createTypeWithNullability(bigIntType, false));
        return typeBuilder.build();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String select2 = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(this.getRowType().getFieldNames()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)idx)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        return super.explainTerms(pw).item("rankFunction", this.rankFunction()).item("partitionBy", ((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)this.partitionKey()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Integer i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i}));
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).item("orderBy", Rank$.MODULE$.sortFieldsToString(this.sortCollation())).item("rankRange", this.rankRange().toString()).item("select", select2);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double d;
        Double countPerGroup = FlinkRelMdUtil$.MODULE$.getRankRangeNdv(this.rankRange());
        if (this.partitionKey().isEmpty()) {
            d = Predef$.MODULE$.Double2double(countPerGroup);
        } else {
            Double inputRowCount = mq.getRowCount(this.input);
            Double numOfGroup = mq.getDistinctRowCount(this.input, this.partitionKey(), null);
            d = numOfGroup == null ? Predef$.MODULE$.Double2double(NumberUtil.min(Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(mq.getRowCount(this.input)) * 0.1), inputRowCount)) : Predef$.MODULE$.Double2double(NumberUtil.min(Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(numOfGroup) * Predef$.MODULE$.Double2double(countPerGroup)), inputRowCount));
        }
        return d;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double rowCount;
        Double cpuCost = rowCount = mq.getRowCount(this.input);
        return planner.getCostFactory().makeCost(Predef$.MODULE$.Double2double(rowCount), Predef$.MODULE$.Double2double(cpuCost), 0.0);
    }

    public Rank(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, SqlRankFunction rankFunction, ImmutableBitSet partitionKey, RelCollation sortCollation, RankRange rankRange) {
        RankRange rankRange2;
        block9: {
            block8: {
                block7: {
                    this.cluster = cluster;
                    this.input = input;
                    this.rankFunction = rankFunction;
                    this.partitionKey = partitionKey;
                    this.sortCollation = sortCollation;
                    this.rankRange = rankRange;
                    super(cluster, traitSet, input);
                    rankRange2 = rankRange;
                    if (!(rankRange2 instanceof ConstantRankRange)) break block7;
                    ConstantRankRange constantRankRange = (ConstantRankRange)rankRange2;
                    if (constantRankRange.rankEnd() <= 0L) {
                        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rank end can't smaller than zero. The rank end is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)constantRankRange.rankEnd())})));
                    }
                    if (constantRankRange.rankStart() > constantRankRange.rankEnd()) {
                        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rank start '", "' can't greater than rank end '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)constantRankRange.rankStart()), BoxesRunTime.boxToLong((long)constantRankRange.rankEnd())})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                if (!(rankRange2 instanceof VariableRankRange)) break block9;
                VariableRankRange variableRankRange = (VariableRankRange)rankRange2;
                if (variableRankRange.rankEndIndex() < 0) {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rank end index can't smaller than zero."})).s((Seq)Nil$.MODULE$));
                }
                if (variableRankRange.rankEndIndex() >= input.getRowType().getFieldCount()) {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rank end index can't greater than input field count."})).s((Seq)Nil$.MODULE$));
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)rankRange2);
    }
}

