/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.common;

import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.plan.nodes.common.CommonMatchRecognize;
import org.apache.flink.table.plan.util.SortUtil$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;

public abstract class CommonMatchRecognize$class {
    public static String partitionKeysToString(CommonMatchRecognize $this, java.util.List keys, List fieldNames, Function3 expression2) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(keys).asScala()).map((Function1)new Serializable($this, fieldNames, expression2){
            public static final long serialVersionUID = 0L;
            private final List fieldNames$1;
            private final Function3 expression$1;

            public final String apply(RexNode k) {
                return (String)this.expression$1.apply((Object)k, (Object)this.fieldNames$1, (Object)None$.MODULE$);
            }
            {
                this.fieldNames$1 = fieldNames$1;
                this.expression$1 = expression$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public static String orderingToString(CommonMatchRecognize $this, RelCollation orders, Seq fieldNames) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orders.getFieldCollations()).asScala()).map((Function1)new Serializable($this, fieldNames){
            public static final long serialVersionUID = 0L;
            private final Seq fieldNames$2;

            public final String apply(RelFieldCollation x) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fieldNames$2.apply(x.getFieldIndex()), SortUtil$.MODULE$.directionToOrder(x.direction).getShortName()}));
            }
            {
                this.fieldNames$2 = fieldNames$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public static String measuresDefineToString(CommonMatchRecognize $this, ImmutableMap measures, List fieldNames, Function3 expression2, boolean withOutputFieldNames) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)measures).asScala()).map((Function1)new Serializable($this, fieldNames, expression2, withOutputFieldNames){
            public static final long serialVersionUID = 0L;
            private final List fieldNames$3;
            private final Function3 expression$2;
            private final boolean withOutputFieldNames$1;

            public final String apply(Tuple2<String, RexNode> x0$1) {
                Tuple2<String, RexNode> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    RexNode v = (RexNode)tuple2._2();
                    String string = this.withOutputFieldNames$1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$2.apply((Object)v, (Object)this.fieldNames$3, (Object)None$.MODULE$), k})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$2.apply((Object)v, (Object)this.fieldNames$3, (Object)None$.MODULE$)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fieldNames$3 = fieldNames$3;
                this.expression$2 = expression$2;
                this.withOutputFieldNames$1 = withOutputFieldNames$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public static boolean measuresDefineToString$default$4(CommonMatchRecognize $this) {
        return true;
    }

    public static String subsetToString(CommonMatchRecognize $this, ImmutableMap subset) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)subset).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, SortedSet<String>> x0$2) {
                Tuple2<String, SortedSet<String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    SortedSet v = (SortedSet)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter((Set)v).asScala()).mkString(", ")}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public static String afterMatchToString(CommonMatchRecognize $this, RexNode after, List fieldNames) {
        block5: {
            SqlMatchRecognize.AfterOption afterOption;
            block8: {
                String string;
                block3: {
                    String string2;
                    block7: {
                        block6: {
                            SqlKind sqlKind;
                            block4: {
                                block2: {
                                    sqlKind = after.getKind();
                                    if (!((Object)((Object)SqlKind.SKIP_TO_FIRST)).equals((Object)sqlKind)) break block2;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SKIP TO FIRST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((RexNode)((RexCall)after).operands.get(0)).toString()}));
                                    break block3;
                                }
                                if (!((Object)((Object)SqlKind.SKIP_TO_LAST)).equals((Object)sqlKind)) break block4;
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SKIP TO LAST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((RexNode)((RexCall)after).operands.get(0)).toString()}));
                                break block3;
                            }
                            if (!((Object)((Object)SqlKind.LITERAL)).equals((Object)sqlKind)) break block5;
                            afterOption = ((RexLiteral)after).getValueAs(SqlMatchRecognize.AfterOption.class);
                            if (!((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW)).equals((Object)afterOption)) break block6;
                            string2 = "SKIP PAST LAST ROW";
                            break block7;
                        }
                        if (!((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW)).equals((Object)afterOption)) break block8;
                        string2 = "SKIP TO NEXT ROW";
                    }
                    string = string2;
                }
                return string;
            }
            throw new MatchError((Object)afterOption);
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupted query tree. Unexpected ", " for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{after}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after match strategy."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public static String matchToString(CommonMatchRecognize $this, MatchRecognize logicalMatch, List fieldNames, Function3 expression2) {
        String partitionBy = logicalMatch.partitionKeys().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PARTITION BY: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.partitionKeysToString(logicalMatch.partitionKeys(), (List<String>)fieldNames, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2)}));
        String orderBy = logicalMatch.orderKeys().getFieldCollations().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ORDER BY: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.orderingToString(logicalMatch.orderKeys(), (Seq<String>)fieldNames)}));
        String measures = logicalMatch.measures().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MEASURES: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.measuresDefineToString(logicalMatch.measures(), (List<String>)fieldNames, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2, $this.measuresDefineToString$default$4())}));
        String afterMatch = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.afterMatchToString(logicalMatch.after(), (List<String>)fieldNames)}));
        String allRows = logicalMatch.rowsPerMatch() == null ? "" : logicalMatch.rowsPerMatch().toString();
        String pattern = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PATTERN: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalMatch.pattern().toString()}));
        String interval = logicalMatch.interval() == null ? "" : logicalMatch.interval().toString();
        String subset = logicalMatch.subsets().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUBSET: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.subsetToString(logicalMatch.subsets())}));
        String define = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEFINE: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.measuresDefineToString(logicalMatch.patternDefinitions(), (List<String>)fieldNames, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2, $this.measuresDefineToString$default$4())}));
        String body = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partitionBy, orderBy, measures, allRows, afterMatch, pattern, interval, subset, define}))).filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.isEmpty();
            }
        })).mkString(", ");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Match(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{body}));
    }

    public static RelWriter explainMatch(CommonMatchRecognize $this, RelWriter pw, MatchRecognize logicalMatch, List fieldNames, Function3 expression2) {
        return pw.itemIf("partitionBy", $this.partitionKeysToString(logicalMatch.partitionKeys(), (List<String>)fieldNames, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2), !logicalMatch.partitionKeys().isEmpty()).itemIf("orderBy", $this.orderingToString(logicalMatch.orderKeys(), (Seq<String>)fieldNames), !logicalMatch.orderKeys().getFieldCollations().isEmpty()).itemIf("measures", $this.measuresDefineToString(logicalMatch.measures(), (List<String>)fieldNames, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2, $this.measuresDefineToString$default$4()), !logicalMatch.measures().isEmpty()).itemIf("rowsPerMatch", logicalMatch.rowsPerMatch(), logicalMatch.rowsPerMatch() != null).item("after", $this.afterMatchToString(logicalMatch.after(), (List<String>)fieldNames)).item("pattern", logicalMatch.pattern().toString()).itemIf("within interval", logicalMatch.interval() == null ? null : logicalMatch.interval().toString(), logicalMatch.interval() != null).itemIf("subset", $this.subsetToString(logicalMatch.subsets()), !logicalMatch.subsets().isEmpty()).item("define", logicalMatch.patternDefinitions());
    }

    public static void $init$(CommonMatchRecognize $this) {
    }
}

