/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.exec;

import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CommonExtendedResource;
import org.apache.flink.api.common.resources.Resource;

public class NodeResource {
    private int parallelism = -1;
    private double cpu;
    private int heapMem;
    private int directMem;
    private int reservedManagedMem;
    private int preferManagedMem;
    private int maxManagedMem;

    public void setCpu(double cpu) {
        this.cpu = cpu;
    }

    public double getCpu() {
        return this.cpu;
    }

    public void setHeapMem(int heapMem) {
        this.heapMem = heapMem;
    }

    public int getReservedManagedMem() {
        return this.reservedManagedMem;
    }

    public void setManagedMem(int reservedManagedMem, int preferManagedMem, int maxManagedMem) {
        this.reservedManagedMem = reservedManagedMem;
        this.preferManagedMem = preferManagedMem;
        this.maxManagedMem = maxManagedMem;
    }

    public int getPreferManagedMem() {
        return this.preferManagedMem;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxManagedMem() {
        return this.maxManagedMem;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void setDirectMem(int directMem) {
        this.directMem = directMem;
    }

    public ResourceSpec getReservedResourceSpec() {
        ResourceSpec.Builder builder = ResourceSpec.newBuilder();
        builder.setCpuCores(this.cpu);
        builder.setHeapMemoryInMB(this.heapMem);
        builder.setDirectMemoryInMB(this.directMem);
        builder.addExtendedResource(new CommonExtendedResource("MANAGED_MEMORY_MB", this.getReservedManagedMem(), Resource.ResourceAggregateType.AGGREGATE_TYPE_SUM));
        builder.addExtendedResource(new CommonExtendedResource("FLOATING_MANAGED_MEMORY_MB", this.getPreferManagedMem() - this.getReservedManagedMem(), Resource.ResourceAggregateType.AGGREGATE_TYPE_SUM));
        return builder.build();
    }

    public ResourceSpec getPreferResourceSpec() {
        ResourceSpec.Builder builder = ResourceSpec.newBuilder();
        builder.setCpuCores(this.cpu);
        builder.setHeapMemoryInMB(this.heapMem);
        builder.setDirectMemoryInMB(this.directMem);
        builder.addExtendedResource(new CommonExtendedResource("MANAGED_MEMORY_MB", this.getPreferManagedMem(), Resource.ResourceAggregateType.AGGREGATE_TYPE_SUM));
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NodeResource{");
        if (this.parallelism > 0) {
            sb.append("parallelism=").append(this.parallelism);
        }
        if (this.cpu > 0.0) {
            sb.append(", cpu=").append(this.cpu);
        }
        if (this.heapMem > 0) {
            sb.append(", heapMem=").append(this.heapMem);
        }
        if (this.directMem > 0) {
            sb.append(", directMem=").append(this.directMem);
        }
        if (this.reservedManagedMem > 0) {
            sb.append(", reservedManagedMem=").append(this.reservedManagedMem);
        }
        if (this.preferManagedMem > 0) {
            sb.append(", preferManagedMem=").append(this.preferManagedMem);
        }
        if (this.maxManagedMem > 0) {
            sb.append(", maxManagedMem=").append(this.maxManagedMem);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeResource resource = (NodeResource)o;
        if (this.parallelism != resource.parallelism) {
            return false;
        }
        if (Double.compare(resource.cpu, this.cpu) != 0) {
            return false;
        }
        if (this.heapMem != resource.heapMem) {
            return false;
        }
        if (this.directMem != resource.directMem) {
            return false;
        }
        if (this.reservedManagedMem != resource.reservedManagedMem) {
            return false;
        }
        if (this.preferManagedMem != resource.preferManagedMem) {
            return false;
        }
        return this.maxManagedMem == resource.maxManagedMem;
    }

    public int hashCode() {
        int result = this.parallelism;
        long temp = Double.doubleToLongBits(this.cpu);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.heapMem;
        result = 31 * result + this.directMem;
        result = 31 * result + this.reservedManagedMem;
        result = 31 * result + this.preferManagedMem;
        result = 31 * result + this.maxManagedMem;
        return result;
    }
}

