/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.logical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.functions.TemporalTableFunction;
import org.apache.flink.table.functions.utils.TableSqlFunction;
import org.apache.flink.table.plan.metadata.FlinkRelMetadataQuery$;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalValues;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001#\t1c\t\\5oW2{w-[2bYR\u000b'\r\\3Gk:\u001cG/[8o'\u000e\fgnQ8om\u0016\u0014H/\u001a:\u000b\u0005\r!\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\tQA\\8eKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001455\tAC\u0003\u0002\u0016-\u000591m\u001c8wKJ$(BA\f\u0019\u0003\r\u0011X\r\u001c\u0006\u000331\tqaY1mG&$X-\u0003\u0002\u001c)\ti1i\u001c8wKJ$XM\u001d*vY\u0016DQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000b\t\u0002A\u0011I\u0012\u0002\u000f5\fGo\u00195fgR\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\b\u0005>|G.Z1o\u0011\u0015Y\u0013\u00051\u0001-\u0003\u0011\u0019\u0017\r\u001c7\u0011\u00055zS\"\u0001\u0018\u000b\u0005\u001dA\u0012B\u0001\u0019/\u00059\u0011V\r\\(qiJ+H.Z\"bY2DQA\r\u0001\u0005\nM\n1$[:UK6\u0004xN]1m)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8DC2dGC\u0001\u00135\u0011\u0015)\u0014\u00071\u00017\u0003QawnZ5dC2$\u0016M\u00197f\rVt7\r^5p]B\u0011q'O\u0007\u0002q)\u00111AF\u0005\u0003ua\u0012\u0001\u0004T8hS\u000e\fG\u000eV1cY\u00164UO\\2uS>t7kY1o\u0011\u0015)\u0002\u0001\"\u0001=)\ti\u0014\t\u0005\u0002?\u007f5\ta#\u0003\u0002A-\t9!+\u001a7O_\u0012,\u0007\"B\f<\u0001\u0004i\u0004\"B\"\u0001\t\u0003!\u0015aG2sK\u0006$XM\u00127j].dunZ5dC2$\u0016M\u00197f'\u000e\fg\u000eF\u0002F\u0011*\u0003\"\u0001\t$\n\u0005\u001d\u0013!!\b$mS:\\Gj\\4jG\u0006dG+\u00192mK\u001a+hn\u0019;j_:\u001c6-\u00198\t\u000b%\u0013\u0005\u0019\u0001\u001c\u0002\tM\u001c\u0017M\u001c\u0005\u0006\u0017\n\u0003\r\u0001T\u0001\tiJ\f\u0017\u000e^*fiB\u0011Q&T\u0005\u0003\u001d:\u00121BU3m)J\f\u0017\u000e^*fi\")\u0001\u000b\u0001C\u0001#\u0006\u00013m\u001c8wKJ$8i\u001c8ti\u0006tGOR;oGRLwN\u001c+bE2,7kY1o)\ri$k\u0015\u0005\u0006\u0013>\u0003\rA\u000e\u0005\u0006\u0017>\u0003\r\u0001\u0014")
public class FlinkLogicalTableFunctionScanConverter
extends ConverterRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalTableFunctionScan logicalTableFunction = (LogicalTableFunctionScan)call.rel(0);
        return !this.isTemporalTableFunctionCall(logicalTableFunction);
    }

    private boolean isTemporalTableFunctionCall(LogicalTableFunctionScan logicalTableFunction) {
        if (logicalTableFunction.getCall() instanceof RexCall) {
            RexCall rexCall = (RexCall)logicalTableFunction.getCall();
            if (rexCall.getOperator() instanceof TableSqlFunction) {
                TableSqlFunction tableFunction = (TableSqlFunction)rexCall.getOperator();
                return tableFunction.udtf() instanceof TemporalTableFunction;
            }
            return false;
        }
        return false;
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalTableFunctionScan scan = (LogicalTableFunctionScan)rel;
        RelTraitSet traitSet = FlinkRelMetadataQuery$.MODULE$.traitSet(rel).replace(FlinkConventions$.MODULE$.LOGICAL()).simplify();
        boolean constantTableFunction = RexUtil.isConstant(scan.getCall()) && scan.getInputs().isEmpty();
        return constantTableFunction ? this.convertConstantFunctionTableScan(scan, traitSet) : this.createFlinkLogicalTableScan(scan, traitSet);
    }

    public FlinkLogicalTableFunctionScan createFlinkLogicalTableScan(LogicalTableFunctionScan scan, RelTraitSet traitSet) {
        return new FlinkLogicalTableFunctionScan(scan.getCluster(), traitSet, scan.getInputs(), scan.getCall(), scan.getElementType(), scan.getRowType(), scan.getColumnMappings());
    }

    public RelNode convertConstantFunctionTableScan(LogicalTableFunctionScan scan, RelTraitSet traitSet) {
        RelOptCluster cluster = scan.getCluster();
        FlinkLogicalValues values = new FlinkLogicalValues(cluster, traitSet, cluster.getTypeFactory().createStructType(ImmutableList.<RelDataType>of(), ImmutableList.<String>of()), ImmutableList.of(ImmutableList.of()));
        FlinkLogicalTableFunctionScan newScan = this.createFlinkLogicalTableScan(scan, traitSet);
        return new FlinkLogicalCorrelate(cluster, traitSet, values, newScan, cluster.createCorrel(), ImmutableBitSet.of(), SemiJoinType.INNER);
    }

    public FlinkLogicalTableFunctionScanConverter() {
        super(LogicalTableFunctionScan.class, Convention.NONE, FlinkConventions$.MODULE$.LOGICAL(), "FlinkLogicalTableFunctionScanConverter");
    }
}

