/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.CodeGeneratorContext$;
import org.apache.flink.table.codegen.GeneratedJoinConditionFunction;
import org.apache.flink.table.codegen.GeneratedProjection;
import org.apache.flink.table.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.codegen.operator.LongHashJoinGenerator$;
import org.apache.flink.table.plan.cost.FlinkBatchCost$;
import org.apache.flink.table.plan.cost.FlinkCostFactory;
import org.apache.flink.table.plan.nodes.ExpressionFormat$;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.exec.batch.BatchExecNodeVisitor;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecHashJoinBase;
import org.apache.flink.table.plan.nodes.physical.batch.BatchPhysicalRel$;
import org.apache.flink.table.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.plan.util.JoinUtil$;
import org.apache.flink.table.runtime.fault.tolerant.FaultTolerantUtil;
import org.apache.flink.table.runtime.join.batch.HashJoinOperator;
import org.apache.flink.table.runtime.join.batch.HashJoinType;
import org.apache.flink.table.runtime.join.batch.hashtable.BinaryHashBucketArea;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.util.NodeResourceUtil;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class BatchExecHashJoinBase$class {
    public static RelNode buildRel(BatchExecHashJoinBase $this) {
        return $this.leftIsBuild() ? ((BiRel)((Object)$this)).getLeft() : ((BiRel)((Object)$this)).getRight();
    }

    public static RelNode probeRel(BatchExecHashJoinBase $this) {
        return $this.leftIsBuild() ? ((BiRel)((Object)$this)).getRight() : ((BiRel)((Object)$this)).getLeft();
    }

    public static void insertRuntimeFilter(BatchExecHashJoinBase $this) {
        $this.haveInsertRf_$eq(true);
    }

    public static RelWriter explainTerms(BatchExecHashJoinBase $this, RelWriter pw) {
        return $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$super$explainTerms(pw).itemIf("isBroadcast", "true", $this.isBroadcast()).item("build", $this.leftIsBuild() ? "left" : "right").itemIf("tryDistinctBuildRow", "true", $this.tryDistinctBuildRow());
    }

    public static RelNode satisfyTraitsByInput(BatchExecHashJoinBase $this, RelTraitSet requiredTraitSet) {
        return $this.isBroadcast() ? $this.pushDownTraitsIntoBroadcastJoin(requiredTraitSet, $this.leftIsBuild()) : BatchExecHashJoinBase$class.pushDownTraitsIntoNonBroadcastHashJoin($this, requiredTraitSet);
    }

    private static RelNode pushDownTraitsIntoNonBroadcastHashJoin(BatchExecHashJoinBase $this, RelTraitSet requiredTraitSet) {
        FlinkRelDistribution requiredDistribution = requiredTraitSet.getTrait(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE());
        Tuple3<Object, FlinkRelDistribution, FlinkRelDistribution> tuple3 = $this.pushDownHashDistributionIntoNonBroadcastJoin(requiredDistribution);
        if (tuple3 != null) {
            Tuple3 tuple32;
            boolean canPushDown = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            FlinkRelDistribution leftDistribution = (FlinkRelDistribution)tuple3._2();
            FlinkRelDistribution rightDistribution = (FlinkRelDistribution)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)canPushDown), (Object)leftDistribution, (Object)rightDistribution);
            boolean canPushDown2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
            FlinkRelDistribution leftDistribution2 = (FlinkRelDistribution)tuple33._2();
            FlinkRelDistribution rightDistribution2 = (FlinkRelDistribution)tuple33._3();
            if (canPushDown2) {
                Serializable toRestrictHashDistributionByKeys = new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BatchExecHashJoinBase $outer;

                    public final RelTraitSet apply(FlinkRelDistribution distribution) {
                        return ((AbstractRelNode)((Object)this.$outer)).getCluster().getPlanner().emptyTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL()).replace(distribution);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                RelTraitSet leftRequiredTrait = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)leftDistribution2);
                RelTraitSet rightRequiredTrait = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)rightDistribution2);
                RelNode newLeft = RelOptRule.convert(((BiRel)((Object)$this)).getLeft(), leftRequiredTrait);
                RelNode newRight = RelOptRule.convert(((BiRel)((Object)$this)).getRight(), rightRequiredTrait);
                return ((Join)((Object)$this)).copy(((AbstractRelNode)((Object)$this)).getTraitSet().replace(requiredDistribution), JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{newLeft, newRight}))));
            }
            return null;
        }
        throw new MatchError(tuple3);
    }

    public static RelOptCost computeSelfCost(BatchExecHashJoinBase $this, RelOptPlanner planner, RelMetadataQuery mq) {
        Tuple2 tuple2;
        Double leftRowCnt = mq.getRowCount(((BiRel)((Object)$this)).getLeft());
        Double rightRowCnt = mq.getRowCount(((BiRel)((Object)$this)).getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        double cpuCost = (double)FlinkBatchCost$.MODULE$.HASH_CPU_COST() * (Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt));
        Tuple2 tuple22 = tuple2 = $this.leftIsBuild() ? new Tuple2((Object)leftRowCnt, (Object)BoxesRunTime.boxToDouble((double)BatchPhysicalRel$.MODULE$.binaryRowAverageSize(((BiRel)((Object)$this)).getLeft()))) : new Tuple2((Object)rightRowCnt, (Object)BoxesRunTime.boxToDouble((double)BatchPhysicalRel$.MODULE$.binaryRowAverageSize(((BiRel)((Object)$this)).getRight())));
        if (tuple2 != null) {
            Tuple2 tuple23;
            Double buildRowCount = (Double)tuple2._1();
            double buildRowSize = tuple2._2$mcD$sp();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)buildRowCount, (Object)BoxesRunTime.boxToDouble((double)buildRowSize));
            Double buildRowCount2 = (Double)tuple24._1();
            double buildRowSize2 = tuple24._2$mcD$sp();
            double bucketSize = Predef$.MODULE$.Double2double(buildRowCount2) * (double)BinaryHashBucketArea.RECORD_BYTES / (double)BatchPhysicalRel$.MODULE$.HASH_COLLISION_WEIGHT();
            double recordSize = Predef$.MODULE$.Double2double(buildRowCount2) * (buildRowSize2 + (double)4);
            double memCost = (bucketSize + recordSize) * (double)$this.shuffleBuildCount(mq);
            FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
            return costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount($this)), cpuCost, 0.0, 0.0, memCost);
        }
        throw new MatchError((Object)tuple2);
    }

    public static int shuffleBuildCount(BatchExecHashJoinBase $this, RelMetadataQuery mq) {
        int n;
        RelNode probeRel;
        RelNode relNode = probeRel = $this.leftIsBuild() ? ((BiRel)((Object)$this)).getRight() : ((BiRel)((Object)$this)).getLeft();
        if ($this.isBroadcast()) {
            double rowCount = Util.first(mq.getRowCount(probeRel), 1.0);
            double shuffleCount = rowCount * Predef$.MODULE$.Double2double(mq.getAverageRowSize(probeRel)) / (double)FlinkBatchCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE();
            n = Math.max(1, (int)shuffleCount);
        } else {
            n = 1;
        }
        return n;
    }

    public static DamBehavior getDamBehavior(BatchExecHashJoinBase $this) {
        return $this.hashJoinType().buildLeftSemiOrAnti() ? DamBehavior.FULL_DAM : DamBehavior.MATERIALIZING;
    }

    public static void accept(BatchExecHashJoinBase $this, BatchExecNodeVisitor visitor) {
        visitor.visit($this);
    }

    public static StreamTransformation translateToPlanInternal(BatchExecHashJoinBase $this, BatchTableEnvironment tableEnv) {
        Tuple7 tuple7;
        TableConfig config = tableEnv.getConfig();
        StreamTransformation<?> lInput = $this.getInputNodes().get(0).translateToPlan(tableEnv);
        StreamTransformation<?> rInput = $this.getInputNodes().get(1).translateToPlan(tableEnv);
        RowType lType = (RowType)TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(lInput.getOutputType());
        RowType rType = (RowType)TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(rInput.getOutputType());
        RowType keyType = new RowType((DataType[])((TraversableOnce)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$leftKeys().map((Function1)new Serializable($this, lType){
            public static final long serialVersionUID = 0L;
            private final RowType lType$1;

            public final DataType apply(int x$5) {
                return this.lType$1.getFieldTypes()[x$5];
            }
            {
                this.lType$1 = lType$1;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class)));
        long managedMemorySize = (long)$this.getResource().getReservedManagedMem() * NodeResourceUtil.SIZE_IN_MB;
        long maxMemorySize = (long)$this.getResource().getMaxManagedMem() * NodeResourceUtil.SIZE_IN_MB;
        GeneratedJoinConditionFunction condFunc = $this.generateConditionFunction(config, lType, rType);
        GeneratedProjection lProj = ProjectionCodeGenerator$.MODULE$.generateProjection(CodeGeneratorContext$.MODULE$.apply(config, CodeGeneratorContext$.MODULE$.apply$default$2()), "HashJoinLeftProjection", lType, keyType, (int[])$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$leftKeys().toArray(ClassTag$.MODULE$.Int()));
        GeneratedProjection rProj = ProjectionCodeGenerator$.MODULE$.generateProjection(CodeGeneratorContext$.MODULE$.apply(config, CodeGeneratorContext$.MODULE$.apply$default$2()), "HashJoinRightProjection", rType, keyType, (int[])$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$rightKeys().toArray(ClassTag$.MODULE$.Int()));
        Tuple7 tuple72 = tuple7 = $this.leftIsBuild() ? new Tuple7(lInput, rInput, (Object)lProj, (Object)rProj, (Object)lType, (Object)rType, (Object)BoxesRunTime.boxToBoolean((boolean)false)) : new Tuple7(rInput, lInput, (Object)rProj, (Object)lProj, (Object)rType, (Object)lType, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (tuple7 != null) {
            Tuple7 tuple73;
            StreamTransformation build2 = (StreamTransformation)tuple7._1();
            StreamTransformation probe = (StreamTransformation)tuple7._2();
            GeneratedProjection bProj = (GeneratedProjection)tuple7._3();
            GeneratedProjection pProj = (GeneratedProjection)tuple7._4();
            RowType bType = (RowType)tuple7._5();
            RowType pType = (RowType)tuple7._6();
            boolean reverseJoin = BoxesRunTime.unboxToBoolean((Object)tuple7._7());
            Tuple7 tuple74 = tuple73 = new Tuple7((Object)build2, (Object)probe, (Object)bProj, (Object)pProj, (Object)bType, (Object)pType, (Object)BoxesRunTime.boxToBoolean((boolean)reverseJoin));
            StreamTransformation build3 = (StreamTransformation)tuple74._1();
            StreamTransformation probe2 = (StreamTransformation)tuple74._2();
            GeneratedProjection bProj2 = (GeneratedProjection)tuple74._3();
            GeneratedProjection pProj2 = (GeneratedProjection)tuple74._4();
            RowType bType2 = (RowType)tuple74._5();
            RowType pType2 = (RowType)tuple74._6();
            boolean reverseJoin2 = BoxesRunTime.unboxToBoolean((Object)tuple74._7());
            long perRequestSize = (long)NodeResourceUtil.getPerRequestManagedMemory(config.getConf()) * NodeResourceUtil.SIZE_IN_MB;
            RelMetadataQuery mq = ((AbstractRelNode)((Object)$this)).getCluster().getMetadataQuery();
            int buildRowSize = (int)Util.first(mq.getAverageRowSize($this.buildRel()), 24.0);
            long buildRowCount = (long)Util.first(mq.getRowCount($this.buildRel()), 200000.0);
            long probeRowCount = (long)Util.first(mq.getRowCount($this.probeRel()), 200000.0);
            HashJoinOperator operator = LongHashJoinGenerator$.MODULE$.support($this.hashJoinType(), keyType, $this.filterNulls()) ? LongHashJoinGenerator$.MODULE$.gen(config, $this.hashJoinType(), keyType, bType2, pType2, (int[])$this.buildKeys().toArray(ClassTag$.MODULE$.Int()), (int[])$this.probeKeys().toArray(ClassTag$.MODULE$.Int()), managedMemorySize, maxMemorySize, perRequestSize, buildRowSize, buildRowCount, reverseJoin2, condFunc) : HashJoinOperator.newHashJoinOperator(managedMemorySize, maxMemorySize, perRequestSize, $this.hashJoinType(), condFunc, reverseJoin2, $this.filterNulls(), bProj2, pProj2, $this.tryDistinctBuildRow(), buildRowSize, buildRowCount, probeRowCount, keyType);
            String operatorName = BatchExecHashJoinBase$class.getOperatorName($this);
            TwoInputTransformation transformation = new TwoInputTransformation(build3, probe2, operatorName, FaultTolerantUtil.addFaultTolerantProxyIfNeed(operator, operatorName, config), (TypeInformation)FlinkTypeFactory$.MODULE$.toInternalBaseRowTypeInfo(((AbstractRelNode)((Object)$this)).getRowType()), $this.getResource().getParallelism());
            tableEnv.getRUKeeper().addTransformation($this, (StreamTransformation<?>)transformation);
            transformation.setDamBehavior($this.getDamBehavior());
            transformation.setReadOrderHint(TwoInputTransformation.ReadOrder.INPUT1_FIRST);
            transformation.setResources($this.getResource().getReservedResourceSpec(), $this.getResource().getPreferResourceSpec());
            return transformation;
        }
        throw new MatchError((Object)tuple7);
    }

    private static String getOperatorName(BatchExecHashJoinBase $this) {
        List inFields = JavaConversions$.MODULE$.asScalaBuffer($this.inputDataType().getFieldNames()).toList();
        String joinExpressionStr = ((Join)((Object)$this)).getCondition() == null ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"where: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getExpressionString(((Join)((Object)$this)).getCondition(), (List<String>)inFields, (Option<List<RexNode>>)None$.MODULE$, ExpressionFormat$.MODULE$.Infix())}));
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HashJoin(", "", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{joinExpressionStr, $this.leftIsBuild() ? "buildLeft" : "buildRight"}));
    }

    public static void $init$(BatchExecHashJoinBase $this) {
        Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> tuple2 = JoinUtil$.MODULE$.checkAndGetKeys($this.keyPairs(), ((BiRel)((Object)$this)).getLeft(), ((BiRel)((Object)$this)).getRight(), true);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ArrayBuffer leftKeys = (ArrayBuffer)tuple2._1();
            ArrayBuffer rightKeys = (ArrayBuffer)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)leftKeys, (Object)rightKeys);
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$_setter_$org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$x$1_$eq(tuple23);
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$_setter_$org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$leftKeys_$eq((ArrayBuffer)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$x$1()._1());
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$_setter_$org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$rightKeys_$eq((ArrayBuffer)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$x$1()._2());
            Tuple2 tuple24 = tuple22 = $this.leftIsBuild() ? new Tuple2($this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$leftKeys(), $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$rightKeys()) : new Tuple2($this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$rightKeys(), $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$leftKeys());
            if (tuple22 != null) {
                ArrayBuffer buildKeys = (ArrayBuffer)tuple22._1();
                ArrayBuffer probeKeys = (ArrayBuffer)tuple22._2();
                Tuple2 tuple25 = new Tuple2((Object)buildKeys, (Object)probeKeys);
                $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$_setter_$org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$x$2_$eq(tuple25);
                $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$_setter_$buildKeys_$eq((ArrayBuffer)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$x$2()._1());
                $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$_setter_$probeKeys_$eq((ArrayBuffer)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$$x$2()._2());
                $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecHashJoinBase$_setter_$hashJoinType_$eq(HashJoinType.of($this.flinkJoinType(), $this.leftIsBuild()));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(tuple2);
    }
}

