/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.physical.stream;

import java.time.Duration;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.codegen.GeneratedRecordEqualiser;
import org.apache.flink.table.codegen.GeneratedSubKeyedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.errorcode.TableErrors;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils$;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.plan.nodes.exec.BaseStreamExecNode$class;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode$class;
import org.apache.flink.table.plan.nodes.exec.ExecNodeVisitor;
import org.apache.flink.table.plan.nodes.exec.ExecNodeWriter;
import org.apache.flink.table.plan.nodes.exec.NodeResource;
import org.apache.flink.table.plan.nodes.exec.RowStreamExecNode;
import org.apache.flink.table.plan.nodes.exec.StreamExecNode$class;
import org.apache.flink.table.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.plan.nodes.physical.FlinkPhysicalRel$class;
import org.apache.flink.table.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.plan.nodes.physical.stream.StreamPhysicalRel$class;
import org.apache.flink.table.plan.rules.physical.stream.StreamExecRetractionRules$;
import org.apache.flink.table.plan.schema.BaseRowSchema;
import org.apache.flink.table.plan.util.AggregateInfoList;
import org.apache.flink.table.plan.util.AggregateNameUtil$;
import org.apache.flink.table.plan.util.AggregateUtil$;
import org.apache.flink.table.plan.util.EmitStrategy;
import org.apache.flink.table.plan.util.StreamExecUtil$;
import org.apache.flink.table.plan.util.WindowAggregateUtil$;
import org.apache.flink.table.runtime.BaseRowKeySelector;
import org.apache.flink.table.runtime.fault.tolerant.FaultTolerantUtil;
import org.apache.flink.table.runtime.window.AbstractAlignedWindowOperator;
import org.apache.flink.table.runtime.window.KeyedAlignedWindowOperator;
import org.apache.flink.table.runtime.window.WindowOperator;
import org.apache.flink.table.runtime.window.WindowOperatorBuilder;
import org.apache.flink.table.runtime.window.aligned.AlignedWindowTrigger;
import org.apache.flink.table.runtime.window.aligned.InternalAlignedWindowTriggers;
import org.apache.flink.table.runtime.window.aligned.OnePhaseAlignedWindowAggregator;
import org.apache.flink.table.runtime.window.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.TumblingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.WindowAssigner;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.util.Logging$class;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B\u0001\u0003\u0001M\u0011ad\u0015;sK\u0006lW\t_3d\u000fJ|W\u000f],j]\u0012|w/Q4he\u0016<\u0017\r^3\u000b\u0005\r!\u0011AB:ue\u0016\fWN\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)an\u001c3fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!B\u0004\t\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t1A]3m\u0015\tIb\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005m1\"!C*j]\u001edWMU3m!\tib$D\u0001\u0003\u0013\ty\"AA\tTiJ,\u0017-\u001c)isNL7-\u00197SK2\u0004\"!\t\u0013\u000e\u0003\tR!a\t\u0004\u0002\t\u0015DXmY\u0005\u0003K\t\u0012\u0011CU8x'R\u0014X-Y7Fq\u0016\u001cgj\u001c3f\u0011!9\u0003A!b\u0001\n\u0003A\u0013AB<j]\u0012|w/F\u0001*!\tQS&D\u0001,\u0015\ta\u0003\"A\u0004m_\u001eL7-\u00197\n\u00059Z#!\u0004'pO&\u001c\u0017\r\\,j]\u0012|w\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u0003*\u0003\u001d9\u0018N\u001c3po\u0002B\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0010]\u0006lW\r\u001a)s_B,'\u000f^5fgB\u0019AGP!\u000f\u0005UZdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0013\u0003\u0019a$o\\8u}%\t!(A\u0003tG\u0006d\u0017-\u0003\u0002={\u00059\u0001/Y2lC\u001e,'\"\u0001\u001e\n\u0005}\u0002%aA*fc*\u0011A(\u0010\t\u0003\u0005Bs!aQ'\u000f\u0005\u0011ceBA#L\u001d\t1%J\u0004\u0002H\u0013:\u0011a\u0007S\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005eQ\u0011B\u0001(P\u0003=1E.\u001b8l%\u0016d')^5mI\u0016\u0014(BA\r\u000b\u0013\t\t&KA\nOC6,GmV5oI><\bK]8qKJ$\u0018P\u0003\u0002O\u001f\"AA\u000b\u0001B\u0001B\u0003%Q+A\u0004dYV\u001cH/\u001a:\u0011\u0005YCV\"A,\u000b\u0005%A\u0012BA-X\u00055\u0011V\r\\(qi\u000ecWo\u001d;fe\"A1\f\u0001B\u0001B\u0003%A,\u0001\u0005ue\u0006LGoU3u!\t1V,\u0003\u0002_/\nY!+\u001a7Ue\u0006LGoU3u\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0017!C5oaV$hj\u001c3f!\t)\"-\u0003\u0002d-\t9!+\u001a7O_\u0012,\u0007\u0002C3\u0001\u0005\u000b\u0007I\u0011\u00014\u0002\u0011\u0005<wmQ1mYN,\u0012a\u001a\t\u0004iyB\u0007CA5m\u001b\u0005Q'BA6\u0017\u0003\u0011\u0019wN]3\n\u00055T'!D!hOJ,w-\u0019;f\u0007\u0006dG\u000e\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003h\u0003%\twmZ\"bY2\u001c\b\u0005\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003s\u00031yW\u000f\u001e9viN\u001b\u0007.Z7b!\t\u0019h/D\u0001u\u0015\t)\b\"\u0001\u0004tG\",W.Y\u0005\u0003oR\u0014QBQ1tKJ{woU2iK6\f\u0007\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\u0002\u0017%t\u0007/\u001e;TG\",W.\u0019\u0005\tw\u0002\u0011\t\u0011)A\u0005y\u0006AqM]8va&tw\r\u0005\u0003~}\u0006\u0005Q\"A\u001f\n\u0005}l$!B!se\u0006L\bcA?\u0002\u0004%\u0019\u0011QA\u001f\u0003\u0007%sG\u000f\u0003\u0006\u0002\n\u0001\u0011)\u0019!C\u0001\u0003\u0017\t1#\u001b8qkR$\u0016.\\3ti\u0006l\u0007/\u00138eKb,\"!!\u0001\t\u0015\u0005=\u0001A!A!\u0002\u0013\t\t!\u0001\u000bj]B,H\u000fV5nKN$\u0018-\u001c9J]\u0012,\u0007\u0010\t\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0011\u0001D3nSR\u001cFO]1uK\u001eLXCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u0011\u0005!Q\u000f^5m\u0013\u0011\t\t#a\u0007\u0003\u0019\u0015k\u0017\u000e^*ue\u0006$XmZ=\t\u0015\u0005\u0015\u0002A!A!\u0002\u0013\t9\"A\u0007f[&$8\u000b\u001e:bi\u0016<\u0017\u0010\t\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003\u0019a\u0014N\\5u}QA\u0012QFA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0011\u0005u\u0001\u0001BB\u0014\u0002(\u0001\u0007\u0011\u0006\u0003\u00043\u0003O\u0001\ra\r\u0005\u0007)\u0006\u001d\u0002\u0019A+\t\rm\u000b9\u00031\u0001]\u0011\u0019\u0001\u0017q\u0005a\u0001C\"1Q-a\nA\u0002\u001dDa!]A\u0014\u0001\u0004\u0011\bBB=\u0002(\u0001\u0007!\u000f\u0003\u0004|\u0003O\u0001\r\u0001 \u0005\t\u0003\u0013\t9\u00031\u0001\u0002\u0002!A\u00111CA\u0014\u0001\u0004\t9\u0002C\u0004\u0002H\u0001!\t%!\u0013\u0002\u001b\u0011,'/\u001b<f%><H+\u001f9f)\t\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tFF\u0001\u0005if\u0004X-\u0003\u0003\u0002V\u0005=#a\u0003*fY\u0012\u000bG/\u0019+za\u0016Dq!!\u0017\u0001\t\u0003\nY&A\bqe>$WoY3t+B$\u0017\r^3t+\t\ti\u0006E\u0002~\u0003?J1!!\u0019>\u0005\u001d\u0011un\u001c7fC:Dq!!\u001a\u0001\t\u0003\nY&A\nd_:\u001cX/\\3t%\u0016$(/Y2uS>t7\u000fC\u0004\u0002j\u0001!\t%a\u001b\u000219,W\rZ:Va\u0012\fG/Z:BgJ+GO]1di&|g\u000e\u0006\u0003\u0002^\u00055\u0004bBA8\u0003O\u0002\r!Y\u0001\u0006S:\u0004X\u000f\u001e\u0005\b\u0003g\u0002A\u0011IA.\u0003A\u0011X-];je\u0016<\u0016\r^3s[\u0006\u00148\u000eC\u0004\u0002x\u0001!\t!!\u001f\u0002\u0019\u001d,Go\u0012:pkBLgnZ:\u0016\u0003qDq!! \u0001\t\u0003\ty(A\nhKR<\u0016N\u001c3poB\u0013x\u000e]3si&,7/F\u00014\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u000bAaY8qsR)\u0011-a\"\u0002\n\"11,!!A\u0002qC\u0001\"a#\u0002\u0002\u0002\u0007\u0011QR\u0001\u0007S:\u0004X\u000f^:\u0011\u000b\u0005=\u0015qS1\u000e\u0005\u0005E%\u0002BA\u000f\u0003'S!!!&\u0002\t)\fg/Y\u0005\u0005\u00033\u000b\tJ\u0001\u0003MSN$\bbBAO\u0001\u0011\u0005\u0013qT\u0001\rKb\u0004H.Y5o)\u0016\u0014Xn\u001d\u000b\u0005\u0003C\u000b9\u000bE\u0002\u0016\u0003GK1!!*\u0017\u0005%\u0011V\r\\,sSR,'\u000f\u0003\u0005\u0002*\u0006m\u0005\u0019AAQ\u0003\t\u0001x\u000fC\u0004\u0002.\u0002!\t%a\u0017\u0002\u001f%\u001cH)\u001a;fe6Lg.[:uS\u000eDq!!-\u0001\t\u0003\n\u0019,A\nhKR4E.\u001b8l!\"L8/[2bYJ+G.\u0006\u0002\u00026B!\u0011qWA]\u001b\u0005!\u0011bAA^\t\t\u0001b\t\\5oWBC\u0017p]5dC2\u0014V\r\u001c\u0005\b\u0003\u007f\u0003A\u0011IAa\u000399W\r^*uCR,G)[4fgR$B!a1\u0002JB\u0019\u0011%!2\n\u0007\u0005\u001d'E\u0001\bFq\u0016\u001cgj\u001c3f/JLG/\u001a:\t\u0011\u0005%\u0016Q\u0018a\u0001\u0003\u0007Dq!!4\u0001\t\u0003\ny-A\fue\u0006t7\u000f\\1uKR{\u0007\u000b\\1o\u0013:$XM\u001d8bYR!\u0011\u0011[Ay!\u0019\t\u0019.!9\u0002f6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.A\bue\u0006t7OZ8s[\u0006$\u0018n\u001c8t\u0015\u0011\tY.!8\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002`2\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005\r\u0018Q\u001b\u0002\u0015'R\u0014X-Y7Ue\u0006t7OZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;\u000b\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u0005\u0003_\fIOA\u0004CCN,'k\\<\t\u0011\u0005M\u00181\u001aa\u0001\u0003k\f\u0001\u0002^1cY\u0016,eN\u001e\t\u0005\u0003o\fY0\u0004\u0002\u0002z*\u0019\u00111\u001c\u0006\n\t\u0005u\u0018\u0011 \u0002\u0017'R\u0014X-Y7UC\ndW-\u00128wSJ|g.\\3oi\"9!\u0011\u0001\u0001\u0005\n\t\r\u0011\u0001G5t/&tGm\\<NS:L')\u0019;dQ\u0016s\u0017M\u00197fIR!\u0011Q\fB\u0003\u0011!\u00119!a@A\u0002\t%\u0011AB2p]\u001aLw\r\u0005\u0003\u0002x\n-\u0011\u0002\u0002B\u0007\u0003s\u00141\u0002V1cY\u0016\u001cuN\u001c4jO\"9!\u0011\u0003\u0001\u0005\n\tM\u0011aD2sK\u0006$X-R9vC2L7/\u001a:\u0015\r\tU!\u0011\u0005B\u001a!\u0011\u00119B!\b\u000e\u0005\te!b\u0001B\u000e\u0015\u000591m\u001c3fO\u0016t\u0017\u0002\u0002B\u0010\u00053\u0011\u0001dR3oKJ\fG/\u001a3SK\u000e|'\u000fZ#rk\u0006d\u0017n]3s\u0011!\u0011\u0019Ca\u0004A\u0002\t\u0015\u0012AD1hOJ+7/\u001e7u)f\u0004Xm\u001d\t\u0005{z\u00149\u0003\u0005\u0003\u0003*\t=RB\u0001B\u0016\u0015\r\u0011iCC\u0001\u0006if\u0004Xm]\u0005\u0005\u0005c\u0011YC\u0001\u0007J]R,'O\\1m)f\u0004X\r\u0003\u0005\u00036\t=\u0001\u0019\u0001B\u0013\u0003M9\u0018N\u001c3poB\u0013x\u000e]3sif$\u0016\u0010]3t\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005w\tQd\u0019:fCR,W*\u001b8j\u0005\u0006$8\r[,j]\u0012|wo\u00149fe\u0006$xN\u001d\u000b\u0011\u0005{\u0011YE!\u0014\u0003p\tM$q\u000fB=\u0005{\u0002BAa\u0010\u0003H5\u0011!\u0011\t\u0006\u0004O\t\r#b\u0001B#\u0015\u00059!/\u001e8uS6,\u0017\u0002\u0002B%\u0005\u0003\u0012Q$\u00112tiJ\f7\r^!mS\u001etW\rZ,j]\u0012|wo\u00149fe\u0006$xN\u001d\u0005\t\u0005\u000f\u00119\u00041\u0001\u0003\n!A!q\nB\u001c\u0001\u0004\u0011\t&A\u0006bO\u001e\u001c\b*\u00198eY\u0016\u0014\b\u0007\u0002B*\u0005;\u0002bAa\u0006\u0003V\te\u0013\u0002\u0002B,\u00053\u00111eR3oKJ\fG/\u001a3Tk\n\\U-_3e\u0003\u001e<7\u000fS1oI2,g)\u001e8di&|g\u000e\u0005\u0003\u0003\\\tuC\u0002\u0001\u0003\r\u0005?\u0012i%!A\u0001\u0002\u000b\u0005!\u0011\r\u0002\u0004?\u0012\n\u0014\u0003\u0002B2\u0005S\u00022! B3\u0013\r\u00119'\u0010\u0002\b\u001d>$\b.\u001b8h!\ri(1N\u0005\u0004\u0005[j$aA!os\"A!\u0011\u000fB\u001c\u0001\u0004\u0011)\"A\bsK\u000e|'\u000fZ#rk\u0006d\u0017n]3s\u0011!\u0011)Ha\u000eA\u0002\t\u0015\u0012\u0001C1dGRK\b/Z:\t\u0011\tU\"q\u0007a\u0001\u0005KA\u0001Ba\u001f\u00038\u0001\u0007!QE\u0001\u000eC\u001e<g+\u00197vKRK\b/Z:\t\u0011\t}$q\u0007a\u0001\u0003\u0003\tq\u0001^5nK&#\u0007\u0010C\u0004\u0003\u0004\u0002!IA!\"\u0002)\r\u0014X-\u0019;f/&tGm\\<Pa\u0016\u0014\u0018\r^8s)A\u00119Ia'\u0003\u001e\n%&1\u0016BW\u0005_\u0013\t\f\r\u0004\u0003\n\nE%q\u0013\t\t\u0005\u007f\u0011YIa$\u0003\u0016&!!Q\u0012B!\u000599\u0016N\u001c3po>\u0003XM]1u_J\u0004BAa\u0017\u0003\u0012\u0012a!1\u0013BA\u0003\u0003\u0005\tQ!\u0001\u0003b\t\u0019q\fJ\u001a\u0011\t\tm#q\u0013\u0003\r\u00053\u0013\t)!A\u0001\u0002\u000b\u0005!\u0011\r\u0002\u0004?\u0012\"\u0004\u0002\u0003B\u0004\u0005\u0003\u0003\rA!\u0003\t\u0011\t=#\u0011\u0011a\u0001\u0005?\u0003DA!)\u0003&B1!q\u0003B+\u0005G\u0003BAa\u0017\u0003&\u0012a!q\u0015BO\u0003\u0003\u0005\tQ!\u0001\u0003b\t\u0019q\f\n\u001a\t\u0011\tE$\u0011\u0011a\u0001\u0005+A\u0001B!\u001e\u0003\u0002\u0002\u0007!Q\u0005\u0005\t\u0005k\u0011\t\t1\u0001\u0003&!A!1\u0010BA\u0001\u0004\u0011)\u0003\u0003\u0005\u0003\u0000\t\u0005\u0005\u0019AA\u0001\u0001")
public class StreamExecGroupWindowAggregate
extends SingleRel
implements StreamPhysicalRel,
RowStreamExecNode {
    private final LogicalWindow window;
    private final Seq<FlinkRelBuilder.NamedWindowProperty> namedProperties;
    private final RelOptCluster cluster;
    private final Seq<AggregateCall> aggCalls;
    private final BaseRowSchema outputSchema;
    private final BaseRowSchema inputSchema;
    private final int[] grouping;
    private final int inputTimestampIndex;
    private final EmitStrategy emitStrategy;
    private final java.util.List<ExecNode<StreamTableEnvironment, ?>> org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes;
    private final transient Logger LOG;
    private final NodeResource org$apache$flink$table$plan$nodes$exec$ExecNode$$resource;
    private StreamTransformation<Object> org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private java.util.List org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes$lzycompute() {
        StreamExecGroupWindowAggregate streamExecGroupWindowAggregate = this;
        synchronized (streamExecGroupWindowAggregate) {
            if (!this.bitmap$0) {
                this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes = BaseStreamExecNode$class.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes(this);
                this.bitmap$0 = true;
            }
            return this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes;
        }
    }

    @Override
    public java.util.List<ExecNode<StreamTableEnvironment, ?>> org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes() {
        return this.bitmap$0 ? this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes : this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes$lzycompute();
    }

    @Override
    public java.util.List<ExecNode<StreamTableEnvironment, ?>> getInputNodes() {
        return BaseStreamExecNode$class.getInputNodes(this);
    }

    @Override
    public void replaceInputNode(int ordinalInParent, ExecNode<StreamTableEnvironment, ?> newInputNode) {
        BaseStreamExecNode$class.replaceInputNode(this, ordinalInParent, newInputNode);
    }

    private Logger LOG$lzycompute() {
        StreamExecGroupWindowAggregate streamExecGroupWindowAggregate = this;
        synchronized (streamExecGroupWindowAggregate) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public /* synthetic */ StreamTransformation org$apache$flink$table$plan$nodes$exec$StreamExecNode$$super$translateToPlan(StreamTableEnvironment tableEnv) {
        return ExecNode$class.translateToPlan(this, tableEnv);
    }

    @Override
    public StreamTransformation<BaseRow> translateToPlan(StreamTableEnvironment tableEnv) {
        return StreamExecNode$class.translateToPlan(this, tableEnv);
    }

    @Override
    public NodeResource org$apache$flink$table$plan$nodes$exec$ExecNode$$resource() {
        return this.org$apache$flink$table$plan$nodes$exec$ExecNode$$resource;
    }

    @Override
    public StreamTransformation<BaseRow> org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation() {
        return this.org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation;
    }

    @Override
    @TraitSetter
    public void org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation_$eq(StreamTransformation<BaseRow> x$1) {
        this.org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation = x$1;
    }

    @Override
    public void org$apache$flink$table$plan$nodes$exec$ExecNode$_setter_$org$apache$flink$table$plan$nodes$exec$ExecNode$$resource_$eq(NodeResource x$1) {
        this.org$apache$flink$table$plan$nodes$exec$ExecNode$$resource = x$1;
    }

    @Override
    public NodeResource getResource() {
        return ExecNode$class.getResource(this);
    }

    @Override
    public void accept(ExecNodeVisitor visitor) {
        ExecNode$class.accept(this, visitor);
    }

    @Override
    public boolean producesRetractions() {
        return StreamPhysicalRel$class.producesRetractions(this);
    }

    @Override
    public RelNode satisfyTraitsByInput(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel$class.satisfyTraitsByInput(this, requiredTraitSet);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable, expressionFormat);
    }

    public LogicalWindow window() {
        return this.window;
    }

    public Seq<AggregateCall> aggCalls() {
        return this.aggCalls;
    }

    public int inputTimestampIndex() {
        return this.inputTimestampIndex;
    }

    public EmitStrategy emitStrategy() {
        return this.emitStrategy;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.outputSchema.relDataType();
    }

    @Override
    public boolean producesUpdates() {
        return this.emitStrategy().produceUpdates();
    }

    @Override
    public boolean consumesRetractions() {
        return true;
    }

    @Override
    public boolean needsUpdatesAsRetraction(RelNode input) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requireWatermark() {
        LogicalWindow logicalWindow = this.window();
        if (logicalWindow instanceof TumblingGroupWindow) {
            TumblingGroupWindow tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return true;
            }
        }
        if (logicalWindow instanceof SlidingGroupWindow) {
            SlidingGroupWindow slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
            Expression timeField = slidingGroupWindow.timeField();
            Expression size = slidingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return true;
            }
        }
        if (!(logicalWindow instanceof SessionGroupWindow)) return false;
        SessionGroupWindow sessionGroupWindow = (SessionGroupWindow)logicalWindow;
        Expression timeField = sessionGroupWindow.timeField();
        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) return false;
        return true;
    }

    public int[] getGroupings() {
        return this.grouping;
    }

    public Seq<FlinkRelBuilder.NamedWindowProperty> getWindowProperties() {
        return this.namedProperties;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        return new StreamExecGroupWindowAggregate(this.window(), this.namedProperties, this.cluster, traitSet, inputs.get(0), this.aggCalls(), this.outputSchema, this.inputSchema, this.grouping, this.inputTimestampIndex(), this.emitStrategy());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("groupBy", AggregateNameUtil$.MODULE$.groupingToString(this.inputSchema.relDataType(), this.grouping), Predef$.MODULE$.intArrayOps(this.grouping).nonEmpty()).item("window", this.window()).itemIf("properties", ((TraversableOnce)this.namedProperties.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FlinkRelBuilder.NamedWindowProperty x$1) {
                return x$1.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", "), this.namedProperties.nonEmpty()).item("select", AggregateNameUtil$.MODULE$.aggregationToString(this.inputSchema.relDataType(), this.grouping, this.outputSchema.relDataType(), this.aggCalls(), this.namedProperties, true, false)).itemIf("emit", this.emitStrategy(), !this.emitStrategy().toString().isEmpty());
    }

    @Override
    public boolean isDeterministic() {
        return AggregateUtil$.MODULE$.isDeterministic(JavaConversions$.MODULE$.seqAsJavaList(this.aggCalls()));
    }

    @Override
    public FlinkPhysicalRel getFlinkPhysicalRel() {
        return this;
    }

    @Override
    public ExecNodeWriter getStateDigest(ExecNodeWriter pw) {
        TableConfig tableConfig = this.cluster.getPlanner().getContext().unwrap(TableConfig.class);
        boolean isMiniBatchEnabled = this.isWindowMiniBatchEnabled(tableConfig);
        return pw.item("inputType", this.input.getRowType()).item("isMiniBatchEnabled", BoxesRunTime.boxToBoolean((boolean)isMiniBatchEnabled)).itemIf("groupBy", AggregateNameUtil$.MODULE$.groupingToString(this.inputSchema.relDataType(), this.grouping), Predef$.MODULE$.intArrayOps(this.grouping).nonEmpty()).item("window", this.window()).itemIf("properties", ((TraversableOnce)this.namedProperties.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FlinkRelBuilder.NamedWindowProperty x$2) {
                return x$2.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", "), this.namedProperties.nonEmpty()).item("select", AggregateNameUtil$.MODULE$.aggregationToString(this.inputSchema.relDataType(), this.grouping, this.outputSchema.relDataType(), this.aggCalls(), this.namedProperties, false, false)).itemIf("emit", this.emitStrategy(), !this.emitStrategy().toString().isEmpty());
    }

    @Override
    public StreamTransformation<BaseRow> translateToPlanInternal(StreamTableEnvironment tableEnv) {
        int n;
        SlidingGroupWindow slidingGroupWindow;
        Expression size;
        TumblingGroupWindow tumblingGroupWindow;
        Expression size2;
        TableConfig config = tableEnv.getConfig();
        StreamTransformation<?> inputTransform = this.getInputNodes().get(0).translateToPlan(tableEnv);
        boolean inputIsAccRetract = StreamExecRetractionRules$.MODULE$.isAccRetract(this.input);
        if (inputIsAccRetract) {
            throw new TableException(TableErrors.INST.sqlGroupWindowAggTranslateRetractNotSupported());
        }
        LogicalWindow logicalWindow = this.window();
        boolean bl = logicalWindow instanceof TumblingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size2 = (tumblingGroupWindow = (TumblingGroupWindow)logicalWindow).size()) ? true : logicalWindow instanceof SlidingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size = (slidingGroupWindow = (SlidingGroupWindow)logicalWindow).size());
        boolean isCountWindow = bl;
        if (isCountWindow && this.grouping.length > 0 && tableEnv.getConfig().getMinIdleStateRetentionTime() < 0L) {
            this.LOG().warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        this.emitStrategy().checkValidation();
        String aggString = AggregateNameUtil$.MODULE$.aggregationToString(this.inputSchema.relDataType(), this.grouping, this.outputSchema.relDataType(), this.aggCalls(), this.namedProperties, true, false);
        if (ExpressionUtils$.MODULE$.isRowtimeAttribute(this.window().timeAttribute())) {
            if (this.inputTimestampIndex() < 0) {
                throw new TableException(TableErrors.INST.sqlGroupWindowAggTranslateTimeAttrNotFound());
            }
            n = this.inputTimestampIndex();
        } else {
            n = -1;
        }
        int timeIdx = n;
        boolean needRetraction = StreamExecRetractionRules$.MODULE$.isAccRetract(this.getInput());
        boolean approxDistinctAggs = this.aggCalls().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AggregateCall call) {
                return call.isDistinct() && call.isApproximate() && call.getAggregation() instanceof SqlCountAggFunction;
            }
        });
        if (approxDistinctAggs && needRetraction) {
            throw new TableException(TableErrors.INST.sqlApproxCountDistinctWithRetractNotSupport());
        }
        AggregateInfoList aggInfoList = AggregateUtil$.MODULE$.transformToStreamAggregateInfoList(this.aggCalls(), this.inputSchema.relDataType(), (boolean[])Array$.MODULE$.fill(this.aggCalls().size(), (Function0)new Serializable(this, needRetraction){
            public static final long serialVersionUID = 0L;
            private final boolean needRetraction$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.needRetraction$1;
            }
            {
                this.needRetraction$1 = needRetraction$1;
            }
        }, ClassTag$.MODULE$.Boolean()), needRetraction, true, AggregateUtil$.MODULE$.transformToStreamAggregateInfoList$default$6());
        boolean isMiniBatchEnabled = WindowAggregateUtil$.MODULE$.isWindowMiniBatchApplicable(config, this.window(), aggInfoList.aggInfos());
        GeneratedSubKeyedAggsHandleFunction<?> aggsHandler = WindowAggregateUtil$.MODULE$.createAggsHandler("GroupWindowAggsHandler", this.window(), this.namedProperties, aggInfoList, config, tableEnv.getRelBuilder(), this.inputSchema.fieldTypes(), needRetraction, isMiniBatchEnabled, 0, isMiniBatchEnabled);
        InternalType[] accTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggInfoList.getAccTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(DataType x$3) {
                return x$3.toInternalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        InternalType[] aggResultTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggInfoList.getActualValueTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(DataType x$4) {
                return x$4.toInternalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        InternalType[] windowPropertyTypes = (InternalType[])((TraversableOnce)this.namedProperties.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(FlinkRelBuilder.NamedWindowProperty x$5) {
                return x$5.property().resultType();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InternalType.class));
        GeneratedRecordEqualiser equaliser = this.createEqualiser(aggResultTypes, windowPropertyTypes);
        InternalType[] aggValueTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggInfoList.getActualValueTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(DataType x$6) {
                return x$6.toInternalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        AbstractStreamOperator operator = isMiniBatchEnabled ? this.createMiniBatchWindowOperator(config, aggsHandler, equaliser, accTypes, windowPropertyTypes, aggValueTypes, timeIdx) : this.createWindowOperator(config, aggsHandler, equaliser, accTypes, windowPropertyTypes, aggValueTypes, timeIdx);
        String windowPrefix = isMiniBatchEnabled ? "minibatch-window" : "window";
        String operatorName = Predef$.MODULE$.intArrayOps(this.grouping).nonEmpty() ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{windowPrefix, this.window()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"groupBy: (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AggregateNameUtil$.MODULE$.groupingToString(this.inputSchema.relDataType(), this.grouping)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggString}))).toString() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": (", "), select: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{windowPrefix, this.window(), aggString}));
        BaseRowTypeInfo inputRowType = (BaseRowTypeInfo)inputTransform.getOutputType();
        BaseRowKeySelector selector = StreamExecUtil$.MODULE$.getKeySelector(this.grouping, inputRowType);
        BaseRowTypeInfo outRowType = this.outputSchema.typeInfo();
        OneInputTransformation transformation = new OneInputTransformation(inputTransform, operatorName, FaultTolerantUtil.addFaultTolerantProxyIfNeed(operator, operatorName, config), (TypeInformation)outRowType, inputTransform.getParallelism());
        if (Predef$.MODULE$.intArrayOps(this.grouping).isEmpty()) {
            transformation.setParallelism(1);
            transformation.setMaxParallelism(1);
        }
        transformation.setResources(this.getResource().getReservedResourceSpec(), this.getResource().getPreferResourceSpec());
        transformation.setStateKeySelector((KeySelector)selector);
        transformation.setStateKeyType(selector.getProducedType());
        return transformation;
    }

    private boolean isWindowMiniBatchEnabled(TableConfig config) {
        boolean needRetraction = StreamExecRetractionRules$.MODULE$.isAccRetract(this.getInput());
        AggregateInfoList aggInfoList = AggregateUtil$.MODULE$.transformToStreamAggregateInfoList(this.aggCalls(), this.inputSchema.relDataType(), (boolean[])Array$.MODULE$.fill(this.aggCalls().size(), (Function0)new Serializable(this, needRetraction){
            public static final long serialVersionUID = 0L;
            private final boolean needRetraction$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.needRetraction$2;
            }
            {
                this.needRetraction$2 = needRetraction$2;
            }
        }, ClassTag$.MODULE$.Boolean()), needRetraction, true, AggregateUtil$.MODULE$.transformToStreamAggregateInfoList$default$6());
        return WindowAggregateUtil$.MODULE$.isWindowMiniBatchApplicable(config, this.window(), aggInfoList.aggInfos());
    }

    private GeneratedRecordEqualiser createEqualiser(InternalType[] aggResultTypes, InternalType[] windowPropertyTypes) {
        EqualiserCodeGenerator generator = new EqualiserCodeGenerator((Seq<InternalType>)((Seq)Predef$.MODULE$.refArrayOps((Object[])aggResultTypes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])windowPropertyTypes), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        return generator.generateRecordEqualiser("WindowValueEqualiser");
    }

    private AbstractAlignedWindowOperator createMiniBatchWindowOperator(TableConfig config, GeneratedSubKeyedAggsHandleFunction<?> aggsHandler, GeneratedRecordEqualiser recordEqualiser, InternalType[] accTypes, InternalType[] windowPropertyTypes, InternalType[] aggValueTypes, int timeIdx) {
        LogicalWindow logicalWindow;
        block6: {
            Tuple2 tuple2;
            OnePhaseAlignedWindowAggregator windowRunner;
            block5: {
                block4: {
                    TypeInformation<?> accTypeInfo = TypeConverters$.MODULE$.createInternalTypeInfoFromDataType(DataTypes.createRowType(accTypes));
                    RowType aggResultType = DataTypes.createRowType((InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggValueTypes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])windowPropertyTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class))));
                    TypeInformation<?> aggResultTypeInfo = TypeConverters$.MODULE$.createInternalTypeInfoFromDataType(aggResultType);
                    long minibatchSize = config.getConf().getLong(TableConfigOptions.SQL_EXEC_MINIBATCH_SIZE);
                    windowRunner = new OnePhaseAlignedWindowAggregator((BaseRowTypeInfo)accTypeInfo, (BaseRowTypeInfo)aggResultTypeInfo, aggsHandler, minibatchSize, false);
                    logicalWindow = this.window();
                    if (!(logicalWindow instanceof TumblingGroupWindow)) break block4;
                    TumblingGroupWindow tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
                    Expression timeField = tumblingGroupWindow.timeField();
                    Expression size = tumblingGroupWindow.size();
                    if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block4;
                    Duration sizeDuration = ExpressionUtils$.MODULE$.toDuration(size);
                    TumblingWindowAssigner assigner = TumblingWindowAssigner.of(sizeDuration).withTimeZone(config.getTimeZone());
                    AlignedWindowTrigger trigger = InternalAlignedWindowTriggers.tumbling(sizeDuration, config.getTimeZone());
                    tuple2 = new Tuple2((Object)assigner, (Object)trigger);
                    break block5;
                }
                if (!(logicalWindow instanceof SlidingGroupWindow)) break block6;
                SlidingGroupWindow slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
                Expression timeField = slidingGroupWindow.timeField();
                Expression size = slidingGroupWindow.size();
                Expression slide = slidingGroupWindow.slide();
                if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block6;
                Duration sizeDuration = ExpressionUtils$.MODULE$.toDuration(size);
                Duration slideDuration = ExpressionUtils$.MODULE$.toDuration(slide);
                SlidingWindowAssigner assigner = SlidingWindowAssigner.of(sizeDuration, slideDuration).withTimeZone(config.getTimeZone());
                AlignedWindowTrigger trigger = InternalAlignedWindowTriggers.sliding(sizeDuration, slideDuration, config.getTimeZone());
                tuple2 = new Tuple2((Object)assigner, (Object)trigger);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                WindowAssigner windowAssigner = (WindowAssigner)tuple22._1();
                AlignedWindowTrigger windowTrigger = (AlignedWindowTrigger)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)windowAssigner, (Object)windowTrigger);
                WindowAssigner windowAssigner2 = (WindowAssigner)tuple24._1();
                AlignedWindowTrigger windowTrigger2 = (AlignedWindowTrigger)tuple24._2();
                return new KeyedAlignedWindowOperator(windowRunner, windowAssigner2, windowTrigger2, timeIdx);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)logicalWindow);
    }

    private WindowOperator<?, ?> createWindowOperator(TableConfig config, GeneratedSubKeyedAggsHandleFunction<?> aggsHandler, GeneratedRecordEqualiser recordEqualiser, InternalType[] accTypes, InternalType[] windowPropertyTypes, InternalType[] aggValueTypes, int timeIdx) {
        LogicalWindow logicalWindow;
        block13: {
            WindowOperatorBuilder windowOperatorBuilder;
            block6: {
                SessionGroupWindow sessionGroupWindow;
                boolean bl;
                WindowOperatorBuilder builder;
                block12: {
                    boolean bl2;
                    block11: {
                        SlidingGroupWindow slidingGroupWindow;
                        block10: {
                            block9: {
                                boolean bl3;
                                block8: {
                                    TumblingGroupWindow tumblingGroupWindow;
                                    block7: {
                                        block5: {
                                            builder = WindowOperatorBuilder.builder().withInputFields((InternalType[])this.inputSchema.fieldTypes().toArray(ClassTag$.MODULE$.apply(InternalType.class)));
                                            bl3 = false;
                                            tumblingGroupWindow = null;
                                            bl2 = false;
                                            slidingGroupWindow = null;
                                            bl = false;
                                            sessionGroupWindow = null;
                                            logicalWindow = this.window();
                                            if (!(logicalWindow instanceof TumblingGroupWindow)) break block5;
                                            bl3 = true;
                                            tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
                                            Expression timeField = tumblingGroupWindow.timeField();
                                            Expression size = tumblingGroupWindow.size();
                                            if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block5;
                                            windowOperatorBuilder = builder.tumble(ExpressionUtils$.MODULE$.toDuration(size), config.getTimeZone()).withProcessingTime();
                                            break block6;
                                        }
                                        if (!bl3) break block7;
                                        Expression timeField = tumblingGroupWindow.timeField();
                                        Expression size = tumblingGroupWindow.size();
                                        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block7;
                                        windowOperatorBuilder = builder.tumble(ExpressionUtils$.MODULE$.toDuration(size), config.getTimeZone()).withEventTime(timeIdx);
                                        break block6;
                                    }
                                    if (!bl3) break block8;
                                    Expression timeField = tumblingGroupWindow.timeField();
                                    Expression size = tumblingGroupWindow.size();
                                    if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isRowCountLiteral(size)) break block8;
                                    windowOperatorBuilder = builder.countWindow(ExpressionUtils$.MODULE$.toLong(size));
                                    break block6;
                                }
                                if (bl3) {
                                    throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
                                }
                                if (!(logicalWindow instanceof SlidingGroupWindow)) break block9;
                                bl2 = true;
                                slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
                                Expression timeField = slidingGroupWindow.timeField();
                                Expression size = slidingGroupWindow.size();
                                Expression slide = slidingGroupWindow.slide();
                                if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(slide)) break block9;
                                windowOperatorBuilder = builder.sliding(ExpressionUtils$.MODULE$.toDuration(size), ExpressionUtils$.MODULE$.toDuration(slide), config.getTimeZone()).withProcessingTime();
                                break block6;
                            }
                            if (!bl2) break block10;
                            Expression timeField = slidingGroupWindow.timeField();
                            Expression size = slidingGroupWindow.size();
                            Expression slide = slidingGroupWindow.slide();
                            if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block10;
                            windowOperatorBuilder = builder.sliding(ExpressionUtils$.MODULE$.toDuration(size), ExpressionUtils$.MODULE$.toDuration(slide), config.getTimeZone()).withEventTime(timeIdx);
                            break block6;
                        }
                        if (!bl2) break block11;
                        Expression timeField = slidingGroupWindow.timeField();
                        Expression size = slidingGroupWindow.size();
                        Expression slide = slidingGroupWindow.slide();
                        if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isRowCountLiteral(size)) break block11;
                        windowOperatorBuilder = builder.countWindow(ExpressionUtils$.MODULE$.toLong(size), ExpressionUtils$.MODULE$.toLong(slide));
                        break block6;
                    }
                    if (bl2) {
                        throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
                    }
                    if (!(logicalWindow instanceof SessionGroupWindow)) break block12;
                    bl = true;
                    sessionGroupWindow = (SessionGroupWindow)logicalWindow;
                    Expression timeField = sessionGroupWindow.timeField();
                    Expression gap = sessionGroupWindow.gap();
                    if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField)) break block12;
                    windowOperatorBuilder = builder.session(ExpressionUtils$.MODULE$.toDuration(gap)).withProcessingTime();
                    break block6;
                }
                if (!bl) break block13;
                Expression timeField = sessionGroupWindow.timeField();
                Expression gap = sessionGroupWindow.gap();
                if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) break block13;
                windowOperatorBuilder = builder.session(ExpressionUtils$.MODULE$.toDuration(gap)).withEventTime(timeIdx);
            }
            WindowOperatorBuilder newBuilder = windowOperatorBuilder;
            Object object = this.emitStrategy().produceUpdates() ? newBuilder.withSendRetraction().triggering(this.emitStrategy().getTrigger()) : BoxedUnit.UNIT;
            return newBuilder.aggregate(aggsHandler, recordEqualiser, accTypes, aggValueTypes, windowPropertyTypes).withAllowedLateness(Duration.ofMillis(this.emitStrategy().getAllowLateness())).build();
        }
        throw new MatchError((Object)logicalWindow);
    }

    public StreamExecGroupWindowAggregate(LogicalWindow window, Seq<FlinkRelBuilder.NamedWindowProperty> namedProperties, RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, Seq<AggregateCall> aggCalls, BaseRowSchema outputSchema, BaseRowSchema inputSchema, int[] grouping, int inputTimestampIndex, EmitStrategy emitStrategy) {
        this.window = window;
        this.namedProperties = namedProperties;
        this.cluster = cluster;
        this.aggCalls = aggCalls;
        this.outputSchema = outputSchema;
        this.inputSchema = inputSchema;
        this.grouping = grouping;
        this.inputTimestampIndex = inputTimestampIndex;
        this.emitStrategy = emitStrategy;
        super(cluster, traitSet, inputNode);
        FlinkRelNode$class.$init$(this);
        FlinkPhysicalRel$class.$init$(this);
        StreamPhysicalRel$class.$init$(this);
        ExecNode$class.$init$(this);
        StreamExecNode$class.$init$(this);
        Logging$class.$init$(this);
        BaseStreamExecNode$class.$init$(this);
    }
}

