/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.physical.stream;

import java.util.SortedSet;
import java.util.UUID;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.FlatSelectCepOperator;
import org.apache.flink.cep.operator.FlatSelectTimeoutCepOperator;
import org.apache.flink.cep.operator.SelectCepOperator;
import org.apache.flink.cep.operator.SelectTimeoutCepOperator;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMap;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.ProcessOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.co.CoStreamMap;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.SideOutputTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.CodeGeneratorContext$;
import org.apache.flink.table.codegen.MatchCodeGenerator;
import org.apache.flink.table.codegen.MatchCodeGenerator$;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.plan.nodes.common.CommonMatchRecognize;
import org.apache.flink.table.plan.nodes.common.CommonMatchRecognize$class;
import org.apache.flink.table.plan.nodes.exec.BaseStreamExecNode$class;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode$class;
import org.apache.flink.table.plan.nodes.exec.ExecNodeVisitor;
import org.apache.flink.table.plan.nodes.exec.ExecNodeWriter;
import org.apache.flink.table.plan.nodes.exec.NodeResource;
import org.apache.flink.table.plan.nodes.exec.RowStreamExecNode;
import org.apache.flink.table.plan.nodes.exec.StreamExecNode$class;
import org.apache.flink.table.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.plan.nodes.physical.FlinkPhysicalRel$class;
import org.apache.flink.table.plan.nodes.physical.stream.PatternVisitor;
import org.apache.flink.table.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.plan.nodes.physical.stream.StreamPhysicalRel$class;
import org.apache.flink.table.plan.rules.physical.stream.StreamExecRetractionRules$;
import org.apache.flink.table.plan.schema.BaseRowSchema;
import org.apache.flink.table.plan.util.MatchUtil$;
import org.apache.flink.table.plan.util.SortUtil$;
import org.apache.flink.table.plan.util.StreamExecUtil$;
import org.apache.flink.table.runtime.BaseRowKeySelector;
import org.apache.flink.table.runtime.BaseRowRowtimeProcessFunction;
import org.apache.flink.table.runtime.match.CombineCepOutputCoMapFunction;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.OutputTag;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u0001\u0003\u0001M\u0011qb\u0015;sK\u0006lW\t_3d\u001b\u0006$8\r\u001b\u0006\u0003\u0007\u0011\taa\u001d;sK\u0006l'BA\u0003\u0007\u0003!\u0001\b._:jG\u0006d'BA\u0004\t\u0003\u0015qw\u000eZ3t\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0006\u0001Qa\"E\n\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t1A]3m\u0015\tIb\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005m1\"!C*j]\u001edWMU3m!\ti\u0002%D\u0001\u001f\u0015\tyb!\u0001\u0004d_6lwN\\\u0005\u0003Cy\u0011AcQ8n[>tW*\u0019;dQJ+7m\\4oSj,\u0007CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u0005E\u0019FO]3b[BC\u0017p]5dC2\u0014V\r\u001c\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0019\tA!\u001a=fG&\u00111\u0006\u000b\u0002\u0012%><8\u000b\u001e:fC6,\u00050Z2O_\u0012,\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u000f\rdWo\u001d;feB\u0011q&M\u0007\u0002a)\u0011\u0011\u0002G\u0005\u0003eA\u0012QBU3m\u001fB$8\t\\;ti\u0016\u0014\b\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0011Q\u0014\u0018-\u001b;TKR\u0004\"a\f\u001c\n\u0005]\u0002$a\u0003*fYR\u0013\u0018-\u001b;TKRD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0006S:\u0004X\u000f\u001e\t\u0003+mJ!\u0001\u0010\f\u0003\u000fI+GNT8eK\"Aa\b\u0001B\u0001B\u0003%q(\u0001\u0007m_\u001eL7-\u00197NCR\u001c\u0007\u000e\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u0011\u00059An\\4jG\u0006d\u0017B\u0001#B\u00059i\u0015\r^2i%\u0016\u001cwn\u001a8ju\u0016D\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IaR\u0001\r_V$\b/\u001e;TG\",W.\u0019\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\"\taa]2iK6\f\u0017B\u0001'J\u00055\u0011\u0015m]3S_^\u001c6\r[3nC\"Aa\n\u0001B\u0001B\u0003%q)A\u0006j]B,HoU2iK6\f\u0007\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u001fj]&$h\bF\u0004S'R+fk\u0016-\u0011\u0005\r\u0002\u0001\"B\u0017P\u0001\u0004q\u0003\"\u0002\u001bP\u0001\u0004)\u0004\"B\u001dP\u0001\u0004Q\u0004\"\u0002 P\u0001\u0004y\u0004\"\u0002$P\u0001\u00049\u0005\"\u0002(P\u0001\u00049\u0005\"\u0002.\u0001\t\u0003Z\u0016!\u00043fe&4XMU8x)f\u0004X\rF\u0001]!\ti\u0006-D\u0001_\u0015\tyf#\u0001\u0003usB,\u0017BA1_\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u000b\r\u0004A\u0011\t3\u0002!I,\u0017/^5sK^\u000bG/\u001a:nCJ\\W#A3\u0011\u0005\u0019LW\"A4\u000b\u0003!\fQa]2bY\u0006L!A[4\u0003\u000f\t{w\u000e\\3b]\")A\u000e\u0001C![\u0006!1m\u001c9z)\rQdn\u001c\u0005\u0006i-\u0004\r!\u000e\u0005\u0006a.\u0004\r!]\u0001\u0007S:\u0004X\u000f^:\u0011\u0007I<((D\u0001t\u0015\t!X/\u0001\u0003vi&d'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u0014A\u0001T5ti\")!\u0010\u0001C!w\u0006aQ\r\u001f9mC&tG+\u001a:ngR\u0011Ap \t\u0003+uL!A \f\u0003\u0013I+Gn\u0016:ji\u0016\u0014\bBBA\u0001s\u0002\u0007A0\u0001\u0002qo\"1\u0011Q\u0001\u0001\u0005B\u0011\fq\"[:EKR,'/\\5oSN$\u0018n\u0019\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0003I!(/\u00198tY\u0006$X\rV5nK\n{WO\u001c3\u0015\t\u00055\u0011Q\u0005\t\u0005\u0003\u001f\t\t#\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0011!\u0018.\\3\u000b\t\u0005]\u0011\u0011D\u0001\no&tGm\\<j]\u001eTA!a\u0007\u0002\u001e\u0005\u0019\u0011\r]5\u000b\u0007\u0005}A\"A\u0005tiJ,\u0017-\\5oO&!\u00111EA\t\u0005\u0011!\u0016.\\3\t\u0011\u0005\u001d\u0012q\u0001a\u0001\u0003S\t\u0001\"\u001b8uKJ4\u0018\r\u001c\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\r\u0002\u0007I,\u00070\u0003\u0003\u00024\u00055\"a\u0002*fq:{G-\u001a\u0005\t\u0003o\u0001A\u0011\u0001\u0007\u0002:\u0005\u0001BO]1og2\fG/\u001a)biR,'O\u001c\u000b\t\u0003w\t\u0019)!%\u0002\"B9a-!\u0010\u0002B\u0005u\u0013bAA O\n1A+\u001e9mKJ\u0002\u0002\"a\u0011\u0002N\u0005E\u0013\u0011K\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u00059\u0001/\u0019;uKJt'bAA&\u0019\u0005\u00191-\u001a9\n\t\u0005=\u0013Q\t\u0002\b!\u0006$H/\u001a:o!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,\u0015\u0005QA-\u0019;bM>\u0014X.\u0019;\n\t\u0005m\u0013Q\u000b\u0002\b\u0005\u0006\u001cXMU8x!\u0019\ty&a\u001c\u0002v9!\u0011\u0011MA6\u001d\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA4%\u00051AH]8pizJ\u0011\u0001[\u0005\u0004\u0003[:\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003c\n\u0019HA\u0002TKFT1!!\u001ch!\u0011\t9(! \u000f\u0007\u0019\fI(C\u0002\u0002|\u001d\fa\u0001\u0015:fI\u00164\u0017\u0002BA@\u0003\u0003\u0013aa\u0015;sS:<'bAA>O\"A\u0011QQA\u001b\u0001\u0004\t9)\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u0013\u000bi)\u0004\u0002\u0002\f*\u0019\u00111\u0004\u0006\n\t\u0005=\u00151\u0012\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005\u0002\u0014\u0006U\u0002\u0019AAK\u0003)\u0011X\r\u001c\"vS2$WM\u001d\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014\r\u0002\u000bQ|w\u000e\\:\n\t\u0005}\u0015\u0011\u0014\u0002\u000b%\u0016d')^5mI\u0016\u0014\b\u0002CAR\u0003k\u0001\r!!*\u0002\u001b%t\u0007/\u001e;UsB,\u0017J\u001c4p!\u0019\t9+!-\u0002R5\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+\u0001\u0005usB,\u0017N\u001c4p\u0015\ry\u0012q\u0016\u0006\u0004\u00037a\u0011\u0002BAZ\u0003S\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0015\u0005\u0003k\t9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\ti\fD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAa\u0003w\u0013\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u0011\u001d\t)\r\u0001C!\u0003\u000f\f1cZ3u\r2Lgn\u001b)isNL7-\u00197SK2,\"!!3\u0011\t\u0005-\u0017QZ\u0007\u0002\t%\u0019\u0011q\u001a\u0003\u0003!\u0019c\u0017N\\6QQf\u001c\u0018nY1m%\u0016d\u0007bBAj\u0001\u0011\u0005\u0013Q[\u0001\u000fO\u0016$8\u000b^1uK\u0012Kw-Z:u)\u0011\t9.!8\u0011\u0007\u001d\nI.C\u0002\u0002\\\"\u0012a\"\u0012=fG:{G-Z,sSR,'\u000f\u0003\u0005\u0002\u0002\u0005E\u0007\u0019AAl\u0011\u001d\t\t\u000f\u0001C!\u0003G\fq\u0003\u001e:b]Nd\u0017\r^3U_Bc\u0017M\\%oi\u0016\u0014h.\u00197\u0015\t\u0005\u0015\u0018\u0011\u001f\t\u0007\u0003O\fi/!\u0015\u000e\u0005\u0005%(\u0002BAv\u00033\tq\u0002\u001e:b]N4wN]7bi&|gn]\u0005\u0005\u0003_\fIO\u0001\u000bTiJ,\u0017-\u001c+sC:\u001chm\u001c:nCRLwN\u001c\u0005\t\u0003g\fy\u000e1\u0001\u0002v\u0006AA/\u00192mK\u0016sg\u000f\u0005\u0003\u0002\n\u0006]\u0018\u0002BA}\u0003\u0017\u0013ac\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\b\u0003{\u0004A\u0011BA\u0000\u00039!(/\u00198tY\u0006$Xm\u0014:eKJ$\u0002B!\u0001\u0003\f\t=!Q\u0004\t\bM\u0006u\u0012Q\u001dB\u0002!\u0019\u0011)Aa\u0002\u0002R5\u0011\u0011\u0011J\u0005\u0005\u0005\u0013\tIEA\bFm\u0016tGoQ8na\u0006\u0014\u0018\r^8s\u0011!\u0011i!a?A\u0002\u0005\u0015\u0018AD5oaV$HK]1og\u001a|'/\u001c\u0005\t\u0003G\u000bY\u00101\u0001\u0003\u0012A!!1\u0003B\r\u001b\t\u0011)BC\u0002\u0003\u0018)\t\u0011\u0002^=qKV$\u0018\u000e\\:\n\t\tm!Q\u0003\u0002\u0010\u0005\u0006\u001cXMU8x)f\u0004X-\u00138g_\"A!qDA~\u0001\u0004\u0011\t#A\u0005pe\u0012,'oS3zgB\u0019QCa\t\n\u0007\t\u0015bC\u0001\u0007SK2\u001cu\u000e\u001c7bi&|g\u000eC\u0004\u0003*\u0001!IAa\u000b\u00029\u001d,g.\u001a:bi\u0016|U\u000f\u001e9viR\u0013\u0018M\\:g_Jl\u0017\r^5p]R\u0001\u0012Q\u001dB\u0017\u0005_\u0011\tDa\r\u00036\te\"Q\b\u0005\t\u0003\u000b\u00139\u00031\u0001\u0002\b\"A\u00111\u0013B\u0014\u0001\u0004\t)\n\u0003\u0005\u0003\u000e\t\u001d\u0002\u0019AAs\u0011!\t\u0019Ka\nA\u0002\tE\u0001\u0002\u0003B\u001c\u0005O\u0001\r!!\u0011\u0002\u0015\r,\u0007\u000fU1ui\u0016\u0014h\u000e\u0003\u0005\u0003<\t\u001d\u0002\u0019\u0001B\u0002\u0003)\u0019w.\u001c9be\u0006$xN\u001d\u0005\t\u0005\u007f\u00119\u00031\u0001\u0002^\u0005a\u0001/\u0019;uKJtg*Y7fg\"9!1\t\u0001\u0005\n\t\u0015\u0013\u0001F:fiR\u0013\u0018M\\:g_Jl\u0017\r^5p]J+7\u000f\u0006\u0003\u0003H\t5\u0003c\u00014\u0003J%\u0019!1J4\u0003\tUs\u0017\u000e\u001e\u0005\t\u0005\u001f\u0012\t\u00051\u0001\u0003R\u0005!2\u000f\u001e:fC6$&/\u00198tM>\u0014X.\u0019;j_:\u0004DAa\u0015\u0003ZA1\u0011q]Aw\u0005+\u0002BAa\u0016\u0003Z1\u0001A\u0001\u0004B.\u0005\u001b\n\t\u0011!A\u0003\u0002\tu#aA0%cE!!q\fB3!\r1'\u0011M\u0005\u0004\u0005G:'a\u0002(pi\"Lgn\u001a\t\u0004M\n\u001d\u0014b\u0001B5O\n\u0019\u0011I\\=\t\u000f\t5\u0004\u0001\"\u0003\u0003p\u0005q1/\u001a;LKf\u001cV\r\\3di>\u0014HC\u0002B$\u0005c\u0012\u0019\t\u0003\u0005\u0003t\t-\u0004\u0019\u0001B;\u0003%!(/\u00198tM>\u0014X\u000e\r\u0003\u0003x\t}\u0004\u0003CAt\u0005s\n\tF! \n\t\tm\u0014\u0011\u001e\u0002\u0017\u001f:,\u0017J\u001c9viR\u0013\u0018M\\:g_Jl\u0017\r^5p]B!!q\u000bB@\t1\u0011\tI!\u001d\u0002\u0002\u0003\u0005)\u0011\u0001B/\u0005\ryFE\r\u0005\t\u0003G\u0013Y\u00071\u0001\u0003\u0012!9!q\u0011\u0001\u0005\n\t%\u0015\u0001H4f]\u0016\u0014\u0018\r^3TK2,7\r\u001e+sC:\u001chm\u001c:nCRLwN\u001c\u000b\u0011\u0003K\u0014YI!$\u0003\u0010\nE%1\u0014BP\u0005CC\u0001B!\u0004\u0003\u0006\u0002\u0007\u0011Q\u001d\u0005\t\u0005o\u0011)\t1\u0001\u0002B!A!1\bBC\u0001\u0004\u0011\u0019\u0001\u0003\u0005\u0003\u0014\n\u0015\u0005\u0019\u0001BK\u0003U\u0001\u0018\r\u001e;fe:\u001cV\r\\3di\u001a+hn\u0019;j_:\u0004\u0002B!\u0002\u0003\u0018\u0006E\u0013\u0011K\u0005\u0005\u00053\u000bIEA\u000bQCR$XM\u001d8TK2,7\r\u001e$v]\u000e$\u0018n\u001c8\t\u000f\tu%Q\u0011a\u0001K\u0006\u0001\u0012n\u001d)s_\u000e,7o]5oORKW.\u001a\u0005\t\u0003G\u0013)\t1\u0001\u0003\u0012!A!1\u0015BC\u0001\u0004\u0011\t\"\u0001\bpkR\u0004X\u000f\u001e+za\u0016LeNZ8\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\u0006\u0001s-\u001a8fe\u0006$XM\u00127biN+G.Z2u)J\fgn\u001d4pe6\fG/[8o)A\t)Oa+\u0003.\n=&\u0011\u0017B^\u0005{\u0013y\f\u0003\u0005\u0003\u000e\t\u0015\u0006\u0019AAs\u0011!\u00119D!*A\u0002\u0005\u0005\u0003\u0002\u0003B\u001e\u0005K\u0003\rAa\u0001\t\u0011\tM&Q\u0015a\u0001\u0005k\u000b\u0011\u0004]1ui\u0016\u0014hN\u00127biN+G.Z2u\rVt7\r^5p]BA!Q\u0001B\\\u0003#\n\t&\u0003\u0003\u0003:\u0006%#!\u0007)biR,'O\u001c$mCR\u001cV\r\\3di\u001a+hn\u0019;j_:DqA!(\u0003&\u0002\u0007Q\r\u0003\u0005\u0002$\n\u0015\u0006\u0019\u0001B\t\u0011!\u0011\u0019K!*A\u0002\tE\u0001b\u0002Bb\u0001\u0011%!QY\u0001$O\u0016tWM]1uKN+G.Z2u)&lWm\\;u)J\fgn\u001d4pe6\fG/[8o)I\t)Oa2\u0003J\n-'Q\u001aBh\u00053\u0014YN!8\t\u0011\t5!\u0011\u0019a\u0001\u0003KD\u0001Ba\u000e\u0003B\u0002\u0007\u0011\u0011\t\u0005\t\u0005w\u0011\t\r1\u0001\u0003\u0004!A!1\u0013Ba\u0001\u0004\u0011)\n\u0003\u0005\u0003R\n\u0005\u0007\u0019\u0001Bj\u0003Y\u0001\u0018\r\u001e;fe:$\u0016.\\3pkR4UO\\2uS>t\u0007\u0003\u0003B\u0003\u0005+\f\t&!\u0015\n\t\t]\u0017\u0011\n\u0002\u0017!\u0006$H/\u001a:o)&lWm\\;u\rVt7\r^5p]\"9!Q\u0014Ba\u0001\u0004)\u0007\u0002CAR\u0005\u0003\u0004\rA!\u0005\t\u0011\t\r&\u0011\u0019a\u0001\u0005#AqA!9\u0001\t\u0013\u0011\u0019/A\u0014hK:,'/\u0019;f\r2\fGoU3mK\u000e$H+[7f_V$HK]1og\u001a|'/\\1uS>tGCEAs\u0005K\u00149O!;\u0003l\n5(q\u001fB}\u0005wD\u0001B!\u0004\u0003`\u0002\u0007\u0011Q\u001d\u0005\t\u0005o\u0011y\u000e1\u0001\u0002B!A!1\bBp\u0001\u0004\u0011\u0019\u0001\u0003\u0005\u00034\n}\u0007\u0019\u0001B[\u0011!\u0011yOa8A\u0002\tE\u0018A\u00079biR,'O\u001c$mCR$\u0016.\\3pkR4UO\\2uS>t\u0007\u0003\u0003B\u0003\u0005g\f\t&!\u0015\n\t\tU\u0018\u0011\n\u0002\u001b!\u0006$H/\u001a:o\r2\fG\u000fV5nK>,HOR;oGRLwN\u001c\u0005\b\u0005;\u0013y\u000e1\u0001f\u0011!\t\u0019Ka8A\u0002\tE\u0001\u0002\u0003BR\u0005?\u0004\rA!\u0005")
public class StreamExecMatch
extends SingleRel
implements CommonMatchRecognize,
StreamPhysicalRel,
RowStreamExecNode {
    private final RelOptCluster cluster;
    private final RelNode input;
    private final MatchRecognize logicalMatch;
    private final BaseRowSchema outputSchema;
    private final BaseRowSchema inputSchema;
    private final java.util.List<ExecNode<StreamTableEnvironment, ?>> org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes;
    private final transient Logger LOG;
    private final NodeResource org$apache$flink$table$plan$nodes$exec$ExecNode$$resource;
    private StreamTransformation<Object> org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private java.util.List org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes$lzycompute() {
        StreamExecMatch streamExecMatch = this;
        synchronized (streamExecMatch) {
            if (!this.bitmap$0) {
                this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes = BaseStreamExecNode$class.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes(this);
                this.bitmap$0 = true;
            }
            return this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes;
        }
    }

    @Override
    public java.util.List<ExecNode<StreamTableEnvironment, ?>> org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes() {
        return this.bitmap$0 ? this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes : this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes$lzycompute();
    }

    @Override
    public java.util.List<ExecNode<StreamTableEnvironment, ?>> getInputNodes() {
        return BaseStreamExecNode$class.getInputNodes(this);
    }

    @Override
    public void replaceInputNode(int ordinalInParent, ExecNode<StreamTableEnvironment, ?> newInputNode) {
        BaseStreamExecNode$class.replaceInputNode(this, ordinalInParent, newInputNode);
    }

    private Logger LOG$lzycompute() {
        StreamExecMatch streamExecMatch = this;
        synchronized (streamExecMatch) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public /* synthetic */ StreamTransformation org$apache$flink$table$plan$nodes$exec$StreamExecNode$$super$translateToPlan(StreamTableEnvironment tableEnv) {
        return ExecNode$class.translateToPlan(this, tableEnv);
    }

    @Override
    public StreamTransformation<BaseRow> translateToPlan(StreamTableEnvironment tableEnv) {
        return StreamExecNode$class.translateToPlan(this, tableEnv);
    }

    @Override
    public NodeResource org$apache$flink$table$plan$nodes$exec$ExecNode$$resource() {
        return this.org$apache$flink$table$plan$nodes$exec$ExecNode$$resource;
    }

    @Override
    public StreamTransformation<BaseRow> org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation() {
        return this.org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation;
    }

    @Override
    @TraitSetter
    public void org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation_$eq(StreamTransformation<BaseRow> x$1) {
        this.org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation = x$1;
    }

    @Override
    public void org$apache$flink$table$plan$nodes$exec$ExecNode$_setter_$org$apache$flink$table$plan$nodes$exec$ExecNode$$resource_$eq(NodeResource x$1) {
        this.org$apache$flink$table$plan$nodes$exec$ExecNode$$resource = x$1;
    }

    @Override
    public NodeResource getResource() {
        return ExecNode$class.getResource(this);
    }

    @Override
    public void accept(ExecNodeVisitor visitor) {
        ExecNode$class.accept(this, visitor);
    }

    @Override
    public boolean producesUpdates() {
        return StreamPhysicalRel$class.producesUpdates(this);
    }

    @Override
    public boolean needsUpdatesAsRetraction(RelNode input) {
        return StreamPhysicalRel$class.needsUpdatesAsRetraction(this, input);
    }

    @Override
    public boolean consumesRetractions() {
        return StreamPhysicalRel$class.consumesRetractions(this);
    }

    @Override
    public boolean producesRetractions() {
        return StreamPhysicalRel$class.producesRetractions(this);
    }

    @Override
    public RelNode satisfyTraitsByInput(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel$class.satisfyTraitsByInput(this, requiredTraitSet);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable, expressionFormat);
    }

    @Override
    public String partitionKeysToString(java.util.List<RexNode> keys, List<String> fieldNames, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression2) {
        return CommonMatchRecognize$class.partitionKeysToString(this, keys, fieldNames, expression2);
    }

    @Override
    public String orderingToString(RelCollation orders, Seq<String> fieldNames) {
        return CommonMatchRecognize$class.orderingToString(this, orders, fieldNames);
    }

    @Override
    public String measuresDefineToString(ImmutableMap<String, RexNode> measures, List<String> fieldNames, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression2, boolean withOutputFieldNames) {
        return CommonMatchRecognize$class.measuresDefineToString(this, measures, fieldNames, expression2, withOutputFieldNames);
    }

    @Override
    public String subsetToString(ImmutableMap<String, SortedSet<String>> subset) {
        return CommonMatchRecognize$class.subsetToString(this, subset);
    }

    @Override
    public String afterMatchToString(RexNode after, List<String> fieldNames) {
        return CommonMatchRecognize$class.afterMatchToString(this, after, fieldNames);
    }

    @Override
    public String matchToString(MatchRecognize logicalMatch, List<String> fieldNames, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression2) {
        return CommonMatchRecognize$class.matchToString(this, logicalMatch, fieldNames, expression2);
    }

    @Override
    public RelWriter explainMatch(RelWriter pw, MatchRecognize logicalMatch, List<String> fieldNames, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression2) {
        return CommonMatchRecognize$class.explainMatch(this, pw, logicalMatch, fieldNames, expression2);
    }

    @Override
    public boolean measuresDefineToString$default$4() {
        return CommonMatchRecognize$class.measuresDefineToString$default$4(this);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.outputSchema.relDataType();
    }

    @Override
    public boolean requireWatermark() {
        Buffer rowtimeFields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.getInput().getRowType().getFieldList()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelDataTypeField f) {
                return FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(f.getType());
            }
        });
        return rowtimeFields.nonEmpty();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        return new StreamExecMatch(this.cluster, traitSet, inputs.get(0), this.logicalMatch, this.outputSchema, this.inputSchema);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.explainMatch(super.explainTerms(pw), this.logicalMatch, (List<String>)this.inputSchema.fieldNames().toList(), (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamExecMatch $outer;

            public final String apply(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
                return this.$outer.getExpressionString(expr, inFields, localExprsTable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean isDeterministic() {
        return MatchUtil$.MODULE$.isDeterministic(this.logicalMatch);
    }

    private Time translateTimeBound(RexNode interval) {
        RexNode rexNode = interval;
        if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode;
            SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
            SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
            if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) {
                Time time = Time.milliseconds((long)Predef$.MODULE$.Long2long(rexLiteral.getValueAs(Long.class)));
                return time;
            }
        }
        throw new TableException("Only constant intervals with millisecond resolution are supported as time constraints of patterns.");
    }

    @VisibleForTesting
    public Tuple2<Pattern<BaseRow, BaseRow>, Seq<String>> translatePattern(TableConfig config, RelBuilder relBuilder, TypeInformation<BaseRow> inputTypeInfo) {
        Pattern pattern;
        PatternVisitor patternVisitor = new PatternVisitor(config, relBuilder, inputTypeInfo, this.logicalMatch);
        if (this.logicalMatch.interval() == null) {
            pattern = this.logicalMatch.pattern().accept(patternVisitor);
        } else {
            Time interval = this.translateTimeBound(this.logicalMatch.interval());
            pattern = this.logicalMatch.pattern().accept(patternVisitor).within(interval);
        }
        Pattern cepPattern = pattern;
        return new Tuple2((Object)cepPattern, (Object)patternVisitor.names().toSeq());
    }

    @Override
    public FlinkPhysicalRel getFlinkPhysicalRel() {
        return this;
    }

    @Override
    public ExecNodeWriter getStateDigest(ExecNodeWriter pw) {
        RelDataType timeType = SortUtil$.MODULE$.getFirstSortField(this.logicalMatch.orderKeys(), this.inputSchema.relDataType()).getType();
        boolean isRowtime = FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(timeType);
        List fieldNames = this.inputSchema.fieldNames().toList();
        return pw.item("inputType", this.input.getRowType()).item("isRowtime", BoxesRunTime.boxToBoolean((boolean)isRowtime)).itemIf("partitionBy", this.partitionKeysToString(this.logicalMatch.partitionKeys(), (List<String>)fieldNames, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamExecMatch $outer;

            public final String apply(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
                return this.$outer.getExpressionString(expr, inFields, localExprsTable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), !this.logicalMatch.partitionKeys().isEmpty()).itemIf("orderBy", this.orderingToString(this.logicalMatch.orderKeys(), (Seq<String>)fieldNames), !this.logicalMatch.orderKeys().getFieldCollations().isEmpty()).itemIf("measures", this.measuresDefineToString(this.logicalMatch.measures(), (List<String>)fieldNames, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamExecMatch $outer;

            public final String apply(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
                return this.$outer.getExpressionString(expr, inFields, localExprsTable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, false), !this.logicalMatch.measures().isEmpty()).itemIf("rowsPerMatch", this.logicalMatch.rowsPerMatch(), this.logicalMatch.rowsPerMatch() != null).item("after", this.afterMatchToString(this.logicalMatch.after(), (List<String>)fieldNames)).item("pattern", this.logicalMatch.pattern().toString()).itemIf("within interval", this.logicalMatch.interval() == null ? null : this.logicalMatch.interval().toString(), this.logicalMatch.interval() != null).itemIf("subset", this.subsetToString(this.logicalMatch.subsets()), !this.logicalMatch.subsets().isEmpty()).item("define", this.logicalMatch.patternDefinitions());
    }

    @Override
    public StreamTransformation<BaseRow> translateToPlanInternal(StreamTableEnvironment tableEnv) {
        boolean inputIsAccRetract = StreamExecRetractionRules$.MODULE$.isAccRetract(this.getInput());
        if (inputIsAccRetract) {
            throw new TableException("Retraction on match recognize is not supported. Note: Match recognize should not follow a non-windowed GroupBy aggregation.");
        }
        TableConfig config = tableEnv.config();
        FlinkRelBuilder relBuilder = tableEnv.getRelBuilder();
        BaseRowTypeInfo inputTypeInfo = this.inputSchema.typeInfo();
        StreamTransformation<?> inputTransform = this.getInputNodes().get(0).translateToPlan(tableEnv);
        Tuple2<StreamTransformation<BaseRow>, EventComparator<BaseRow>> tuple2 = this.translateOrder(inputTransform, inputTypeInfo, this.logicalMatch.orderKeys());
        if (tuple2 != null) {
            Tuple2 tuple22;
            StreamTransformation timestampedInput = (StreamTransformation)tuple2._1();
            EventComparator comparator = (EventComparator)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)timestampedInput, (Object)comparator);
            StreamTransformation timestampedInput2 = (StreamTransformation)tuple23._1();
            EventComparator comparator2 = (EventComparator)tuple23._2();
            Tuple2<Pattern<BaseRow, BaseRow>, Seq<String>> tuple24 = this.translatePattern(config, relBuilder, inputTypeInfo);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Pattern cepPattern = (Pattern)tuple24._1();
                Seq patternNames = (Seq)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)cepPattern, (Object)patternNames);
                Pattern cepPattern2 = (Pattern)tuple26._1();
                Seq patternNames2 = (Seq)tuple26._2();
                if (NFACompiler.canProduceEmptyMatches((Pattern)cepPattern2)) {
                    throw new TableException("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
                }
                if (cepPattern2.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY)) {
                    throw new TableException("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
                }
                return this.generateOutputTransformation(config, relBuilder, (StreamTransformation<BaseRow>)timestampedInput2, inputTypeInfo, (Pattern<BaseRow, BaseRow>)cepPattern2, (EventComparator<BaseRow>)comparator2, (Seq<String>)patternNames2);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<StreamTransformation<BaseRow>, EventComparator<BaseRow>> translateOrder(StreamTransformation<BaseRow> inputTransform, BaseRowTypeInfo inputTypeInfo, RelCollation orderKeys) {
        if (orderKeys.getFieldCollations().size() == 0) {
            throw new ValidationException("You must specify either rowtime or proctime for order by.");
        }
        RelDataTypeField timeOrderField = SortUtil$.MODULE$.getFirstSortField(orderKeys, this.inputSchema.relDataType());
        if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(timeOrderField.getType())) {
            RelFieldCollation.Direction direction = SortUtil$.MODULE$.getFirstSortDirection(orderKeys);
            RelFieldCollation.Direction direction2 = RelFieldCollation.Direction.ASCENDING;
            if (!(direction != null ? !((Object)((Object)direction)).equals((Object)direction2) : direction2 != null)) {
                OneInputTransformation oneInputTransformation;
                EventComparator<BaseRow> rowComparator = orderKeys.getFieldCollations().size() > 1 ? (FlinkTypeFactory$.MODULE$.isProctimeIndicatorType(timeOrderField.getType()) ? MatchUtil$.MODULE$.createProcTimeSortFunction(orderKeys, this.inputSchema) : MatchUtil$.MODULE$.createRowTimeSortFunction(orderKeys, this.inputSchema)) : null;
                Buffer rowtimeFields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.inputSchema.relDataType().getFieldList()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(RelDataTypeField f) {
                        return FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(f.getType());
                    }
                });
                if (rowtimeFields.nonEmpty()) {
                    int timeIdx = ((RelDataTypeField)rowtimeFields.head()).getIndex();
                    OneInputTransformation transformation = new OneInputTransformation(inputTransform, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime field: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowtimeFields.head()})), (OneInputStreamOperator)new ProcessOperator((ProcessFunction)new BaseRowRowtimeProcessFunction(timeIdx, inputTypeInfo)), (TypeInformation)inputTypeInfo, inputTransform.getParallelism());
                    this.setTransformationRes((StreamTransformation<?>)transformation);
                    oneInputTransformation = transformation;
                } else {
                    oneInputTransformation = inputTransform;
                }
                OneInputTransformation timestampedInputTransform = oneInputTransformation;
                return new Tuple2(timestampedInputTransform, rowComparator);
            }
            throw new ValidationException("Primary sort order of a streaming table must be ascending on time.");
        }
        throw new ValidationException("You must specify either rowtime or proctime for order by as the first one.");
    }

    /*
     * WARNING - void declaration
     */
    private StreamTransformation<BaseRow> generateOutputTransformation(TableConfig config, RelBuilder relBuilder, StreamTransformation<BaseRow> inputTransform, BaseRowTypeInfo inputTypeInfo, Pattern<BaseRow, BaseRow> cepPattern, EventComparator<BaseRow> comparator, Seq<String> patternNames) {
        void var11_11;
        block6: {
            StreamTransformation<BaseRow> streamTransformation;
            block3: {
                SqlMatchRecognize.RowsPerMatchOption rowsPerMatchOption;
                BaseRowTypeInfo outputTypeInfo;
                boolean isProcessingTime;
                block5: {
                    block4: {
                        block2: {
                            Buffer rowtimeFields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.inputSchema.relDataType().getFieldList()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(RelDataTypeField f) {
                                    return FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(f.getType());
                                }
                            });
                            isProcessingTime = rowtimeFields.isEmpty();
                            outputTypeInfo = FlinkTypeFactory$.MODULE$.toInternalBaseRowTypeInfo(this.getRowType());
                            Object rowsPerMatchLiteral = this.logicalMatch.rowsPerMatch() == null ? SqlMatchRecognize.RowsPerMatchOption.ONE_ROW : ((RexLiteral)this.logicalMatch.rowsPerMatch()).getValue();
                            rowsPerMatchOption = rowsPerMatchLiteral;
                            if (!((Object)((Object)SqlMatchRecognize.RowsPerMatchOption.ONE_ROW)).equals((Object)rowsPerMatchOption)) break block2;
                            MatchCodeGenerator qual$1 = new MatchCodeGenerator(CodeGeneratorContext$.MODULE$.apply(config, true), relBuilder, false, config.getNullCheck(), patternNames, MatchCodeGenerator$.MODULE$.$lessinit$greater$default$6(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$7());
                            InternalType x$3 = TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(inputTypeInfo);
                            String x$4 = qual$1.bindInput$default$2();
                            Option<int[]> x$5 = qual$1.bindInput$default$3();
                            MatchCodeGenerator generator = (MatchCodeGenerator)qual$1.bindInput(x$3, x$4, x$5);
                            PatternSelectFunction<BaseRow, BaseRow> patternSelectFunction = generator.generatePatternSelectFunction(config, this.outputSchema, this.logicalMatch.partitionKeys(), this.logicalMatch.measures());
                            streamTransformation = this.generateSelectTransformation(inputTransform, cepPattern, comparator, patternSelectFunction, isProcessingTime, inputTypeInfo, outputTypeInfo);
                            break block3;
                        }
                        if (!((Object)((Object)SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS)).equals((Object)rowsPerMatchOption)) break block4;
                        MatchCodeGenerator qual$2 = new MatchCodeGenerator(CodeGeneratorContext$.MODULE$.apply(config, true), relBuilder, false, config.getNullCheck(), patternNames, MatchCodeGenerator$.MODULE$.$lessinit$greater$default$6(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$7());
                        InternalType x$6 = TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(inputTypeInfo);
                        String x$7 = qual$2.bindInput$default$2();
                        Option<int[]> x$8 = qual$2.bindInput$default$3();
                        MatchCodeGenerator generator = (MatchCodeGenerator)qual$2.bindInput(x$6, x$7, x$8);
                        PatternFlatSelectFunction<BaseRow, BaseRow> patternFlatSelectFunction = generator.generatePatternFlatSelectFunction(config, this.outputSchema, this.logicalMatch.partitionKeys(), this.logicalMatch.orderKeys(), this.logicalMatch.measures());
                        streamTransformation = this.generateFlatSelectTransformation(inputTransform, cepPattern, comparator, patternFlatSelectFunction, isProcessingTime, inputTypeInfo, outputTypeInfo);
                        break block3;
                    }
                    if (!((Object)((Object)SqlMatchRecognize.RowsPerMatchOption.ONE_ROW_WITH_TIMEOUT)).equals((Object)rowsPerMatchOption)) break block5;
                    MatchCodeGenerator qual$3 = new MatchCodeGenerator(CodeGeneratorContext$.MODULE$.apply(config, true), relBuilder, false, config.getNullCheck(), patternNames, MatchCodeGenerator$.MODULE$.$lessinit$greater$default$6(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$7());
                    InternalType x$9 = TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(inputTypeInfo);
                    String x$10 = qual$3.bindInput$default$2();
                    Option<int[]> x$11 = qual$3.bindInput$default$3();
                    MatchCodeGenerator generator = (MatchCodeGenerator)qual$3.bindInput(x$9, x$10, x$11);
                    PatternSelectFunction<BaseRow, BaseRow> patternSelectFunction = generator.generatePatternSelectFunction(config, this.outputSchema, this.logicalMatch.partitionKeys(), this.logicalMatch.measures());
                    MatchCodeGenerator qual$4 = new MatchCodeGenerator(CodeGeneratorContext$.MODULE$.apply(config, true), relBuilder, false, config.getNullCheck(), patternNames, MatchCodeGenerator$.MODULE$.$lessinit$greater$default$6(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$7());
                    InternalType x$12 = TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(inputTypeInfo);
                    String x$13 = qual$4.bindInput$default$2();
                    Option<int[]> x$14 = qual$4.bindInput$default$3();
                    MatchCodeGenerator timeoutFuncGenerator = (MatchCodeGenerator)qual$4.bindInput(x$12, x$13, x$14);
                    PatternTimeoutFunction<BaseRow, BaseRow> patternTimeoutFunction = timeoutFuncGenerator.generatePatternTimeoutFunction(config, this.outputSchema, this.logicalMatch.partitionKeys(), this.logicalMatch.measures());
                    streamTransformation = this.generateSelectTimeoutTransformation(inputTransform, cepPattern, comparator, patternSelectFunction, patternTimeoutFunction, isProcessingTime, inputTypeInfo, outputTypeInfo);
                    break block3;
                }
                if (!((Object)((Object)SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS_WITH_TIMEOUT)).equals((Object)rowsPerMatchOption)) break block6;
                MatchCodeGenerator qual$5 = new MatchCodeGenerator(CodeGeneratorContext$.MODULE$.apply(config, true), relBuilder, false, config.getNullCheck(), patternNames, MatchCodeGenerator$.MODULE$.$lessinit$greater$default$6(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$7());
                InternalType x$15 = TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(inputTypeInfo);
                String x$16 = qual$5.bindInput$default$2();
                Option<int[]> x$17 = qual$5.bindInput$default$3();
                MatchCodeGenerator generator = (MatchCodeGenerator)qual$5.bindInput(x$15, x$16, x$17);
                PatternFlatSelectFunction<BaseRow, BaseRow> patternFlatSelectFunction = generator.generatePatternFlatSelectFunction(config, this.outputSchema, this.logicalMatch.partitionKeys(), this.logicalMatch.orderKeys(), this.logicalMatch.measures());
                MatchCodeGenerator qual$6 = new MatchCodeGenerator(CodeGeneratorContext$.MODULE$.apply(config, true), relBuilder, false, config.getNullCheck(), patternNames, MatchCodeGenerator$.MODULE$.$lessinit$greater$default$6(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$7());
                InternalType x$18 = TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(inputTypeInfo);
                String x$19 = qual$6.bindInput$default$2();
                Option<int[]> x$20 = qual$6.bindInput$default$3();
                MatchCodeGenerator flatTimeoutGenerator = (MatchCodeGenerator)qual$6.bindInput(x$18, x$19, x$20);
                PatternFlatTimeoutFunction<BaseRow, BaseRow> patternFlatTimeoutFunction = flatTimeoutGenerator.generatePatternFlatTimeoutFunction(config, this.outputSchema, this.logicalMatch.partitionKeys(), this.logicalMatch.orderKeys(), this.logicalMatch.measures());
                streamTransformation = this.generateFlatSelectTimeoutTransformation(inputTransform, cepPattern, comparator, patternFlatSelectFunction, patternFlatTimeoutFunction, isProcessingTime, inputTypeInfo, outputTypeInfo);
            }
            return streamTransformation;
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported RowsPerMatchOption: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var11_11})));
    }

    private void setTransformationRes(StreamTransformation<?> streamTransformation) {
        streamTransformation.setResources(this.getResource().getReservedResourceSpec(), this.getResource().getPreferResourceSpec());
    }

    private void setKeySelector(OneInputTransformation<BaseRow, ?> transform, BaseRowTypeInfo inputTypeInfo) {
        int[] logicalKeys = (int[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.logicalMatch.partitionKeys()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(RexNode x0$1) {
                RexNode rexNode = x0$1;
                if (rexNode instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)rexNode;
                    int n = rexInputRef.getIndex();
                    return n;
                }
                throw new MatchError((Object)rexNode);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        BaseRowKeySelector selector = StreamExecUtil$.MODULE$.getKeySelector(logicalKeys, inputTypeInfo);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType(selector.getProducedType());
        if (Predef$.MODULE$.intArrayOps(logicalKeys).isEmpty()) {
            transform.setParallelism(1);
            transform.setMaxParallelism(1);
        }
    }

    private StreamTransformation<BaseRow> generateSelectTransformation(StreamTransformation<BaseRow> inputTransform, Pattern<BaseRow, BaseRow> cepPattern, EventComparator<BaseRow> comparator, PatternSelectFunction<BaseRow, BaseRow> patternSelectFunction, boolean isProcessingTime, BaseRowTypeInfo inputTypeInfo, BaseRowTypeInfo outputTypeInfo) {
        TypeSerializer<BaseRow> inputSerializer = inputTypeInfo.createSerializer(new ExecutionConfig());
        NFACompiler.NFAFactory nfaFactory = NFACompiler.compileFactory(cepPattern, (boolean)true);
        OutputTag<BaseRow> timeoutOutputTag = new OutputTag<BaseRow>(UUID.randomUUID().toString(), outputTypeInfo);
        OneInputTransformation patternStreamTransform = new OneInputTransformation(inputTransform, "SelectCepOperator", (OneInputStreamOperator)new SelectCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, cepPattern.getAfterMatchSkipStrategy(), patternSelectFunction, timeoutOutputTag), (TypeInformation)outputTypeInfo, inputTransform.getParallelism());
        this.setTransformationRes((StreamTransformation<?>)patternStreamTransform);
        patternStreamTransform.setChainingStrategy(ChainingStrategy.ALWAYS);
        this.setKeySelector(patternStreamTransform, inputTypeInfo);
        return patternStreamTransform;
    }

    private StreamTransformation<BaseRow> generateFlatSelectTransformation(StreamTransformation<BaseRow> inputTransform, Pattern<BaseRow, BaseRow> cepPattern, EventComparator<BaseRow> comparator, PatternFlatSelectFunction<BaseRow, BaseRow> patternFlatSelectFunction, boolean isProcessingTime, BaseRowTypeInfo inputTypeInfo, BaseRowTypeInfo outputTypeInfo) {
        TypeSerializer<BaseRow> inputSerializer = inputTypeInfo.createSerializer(new ExecutionConfig());
        NFACompiler.NFAFactory nfaFactory = NFACompiler.compileFactory(cepPattern, (boolean)true);
        OutputTag<BaseRow> timeoutOutputTag = new OutputTag<BaseRow>(UUID.randomUUID().toString(), outputTypeInfo);
        OneInputTransformation patternStreamTransform = new OneInputTransformation(inputTransform, "FlatSelectCepOperator", (OneInputStreamOperator)new FlatSelectCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, cepPattern.getAfterMatchSkipStrategy(), patternFlatSelectFunction, timeoutOutputTag), (TypeInformation)outputTypeInfo, inputTransform.getParallelism());
        this.setTransformationRes((StreamTransformation<?>)patternStreamTransform);
        patternStreamTransform.setChainingStrategy(ChainingStrategy.ALWAYS);
        this.setKeySelector(patternStreamTransform, inputTypeInfo);
        return patternStreamTransform;
    }

    private StreamTransformation<BaseRow> generateSelectTimeoutTransformation(StreamTransformation<BaseRow> inputTransform, Pattern<BaseRow, BaseRow> cepPattern, EventComparator<BaseRow> comparator, PatternSelectFunction<BaseRow, BaseRow> patternSelectFunction, PatternTimeoutFunction<BaseRow, BaseRow> patternTimeoutFunction, boolean isProcessingTime, BaseRowTypeInfo inputTypeInfo, BaseRowTypeInfo outputTypeInfo) {
        TypeSerializer<BaseRow> inputSerializer = inputTypeInfo.createSerializer(new ExecutionConfig());
        NFACompiler.NFAFactory nfaFactory = NFACompiler.compileFactory(cepPattern, (boolean)true);
        OutputTag<BaseRow> timeoutOutputTag = new OutputTag<BaseRow>(UUID.randomUUID().toString(), outputTypeInfo);
        OutputTag<BaseRow> lateDataOutputTag = new OutputTag<BaseRow>(UUID.randomUUID().toString(), inputTypeInfo);
        OneInputTransformation patternStreamTransform = new OneInputTransformation(inputTransform, "SelectTimeoutCepOperator", (OneInputStreamOperator)new SelectTimeoutCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, cepPattern.getAfterMatchSkipStrategy(), patternSelectFunction, patternTimeoutFunction, timeoutOutputTag, lateDataOutputTag), (TypeInformation)outputTypeInfo, inputTransform.getParallelism());
        this.setTransformationRes((StreamTransformation<?>)patternStreamTransform);
        patternStreamTransform.setChainingStrategy(ChainingStrategy.ALWAYS);
        this.setKeySelector(patternStreamTransform, inputTypeInfo);
        SideOutputTransformation timeoutStreamTransform = new SideOutputTransformation((StreamTransformation)patternStreamTransform, timeoutOutputTag);
        this.setTransformationRes((StreamTransformation<?>)timeoutStreamTransform);
        TwoInputTransformation transformation = new TwoInputTransformation((StreamTransformation)patternStreamTransform, (StreamTransformation)timeoutStreamTransform, "CombineOutputCepOperator", (TwoInputStreamOperator)new CoStreamMap((CoMapFunction)new CombineCepOutputCoMapFunction()), (TypeInformation)outputTypeInfo, inputTransform.getParallelism());
        this.setTransformationRes((StreamTransformation<?>)transformation);
        return transformation;
    }

    private StreamTransformation<BaseRow> generateFlatSelectTimeoutTransformation(StreamTransformation<BaseRow> inputTransform, Pattern<BaseRow, BaseRow> cepPattern, EventComparator<BaseRow> comparator, PatternFlatSelectFunction<BaseRow, BaseRow> patternFlatSelectFunction, PatternFlatTimeoutFunction<BaseRow, BaseRow> patternFlatTimeoutFunction, boolean isProcessingTime, BaseRowTypeInfo inputTypeInfo, BaseRowTypeInfo outputTypeInfo) {
        TypeSerializer<BaseRow> inputSerializer = inputTypeInfo.createSerializer(new ExecutionConfig());
        NFACompiler.NFAFactory nfaFactory = NFACompiler.compileFactory(cepPattern, (boolean)true);
        OutputTag<BaseRow> timeoutOutputTag = new OutputTag<BaseRow>(UUID.randomUUID().toString(), outputTypeInfo);
        OutputTag<BaseRow> lateDataOutputTag = new OutputTag<BaseRow>(UUID.randomUUID().toString(), inputTypeInfo);
        OneInputTransformation patternStreamTransform = new OneInputTransformation(inputTransform, "FlatSelectTimeoutCepOperator", (OneInputStreamOperator)new FlatSelectTimeoutCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, cepPattern.getAfterMatchSkipStrategy(), patternFlatSelectFunction, patternFlatTimeoutFunction, timeoutOutputTag, lateDataOutputTag), (TypeInformation)outputTypeInfo, inputTransform.getParallelism());
        this.setTransformationRes((StreamTransformation<?>)patternStreamTransform);
        patternStreamTransform.setChainingStrategy(ChainingStrategy.ALWAYS);
        this.setKeySelector(patternStreamTransform, inputTypeInfo);
        SideOutputTransformation timeoutStreamTransform = new SideOutputTransformation((StreamTransformation)patternStreamTransform, timeoutOutputTag);
        this.setTransformationRes((StreamTransformation<?>)timeoutStreamTransform);
        TwoInputTransformation transformation = new TwoInputTransformation((StreamTransformation)patternStreamTransform, (StreamTransformation)timeoutStreamTransform, "CombineOutputCepOperator", (TwoInputStreamOperator)new CoStreamMap((CoMapFunction)new CombineCepOutputCoMapFunction()), (TypeInformation)outputTypeInfo, inputTransform.getParallelism());
        this.setTransformationRes((StreamTransformation<?>)transformation);
        return transformation;
    }

    public StreamExecMatch(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, MatchRecognize logicalMatch, BaseRowSchema outputSchema, BaseRowSchema inputSchema) {
        this.cluster = cluster;
        this.input = input;
        this.logicalMatch = logicalMatch;
        this.outputSchema = outputSchema;
        this.inputSchema = inputSchema;
        super(cluster, traitSet, input);
        CommonMatchRecognize$class.$init$(this);
        FlinkRelNode$class.$init$(this);
        FlinkPhysicalRel$class.$init$(this);
        StreamPhysicalRel$class.$init$(this);
        ExecNode$class.$init$(this);
        StreamExecNode$class.$init$(this);
        Logging$class.$init$(this);
        BaseStreamExecNode$class.$init$(this);
    }
}

