/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.process;

import java.util.LinkedList;
import java.util.List;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.plan.nodes.process.DAGProcessor;
import org.apache.flink.table.plan.util.DeadlockBreakupProcessor;
import org.apache.flink.table.resource.batch.BatchRunningUnitBuildProcessor;
import org.apache.flink.table.resource.batch.managedmem.BatchManagedMemoryProcessor;
import org.apache.flink.table.resource.batch.parallelism.BatchParallelismProcessor;
import org.apache.flink.table.resource.common.NodePartialResProcessor;
import org.apache.flink.table.resource.stream.StreamParallelismProcessor;
import org.apache.flink.table.util.CalcOutputBinaryRowProcessor;

public class ChainedDAGProcessors {
    private List<DAGProcessor> dagProcessorList = new LinkedList<DAGProcessor>();

    public static ChainedDAGProcessors buildBatchProcessors() {
        ChainedDAGProcessors processors = new ChainedDAGProcessors();
        processors.addProcessor(new DeadlockBreakupProcessor());
        processors.addProcessor(new CalcOutputBinaryRowProcessor());
        processors.addProcessor(new BatchRunningUnitBuildProcessor());
        processors.addProcessor(new NodePartialResProcessor());
        processors.addProcessor(new BatchParallelismProcessor());
        processors.addProcessor(new BatchManagedMemoryProcessor());
        return processors;
    }

    public static ChainedDAGProcessors buildStreamProcessors() {
        ChainedDAGProcessors processors = new ChainedDAGProcessors();
        processors.addProcessor(new NodePartialResProcessor());
        processors.addProcessor(new StreamParallelismProcessor());
        return processors;
    }

    public void addProcessor(DAGProcessor dagProcessorList) {
        this.dagProcessorList.add(dagProcessorList);
    }

    public List<ExecNode<?, ?>> process(List<ExecNode<?, ?>> sinkNodes, DAGProcessContext context) {
        for (DAGProcessor processor : this.dagProcessorList) {
            sinkNodes = processor.process(sinkNodes, context);
        }
        return sinkNodes;
    }
}

