/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.plan.rules.logical.CalcRankTransposeRule$;
import org.apache.flink.table.plan.util.FlinkRelMdUtil$;
import org.apache.flink.table.plan.util.InputRefVisitor;
import org.apache.flink.table.plan.util.InputRewriter;
import org.apache.flink.table.plan.util.RankRange;
import org.apache.flink.table.plan.util.VariableRankRange;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001E\u0011QcQ1mGJ\u000bgn\u001b+sC:\u001c\bo\\:f%VdWM\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"aE\f\u000e\u0003QQ!aB\u000b\u000b\u0005Ya\u0011aB2bY\u000eLG/Z\u0005\u00031Q\u0011!BU3m\u001fB$(+\u001e7f\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003 \u0001\u0011\u0005\u0003%A\u0004nCR\u001c\u0007.Z:\u0015\u0005\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#a\u0002\"p_2,\u0017M\u001c\u0005\u0006Qy\u0001\r!K\u0001\u0005G\u0006dG\u000e\u0005\u0002\u0014U%\u00111\u0006\u0006\u0002\u000f%\u0016dw\n\u001d;Sk2,7)\u00197m\u0011\u0015i\u0003\u0001\"\u0011/\u0003\u001dyg.T1uG\"$\"a\f\u001a\u0011\u0005\t\u0002\u0014BA\u0019$\u0005\u0011)f.\u001b;\t\u000b!b\u0003\u0019A\u0015\t\u000bQ\u0002A\u0011B\u001b\u0002%\u001d,G\u000fU;tQ\u0006\u0014G.Z\"pYVlgn\u001d\u000b\u0004mq2\u0005c\u0001\u00128s%\u0011\u0001h\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003EiJ!aO\u0012\u0003\u0007%sG\u000fC\u0003>g\u0001\u0007a(\u0001\u0003dC2\u001c\u0007CA E\u001b\u0005\u0001%BA!C\u0003\u0011\u0019wN]3\u000b\u0005\r+\u0012a\u0001:fY&\u0011Q\t\u0011\u0002\u0005\u0007\u0006d7\rC\u0003Hg\u0001\u0007\u0001*\u0001\u0003sC:\\\u0007CA%N\u001b\u0005Q%BA\u0002L\u0015\tae!A\u0003o_\u0012,7/\u0003\u0002O\u0015\n\u0001b\t\\5oW2{w-[2bYJ\u000bgn\u001b\u0005\u0006!\u0002!I!U\u0001\u000eO\u0016$Xk]3e\r&,G\u000eZ:\u0015\u0005Y\u0012\u0006\"B\u001fP\u0001\u0004q\u0004\"\u0002+\u0001\t\u0013)\u0016\u0001D4fi.+\u0017PR5fY\u0012\u001cHC\u0001\u001cW\u0011\u001595\u000b1\u0001I\u0011\u0015A\u0006\u0001\"\u0003Z\u0003e\u0019'/Z1uK:+w/\u00138oKJ\u001c\u0015\r\\2Qe><'/Y7\u0015\ti\u0003'M\u001b\t\u00037zk\u0011\u0001\u0018\u0006\u0003;V\t1A]3y\u0013\tyFL\u0001\u0006SKb\u0004&o\\4sC6DQ!Y,A\u0002Y\nq\u0002\u001d:pU\u0016\u001cG/\u001a3GS\u0016dGm\u001d\u0005\u0006G^\u0003\r\u0001Z\u0001\rS:\u0004X\u000f\u001e*poRK\b/\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O\n\u000bA\u0001^=qK&\u0011\u0011N\u001a\u0002\f%\u0016dG)\u0019;b)f\u0004X\rC\u0003l/\u0002\u0007A.\u0001\u0006sKb\u0014U/\u001b7eKJ\u0004\"aW7\n\u00059d&A\u0003*fq\n+\u0018\u000e\u001c3fe\")\u0001\u000f\u0001C\u0005c\u000692M]3bi\u0016tUm\u001e+pa\u000e\u000bGn\u0019)s_\u001e\u0014\u0018-\u001c\u000b\u00065J$XP \u0005\u0006g>\u0004\rAW\u0001\u000e_2$Gk\u001c9Qe><'/Y7\t\u000bU|\u0007\u0019\u0001<\u0002\u0019\u0019LW\r\u001c3NCB\u0004\u0018N\\4\u0011\t]T\u0018(\u000f\b\u0003EaL!!_\u0012\u0002\rA\u0013X\rZ3g\u0013\tYHPA\u0002NCBT!!_\u0012\t\u000b\r|\u0007\u0019\u00013\t\u000b-|\u0007\u0019\u00017\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u0005\u00192M]3bi\u0016tUm\u001e*b].|enQ1mGR9\u0001*!\u0002\u0002\b\u0005-\u0001\"B;\u0000\u0001\u00041\bBBA\u0005\u007f\u0002\u0007a(A\u0003j]B,H\u000fC\u0003H\u007f\u0002\u0007\u0001jB\u0004\u0002\u0010\tA\t!!\u0005\u0002+\r\u000bGn\u0019*b].$&/\u00198ta>\u001cXMU;mKB\u0019Q$a\u0005\u0007\r\u0005\u0011\u0001\u0012AA\u000b'\u0011\t\u0019\"a\u0006\u0011\u0007\t\nI\"C\u0002\u0002\u001c\r\u0012a!\u00118z%\u00164\u0007b\u0002\u000e\u0002\u0014\u0011\u0005\u0011q\u0004\u000b\u0003\u0003#A!\"a\t\u0002\u0014\t\u0007I\u0011AA\u0013\u0003!Iej\u0015+B\u001d\u000e+U#\u0001\u000f\t\u0011\u0005%\u00121\u0003Q\u0001\nq\t\u0011\"\u0013(T)\u0006s5)\u0012\u0011")
public class CalcRankTransposeRule
extends RelOptRule {
    public static CalcRankTransposeRule INSTANCE() {
        return CalcRankTransposeRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Calc calc = (Calc)call.rel(0);
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(1);
        int totalColumnCount = rank.getInput().getRowType().getFieldCount();
        int[] pushableColumns = this.getPushableColumns(calc, rank);
        return pushableColumns.length < totalColumnCount;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RexProgram topProgram;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(1);
        int[] pushableColumns = this.getPushableColumns(calc, rank);
        RexBuilder rexBuilder = calc.getCluster().getRexBuilder();
        RexProgram innerProgram = this.createNewInnerCalcProgram(pushableColumns, rank.getInput().getRowType(), rexBuilder);
        Calc newInnerCalc = calc.copy(calc.getTraitSet(), rank.getInput(), innerProgram);
        Map fieldMapping = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(pushableColumns).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        FlinkLogicalRank newRank = this.createNewRankOnCalc((Map<Object, Object>)fieldMapping, newInnerCalc, rank);
        if (rank.outputRankFunColumn()) {
            int oldRankFunFieldIdx = FlinkRelMdUtil$.MODULE$.getRankFunColumnIndex(rank);
            int newRankFunFieldIdx = FlinkRelMdUtil$.MODULE$.getRankFunColumnIndex(newRank);
            fieldMapping = fieldMapping.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)oldRankFunFieldIdx)), (Object)BoxesRunTime.boxToInteger((int)newRankFunFieldIdx)));
        }
        FlinkLogicalRank equiv = (topProgram = this.createNewTopCalcProgram(calc.getProgram(), (Map<Object, Object>)fieldMapping, newRank.getRowType(), rexBuilder)).isTrivial() ? newRank : calc.copy(calc.getTraitSet(), newRank, topProgram);
        call.transformTo(equiv);
    }

    private int[] getPushableColumns(Calc calc, FlinkLogicalRank rank) {
        int[] usedFields = this.getUsedFields(calc);
        int rankFunFieldIndex = FlinkRelMdUtil$.MODULE$.getRankFunColumnIndex(rank);
        int[] usedFieldsExcludeRankFun = (int[])Predef$.MODULE$.intArrayOps(usedFields).filter((Function1)new Serializable(this, rankFunFieldIndex){
            public static final long serialVersionUID = 0L;
            private final int rankFunFieldIndex$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return x$1 != this.rankFunFieldIndex$1;
            }
            {
                this.rankFunFieldIndex$1 = rankFunFieldIndex$1;
            }
        });
        int[] requiredFields = this.getKeyFields(rank);
        return (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(usedFieldsExcludeRankFun).union((GenSeq)Predef$.MODULE$.wrapIntArray(requiredFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSet().toArray(ClassTag$.MODULE$.Int())).sorted((Ordering)Ordering.Int$.MODULE$);
    }

    private int[] getUsedFields(Calc calc) {
        Pair<ImmutableList<RexNode>, ImmutableList<RexNode>> projectsAndConditions = calc.getProgram().split();
        Tuple2 tuple2 = new Tuple2(projectsAndConditions.left, projectsAndConditions.right);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ImmutableList projects = (ImmutableList)tuple2._1();
            ImmutableList conditions = (ImmutableList)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)projects, (Object)conditions);
            ImmutableList projects2 = (ImmutableList)tuple23._1();
            ImmutableList conditions2 = (ImmutableList)tuple23._2();
            InputRefVisitor visitor = new InputRefVisitor();
            JavaConversions$.MODULE$.asScalaBuffer((List)projects2).foreach((Function1)new Serializable(this, visitor){
                public static final long serialVersionUID = 0L;
                private final InputRefVisitor visitor$1;

                public final void apply(RexNode x$3) {
                    x$3.accept(this.visitor$1);
                }
                {
                    this.visitor$1 = visitor$1;
                }
            });
            JavaConversions$.MODULE$.asScalaBuffer((List)conditions2).foreach((Function1)new Serializable(this, visitor){
                public static final long serialVersionUID = 0L;
                private final InputRefVisitor visitor$1;

                public final void apply(RexNode x$4) {
                    x$4.accept(this.visitor$1);
                }
                {
                    this.visitor$1 = visitor$1;
                }
            });
            return visitor.getFields();
        }
        throw new MatchError((Object)tuple2);
    }

    private int[] getKeyFields(FlinkLogicalRank rank) {
        int[] nArray;
        int[] partitionKey = rank.partitionKey().toArray();
        int[] orderKey = (int[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(rank.sortCollation().getFieldCollations()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(RelFieldCollation x$5) {
                return x$5.getFieldIndex();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        Set<ImmutableBitSet> uniqueKeys = rank.getCluster().getMetadataQuery().getUniqueKeys(rank.getInput());
        int[] keysInUniqueKeys = uniqueKeys == null || uniqueKeys.isEmpty() ? (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()) : (int[])((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(uniqueKeys).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Object> apply(ImmutableBitSet x$6) {
                return Predef$.MODULE$.intArrayOps(x$6.toArray());
            }
        }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        RankRange rankRange = rank.rankRange();
        if (rankRange instanceof VariableRankRange) {
            VariableRankRange variableRankRange = (VariableRankRange)rankRange;
            nArray = new int[]{variableRankRange.rankEndIndex()};
        } else {
            nArray = (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
        }
        int[] rankRangeKey = nArray;
        return (int[])((TraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][]{partitionKey, orderKey, keysInUniqueKeys, rankRangeKey})).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Object> apply(int[] xs) {
                return Predef$.MODULE$.intArrayOps(xs);
            }
        })).toArray(ClassTag$.MODULE$.Int());
    }

    private RexProgram createNewInnerCalcProgram(int[] projectedFields, RelDataType inputRowType, RexBuilder rexBuilder) {
        RexInputRef[] projects = (RexInputRef[])Predef$.MODULE$.intArrayOps(projectedFields).map((Function1)new Serializable(this, inputRowType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputRowType$1;

            public final RexInputRef apply(int x$7) {
                return RexInputRef.of(x$7, this.inputRowType$1);
            }
            {
                this.inputRowType$1 = inputRowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RexInputRef.class)));
        List<String> inputColNames = inputRowType.getFieldNames();
        String[] colNames = (String[])Predef$.MODULE$.intArrayOps(projectedFields).map((Function1)new Serializable(this, inputColNames){
            public static final long serialVersionUID = 0L;
            private final List inputColNames$1;

            public final String apply(int x$1) {
                return (String)this.inputColNames$1.get(x$1);
            }
            {
                this.inputColNames$1 = inputColNames$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return RexProgram.create(inputRowType, (List<? extends RexNode>)JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])projects).toList()), null, JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])colNames).toList()), rexBuilder);
    }

    private RexProgram createNewTopCalcProgram(RexProgram oldTopProgram, Map<Object, Object> fieldMapping, RelDataType inputRowType, RexBuilder rexBuilder) {
        InputRewriter inputRewriter = new InputRewriter(fieldMapping);
        List<RexLocalRef> oldProjects = oldTopProgram.getProjectList();
        Buffer projects = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(oldProjects).map((Function1)new Serializable(this, oldTopProgram){
            public static final long serialVersionUID = 0L;
            private final RexProgram oldTopProgram$1;

            public final RexNode apply(RexLocalRef x$1) {
                return this.oldTopProgram$1.expandLocalRef(x$1);
            }
            {
                this.oldTopProgram$1 = oldTopProgram$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, inputRewriter){
            public static final long serialVersionUID = 0L;
            private final InputRewriter inputRewriter$1;

            public final RexNode apply(RexNode x$8) {
                return x$8.accept(this.inputRewriter$1);
            }
            {
                this.inputRewriter$1 = inputRewriter$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        RexLocalRef oldCondition = oldTopProgram.getCondition();
        RexNode condition = oldCondition == null ? null : oldTopProgram.expandLocalRef(oldCondition).accept(inputRewriter);
        List<String> colNames = oldTopProgram.getOutputRowType().getFieldNames();
        return RexProgram.create(inputRowType, (List<? extends RexNode>)JavaConversions$.MODULE$.bufferAsJavaList(projects), condition, colNames, rexBuilder);
    }

    private FlinkLogicalRank createNewRankOnCalc(Map<Object, Object> fieldMapping, Calc input, FlinkLogicalRank rank) {
        int[] newPartitionKey = (int[])Predef$.MODULE$.intArrayOps(rank.partitionKey().toArray()).map((Function1)new Serializable(this, fieldMapping){
            public static final long serialVersionUID = 0L;
            private final Map fieldMapping$1;

            public final int apply(int x$9) {
                return this.apply$mcII$sp(x$9);
            }

            public int apply$mcII$sp(int x$9) {
                return BoxesRunTime.unboxToInt((Object)this.fieldMapping$1.apply((Object)BoxesRunTime.boxToInteger((int)x$9)));
            }
            {
                this.fieldMapping$1 = fieldMapping$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        RelCollation oldSortCollation = rank.sortCollation();
        List<RelFieldCollation> oldFieldCollations = oldSortCollation.getFieldCollations();
        Buffer newFieldCollations = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(oldFieldCollations).map((Function1)new Serializable(this, fieldMapping){
            public static final long serialVersionUID = 0L;
            private final Map fieldMapping$1;

            public final RelFieldCollation apply(RelFieldCollation fc) {
                return fc.copy(BoxesRunTime.unboxToInt((Object)this.fieldMapping$1.apply((Object)BoxesRunTime.boxToInteger((int)fc.getFieldIndex()))));
            }
            {
                this.fieldMapping$1 = fieldMapping$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        RelCollation newSortCollation = newFieldCollations == oldFieldCollations ? oldSortCollation : RelCollations.of(JavaConversions$.MODULE$.bufferAsJavaList(newFieldCollations));
        return new FlinkLogicalRank(rank.getCluster(), rank.getTraitSet(), input, rank.rankFunction(), ImmutableBitSet.of(newPartitionKey), newSortCollation, rank.rankRange(), rank.outputRankFunColumn());
    }

    public CalcRankTransposeRule() {
        super(RelOptRule.operand(Calc.class, RelOptRule.operand(FlinkLogicalRank.class, RelOptRule.any()), new RelOptRuleOperand[0]), "CalcRankTransposeRule");
    }
}

