/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.TableSourceParser;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.utils.TableSqlFunction;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.plan.rules.logical.CatalogTableRules;
import org.apache.flink.table.plan.rules.logical.CatalogTableToBatchTableSourceRule;
import org.apache.flink.table.plan.rules.logical.CatalogTableToStreamTableSourceRule;
import org.apache.flink.table.plan.schema.CatalogCalciteTable;
import org.apache.flink.table.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.util.TableEnvironmentUtil$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class CatalogTableRules$ {
    public static final CatalogTableRules$ MODULE$;
    private final CatalogTableToStreamTableSourceRule STREAM_TABLE_SCAN_RULE;
    private final CatalogTableToBatchTableSourceRule BATCH_TABLE_SCAN_RULE;

    static {
        new CatalogTableRules$();
    }

    public CatalogTableToStreamTableSourceRule STREAM_TABLE_SCAN_RULE() {
        return this.STREAM_TABLE_SCAN_RULE;
    }

    public CatalogTableToBatchTableSourceRule BATCH_TABLE_SCAN_RULE() {
        return this.BATCH_TABLE_SCAN_RULE;
    }

    public RelNode appendParserNode(CatalogCalciteTable catalogTable, RelNode inputNode, RelBuilder relBuilder) {
        RelNode relNode;
        TableSourceParser parser = catalogTable.tableSourceParser();
        if (parser == null) {
            relNode = inputNode;
        } else {
            CorrelationId colId = inputNode.getCluster().createCorrel();
            relBuilder.push(inputNode);
            Buffer params = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(parser.getParameters()).map((Function1)new Serializable(relBuilder){
                public static final long serialVersionUID = 0L;
                private final RelBuilder relBuilder$1;

                public final RexInputRef apply(String name) {
                    return this.relBuilder$1.field(name);
                }
                {
                    this.relBuilder$1 = relBuilder$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            TableFunction<?> tf = parser.getParser();
            FlinkTypeFactory typeFactory = (FlinkTypeFactory)inputNode.getCluster().getTypeFactory();
            TableSqlFunction parserSqlFunction = UserDefinedFunctionUtils$.MODULE$.createTableSqlFunction("parser", "parser", tf, typeFactory);
            RexNode rexCall = relBuilder.call((SqlOperator)parserSqlFunction, JavaConversions$.MODULE$.bufferAsJavaList(params));
            LogicalTableFunctionScan tableFunctionScan = LogicalTableFunctionScan.create(inputNode.getCluster(), ImmutableList.<RelNode>of(), rexCall, parserSqlFunction.getElementType(typeFactory, JavaConversions$.MODULE$.seqAsJavaList((Seq)params.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SqlLiteral apply(RexInputRef x$1) {
                    return SqlLiteral.createNull(new SqlParserPos(0, 0));
                }
            }, Buffer$.MODULE$.canBuildFrom()))), parserSqlFunction.getRowType(typeFactory, JavaConversions$.MODULE$.seqAsJavaList((Seq)params.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SqlLiteral apply(RexInputRef x$2) {
                    return SqlLiteral.createNull(new SqlParserPos(0, 0));
                }
            }, Buffer$.MODULE$.canBuildFrom())), JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(parser.getParameters()).map((Function1)new Serializable(inputNode){
                public static final long serialVersionUID = 0L;
                private final RelNode inputNode$1;

                public final RelDataType apply(String name) {
                    return this.inputNode$1.getRowType().getField(name, true, false).getType();
                }
                {
                    this.inputNode$1 = inputNode$1;
                }
            }, Buffer$.MODULE$.canBuildFrom()))), null);
            RelDataType outputDataType = tableFunctionScan.getRowType();
            ImmutableBitSet.Builder columnSetBuilder = ImmutableBitSet.builder();
            params.foreach((Function1)new Serializable(columnSetBuilder){
                public static final long serialVersionUID = 0L;
                private final ImmutableBitSet.Builder columnSetBuilder$1;

                public final ImmutableBitSet.Builder apply(RexInputRef param) {
                    return this.columnSetBuilder$1.set(param.getIndex());
                }
                {
                    this.columnSetBuilder$1 = columnSetBuilder$1;
                }
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outputDataType.getFieldCount()).foreach((Function1)new Serializable(inputNode, columnSetBuilder){
                public static final long serialVersionUID = 0L;
                private final RelNode inputNode$1;
                private final ImmutableBitSet.Builder columnSetBuilder$1;

                public final ImmutableBitSet.Builder apply(int idx) {
                    return this.columnSetBuilder$1.set(this.inputNode$1.getRowType().getFieldCount() + idx);
                }
                {
                    this.inputNode$1 = inputNode$1;
                    this.columnSetBuilder$1 = columnSetBuilder$1;
                }
            });
            LogicalCorrelate correlate = LogicalCorrelate.create(inputNode, tableFunctionScan, colId, columnSetBuilder.build(), SemiJoinType.INNER);
            relBuilder.push(correlate);
            Buffer projects = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(outputDataType.getFieldList()).map((Function1)new Serializable(inputNode, relBuilder){
                public static final long serialVersionUID = 0L;
                private final RelNode inputNode$1;
                private final RelBuilder relBuilder$1;

                public final RexInputRef apply(RelDataTypeField field) {
                    return this.relBuilder$1.field(this.inputNode$1.getRowType().getFieldCount() + field.getIndex());
                }
                {
                    this.inputNode$1 = inputNode$1;
                    this.relBuilder$1 = relBuilder$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            relNode = LogicalProject.create((RelNode)correlate, (List<? extends RexNode>)JavaConversions$.MODULE$.bufferAsJavaList(projects), outputDataType);
        }
        return relNode;
    }

    public RelNode appendComputedColumns(FlinkPlannerImpl flinkPlanner, RelBuilder relBuilder, LogicalTableScan tableScan, RelNode currentRel, CatalogTable catalogTable, boolean isStreaming) {
        RelNode relNode;
        List<Pair<RexNode, String>> list;
        CalciteCatalogReader catalogReader;
        TableSchema physicalSchema = this.tableSchemaFromRichSchema(catalogTable.getRichTableSchema());
        TableSchema logicalSchema = catalogTable.getTableSchema();
        String tableName = "__MockTable__";
        String viewSql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogTable.getComputedColumnsSql(), tableName}));
        LogicalProject project = (LogicalProject)TableEnvironmentUtil$.MODULE$.queryToRel(viewSql, flinkPlanner, (Option<CalciteCatalogReader>)Option$.MODULE$.apply((Object)(catalogReader = this.createSingleTableCatalogReader(tableName, flinkPlanner.typeFactory(), flinkPlanner.typeFactory().buildLogicalRowType(physicalSchema, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)isStreaming)))))));
        List<Pair<RexNode, String>> list2 = project.getNamedProjects();
        if (list2 != null && !(list = list2).isEmpty()) {
            ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(list).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Pair<RexNode, String> x$3) {
                    return (String)x$3.right;
                }
            }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(logicalSchema){
                public static final long serialVersionUID = 0L;
                private final TableSchema logicalSchema$1;

                public final void apply(String name) {
                    if (Predef$.MODULE$.refArrayOps((Object[])this.logicalSchema$1.getColumnNames()).contains((Object)name)) {
                        return;
                    }
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column name ", " does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                {
                    this.logicalSchema$1 = logicalSchema$1;
                }
            });
            Buffer projects = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(list).map((Function1)new Serializable(relBuilder, tableScan, isStreaming){
                public static final long serialVersionUID = 0L;
                private final RelBuilder relBuilder$2;
                private final LogicalTableScan tableScan$1;
                private final boolean isStreaming$1;

                public final RexNode apply(Pair<RexNode, String> p) {
                    RexNode node = (RexNode)p.left;
                    return !this.isStreaming$1 && node.getType() instanceof TimeIndicatorRelDataType ? this.relBuilder$2.getRexBuilder().makeAbstractCast(this.tableScan$1.getRowType().getField((String)p.right, true, false).getType(), node) : node;
                }
                {
                    this.relBuilder$2 = relBuilder$2;
                    this.tableScan$1 = tableScan$1;
                    this.isStreaming$1 = isStreaming$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            relBuilder.push(currentRel);
            relNode = relBuilder.project(JavaConversions$.MODULE$.bufferAsJavaList(projects), JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(list).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Pair<RexNode, String> x$4) {
                    return (String)x$4.right;
                }
            }, Buffer$.MODULE$.canBuildFrom()))).build();
        } else {
            relNode = currentRel;
        }
        return relNode;
    }

    private TableSchema tableSchemaFromRichSchema(RichTableSchema richSchema) {
        TableSchema.Builder builder = TableSchema.builder();
        String[] physicalNames = richSchema.getColumnNames();
        InternalType[] physicalDataTypes = richSchema.getColumnTypes();
        boolean[] physicalNullables = richSchema.getNullables();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])physicalNames).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])physicalDataTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).zip((GenIterable)Predef$.MODULE$.wrapBooleanArray(physicalNullables), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final TableSchema.Builder builder$1;

            public final TableSchema.Builder apply(Tuple2<Tuple2<String, InternalType>, Object> x0$1) {
                Tuple2<Tuple2<String, InternalType>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    boolean nullable = tuple2._2$mcZ$sp();
                    if (tuple22 != null) {
                        String name = (String)tuple22._1();
                        InternalType dataType2 = (InternalType)tuple22._2();
                        TableSchema.Builder builder = this.builder$1.column(name, dataType2, nullable);
                        return builder;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    private CalciteCatalogReader createSingleTableCatalogReader(String name, FlinkTypeFactory typeFactory, RelDataType rowType) {
        CatalogTableRules.SimpleSchema schema2 = new CatalogTableRules.SimpleSchema(name, rowType);
        Properties props = new Properties();
        props.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(false));
        return new CalciteCatalogReader(CalciteSchemaBuilder.asRootSchema(schema2), new ArrayList<String>(), typeFactory, new CalciteConnectionConfigImpl(props));
    }

    private CatalogTableRules$() {
        MODULE$ = this;
        this.STREAM_TABLE_SCAN_RULE = new CatalogTableToStreamTableSourceRule();
        this.BATCH_TABLE_SCAN_RULE = new CatalogTableToBatchTableSourceRule();
    }
}

