/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.schema.Table;
import org.apache.flink.shaded.calcite.com.google.common.base.Strings;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.plan.rules.logical.CatalogTableRules$;
import org.apache.flink.table.plan.schema.BatchTableSourceTable;
import org.apache.flink.table.plan.schema.CatalogCalciteTable;
import org.apache.flink.table.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.util.FlinkRelOptUtil$;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.TableSourceUtil$;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001#\t\u00113)\u0019;bY><G+\u00192mKR{')\u0019;dQR\u000b'\r\\3T_V\u00148-\u001a*vY\u0016T!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019r#D\u0001\u0015\u0015\t9QC\u0003\u0002\u0017\u0019\u000591-\u00197dSR,\u0017B\u0001\r\u0015\u0005)\u0011V\r\\(qiJ+H.\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAQa\b\u0001\u0005B\u0001\nq!\\1uG\",7\u000f\u0006\u0002\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t9!i\\8mK\u0006t\u0007\"\u0002\u0015\u001f\u0001\u0004I\u0013\u0001B2bY2\u0004\"a\u0005\u0016\n\u0005-\"\"A\u0004*fY>\u0003HOU;mK\u000e\u000bG\u000e\u001c\u0005\u0006[\u0001!\tEL\u0001\b_:l\u0015\r^2i)\ty#\u0007\u0005\u0002#a%\u0011\u0011g\t\u0002\u0005+:LG\u000fC\u0003)Y\u0001\u0007\u0011\u0006")
public class CatalogTableToBatchTableSourceRule
extends RelOptRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalTableScan rel = (LogicalTableScan)call.rel(0);
        CatalogCalciteTable table = rel.getTable().unwrap(CatalogCalciteTable.class);
        return table != null && !(table.table() instanceof CatalogView);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelOptTable relOptTable;
        LogicalTableScan tableScan = (LogicalTableScan)call.rel(0);
        CatalogCalciteTable catalogTable = tableScan.getTable().unwrap(CatalogCalciteTable.class);
        BatchTableSource<Object> tableSource = catalogTable.batchTableSource();
        FlinkRelOptTable table = ((FlinkRelOptTable)tableScan.getTable()).copy(new BatchTableSourceTable<Object>(tableSource, catalogTable.getStatistic(), FlinkRelOptUtil$.MODULE$.getTableConfig(tableScan).getConf().getBoolean(TableConfigOptions.SQL_OPTIMIZER_SOURCE_COLLECT_STATS_ENABLED)), TableSourceUtil$.MODULE$.getRelDataType(tableSource, (Option<int[]>)None$.MODULE$, false, (FlinkTypeFactory)tableScan.getCluster().getTypeFactory()));
        if (tableSource.explainSource().isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add("From");
            builder.addAll(tableScan.getTable().getQualifiedName());
            relOptTable = table.config((List)((Object)builder.build()), (Table)table.unwrap(TableSourceTable.class));
        } else {
            relOptTable = table;
        }
        table = relOptTable;
        RelNode newRel = CatalogTableRules$.MODULE$.appendParserNode(catalogTable, LogicalTableScan.create(tableScan.getCluster(), table), call.builder());
        FlinkPlannerImpl flinkPlanner = call.getPlanner().getContext().unwrap(FlinkPlannerImpl.class);
        if (!Strings.isNullOrEmpty(catalogTable.table().getComputedColumnsSql())) {
            newRel = CatalogTableRules$.MODULE$.appendComputedColumns(flinkPlanner, call.builder(), tableScan, newRel, catalogTable.table(), false);
        }
        call.transformTo(newRel);
    }

    public CatalogTableToBatchTableSourceRule() {
        super(RelOptRule.operand(LogicalTableScan.class, RelOptRule.any()), "CatalogTableToBatchTableSource");
    }
}

