/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.EquiJoin;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableCollection;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;
import org.apache.flink.shaded.calcite.com.google.common.collect.Sets;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalSemiJoin;
import org.apache.flink.util.Preconditions;

public abstract class FlinkFilterJoinRule
extends RelOptRule {
    public static final Predicate TRUE_PREDICATE = new Predicate(){

        @Override
        public boolean apply(Join join, JoinRelType joinType, RexNode exp) {
            return true;
        }
    };
    public static final FlinkFilterJoinRule FILTER_ON_JOIN = new FlinkFilterIntoJoinRule(true, RelFactories.LOGICAL_BUILDER, TRUE_PREDICATE);
    public static final FlinkFilterJoinRule DUMB_FILTER_ON_JOIN = new FlinkFilterIntoJoinRule(false, RelFactories.LOGICAL_BUILDER, TRUE_PREDICATE);
    public static final FlinkFilterJoinRule JOIN = new FlinkJoinConditionPushRule(RelFactories.LOGICAL_BUILDER, TRUE_PREDICATE);
    private final boolean smart;
    private final Predicate predicate;

    protected FlinkFilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelBuilderFactory relBuilderFactory, Predicate predicate) {
        super(operand, relBuilderFactory, "FlinkFilterJoinRule:" + id);
        this.smart = smart;
        this.predicate = Preconditions.checkNotNull(predicate);
    }

    @Deprecated
    protected FlinkFilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
        this(operand, id, smart, RelBuilder.proto(filterFactory, projectFactory), TRUE_PREDICATE);
    }

    @Deprecated
    protected FlinkFilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory, Predicate predicate) {
        this(operand, id, smart, RelBuilder.proto(filterFactory, projectFactory), predicate);
    }

    protected void perform(RelOptRuleCall call, Filter filter, Join join) {
        boolean isAntiJoin;
        ArrayList<RexNode> deterministicJoinFilters = Lists.newArrayList();
        ImmutableList.Builder nondeterministicJoinFiltersBuilder = ImmutableList.builder();
        for (RexNode expr : RelOptUtil.conjunctions(join.getCondition())) {
            if (RexUtil.isDeterministic(expr)) {
                deterministicJoinFilters.add(expr);
                continue;
            }
            nondeterministicJoinFiltersBuilder.add(expr);
        }
        ImmutableCollection nondeterministicJoinFilters = nondeterministicJoinFiltersBuilder.build();
        ImmutableList origDeterministicJoinFilters = ImmutableList.copyOf(deterministicJoinFilters);
        if (filter == null && deterministicJoinFilters.isEmpty()) {
            return;
        }
        ArrayList<RexNode> deterministicAboveFilters = Lists.newArrayList();
        ImmutableList.Builder nondeterministicAboveFiltersBuilder = ImmutableList.builder();
        if (filter != null) {
            for (RexNode expr : RelOptUtil.conjunctions(filter.getCondition())) {
                if (RexUtil.isDeterministic(expr)) {
                    deterministicAboveFilters.add(expr);
                    continue;
                }
                nondeterministicAboveFiltersBuilder.add(expr);
            }
        }
        ImmutableCollection nondeterministicAboveFilters = nondeterministicAboveFiltersBuilder.build();
        ImmutableList<RexNode> origDeterministicAboveFilters = ImmutableList.copyOf(deterministicAboveFilters);
        JoinRelType joinType = join.getJoinType();
        if (this.smart && !origDeterministicAboveFilters.isEmpty() && join.getJoinType() != JoinRelType.INNER) {
            joinType = RelOptUtil.simplifyJoin(join, origDeterministicAboveFilters, joinType);
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        boolean filterPushed = false;
        if (RelOptUtil.classifyFilters(join, deterministicAboveFilters, joinType, !(join instanceof EquiJoin), !joinType.generatesNullsOnLeft(), !joinType.generatesNullsOnRight(), deterministicJoinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        this.validateJoinFilters(deterministicAboveFilters, deterministicJoinFilters, join, joinType);
        if (leftFilters.isEmpty() && rightFilters.isEmpty() && deterministicJoinFilters.size() == origDeterministicJoinFilters.size() && Sets.newHashSet(deterministicJoinFilters).equals(Sets.newHashSet(origDeterministicJoinFilters))) {
            filterPushed = false;
        }
        boolean bl = isAntiJoin = join instanceof SemiJoin && ((SemiJoin)join).isAnti;
        if (!isAntiJoin && RelOptUtil.classifyFilters(join, deterministicJoinFilters, joinType, false, !joinType.generatesNullsOnRight(), !joinType.generatesNullsOnLeft(), deterministicJoinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        if (!filterPushed && joinType == join.getJoinType() || deterministicJoinFilters.isEmpty() && leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        RelNode leftRel = relBuilder.push(join.getLeft()).filter(leftFilters).build();
        RelNode rightRel = relBuilder.push(join.getRight()).filter(rightFilters).build();
        ImmutableCollection fieldTypes2 = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(RelOptUtil.getFieldTypeList(leftRel.getRowType()))).addAll(RelOptUtil.getFieldTypeList(rightRel.getRowType()))).build();
        ImmutableCollection leftJoinFilters = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(deterministicJoinFilters)).addAll((Iterable)nondeterministicJoinFilters)).build();
        RexNode joinFilter = RexUtil.composeConjunction(rexBuilder, RexUtil.fixUp(rexBuilder, (List<RexNode>)((Object)leftJoinFilters), (List<RelDataType>)((Object)fieldTypes2)), false);
        if (joinFilter.isAlwaysTrue() && leftFilters.isEmpty() && rightFilters.isEmpty() && joinType == join.getJoinType()) {
            return;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), joinFilter, leftRel, rightRel, joinType, join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newJoinRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, rightRel);
        }
        relBuilder.push(newJoinRel);
        relBuilder.convert(join.getRowType(), false);
        ImmutableCollection leftAboveFilters = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(deterministicAboveFilters)).addAll((Iterable)nondeterministicAboveFilters)).build();
        relBuilder.filter(RexUtil.fixUp(rexBuilder, (List<RexNode>)((Object)leftAboveFilters), RelOptUtil.getFieldTypeList(relBuilder.peek().getRowType())));
        call.transformTo(relBuilder.build());
    }

    protected void validateJoinFilters(List<RexNode> aboveFilters, List<RexNode> joinFilters, Join join, JoinRelType joinType) {
        Iterator<RexNode> filterIter = joinFilters.iterator();
        while (filterIter.hasNext()) {
            RexNode exp = filterIter.next();
            if (this.predicate.apply(join, joinType, exp)) continue;
            aboveFilters.add(exp);
            filterIter.remove();
        }
    }

    protected boolean matches(Join join) {
        return join instanceof LogicalJoin || join instanceof SemiJoin && !(join instanceof FlinkLogicalSemiJoin);
    }

    public static interface Predicate {
        public boolean apply(Join var1, JoinRelType var2, RexNode var3);
    }

    public static class FlinkFilterIntoJoinRule
    extends FlinkFilterJoinRule {
        public FlinkFilterIntoJoinRule(boolean smart, RelBuilderFactory relBuilderFactory, Predicate predicate) {
            super(FlinkFilterIntoJoinRule.operand(Filter.class, FlinkFilterIntoJoinRule.operand(Join.class, RelOptRule.any()), new RelOptRuleOperand[0]), "FlinkFilterJoinRule:filter", smart, relBuilderFactory, predicate);
        }

        @Deprecated
        public FlinkFilterIntoJoinRule(boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory, Predicate predicate) {
            this(smart, RelBuilder.proto(filterFactory, projectFactory), predicate);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            Join join = (Join)call.rel(1);
            return this.matches(join);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Join join = (Join)call.rel(1);
            this.perform(call, filter, join);
        }
    }

    public static class FlinkJoinConditionPushRule
    extends FlinkFilterJoinRule {
        public FlinkJoinConditionPushRule(RelBuilderFactory relBuilderFactory, Predicate predicate) {
            super(RelOptRule.operand(Join.class, RelOptRule.any()), "FlinkFilterJoinRule:no-filter", true, relBuilderFactory, predicate);
        }

        @Deprecated
        public FlinkJoinConditionPushRule(RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory, Predicate predicate) {
            this(RelBuilder.proto(filterFactory, projectFactory), predicate);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            return this.matches(join);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            this.perform(call, null, join);
        }
    }
}

