/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.physical.batch.runtimefilter;

import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.functions.sql.internal.SqlRuntimeFilterBuilderFunction;
import org.apache.flink.table.functions.sql.internal.SqlRuntimeFilterFunction;
import org.apache.flink.table.plan.rules.physical.batch.runtimefilter.RfBuilderJoinTransposeRule$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;

public final class BaseRuntimeFilterPushDownRule$ {
    public static final BaseRuntimeFilterPushDownRule$ MODULE$;

    static {
        new BaseRuntimeFilterPushDownRule$();
    }

    public Seq<RexCall> findRuntimeFilters(RexProgram program) {
        if (program.getCondition() == null) {
            return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        List<RexNode> conditions = RelOptUtil.conjunctions(program.expandLocalRef(program.getCondition()));
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(conditions).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RexNode x0$1) {
                boolean bl;
                RexNode rexNode = x0$1;
                if (rexNode instanceof RexCall) {
                    RexCall rexCall = (RexCall)rexNode;
                    bl = rexCall.getOperator() instanceof SqlRuntimeFilterFunction;
                } else {
                    bl = false;
                }
                return bl;
            }
        });
    }

    public Seq<RexCall> findRfBuilders(RexProgram program) {
        if (program.getCondition() == null) {
            return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        List<RexNode> conditions = RelOptUtil.conjunctions(program.expandLocalRef(program.getCondition()));
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(conditions).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RexNode x0$2) {
                boolean bl;
                RexNode rexNode = x0$2;
                if (rexNode instanceof RexCall) {
                    RexCall rexCall = (RexCall)rexNode;
                    bl = rexCall.getOperator() instanceof SqlRuntimeFilterBuilderFunction;
                } else {
                    bl = false;
                }
                return bl;
            }
        });
    }

    public void updateRuntimeFilterFunction(RelNode filterInput, RexProgram program) {
        Seq<RexCall> rfCalls = this.findRuntimeFilters(program);
        rfCalls.foreach((Function1)new Serializable(filterInput){
            public static final long serialVersionUID = 0L;
            private final RelNode filterInput$1;

            public final void apply(RexCall call) {
                Double rowCount;
                int fieldIndex = RfBuilderJoinTransposeRule$.MODULE$.getIndexFromCall(call);
                SqlRuntimeFilterFunction rf = (SqlRuntimeFilterFunction)call.getOperator();
                RelMetadataQuery query = this.filterInput$1.getCluster().getMetadataQuery();
                Double ndv = query.getDistinctRowCount(this.filterInput$1, ImmutableBitSet.of(fieldIndex), null);
                if (ndv != null) {
                    rf.ndv_$eq(Predef$.MODULE$.Double2double(ndv));
                }
                if ((rowCount = query.getRowCount(this.filterInput$1)) != null) {
                    rf.rowCount_$eq(Predef$.MODULE$.Double2double(rowCount));
                }
            }
            {
                this.filterInput$1 = filterInput$1;
            }
        });
    }

    private BaseRuntimeFilterPushDownRule$() {
        MODULE$ = this;
    }
}

