/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.physical.stream;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.api.AggPhaseEnforcer$;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.physical.stream.StreamExecExchange;
import org.apache.flink.table.plan.nodes.physical.stream.StreamExecGlobalWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.stream.StreamExecGroupWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.stream.StreamExecLocalWindowAggregate;
import org.apache.flink.table.plan.rules.physical.FlinkExpandConversionRule$;
import org.apache.flink.table.plan.rules.physical.stream.StreamExecRetractionRules$;
import org.apache.flink.table.plan.rules.physical.stream.TwoStageOptimizedWindowAggregateRule$;
import org.apache.flink.table.plan.schema.BaseRowSchema;
import org.apache.flink.table.plan.trait.AccMode$;
import org.apache.flink.table.plan.trait.AccModeTrait;
import org.apache.flink.table.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.plan.util.AggregateInfoList;
import org.apache.flink.table.plan.util.AggregateUtil$;
import org.apache.flink.table.plan.util.EmitStrategy;
import org.apache.flink.table.plan.util.EmitStrategy$;
import org.apache.flink.table.plan.util.FlinkRelOptUtil$;
import org.apache.flink.table.plan.util.WindowAggregateUtil$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\t!Ck^8Ti\u0006<Wm\u00149uS6L'0\u001a3XS:$wn^!hOJ,w-\u0019;f%VdWM\u0003\u0002\u0004\t\u000511\u000f\u001e:fC6T!!\u0002\u0004\u0002\u0011AD\u0017p]5dC2T!a\u0002\u0005\u0002\u000bI,H.Z:\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q#G\u0007\u0002-)\u0011\u0011b\u0006\u0006\u000319\tqaY1mG&$X-\u0003\u0002\u001b-\tQ!+\u001a7PaR\u0014V\u000f\\3\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005\u0011\u0001\"B\u0011\u0001\t\u0003\u0012\u0013aB7bi\u000eDWm\u001d\u000b\u0003G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012qAQ8pY\u0016\fg\u000eC\u0003+A\u0001\u00071&\u0001\u0003dC2d\u0007CA\u000b-\u0013\ticC\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000b=\u0002A\u0011\t\u0019\u0002\u000f=tW*\u0019;dQR\u0011\u0011\u0007\u000e\t\u0003IIJ!aM\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006U9\u0002\ra\u000b\u0005\u0007m\u0001!\t\u0001D\u001c\u0002-Q\u0014\u0018M\\:g_JlGk\u001c+x_N#\u0018mZ3BO\u001e$b!\r\u001d:\u0003&[\u0005\"\u0002\u00166\u0001\u0004Y\u0003\"\u0002\u001e6\u0001\u0004Y\u0014!B5oaV$\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u0018\u0003\r\u0011X\r\\\u0005\u0003\u0001v\u0012qAU3m\u001d>$W\rC\u0003Ck\u0001\u00071)\u0001\tm_\u000e\fG.Q4h\u0013:4w\u000eT5tiB\u0011AiR\u0007\u0002\u000b*\u0011a\tC\u0001\u0005kRLG.\u0003\u0002I\u000b\n\t\u0012iZ4sK\u001e\fG/Z%oM>d\u0015n\u001d;\t\u000b)+\u0004\u0019A\"\u0002#\u001ddwNY1m\u0003\u001e<\u0017J\u001c4p\u0019&\u001cH\u000fC\u0003Mk\u0001\u0007Q*A\u0002bO\u001e\u0004\"AT*\u000e\u0003=S!a\u0001)\u000b\u0005\u0015\t&B\u0001*\t\u0003\u0015qw\u000eZ3t\u0013\t!vJ\u0001\u0010TiJ,\u0017-\\#yK\u000e<%o\\;q/&tGm\\<BO\u001e\u0014XmZ1uK\u001e)aK\u0001E\u0001/\u0006!Ck^8Ti\u0006<Wm\u00149uS6L'0\u001a3XS:$wn^!hOJ,w-\u0019;f%VdW\r\u0005\u0002 1\u001a)\u0011A\u0001E\u00013N\u0011\u0001L\u0017\t\u0003ImK!\u0001X\u0013\u0003\r\u0005s\u0017PU3g\u0011\u0015a\u0002\f\"\u0001_)\u00059\u0006b\u00021Y\u0005\u0004%\t!Y\u0001\t\u0013:\u001bF+\u0011(D\u000bV\tA\u0003\u0003\u0004d1\u0002\u0006I\u0001F\u0001\n\u0013:\u001bF+\u0011(D\u000b\u0002\u0002")
public class TwoStageOptimizedWindowAggregateRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return TwoStageOptimizedWindowAggregateRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        StreamExecGroupWindowAggregate windowAgg = (StreamExecGroupWindowAggregate)call.rel(0);
        Object realInput = call.rel(2);
        TableConfig tableConfig = FlinkRelOptUtil$.MODULE$.getTableConfig(windowAgg);
        boolean needRetraction = StreamExecRetractionRules$.MODULE$.isAccRetract((RelNode)realInput);
        RelModifiedMonotonicity modifiedMono = ((FlinkRelMetadataQuery)call.getMetadataQuery()).getRelModifiedMonotonicity(windowAgg);
        boolean[] needRetractionArray = AggregateUtil$.MODULE$.getNeedRetractions(windowAgg.getGroupings().length, needRetraction, modifiedMono, windowAgg.aggCalls());
        AggregateInfoList aggInfoList = AggregateUtil$.MODULE$.transformToStreamAggregateInfoList(windowAgg.aggCalls(), windowAgg.getInput().getRowType(), needRetractionArray, needRetraction, true, AggregateUtil$.MODULE$.transformToStreamAggregateInfoList$default$6());
        return !tableConfig.getConf().getString(TableConfigOptions.SQL_OPTIMIZER_WINDOW_AGG_PHASE_ENFOREER).equalsIgnoreCase(AggPhaseEnforcer$.MODULE$.ONE_PHASE().toString()) && WindowAggregateUtil$.MODULE$.isWindowMiniBatchApplicable(tableConfig, windowAgg.window(), aggInfoList.aggInfos());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        StreamExecGroupWindowAggregate agg = (StreamExecGroupWindowAggregate)call.rel(0);
        Object realInput = call.rel(2);
        boolean needRetraction = StreamExecRetractionRules$.MODULE$.isAccRetract((RelNode)realInput);
        RelModifiedMonotonicity modifiedMono = ((FlinkRelMetadataQuery)call.getMetadataQuery()).getRelModifiedMonotonicity(agg);
        boolean[] needRetractionArray = AggregateUtil$.MODULE$.getNeedRetractions(agg.getGroupings().length, needRetraction, modifiedMono, agg.aggCalls());
        AggregateInfoList localAggInfoList = AggregateUtil$.MODULE$.transformToStreamAggregateInfoList(agg.aggCalls(), realInput.getRowType(), needRetractionArray, needRetraction, false, AggregateUtil$.MODULE$.transformToStreamAggregateInfoList$default$6());
        AggregateInfoList globalAggInfoList = AggregateUtil$.MODULE$.transformToStreamAggregateInfoList(agg.aggCalls(), realInput.getRowType(), needRetractionArray, needRetraction, true, AggregateUtil$.MODULE$.transformToStreamAggregateInfoList$default$6());
        this.transformToTwoStageAgg(call, (RelNode)realInput, localAggInfoList, globalAggInfoList, agg);
    }

    public void transformToTwoStageAgg(RelOptRuleCall call, RelNode input, AggregateInfoList localAggInfoList, AggregateInfoList globalAggInfoList, StreamExecGroupWindowAggregate agg) {
        FlinkRelDistribution flinkRelDistribution;
        RelDataType localWindowAggType = WindowAggregateUtil$.MODULE$.inferLocalWindowAggType(localAggInfoList, input.getRowType(), agg.getGroupings(), (FlinkTypeFactory)input.getCluster().getTypeFactory());
        RelTraitSet localWindowAggTraitSet = input.getTraitSet().plus(new AccModeTrait(AccMode$.MODULE$.Acc()));
        StreamExecLocalWindowAggregate localWindowAgg = new StreamExecLocalWindowAggregate(agg.window(), agg.getCluster(), localWindowAggTraitSet, input, localAggInfoList, agg.aggCalls(), new BaseRowSchema(localWindowAggType), new BaseRowSchema(input.getRowType()), agg.getGroupings(), agg.inputTimestampIndex());
        if (Predef$.MODULE$.intArrayOps(agg.getGroupings()).nonEmpty()) {
            ArrayList fields2 = new ArrayList();
            Predef$.MODULE$.intArrayOps(agg.getGroupings()).indices().foreach((Function1)new Serializable(this, fields2){
                public static final long serialVersionUID = 0L;
                private final ArrayList fields$1;

                public final boolean apply(int x$1) {
                    return this.apply$mcZI$sp(x$1);
                }

                public boolean apply$mcZI$sp(int x$1) {
                    return this.fields$1.add(Predef$.MODULE$.int2Integer(x$1));
                }
                {
                    this.fields$1 = fields$1;
                }
            });
            flinkRelDistribution = FlinkRelDistribution$.MODULE$.hash(fields2, FlinkRelDistribution$.MODULE$.hash$default$2());
        } else {
            flinkRelDistribution = FlinkRelDistribution$.MODULE$.SINGLETON();
        }
        FlinkRelDistribution globalDistribution = flinkRelDistribution;
        RelNode newInput = FlinkExpandConversionRule$.MODULE$.satisfyDistribution(FlinkConventions$.MODULE$.STREAM_PHYSICAL(), localWindowAgg, globalDistribution);
        RelTraitSet globalAggProvidedTraitSet = agg.getTraitSet();
        int inputTimestampIndexFromLocal = agg.getGroupings().length;
        TableConfig config = agg.getCluster().getPlanner().getContext().unwrap(TableConfig.class);
        EmitStrategy emitStrategy = EmitStrategy$.MODULE$.apply(config, agg.window());
        StreamExecGlobalWindowAggregate globalWindowAgg = new StreamExecGlobalWindowAggregate(agg.window(), agg.getWindowProperties(), agg.getCluster(), globalAggProvidedTraitSet, newInput, localAggInfoList, globalAggInfoList, input.getRowType(), agg.aggCalls(), new BaseRowSchema(agg.getRowType()), new BaseRowSchema(newInput.getRowType()), (int[])Predef$.MODULE$.intArrayOps(agg.getGroupings()).indices().toArray(ClassTag$.MODULE$.Int()), inputTimestampIndexFromLocal, emitStrategy);
        call.transformTo(globalWindowAgg);
    }

    public TwoStageOptimizedWindowAggregateRule() {
        super(RelOptRule.operand(StreamExecGroupWindowAggregate.class, RelOptRule.operand(StreamExecExchange.class, RelOptRule.operand(RelNode.class, RelOptRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "TwoStageOptimizedWindowAggregateRule");
    }
}

