/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ConfigurableTable;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.api.TableSourceParser;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ExternalTableUtil$;
import org.apache.flink.table.plan.schema.FlinkTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.plan.stats.FlinkStatistic$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001=\u00111cQ1uC2|wmQ1mG&$X\rV1cY\u0016T!a\u0001\u0003\u0002\rM\u001c\u0007.Z7b\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005)1E.\u001b8l)\u0006\u0014G.\u001a\t\u0003+ei\u0011A\u0006\u0006\u0003\u0007]Q!\u0001\u0007\u0006\u0002\u000f\r\fGnY5uK&\u0011!D\u0006\u0002\u0012\u0007>tg-[4ve\u0006\u0014G.\u001a+bE2,\u0007\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002\t9\fW.Z\u000b\u0002=A\u0011q$\n\b\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%I\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%C!A\u0011\u0006\u0001B\u0001B\u0003%a$A\u0003oC6,\u0007\u0005\u0003\u0005\b\u0001\t\u0015\r\u0011\"\u0001,+\u0005a\u0003CA\u00171\u001b\u0005q#BA\u0018\u0007\u0003\u001d\u0019\u0017\r^1m_\u001eL!!\r\u0018\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\t\u0011M\u0002!\u0011!Q\u0001\n1\na\u0001^1cY\u0016\u0004\u0003\"B\u001b\u0001\t\u00031\u0014A\u0002\u001fj]&$h\bF\u00028qe\u0002\"!\u0005\u0001\t\u000bq!\u0004\u0019\u0001\u0010\t\u000b\u001d!\u0004\u0019\u0001\u0017\t\u000fm\u0002!\u0019!C\u0001y\u0005Y\u0011n]*ue\u0016\fW.\u001b8h+\u0005i\u0004c\u0001\u0011?\u0001&\u0011q(\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001\n\u0015B\u0001\"\"\u0005\u001d\u0011un\u001c7fC:Da\u0001\u0012\u0001!\u0002\u0013i\u0014\u0001D5t'R\u0014X-Y7j]\u001e\u0004\u0003\"\u0002$\u0001\t\u0003:\u0015\u0001B2paf$\"a\u000e%\t\u000b%+\u0005\u0019\u0001&\u0002\u0013M$\u0018\r^5ti&\u001c\u0007CA&O\u001b\u0005a%BA'\u0005\u0003\u0015\u0019H/\u0019;t\u0013\tyEJ\u0001\bGY&t7n\u0015;bi&\u001cH/[2\t\u000bE\u0003A\u0011\t*\u0002\u0015\u001d,GOU8x)f\u0004X\r\u0006\u0002T7B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0005if\u0004XM\u0003\u0002Y/\u0005\u0019!/\u001a7\n\u0005i+&a\u0003*fY\u0012\u000bG/\u0019+za\u0016DQ\u0001\u0018)A\u0002u\u000b1\u0002^=qK\u001a\u000b7\r^8ssB\u0011AKX\u0005\u0003?V\u0013!CU3m\t\u0006$\u0018\rV=qK\u001a\u000b7\r^8ss\")\u0011\r\u0001C!E\u000611m\u001c8gS\u001e$\"aN2\t\u000b\u0011\u0004\u0007\u0019A3\u0002#\u0011Lh.Y7jGB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003gWzqR\"A4\u000b\u0005!L\u0017\u0001B;uS2T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n\u0019Q*\u00199\t\u000b9\u0004A\u0011I8\u0002\u0019\u001d,Go\u0015;bi&\u001cH/[2\u0015\u0003)CQ!\u001d\u0001\u0005\u0002I\f\u0011\u0002^1cY\u0016\u001c\u0016N\\6\u0016\u0003M\u00042\u0001^<z\u001b\u0005)(B\u0001<\u0007\u0003\u0015\u0019\u0018N\\6t\u0013\tAXOA\u0005UC\ndWmU5oWB\u0011\u0001E_\u0005\u0003w\u0006\u00121!\u00118z\u0011\u0015i\b\u0001\"\u0003s\u0003=\u0019HO]3b[R\u000b'\r\\3TS:\\\u0007\"B@\u0001\t\u0013\u0011\u0018A\u00042bi\u000eDG+\u00192mKNKgn\u001b\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003E\u0019HO]3b[R\u000b'\r\\3T_V\u00148-Z\u000b\u0003\u0003\u000f\u0001R!!\u0003\u0002\u0010el!!a\u0003\u000b\u0007\u00055a!A\u0004t_V\u00148-Z:\n\t\u0005E\u00111\u0002\u0002\u0012'R\u0014X-Y7UC\ndWmU8ve\u000e,\u0007bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0012i\u0006\u0014G.Z*pkJ\u001cW\rU1sg\u0016\u0014XCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\r\u0005\u0019\u0011\r]5\n\t\u0005\r\u0012Q\u0004\u0002\u0012)\u0006\u0014G.Z*pkJ\u001cW\rU1sg\u0016\u0014\bbBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\u0011E\u0006$8\r\u001b+bE2,7k\\;sG\u0016,\"!a\u000b\u0011\u000b\u0005%\u0011QF=\n\t\u0005=\u00121\u0002\u0002\u0011\u0005\u0006$8\r\u001b+bE2,7k\\;sG\u0016\u0004")
public class CatalogCalciteTable
extends FlinkTable
implements ConfigurableTable {
    private final String name;
    private final CatalogTable table;
    private final Option<Object> isStreaming;

    public String name() {
        return this.name;
    }

    public CatalogTable table() {
        return this.table;
    }

    public Option<Object> isStreaming() {
        return this.isStreaming;
    }

    @Override
    public CatalogCalciteTable copy(FlinkStatistic statistic2) {
        Object object = this.isStreaming().isDefined() ? this.table().getProperties().put("is_streaming", this.isStreaming().get().toString()) : BoxedUnit.UNIT;
        return new CatalogCalciteTable(this.name(), this.table());
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return ((FlinkTypeFactory)typeFactory).buildLogicalRowType(this.table().getTableSchema(), this.isStreaming());
    }

    @Override
    public CatalogCalciteTable config(Map<String, String> dynamicParameters) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        newProperties.putAll(this.table().getProperties());
        newProperties.putAll(dynamicParameters);
        CatalogTable newTable = new CatalogTable(this.table().getTableType(), this.table().getTableSchema(), newProperties, this.table().getRichTableSchema(), this.table().getTableStats(), this.table().getComment(), this.table().getPartitionColumnNames(), this.table().isPartitioned(), this.table().getComputedColumnsSql(), this.table().getRowTimeField(), this.table().getWatermarkOffset(), this.table().getCreateTime(), this.table().getLastAccessTime());
        Object object = this.isStreaming().isDefined() ? newTable.getProperties().put("is_streaming", this.isStreaming().get().toString()) : BoxedUnit.UNIT;
        return new CatalogCalciteTable(this.name(), newTable);
    }

    @Override
    public FlinkStatistic getStatistic() {
        Object object;
        FlinkStatistic.Builder statisticBuilder = FlinkStatistic$.MODULE$.builder().tableStats(this.table().getTableStats());
        String[] primaryKeys = this.table().getTableSchema().getPrimaryKeys();
        String[][] uniqueKeys = this.table().getTableSchema().getUniqueKeys();
        if (Predef$.MODULE$.refArrayOps((Object[])primaryKeys).nonEmpty() || Predef$.MODULE$.refArrayOps((Object[])uniqueKeys).nonEmpty()) {
            ArrayBuffer keyBuffer = new ArrayBuffer();
            if (!Predef$.MODULE$.refArrayOps((Object[])primaryKeys).isEmpty()) {
                keyBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Set[]{ImmutableSet.copyOf((Object[])primaryKeys)}));
            }
            Predef$.MODULE$.refArrayOps((Object[])uniqueKeys).foreach((Function1)new Serializable(this, keyBuffer){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer keyBuffer$1;

                public final void apply(String[] x0$1) {
                    String[] stringArray = x0$1;
                    if (stringArray != null) {
                        String[] stringArray2 = stringArray;
                        this.keyBuffer$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Set[]{ImmutableSet.copyOf((Object[])stringArray2)}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)stringArray);
                }
                {
                    this.keyBuffer$1 = keyBuffer$1;
                }
            });
            object = statisticBuilder.uniqueKeys(ImmutableSet.copyOf((Object[])keyBuffer.toArray(ClassTag$.MODULE$.apply(Set.class))));
        } else {
            object = BoxedUnit.UNIT;
        }
        return statisticBuilder.build();
    }

    public TableSink<Object> tableSink() {
        block2: {
            boolean bl;
            block5: {
                TableSink<Object> tableSink;
                block4: {
                    block3: {
                        if (!this.isStreaming().isDefined()) break block2;
                        bl = BoxesRunTime.unboxToBoolean((Object)this.isStreaming().get());
                        if (!bl) break block3;
                        tableSink = this.streamTableSink();
                        break block4;
                    }
                    if (bl) break block5;
                    tableSink = this.batchTableSink();
                }
                return tableSink;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        throw new RuntimeException("isStreaming flag should be set for external tables");
    }

    private TableSink<Object> streamTableSink() {
        return ExternalTableUtil$.MODULE$.toTableSink(this.name(), this.table(), true);
    }

    private TableSink<Object> batchTableSink() {
        return ExternalTableUtil$.MODULE$.toTableSink(this.name(), this.table(), false);
    }

    public StreamTableSource<Object> streamTableSource() {
        StreamTableSource streamTableSource;
        if (this.isStreaming().isDefined()) {
            if (BoxesRunTime.unboxToBoolean((Object)this.isStreaming().get())) {
                StreamTableSource streamTableSource2;
                TableSource tableSource = ExternalTableUtil$.MODULE$.toTableSource(this.name(), this.table(), true);
                StreamTableSource streamTableSource3 = tableSource instanceof StreamTableSource ? (streamTableSource2 = (StreamTableSource)tableSource) : null;
                streamTableSource = streamTableSource3;
            } else {
                streamTableSource = null;
            }
        } else {
            streamTableSource = null;
        }
        return streamTableSource;
    }

    public TableSourceParser tableSourceParser() {
        return this.isStreaming().isDefined() ? ExternalTableUtil$.MODULE$.toParser(this.name(), this.table(), BoxesRunTime.unboxToBoolean((Object)this.isStreaming().get())) : null;
    }

    public BatchTableSource<Object> batchTableSource() {
        BatchTableSource batchTableSource;
        if (this.isStreaming().isDefined()) {
            if (BoxesRunTime.unboxToBoolean((Object)this.isStreaming().get())) {
                batchTableSource = null;
            } else {
                BatchTableSource batchTableSource2;
                TableSource tableSource = ExternalTableUtil$.MODULE$.toTableSource(this.name(), this.table(), false);
                BatchTableSource batchTableSource3 = tableSource instanceof BatchTableSource ? (batchTableSource2 = (BatchTableSource)tableSource) : null;
                batchTableSource = batchTableSource3;
            }
        } else {
            batchTableSource = null;
        }
        return batchTableSource;
    }

    public CatalogCalciteTable(String name, CatalogTable table) {
        this.name = name;
        this.table = table;
        this.isStreaming = table.getProperties().containsKey("is_streaming") ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(table.getProperties().remove("is_streaming"))).toBoolean())) : Option$.MODULE$.empty();
    }
}

