/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.BigDecimalTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.metadata.FlinkRelMdSize$;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AnalyzeStatistic$
implements Logging {
    public static final AnalyzeStatistic$ MODULE$;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new AnalyzeStatistic$();
    }

    private Logger LOG$lzycompute() {
        AnalyzeStatistic$ analyzeStatistic$ = this;
        synchronized (analyzeStatistic$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public TableStats generateTableStats(TableEnvironment tableEnv, String tableName, String[] columnNames) {
        Predef$.MODULE$.require(tableName != null && new StringOps(Predef$.MODULE$.augmentString(tableName)).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "tableName must not be null or empty.";
            }
        });
        return this.generateTableStats(tableEnv, (String[])((Object[])new String[]{tableName}), columnNames);
    }

    public TableStats generateTableStats(TableEnvironment tableEnv, String[] tablePath, String[] columnNames) {
        Predef$.MODULE$.require(tablePath != null && Predef$.MODULE$.refArrayOps((Object[])tablePath).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "tablePath must not be null or empty.";
            }
        });
        Predef$.MODULE$.require(columnNames != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "columnNames must not be null";
            }
        });
        String tableName = Predef$.MODULE$.refArrayOps((Object[])tablePath).mkString(".");
        String statsSql = this.generateAnalyzeSQL(tableEnv, tableName, columnNames);
        Row result = (Row)tableEnv.sqlQuery(statsSql).collect().head();
        return this.parseTableStats(tableEnv, tableName, result, columnNames);
    }

    public String generateAnalyzeSQL(TableEnvironment tableEnv, String tableName, String[] columnNames) {
        String statsSql;
        String string;
        String[] stringArray;
        Option<Table> tableOpt = tableEnv.getTable(tableName);
        if (tableOpt.isEmpty()) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' was not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        }
        Table table = (Table)tableOpt.get();
        RelDataType rowType = table.getRowType(tableEnv.getTypeFactory());
        Buffer allFieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala();
        if (Predef$.MODULE$.refArrayOps((Object[])columnNames).nonEmpty()) {
            if (Predef$.MODULE$.refArrayOps((Object[])columnNames).contains((Object)"*")) {
                if (columnNames.length > 1) {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"columnNames are either star('*') or field names."})).s((Seq)Nil$.MODULE$));
                }
                stringArray = (String[])allFieldNames.toArray(ClassTag$.MODULE$.apply(String.class));
            } else {
                String[] notExistColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])columnNames).filter((Function1)new Serializable(allFieldNames){
                    public static final long serialVersionUID = 0L;
                    private final Buffer allFieldNames$1;

                    public final boolean apply(String n) {
                        return !this.allFieldNames$1.contains((Object)n);
                    }
                    {
                        this.allFieldNames$1 = allFieldNames$1;
                    }
                });
                if (Predef$.MODULE$.refArrayOps((Object[])notExistColumns).nonEmpty()) {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column(s): ", " not found in table: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])notExistColumns).mkString(", "), tableName})));
                }
                stringArray = columnNames;
            }
        } else {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        String[] finalColumnNames = stringArray;
        Quoting quoting = tableEnv.getFrameworkConfig().getParserConfig().quoting();
        String tableNameWithQuoting = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableEnv.getCatalogManager().resolveTableName(tableName)).map((Function1)new Serializable(quoting){
            public static final long serialVersionUID = 0L;
            private final Quoting quoting$1;

            public final String apply(String x$1) {
                return AnalyzeStatistic$.MODULE$.withQuoting(x$1, this.quoting$1);
            }
            {
                this.quoting$1 = quoting$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(".");
        String rowCountStats = "CAST(COUNT(1) AS BIGINT)";
        if (Predef$.MODULE$.refArrayOps((Object[])finalColumnNames).nonEmpty()) {
            RelDataType rowType2 = table.getRowType(tableEnv.getTypeFactory());
            String columnStatsSelects = this.getColumnStatsSelects(tableEnv, rowType2, finalColumnNames, quoting);
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", ", ", " FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowCountStats, columnStatsSelects, tableNameWithQuoting}));
        } else {
            string = statsSql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", " FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowCountStats, tableNameWithQuoting}));
        }
        if (this.LOG().isDebugEnabled()) {
            this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Analyze TableStats for ", ", SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, statsSql})));
        }
        return statsSql;
    }

    public String[] generateAnalyzeSQL$default$3() {
        return (String[])((Object[])new String[]{"*"});
    }

    public TableStats parseTableStats(TableEnvironment tableEnv, String tableName, Row result, String[] columnNames) {
        String[] stringArray;
        Option<Table> tableOpt = tableEnv.getTable(tableName);
        if (tableOpt.isEmpty()) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' was not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        }
        Table table = (Table)tableOpt.get();
        RelDataType rowType = table.getRowType(tableEnv.getTypeFactory());
        Buffer allFieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala();
        if (Predef$.MODULE$.refArrayOps((Object[])columnNames).nonEmpty()) {
            if (Predef$.MODULE$.refArrayOps((Object[])columnNames).contains((Object)"*")) {
                if (columnNames.length > 1) {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"columnNames are either star('*') or field names."})).s((Seq)Nil$.MODULE$));
                }
                stringArray = (String[])allFieldNames.toArray(ClassTag$.MODULE$.apply(String.class));
            } else {
                String[] notExistColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])columnNames).filter((Function1)new Serializable(allFieldNames){
                    public static final long serialVersionUID = 0L;
                    private final Buffer allFieldNames$2;

                    public final boolean apply(String n) {
                        return !this.allFieldNames$2.contains((Object)n);
                    }
                    {
                        this.allFieldNames$2 = allFieldNames$2;
                    }
                });
                if (Predef$.MODULE$.refArrayOps((Object[])notExistColumns).nonEmpty()) {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column(s): ", " not found in table: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])notExistColumns).mkString(", "), tableName})));
                }
                stringArray = columnNames;
            }
        } else {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        String[] finalColumnNames = stringArray;
        long rowCount = BoxesRunTime.unboxToLong((Object)result.getField(0));
        int numOfColStats = 6;
        scala.collection.immutable.Map colStatsMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])finalColumnNames).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(result, numOfColStats){
            public static final long serialVersionUID = 0L;
            private final Row result$1;
            private final int numOfColStats$1;

            public final Tuple2<String, ColumnStats> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String columnName = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    long ndv = BoxesRunTime.unboxToLong((Object)this.result$1.getField(index * this.numOfColStats$1 + 1));
                    long nullCount = BoxesRunTime.unboxToLong((Object)this.result$1.getField(index * this.numOfColStats$1 + 2));
                    double avgLen = BoxesRunTime.unboxToDouble((Object)this.result$1.getField(index * this.numOfColStats$1 + 3));
                    Integer maxLen = (Integer)this.result$1.getField(index * this.numOfColStats$1 + 4);
                    Object max = this.result$1.getField(index * this.numOfColStats$1 + 5);
                    Object min = this.result$1.getField(index * this.numOfColStats$1 + 6);
                    Tuple2 tuple22 = new Tuple2((Object)columnName, (Object)new ColumnStats(Predef$.MODULE$.long2Long(ndv), Predef$.MODULE$.long2Long(nullCount), Predef$.MODULE$.double2Double(avgLen), maxLen, max, min));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.result$1 = result$1;
                this.numOfColStats$1 = numOfColStats$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        return new TableStats(Predef$.MODULE$.long2Long(rowCount), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)colStatsMap).asJava());
    }

    public String[] parseTableStats$default$4() {
        return (String[])((Object[])new String[]{"*"});
    }

    public String getColumnStatsSelects(TableEnvironment tableEnv, RelDataType rowType, String[] columnNames, Quoting quoting) {
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])columnNames).nonEmpty());
        Buffer allFieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala();
        String[] columnStatsSelects = (String[])Predef$.MODULE$.refArrayOps((Object[])columnNames).map((Function1)new Serializable(tableEnv, rowType, quoting, allFieldNames){
            public static final long serialVersionUID = 0L;
            private final TableEnvironment tableEnv$1;
            private final RelDataType rowType$1;
            private final Quoting quoting$2;
            private final Buffer allFieldNames$3;

            /*
             * WARNING - void declaration
             */
            public final String apply(String columnName) {
                void var4_4;
                block28: {
                    Tuple2.mcZZ.sp sp2;
                    TypeInformation<?> typeInfo;
                    RelDataType relDataType;
                    block27: {
                        TypeInformation<?> typeInformation;
                        block26: {
                            boolean bl;
                            int fieldIndex = this.allFieldNames$3.indexOf((Object)columnName);
                            relDataType = this.rowType$1.getFieldList().get(fieldIndex).getType();
                            typeInformation = typeInfo = FlinkTypeFactory$.MODULE$.toTypeInfo(relDataType);
                            BasicTypeInfo<Boolean> basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                            TypeInformation<?> typeInformation2 = typeInformation;
                            if (!(basicTypeInfo != null ? !((Object)basicTypeInfo).equals(typeInformation2) : typeInformation2 != null)) {
                                bl = true;
                            } else {
                                BasicTypeInfo<Byte> basicTypeInfo2 = BasicTypeInfo.BYTE_TYPE_INFO;
                                TypeInformation<?> typeInformation3 = typeInformation;
                                if (!(basicTypeInfo2 != null ? !((Object)basicTypeInfo2).equals(typeInformation3) : typeInformation3 != null)) {
                                    bl = true;
                                } else {
                                    BasicTypeInfo<Short> basicTypeInfo3 = BasicTypeInfo.SHORT_TYPE_INFO;
                                    TypeInformation<?> typeInformation4 = typeInformation;
                                    if (!(basicTypeInfo3 != null ? !((Object)basicTypeInfo3).equals(typeInformation4) : typeInformation4 != null)) {
                                        bl = true;
                                    } else {
                                        BasicTypeInfo<Integer> basicTypeInfo4 = BasicTypeInfo.INT_TYPE_INFO;
                                        TypeInformation<?> typeInformation5 = typeInformation;
                                        if (!(basicTypeInfo4 != null ? !((Object)basicTypeInfo4).equals(typeInformation5) : typeInformation5 != null)) {
                                            bl = true;
                                        } else {
                                            BasicTypeInfo<Long> basicTypeInfo5 = BasicTypeInfo.LONG_TYPE_INFO;
                                            TypeInformation<?> typeInformation6 = typeInformation;
                                            if (!(basicTypeInfo5 != null ? !((Object)basicTypeInfo5).equals(typeInformation6) : typeInformation6 != null)) {
                                                bl = true;
                                            } else {
                                                BasicTypeInfo<Float> basicTypeInfo6 = BasicTypeInfo.FLOAT_TYPE_INFO;
                                                TypeInformation<?> typeInformation7 = typeInformation;
                                                if (!(basicTypeInfo6 != null ? !((Object)basicTypeInfo6).equals(typeInformation7) : typeInformation7 != null)) {
                                                    bl = true;
                                                } else {
                                                    BasicTypeInfo<Double> basicTypeInfo7 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                                                    TypeInformation<?> typeInformation8 = typeInformation;
                                                    if (!(basicTypeInfo7 != null ? !((Object)basicTypeInfo7).equals(typeInformation8) : typeInformation8 != null)) {
                                                        bl = true;
                                                    } else if (typeInformation instanceof BigDecimalTypeInfo) {
                                                        bl = true;
                                                    } else {
                                                        SqlTimeTypeInfo<Date> sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
                                                        TypeInformation<?> typeInformation9 = typeInformation;
                                                        if (!(sqlTimeTypeInfo != null ? !((Object)sqlTimeTypeInfo).equals(typeInformation9) : typeInformation9 != null)) {
                                                            bl = true;
                                                        } else {
                                                            SqlTimeTypeInfo<Time> sqlTimeTypeInfo2 = SqlTimeTypeInfo.TIME;
                                                            TypeInformation<?> typeInformation10 = typeInformation;
                                                            if (!(sqlTimeTypeInfo2 != null ? !((Object)sqlTimeTypeInfo2).equals(typeInformation10) : typeInformation10 != null)) {
                                                                bl = true;
                                                            } else {
                                                                SqlTimeTypeInfo<Timestamp> sqlTimeTypeInfo3 = SqlTimeTypeInfo.TIMESTAMP;
                                                                TypeInformation<?> typeInformation11 = typeInformation;
                                                                bl = !(sqlTimeTypeInfo3 != null ? !((Object)sqlTimeTypeInfo3).equals(typeInformation11) : typeInformation11 != null);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (!bl) break block26;
                            sp2 = new Tuple2.mcZZ.sp(true, true);
                            break block27;
                        }
                        BasicTypeInfo<String> basicTypeInfo = BasicTypeInfo.STRING_TYPE_INFO;
                        TypeInformation<?> typeInformation12 = typeInformation;
                        if (basicTypeInfo != null ? !((Object)basicTypeInfo).equals(typeInformation12) : typeInformation12 != null) break block28;
                        sp2 = new Tuple2.mcZZ.sp(true, false);
                    }
                    Tuple2.mcZZ.sp sp3 = sp2;
                    if (sp3 != null) {
                        Object object;
                        Tuple2.mcZZ.sp sp4;
                        boolean isComparableType = sp3._1$mcZ$sp();
                        boolean isFixLenType = sp3._2$mcZ$sp();
                        Tuple2.mcZZ.sp sp5 = sp4 = new Tuple2.mcZZ.sp(isComparableType, isFixLenType);
                        boolean isComparableType2 = sp5._1$mcZ$sp();
                        boolean isFixLenType2 = sp5._2$mcZ$sp();
                        Double fixLen = FlinkRelMdSize$.MODULE$.averageTypeValueSize(relDataType);
                        SqlTypeName tmpSqlTypeName = FlinkTypeFactory$.MODULE$.typeInfoToSqlTypeName(typeInfo);
                        TypeInformation<?> typeInformation = typeInfo;
                        if (typeInformation instanceof BigDecimalTypeInfo) {
                            BigDecimalTypeInfo bigDecimalTypeInfo = (BigDecimalTypeInfo)typeInformation;
                            object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpSqlTypeName, BoxesRunTime.boxToInteger((int)bigDecimalTypeInfo.precision()), BoxesRunTime.boxToInteger((int)bigDecimalTypeInfo.scale())}));
                        } else {
                            object = tmpSqlTypeName;
                        }
                        SqlTypeName sqlTypeName = object;
                        String columnNameWithQuoting = AnalyzeStatistic$.MODULE$.withQuoting(columnName, this.quoting$2);
                        String computeNdv = this.tableEnv$1 instanceof BatchTableEnvironment ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(APPROX_COUNT_DISTINCT(", ") AS BIGINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnNameWithQuoting})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(COUNT(DISTINCT ", ") AS BIGINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnNameWithQuoting}));
                        String computeNullCount = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST((COUNT(1) - COUNT(", ")) AS BIGINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnNameWithQuoting}));
                        String computeAvgLen = isFixLenType2 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DOUBLE)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fixLen})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(AVG(CAST(CHAR_LENGTH(", ") AS DOUBLE)) AS DOUBLE)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnNameWithQuoting}));
                        String computeMaxLen = isFixLenType2 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS INTEGER)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fixLen})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(MAX(CHAR_LENGTH(", ")) AS INTEGER)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnNameWithQuoting}));
                        String computeMax = isComparableType2 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(MAX(", ") AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnNameWithQuoting, sqlTypeName})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(NULL AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlTypeName}));
                        String computeMin = isComparableType2 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(MIN(", ") AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnNameWithQuoting, sqlTypeName})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(NULL AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlTypeName}));
                        return ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{computeNdv, computeNullCount, computeAvgLen, computeMaxLen, computeMax, computeMin}))).mkString(", ");
                    }
                    throw new MatchError((Object)sp3);
                }
                throw new TableException(new StringBuilder().append((Object)"Analyzing statistics is not supported ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for column ", " of data type: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName, var4_4}))).toString());
            }
            {
                this.tableEnv$1 = tableEnv$1;
                this.rowType$1 = rowType$1;
                this.quoting$2 = quoting$2;
                this.allFieldNames$3 = allFieldNames$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return Predef$.MODULE$.refArrayOps((Object[])columnStatsSelects).mkString(", ");
    }

    public String withQuoting(String name, Quoting quoting) {
        if (name.contains(quoting.string)) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " contains ", ", that is not supported now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, quoting.string})));
        }
        Quoting quoting2 = quoting;
        String string = ((Object)((Object)Quoting.BRACKET)).equals((Object)quoting2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quoting.string, name, quoting.string}));
        return string;
    }

    private AnalyzeStatistic$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

