/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class ColumnStats
implements Serializable {
    private static final long serialVersionUID = -1L;
    public final Long ndv;
    public final Long nullCount;
    public final Double avgLen;
    public final Integer maxLen;
    public final Object max;
    public final Object min;

    public ColumnStats(Long ndv, Long nullCount, Double avgLen, Integer maxLen, Object max, Object min) {
        Preconditions.checkArgument(max == null || max instanceof Comparable);
        Preconditions.checkArgument(min == null || min instanceof Comparable);
        Preconditions.checkArgument(max == null || min == null || max.getClass() == min.getClass());
        this.ndv = ndv;
        this.nullCount = nullCount;
        this.avgLen = avgLen;
        this.maxLen = maxLen;
        this.max = max;
        this.min = min;
    }

    public ColumnStats(Long ndv) {
        this(ndv, null, null, null, null, null);
    }

    public Long ndv() {
        return this.ndv;
    }

    public Long nullCount() {
        return this.nullCount;
    }

    public Double avgLen() {
        return this.avgLen;
    }

    public Integer maxLen() {
        return this.maxLen;
    }

    public Object max() {
        return this.max;
    }

    public Object min() {
        return this.min;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnStats other = (ColumnStats)obj;
        return Objects.equals(this.ndv, other.ndv) && Objects.equals(this.nullCount, other.nullCount) && Objects.equals(this.avgLen, other.avgLen) && Objects.equals(this.maxLen, other.maxLen) && Objects.equals(this.max, other.max) && Objects.equals(this.min, other.min);
    }

    public String toString() {
        CharSequence[] stats = new String[]{this.ndv != null ? "ndv=" + this.ndv : "", this.nullCount != null ? "nullCount=" + this.nullCount : "", this.avgLen != null ? "avgLen=" + this.avgLen : "", this.maxLen != null ? "maxLen=" + this.maxLen : "", this.max != null ? "max=" + this.max : "", this.min != null ? "min=" + this.min : ""};
        stats = (String[])Arrays.stream(stats).filter(s -> !s.isEmpty()).toArray(String[]::new);
        return String.format("ColumnStats(%s)", String.join((CharSequence)", ", stats));
    }
}

