/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.util.Preconditions;

public class TableStats
implements Serializable {
    private static final long serialVersionUID = -1L;
    public Long rowCount;
    public Map<String, ColumnStats> colStats;
    public Map<String, List<Object>> skewInfo;
    public static final TableStats UNKNOWN_STATS = new TableStats(null);

    public TableStats(Long rowCount, Map<String, ColumnStats> colStats, Map<String, List<Object>> skewInfo) {
        Preconditions.checkArgument(rowCount == null || rowCount >= 0L, "rowCount cannot be negative!");
        Preconditions.checkArgument(colStats != null, "column statistic cannot be null!");
        Preconditions.checkArgument(skewInfo != null, "skew information cannot be null!");
        this.rowCount = rowCount;
        this.colStats = colStats;
        this.skewInfo = skewInfo;
    }

    public TableStats(Long rowCount) {
        this(rowCount, new HashMap<String, ColumnStats>(), new HashMap<String, List<Object>>());
    }

    public TableStats(Long rowCount, Map<String, ColumnStats> colStats) {
        this(rowCount, colStats, new HashMap<String, List<Object>>());
    }

    public Long rowCount() {
        return this.rowCount;
    }

    public Map<String, ColumnStats> colStats() {
        return this.colStats;
    }

    public Map<String, List<Object>> skewInfo() {
        return this.skewInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableStats other = (TableStats)obj;
        return Objects.equals(this.rowCount, other.rowCount) && Objects.equals(this.colStats, other.colStats) && Objects.equals(this.skewInfo, other.skewInfo);
    }

    public String toString() {
        CharSequence[] stats = new String[]{this.rowCount != null ? "rowCount=" + this.rowCount : "", !this.colStats.isEmpty() ? "colStats=" + this.colStats : "", !this.skewInfo.isEmpty() ? "skewInfo=" + this.skewInfo : ""};
        return String.format("TableStats{%s}", String.join((CharSequence)", ", stats));
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.rowCount);
        oos.writeObject(this.colStats.size());
        for (Map.Entry<String, ColumnStats> entry : this.colStats.entrySet()) {
            oos.writeObject(entry.getKey());
            oos.writeObject(entry.getValue());
        }
        oos.writeObject(this.skewInfo.size());
        for (Map.Entry<String, Object> entry : this.skewInfo.entrySet()) {
            oos.writeObject(entry.getKey());
            oos.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.rowCount = (Long)ois.readObject();
        this.colStats = new HashMap<String, ColumnStats>();
        int size = (Integer)ois.readObject();
        for (int i = 0; i < size; ++i) {
            this.colStats.put((String)ois.readObject(), (ColumnStats)ois.readObject());
        }
        this.skewInfo = new HashMap<String, List<Object>>();
        int size2 = (Integer)ois.readObject();
        for (int i = 0; i < size2; ++i) {
            this.skewInfo.put((String)ois.readObject(), (List)ois.readObject());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long rowCount = null;
        private Map<String, ColumnStats> colStats = new HashMap<String, ColumnStats>();
        private Map<String, List<Object>> skewInfo = new HashMap<String, List<Object>>();

        public Builder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public Builder colStats(Map<String, ColumnStats> colStats) {
            this.colStats = colStats;
            return this;
        }

        public Builder skewInfo(Map<String, List<Object>> skewInfo) {
            this.skewInfo = skewInfo;
            return this;
        }

        public Builder tableStats(TableStats stats) {
            Preconditions.checkArgument(stats != null, "input TableStats cannot be null!");
            this.rowCount = stats.rowCount;
            this.colStats = stats.colStats;
            this.skewInfo = stats.skewInfo;
            return this;
        }

        public TableStats build() {
            return new TableStats(this.rowCount, this.colStats, this.skewInfo);
        }
    }
}

