/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNodeWriter;

public class ExecNodeInfoWriter
implements ExecNodeWriter {
    public static final String STREAM_EXEC = "StreamExec";
    public static final String BATCH_EXEC = "BatchExec";
    private final PrintWriter pw;
    private final String execNodeTypeNamePrefix;
    private final boolean notOutputIfEmpty;
    private final List<Tuple2<String, Object>> values = new ArrayList<Tuple2<String, Object>>();

    public ExecNodeInfoWriter(PrintWriter pw, String execNodeTypeNamePrefix, boolean notOutputIfEmpty) {
        this.pw = pw;
        this.execNodeTypeNamePrefix = execNodeTypeNamePrefix;
        this.notOutputIfEmpty = notOutputIfEmpty;
    }

    @Override
    public void explain(ExecNode<?, ?> node, List<Tuple2<String, Object>> valueList) {
        StringBuilder s = new StringBuilder();
        String execNodeTypeName = this.getExecNodeTypeName(node);
        if (!execNodeTypeName.startsWith(this.execNodeTypeNamePrefix)) {
            throw new IllegalArgumentException("Current ExecNode class name is not start with \"" + execNodeTypeName + "\"");
        }
        s.append(execNodeTypeName.substring(this.execNodeTypeNamePrefix.length()));
        int j2 = 0;
        for (Tuple2<String, Object> value : valueList) {
            if (j2++ == 0) {
                s.append("(");
            } else {
                s.append(", ");
            }
            s.append((String)value.f0).append("=[").append(value.f1).append("]");
        }
        if (j2 > 0) {
            s.append(")");
        }
        this.pw.print(s.toString());
    }

    @Override
    public ExecNodeWriter input(String term2, ExecNode<?, ?> input) {
        return this;
    }

    @Override
    public ExecNodeWriter item(String term2, Object value) {
        this.values.add(Tuple2.of(term2, value));
        return this;
    }

    @Override
    public ExecNodeWriter itemIf(String term2, Object value, boolean condition) {
        if (condition) {
            this.item(term2, value);
        }
        return this;
    }

    @Override
    public ExecNodeWriter done(ExecNode<?, ?> node) {
        ImmutableList<Tuple2<String, Object>> valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        if (this.notOutputIfEmpty && !valuesCopy.isEmpty()) {
            this.explain(node, valuesCopy);
        }
        this.pw.flush();
        return this;
    }

    private String getExecNodeTypeName(ExecNode<?, ?> node) {
        String className = node.getClass().getName();
        int i = className.lastIndexOf("$");
        if (i >= 0) {
            return className.substring(i + 1);
        }
        i = className.lastIndexOf(".");
        if (i >= 0) {
            return className.substring(i + 1);
        }
        return className;
    }
}

