/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.util.HashSet;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.Util;
import org.apache.flink.table.plan.util.FlinkRexUtil;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class FlinkRexUtil$ {
    public static final FlinkRexUtil$ MODULE$;

    static {
        new FlinkRexUtil$();
    }

    public RexNode toCnf(RexBuilder rexBuilder, int maxCnfNodeCount, RexNode rex) {
        int maxCnfNodeCnt = maxCnfNodeCount < 0 ? this.org$apache$flink$table$plan$util$FlinkRexUtil$$getNumberOfRexCall(rex) * 2 : maxCnfNodeCount;
        return new FlinkRexUtil.CnfHelper(rexBuilder, maxCnfNodeCnt).toCnf(rex);
    }

    public int org$apache$flink$table$plan$util$FlinkRexUtil$$getNumberOfRexCall(RexNode rex) {
        IntRef numberOfNodes = IntRef.create((int)0);
        rex.accept(new RexVisitorImpl<BoxedUnit>(numberOfNodes){
            private final IntRef numberOfNodes$1;

            public void visitCall(RexCall call) {
                ++this.numberOfNodes$1.elem;
                super.visitCall(call);
            }
            {
                this.numberOfNodes$1 = numberOfNodes$1;
                super(true);
            }
        });
        return numberOfNodes.elem;
    }

    public RexNode simplify(RexBuilder rexBuilder, RexNode expr) {
        if (expr.isAlwaysTrue() || expr.isAlwaysFalse()) {
            return expr;
        }
        FlinkRexUtil.EquivalentExprShuttle exprShuttle = new FlinkRexUtil.EquivalentExprShuttle(rexBuilder);
        RexNode equiExpr = expr.accept(exprShuttle);
        FlinkRexUtil.SameExprMerger exprMerger = new FlinkRexUtil.SameExprMerger(rexBuilder);
        RexNode sameExprMerged = exprMerger.mergeSameExpr(equiExpr);
        RexNode binaryComparisonExprReduced = sameExprMerged.accept(new FlinkRexUtil.BinaryComparisonExprReducer(rexBuilder));
        RexSimplify rexSimplify = new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, true, RexUtil.EXECUTOR);
        return rexSimplify.simplify(binaryComparisonExprReduced);
    }

    /*
     * WARNING - void declaration
     */
    public HashSet<RexInputRef> findAllInputRefs(RexNode node) {
        void var2_2;
        HashSet set = new HashSet();
        node.accept(new RexVisitorImpl<Void>(set){
            private final HashSet set$1;

            public Void visitInputRef(RexInputRef inputRef) {
                this.set$1.add(inputRef);
                return null;
            }
            {
                this.set$1 = set$1;
                super(true);
            }
        });
        return var2_2;
    }

    public RexNode adjustInputRefs(RexNode c, scala.collection.immutable.Map<Object, Object> fieldsOldToNewIndexMapping, RelDataType rowType) {
        return c.accept(new RexShuttle(fieldsOldToNewIndexMapping, rowType){
            private final scala.collection.immutable.Map fieldsOldToNewIndexMapping$1;
            private final RelDataType rowType$1;

            public RexNode visitInputRef(RexInputRef inputRef) {
                Predef$.MODULE$.assert(JavaConversions$.MODULE$.mapAsJavaMap((Map)this.fieldsOldToNewIndexMapping$1).containsKey(BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                int newIndex = BoxesRunTime.unboxToInt((Object)this.fieldsOldToNewIndexMapping$1.apply((Object)BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                RexInputRef ref = RexInputRef.of(newIndex, this.rowType$1);
                return ref.getIndex() == inputRef.getIndex() && ref.getType() == inputRef.getType() ? inputRef : ref;
            }
            {
                this.fieldsOldToNewIndexMapping$1 = fieldsOldToNewIndexMapping$1;
                this.rowType$1 = rowType$1;
            }
        });
    }

    public boolean hasDynamicFunction(RexNode e2) {
        boolean bl;
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(){

                public Void visitCall(RexCall call) {
                    if (call.getOperator().isDynamicFunction()) {
                        throw Util.FoundOne.NULL;
                    }
                    return (Void)super.visitCall(call);
                }
            };
            e2.accept(visitor);
            bl = false;
        }
        catch (Util.FoundOne foundOne) {
            Util.swallow(foundOne, null);
            bl = true;
        }
        return bl;
    }

    public boolean isDeterministicOperator(RexNode rex) {
        return rex == null ? true : RexUtil.isDeterministic(rex) && !this.hasDynamicFunction(rex);
    }

    public boolean isDeterministicOperator(SqlOperator op) {
        return op == null ? true : op.isDeterministic() && !op.isDynamicFunction();
    }

    private FlinkRexUtil$() {
        MODULE$ = this;
    }
}

