/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.plan.schema.IndexKey;
import org.apache.flink.table.plan.util.FlinkRexUtil$;
import org.apache.flink.table.plan.util.TemporalJoinUtil;
import org.apache.flink.table.plan.util.TemporalJoinUtil$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class TemporalJoinUtil$ {
    public static final TemporalJoinUtil$ MODULE$;
    private final SqlFunction TEMPORAL_JOIN_CONDITION;

    static {
        new TemporalJoinUtil$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDeterministic(Option<RexProgram> calcProgram, RexNode period, RexNode joinCondition) {
        Option<RexProgram> option = calcProgram;
        if (option instanceof Some) {
            Buffer projection;
            Some some = (Some)option;
            RexProgram program = (RexProgram)some.x();
            if (program.getCondition() != null) {
                RexNode condition = program.expandLocalRef(program.getCondition());
                if (!FlinkRexUtil$.MODULE$.isDeterministicOperator(condition)) return false;
            }
            if (!(projection = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(program.getProjectList()).map((Function1)new Serializable(program){
                public static final long serialVersionUID = 0L;
                private final RexProgram program$1;

                public final RexNode apply(RexLocalRef x$1) {
                    return this.program$1.expandLocalRef(x$1);
                }
                {
                    this.program$1 = program$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(RexNode p) {
                    return FlinkRexUtil$.MODULE$.isDeterministicOperator(p);
                }
            })) return false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (!FlinkRexUtil$.MODULE$.isDeterministicOperator(period)) return false;
        if (joinCondition == null) {
            return true;
        }
        boolean bl = FlinkRexUtil$.MODULE$.isDeterministicOperator(joinCondition);
        return bl;
    }

    public RexNode isDeterministic$default$3() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<IndexKey> getTableIndexKeys(TableSource table) {
        void var3_3;
        TableSchema schema2 = table.getTableSchema();
        ArrayList indexes = new ArrayList();
        if (Predef$.MODULE$.refArrayOps((Object[])schema2.getUniqueIndexes()).nonEmpty()) {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema2.getUniqueIndexes()).map((Function1)new Serializable(schema2){
                public static final long serialVersionUID = 0L;
                public final TableSchema schema$1;

                public final int[] apply(String[] keys) {
                    return (int[])Predef$.MODULE$.refArrayOps((Object[])keys).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getTableIndexKeys.1 $outer;

                        public final int apply(String x$1) {
                            return this.$outer.schema$1.getColumnIndex(x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                }
                {
                    this.schema$1 = schema$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))))).foreach((Function1)new Serializable(indexes){
                public static final long serialVersionUID = 0L;
                private final ArrayList indexes$1;

                public final boolean apply(int[] keys) {
                    return this.indexes$1.add(IndexKey.of(true, keys));
                }
                {
                    this.indexes$1 = indexes$1;
                }
            });
        }
        if (Predef$.MODULE$.refArrayOps((Object[])schema2.getNormalIndexes()).nonEmpty()) {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema2.getNormalIndexes()).map((Function1)new Serializable(schema2){
                public static final long serialVersionUID = 0L;
                public final TableSchema schema$1;

                public final int[] apply(String[] index) {
                    return (int[])Predef$.MODULE$.refArrayOps((Object[])index).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getTableIndexKeys.3 $outer;

                        public final int apply(String x$1) {
                            return this.$outer.schema$1.getColumnIndex(x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                }
                {
                    this.schema$1 = schema$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))))).foreach((Function1)new Serializable(indexes){
                public static final long serialVersionUID = 0L;
                private final ArrayList indexes$1;

                public final boolean apply(int[] index) {
                    return this.indexes$1.add(IndexKey.of(true, index));
                }
                {
                    this.indexes$1 = indexes$1;
                }
            });
        }
        Collections.sort(indexes, new Comparator<IndexKey>(){

            public int compare(IndexKey o1, IndexKey o2) {
                return o1 == null ? 1 : o1.compareTo(o2);
            }
        });
        return var3_3;
    }

    public SqlFunction TEMPORAL_JOIN_CONDITION() {
        return this.TEMPORAL_JOIN_CONDITION;
    }

    public boolean isRowtimeCall(RexCall call) {
        SqlOperator sqlOperator = call.getOperator();
        SqlFunction sqlFunction = this.TEMPORAL_JOIN_CONDITION();
        Preconditions.checkArgument(!(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null));
        return call.getOperands().size() == 3;
    }

    public boolean isProctimeCall(RexCall call) {
        SqlOperator sqlOperator = call.getOperator();
        SqlFunction sqlFunction = this.TEMPORAL_JOIN_CONDITION();
        Preconditions.checkArgument(!(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null));
        return call.getOperands().size() == 2;
    }

    public RexNode makeRowTimeTemporalJoinConditionCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightTimeAttribute, RexNode rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightTimeAttribute, rightPrimaryKeyExpression);
    }

    public RexNode makeProcTimeTemporalJoinConditionCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightPrimaryKeyExpression);
    }

    public boolean containsTemporalJoinCondition(RexNode condition) {
        TemporalJoinUtil.TemporalJoinConditionVisitor visitor = new TemporalJoinUtil.TemporalJoinConditionVisitor();
        condition.accept(visitor);
        return visitor.hasTemporalJoinCondition();
    }

    private TemporalJoinUtil$() {
        MODULE$ = this;
        this.TEMPORAL_JOIN_CONDITION = new SqlFunction("__TEMPORAL_JOIN_CONDITION", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.or(OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, RIGHT_TIME_ATTRIBUTE, PRIMARY_KEY)'", OperandTypes.DATETIME, OperandTypes.DATETIME, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, PRIMARY_KEY)'", OperandTypes.DATETIME, OperandTypes.ANY)), SqlFunctionCategory.SYSTEM);
    }
}

