/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.time.Duration;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.window.CountWindow;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.CodeGeneratorContext;
import org.apache.flink.table.codegen.CodeGeneratorContext$;
import org.apache.flink.table.codegen.GeneratedSubKeyedAggsHandleFunction;
import org.apache.flink.table.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils$;
import org.apache.flink.table.expressions.ProctimeAttribute;
import org.apache.flink.table.expressions.RowtimeAttribute;
import org.apache.flink.table.expressions.WindowEnd;
import org.apache.flink.table.expressions.WindowProperty;
import org.apache.flink.table.expressions.WindowStart;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.plan.util.AggregateInfo;
import org.apache.flink.table.plan.util.AggregateInfoList;
import org.apache.flink.table.plan.util.AggregateUtil$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TimestampType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class WindowAggregateUtil$ {
    public static final WindowAggregateUtil$ MODULE$;

    static {
        new WindowAggregateUtil$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWindowMiniBatchApplicable(TableConfig config, LogicalWindow window, AggregateInfo[] aggInfos) {
        if (!config.getConf().getBoolean(TableConfigOptions.SQL_EXEC_MINIBATCH_WINDOW_ENABLED)) return false;
        if (!AggregateUtil$.MODULE$.doAllSupportPartialMerge(aggInfos)) return false;
        LogicalWindow logicalWindow = window;
        if (logicalWindow instanceof TumblingGroupWindow) {
            TumblingGroupWindow tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return true;
            }
        }
        if (!(logicalWindow instanceof SlidingGroupWindow)) return false;
        SlidingGroupWindow slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
        Expression timeField = slidingGroupWindow.timeField();
        Expression size = slidingGroupWindow.size();
        Expression slide = slidingGroupWindow.slide();
        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) return false;
        if (!ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) return false;
        Duration sizeDuration = ExpressionUtils$.MODULE$.toDuration(size);
        Duration slideDuration = ExpressionUtils$.MODULE$.toDuration(slide);
        if (sizeDuration.toMillis() % slideDuration.toMillis() != 0L) return false;
        return true;
    }

    public RelDataType inferLocalWindowAggType(AggregateInfoList aggInfoList, RelDataType inputType, int[] groupSet, FlinkTypeFactory typeFactory) {
        DataType[] accTypes = aggInfoList.getAccTypes();
        InternalType[] groupingTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(groupSet).map((Function1)new Serializable(inputType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputType$1;

            public final RelDataType apply(int x$1) {
                return this.inputType$1.getFieldList().get(x$1).getType();
            }
            {
                this.inputType$1 = inputType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(RelDataType relDataType) {
                return FlinkTypeFactory$.MODULE$.toInternalType(relDataType);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        String[] groupingNames = (String[])Predef$.MODULE$.intArrayOps(groupSet).map((Function1)new Serializable(inputType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputType$1;

            public final String apply(int x$2) {
                return this.inputType$1.getFieldNames().get(x$2);
            }
            {
                this.inputType$1 = inputType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] accFieldNames = AggregateUtil$.MODULE$.inferAggAccumulatorNames(aggInfoList);
        return typeFactory.buildRelDataType((Seq<String>)((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])groupingNames).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"assignedWindow$"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])accFieldNames), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Seq<InternalType>)((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])groupingTypes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new TimestampType[]{DataTypes.TIMESTAMP}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])accTypes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(DataType x$3) {
                return x$3.toInternalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)))), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
    }

    public Tuple3<Option<Object>, Option<Object>, Option<Object>> computeWindowPropertyPos(Seq<FlinkRelBuilder.NamedWindowProperty> properties) {
        Tuple4 propPos = (Tuple4)properties.foldRight((Object)new Tuple4((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Option<Object>, Option<Object>, Option<Object>, Object> apply(FlinkRelBuilder.NamedWindowProperty x0$1, Tuple4<Option<Object>, Option<Object>, Option<Object>, Object> x1$1) {
                Tuple2 tuple2;
                block9: {
                    FlinkRelBuilder.NamedWindowProperty namedWindowProperty;
                    block10: {
                        WindowProperty windowProperty;
                        block15: {
                            Tuple4 tuple4;
                            Tuple4 tuple42;
                            block12: {
                                int i;
                                Option rt;
                                Option e2;
                                Option s;
                                block14: {
                                    RowtimeAttribute rowtimeAttribute;
                                    boolean bl;
                                    block13: {
                                        WindowEnd windowEnd;
                                        boolean bl2;
                                        block11: {
                                            tuple2 = new Tuple2((Object)x0$1, x1$1);
                                            if (tuple2 == null) break block9;
                                            FlinkRelBuilder.NamedWindowProperty p = (FlinkRelBuilder.NamedWindowProperty)tuple2._1();
                                            Tuple4 tuple43 = (Tuple4)tuple2._2();
                                            if (tuple43 == null) break block9;
                                            s = (Option)tuple43._1();
                                            e2 = (Option)tuple43._2();
                                            rt = (Option)tuple43._3();
                                            i = BoxesRunTime.unboxToInt((Object)tuple43._4());
                                            namedWindowProperty = p;
                                            if (namedWindowProperty == null) break block10;
                                            WindowProperty prop = namedWindowProperty.property();
                                            boolean bl3 = false;
                                            WindowStart windowStart = null;
                                            bl2 = false;
                                            windowEnd = null;
                                            bl = false;
                                            rowtimeAttribute = null;
                                            windowProperty = prop;
                                            if (windowProperty instanceof WindowStart) {
                                                bl3 = true;
                                                windowStart = (WindowStart)windowProperty;
                                                if (s.isDefined()) {
                                                    throw new TableException("Duplicate window start property encountered. This is a bug.");
                                                }
                                            }
                                            if (!bl3) break block11;
                                            tuple42 = new Tuple4((Object)new Some((Object)BoxesRunTime.boxToInteger((int)i)), (Object)e2, (Object)rt, (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
                                            break block12;
                                        }
                                        if (windowProperty instanceof WindowEnd) {
                                            bl2 = true;
                                            windowEnd = (WindowEnd)windowProperty;
                                            if (e2.isDefined()) {
                                                throw new TableException("Duplicate window end property encountered. This is a bug.");
                                            }
                                        }
                                        if (!bl2) break block13;
                                        tuple42 = new Tuple4((Object)s, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)i)), (Object)rt, (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
                                        break block12;
                                    }
                                    if (windowProperty instanceof RowtimeAttribute) {
                                        bl = true;
                                        rowtimeAttribute = (RowtimeAttribute)windowProperty;
                                        if (rt.isDefined()) {
                                            throw new TableException("Duplicate window rowtime property encountered. This is a bug.");
                                        }
                                    }
                                    if (!bl) break block14;
                                    tuple42 = new Tuple4((Object)s, (Object)e2, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
                                    break block12;
                                }
                                if (!(windowProperty instanceof ProctimeAttribute)) break block15;
                                tuple42 = new Tuple4((Object)s, (Object)e2, (Object)rt, (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
                            }
                            Tuple4 tuple44 = tuple4 = tuple42;
                            return tuple44;
                        }
                        throw new MatchError((Object)windowProperty);
                    }
                    throw new MatchError((Object)namedWindowProperty);
                }
                throw new MatchError((Object)tuple2);
            }
        });
        return new Tuple3(propPos._1(), propPos._2(), propPos._3());
    }

    public GeneratedSubKeyedAggsHandleFunction<?> createAggsHandler(String name, LogicalWindow window, Seq<FlinkRelBuilder.NamedWindowProperty> namedProperties, AggregateInfoList aggInfoList, TableConfig config, RelBuilder relBuilder, Seq<InternalType> inputFieldTypes, boolean needRetraction, boolean minibatch, int mergedAccOffset, boolean mergedAccOnHeap) {
        SlidingGroupWindow slidingGroupWindow;
        Expression size;
        TumblingGroupWindow tumblingGroupWindow;
        Expression size2;
        SlidingGroupWindow slidingGroupWindow2;
        Expression size3;
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(config, true);
        LogicalWindow logicalWindow = window;
        boolean bl = logicalWindow instanceof SlidingGroupWindow && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size3 = (slidingGroupWindow2 = (SlidingGroupWindow)logicalWindow).size()) ? true : logicalWindow instanceof SessionGroupWindow;
        boolean mergingWindow = bl;
        LogicalWindow logicalWindow2 = window;
        Class clazz = logicalWindow2 instanceof TumblingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size2 = (tumblingGroupWindow = (TumblingGroupWindow)logicalWindow2).size()) ? CountWindow.class : (logicalWindow2 instanceof SlidingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size = (slidingGroupWindow = (SlidingGroupWindow)logicalWindow2).size()) ? CountWindow.class : TimeWindow.class);
        Class<TimeWindow> windowClass = clazz;
        AggsHandlerCodeGenerator aggsGenerator = new AggsHandlerCodeGenerator(ctx, relBuilder, inputFieldTypes, needRetraction, mergingWindow || minibatch, config.getNullCheck(), minibatch);
        aggsGenerator.withMerging(mergedAccOffset, mergedAccOnHeap, aggInfoList.getAccTypes());
        return aggsGenerator.generateSubKeyedAggsHandler(name, aggInfoList, (Seq<WindowProperty>)((Seq)namedProperties.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WindowProperty apply(FlinkRelBuilder.NamedWindowProperty x$4) {
                return x$4.property();
            }
        }, Seq$.MODULE$.canBuildFrom())), windowClass);
    }

    private WindowAggregateUtil$() {
        MODULE$ = this;
    }
}

