/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch;

import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.plan.nodes.process.DAGProcessor;
import org.apache.flink.table.resource.batch.RunningUnitGenerator;

public class BatchRunningUnitBuildProcessor
implements DAGProcessor {
    @Override
    public List<ExecNode<?, ?>> process(List<ExecNode<?, ?>> sinkNodes, DAGProcessContext context) {
        if (!context.getTableEnvironment().getConfig().getConf().getBoolean(TableConfigOptions.SQL_EXEC_SORT_RANGE_ENABLED)) {
            List<BatchExecNode<?>> batchExecNodes = DAGProcessor.getNonSinkBatchExecNodes(sinkNodes);
            RunningUnitGenerator visitor = this.getRunningUnitGenerator(context.getTableEnvironment().getConfig().getConf());
            batchExecNodes.forEach(b -> b.accept(visitor));
            ((BatchTableEnvironment)context.getTableEnvironment()).getRUKeeper().setRunningUnits(visitor.getRunningUnits());
        }
        return sinkNodes;
    }

    protected RunningUnitGenerator getRunningUnitGenerator(Configuration tableConf) {
        return new RunningUnitGenerator(tableConf);
    }
}

