/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime;

import java.util.Arrays;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.codegen.CodeGenUtils;
import org.apache.flink.table.codegen.CodeGeneratorContext;
import org.apache.flink.table.codegen.GeneratedHashFunc;
import org.apache.flink.table.codegen.HashCodeGenerator;
import org.apache.flink.table.codegen.HashFunc;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.util.MathUtils;

public class BinaryHashPartitioner
extends StreamPartitioner<BaseRow> {
    private GeneratedHashFunc genHashFunc;
    private final String[] hashFieldNames;
    private transient HashFunc hashFunc;

    public BinaryHashPartitioner(BaseRowTypeInfo info, int[] hashFields) {
        this.genHashFunc = HashCodeGenerator.generateRowHash(CodeGeneratorContext.apply(new TableConfig(), false), TypeConverters.createInternalTypeFromTypeInfo(info), "HashPartitioner", hashFields);
        this.hashFieldNames = new String[hashFields.length];
        String[] fieldNames = info.getFieldNames();
        for (int i = 0; i < hashFields.length; ++i) {
            this.hashFieldNames[i] = fieldNames[hashFields[i]];
        }
    }

    public StreamPartitioner<BaseRow> copy() {
        return this;
    }

    public int selectChannel(StreamRecord<BaseRow> record, int numChannels) {
        return MathUtils.murmurHash(this.getHashFunc().apply((BaseRow)record.getValue())) % numChannels;
    }

    private HashFunc getHashFunc() {
        if (this.hashFunc == null) {
            try {
                this.hashFunc = (HashFunc)CodeGenUtils.compile(Thread.currentThread().getContextClassLoader(), this.genHashFunc.name(), this.genHashFunc.code()).newInstance();
                this.genHashFunc = null;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return this.hashFunc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BinaryHashPartitioner that = (BinaryHashPartitioner)((Object)o);
        return Arrays.equals(this.hashFieldNames, that.hashFieldNames);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashFieldNames);
    }

    public String toString() {
        return "HASH" + Arrays.toString(this.hashFieldNames);
    }
}

