/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime;

import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.fault.tolerant.ProcessingTimeCallbackOperator;
import org.apache.flink.util.Preconditions;

public class WatermarkAssignerOperator
extends ProcessingTimeCallbackOperator<BaseRow>
implements OneInputStreamOperator<BaseRow, BaseRow> {
    private static final long serialVersionUID = 1L;
    private final int rowtimeIndex;
    private final long offset;
    private final long idleTimeout;
    private transient long watermarkInterval;
    private transient long currentWatermark;
    private transient long currentMaxTimestamp;
    private transient long lastRecordTime;
    private transient StreamStatusMaintainer streamStatusMaintainer;

    public WatermarkAssignerOperator(int rowtimeIndex, long offset, long idleTimeout) {
        this.rowtimeIndex = rowtimeIndex;
        this.offset = offset;
        if (idleTimeout != -1L) {
            Preconditions.checkArgument(idleTimeout >= 1L, "The idle timeout cannot be smaller than 1 ms.");
        }
        this.idleTimeout = idleTimeout;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.currentWatermark = 0L;
        this.currentMaxTimestamp = 0L;
        this.watermarkInterval = this.getExecutionConfig().getAutoWatermarkInterval();
        this.lastRecordTime = this.getProcessingTimeService().getCurrentProcessingTime();
        this.streamStatusMaintainer = this.getContainingTask().getStreamStatusMaintainer();
        if (this.watermarkInterval > 0L) {
            long now = this.getProcessingTimeService().getCurrentProcessingTime();
            this.getProcessingTimeService().registerTimer(now + this.watermarkInterval, (ProcessingTimeCallback)this);
        }
    }

    public void processElement(StreamRecord<BaseRow> element) throws Exception {
        BaseRow row2;
        if (this.idleTimeout != -1L) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
            this.lastRecordTime = this.getProcessingTimeService().getCurrentProcessingTime();
        }
        if ((row2 = (BaseRow)element.getValue()).isNullAt(this.rowtimeIndex)) {
            throw new RuntimeException("RowTime field should not be null, please convert it to a non-null long value.");
        }
        long ts = row2.getLong(this.rowtimeIndex);
        this.currentMaxTimestamp = Math.max(this.currentMaxTimestamp, ts);
        this.output.collect(element);
        if (this.currentMaxTimestamp - (this.currentWatermark + this.offset) > this.watermarkInterval) {
            this.advanceWatermark();
        }
    }

    private void advanceWatermark() {
        long newWatermark = this.currentMaxTimestamp - this.offset;
        if (newWatermark > this.currentWatermark) {
            this.currentWatermark = newWatermark;
            this.output.emitWatermark(new Watermark(newWatermark));
        }
    }

    public void onProcessingTime(long timestamp) throws Exception {
        long currentTime2;
        this.advanceWatermark();
        if (this.idleTimeout != -1L && (currentTime2 = this.getProcessingTimeService().getCurrentProcessingTime()) - this.lastRecordTime > this.idleTimeout) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.IDLE);
        }
        long now = this.getProcessingTimeService().getCurrentProcessingTime();
        this.getProcessingTimeService().registerTimer(now + this.watermarkInterval, (ProcessingTimeCallback)this);
    }

    public void processWatermark(Watermark mark) throws Exception {
        if (mark.getTimestamp() == Long.MAX_VALUE && this.currentWatermark != Long.MAX_VALUE) {
            if (this.idleTimeout != -1L) {
                this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
            }
            this.currentWatermark = Long.MAX_VALUE;
            this.output.emitWatermark(mark);
        }
    }

    public void endInput() throws Exception {
        this.processWatermark(Watermark.MAX_WATERMARK);
    }

    public void close() throws Exception {
        super.close();
        this.advanceWatermark();
    }
}

