/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.GeneratedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.functions.AggsHandleFunction;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.functions.ProcessFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0007\t\u0005#I!B#D\u0001\u0003\u0013\t\u0019\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0015\u0011\fG/\u00194pe6\fG/\u0003\u0002\u001a-\t9!)Y:f%><\bCA\u000e\u001f\u001b\u0005a\"BA\u000f\u0007\u0003\u0011)H/\u001b7\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005qq-\u001a8BO\u001e\u001c\b*\u00198eY\u0016\u0014\bCA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003\u001d\u0019w\u000eZ3hK:L!a\n\u0013\u00037\u001d+g.\u001a:bi\u0016$\u0017iZ4t\u0011\u0006tG\r\\3Gk:\u001cG/[8o\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001C1dGRK\b/Z:\u0011\u0007-*\u0004H\u0004\u0002-e9\u0011Q\u0006M\u0007\u0002])\u0011qFD\u0001\u0007yI|w\u000e\u001e \n\u0003E\nQa]2bY\u0006L!a\r\u001b\u0002\u000fA\f7m[1hK*\t\u0011'\u0003\u00027o\t\u00191+Z9\u000b\u0005M\"\u0004CA\u001d=\u001b\u0005Q$BA\u001e\u0007\u0003\u0015!\u0018\u0010]3t\u0013\ti$H\u0001\u0007J]R,'O\\1m)f\u0004X\r\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003+\u0003=Ig\u000e];u\r&,G\u000e\u001a+za\u0016\u001c\b\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u001fA\u0014XmY3eS:<wJ\u001a4tKR\u0004\"a\u0011#\u000e\u0003QJ!!\u0012\u001b\u0003\t1{gn\u001a\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\u0006Q!o\\<US6,\u0017\n\u001a=\u0011\u0005\rK\u0015B\u0001&5\u0005\rIe\u000e\u001e\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\u0006YA/\u00192mK\u000e{gNZ5h!\tq\u0015+D\u0001P\u0015\t\u0001f!A\u0002ba&L!AU(\u0003\u0017Q\u000b'\r\\3D_:4\u0017n\u001a\u0005\u0006)\u0002!\t!V\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fY;\u0006,\u0017.\\9B\u0011\u0011\u0003\u0001\u0005\u0006CM\u0003\rA\t\u0005\u0006SM\u0003\rA\u000b\u0005\u0006\u007fM\u0003\rA\u000b\u0005\u0006\u0003N\u0003\rA\u0011\u0005\u0006\u000fN\u0003\r\u0001\u0013\u0005\u0006\u0019N\u0003\r!\u0014\u0005\n=\u0002\u0001\r\u00111A\u0005\n}\u000baa\\;uaV$X#\u00011\u0011\u0005U\t\u0017B\u00012\u0017\u0005%Qu.\u001b8fIJ{w\u000fC\u0005e\u0001\u0001\u0007\t\u0019!C\u0005K\u0006Qq.\u001e;qkR|F%Z9\u0015\u0005\u0019L\u0007CA\"h\u0013\tAGG\u0001\u0003V]&$\bb\u00026d\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\n\u0004B\u00027\u0001A\u0003&\u0001-A\u0004pkR\u0004X\u000f\u001e\u0011\t\u00139\u0004\u0001\u0019!a\u0001\n\u0013y\u0017!\u00067bgR$&/[4hKJLgn\u001a+t'R\fG/Z\u000b\u0002aB!\u0011o\u001e\u000bz\u001b\u0005\u0011(BA:u\u0003\u0015YW-_3e\u0015\t)h/A\u0003ti\u0006$XM\u0003\u0002\u0006\u0011%\u0011\u0001P\u001d\u0002\u0010\u0017\u0016LX\r\u001a,bYV,7\u000b^1uKB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\u0005Y\u0006twMC\u0001\u007f\u0003\u0011Q\u0017M^1\n\u0005\u0015[\bbCA\u0002\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000b\t\u0011\u0004\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$Xm\u0018\u0013fcR\u0019a-a\u0002\t\u0011)\f\t!!AA\u0002ADq!a\u0003\u0001A\u0003&\u0001/\u0001\fmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3!\u0011)\ty\u0001\u0001a\u0001\u0002\u0004%Ia\\\u0001\rG>,h\u000e^3s'R\fG/\u001a\u0005\f\u0003'\u0001\u0001\u0019!a\u0001\n\u0013\t)\"\u0001\td_VtG/\u001a:Ti\u0006$Xm\u0018\u0013fcR\u0019a-a\u0006\t\u0011)\f\t\"!AA\u0002ADq!a\u0007\u0001A\u0003&\u0001/A\u0007d_VtG/\u001a:Ti\u0006$X\r\t\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0013\t\t#\u0001\u0005bG\u000e\u001cF/\u0019;f+\t\t\u0019\u0003\u0005\u0003roR!\u0002bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003S\tA\"Y2d'R\fG/Z0%KF$2AZA\u0016\u0011%Q\u0017QEA\u0001\u0002\u0004\t\u0019\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0015BA\u0012\u0003%\t7mY*uCR,\u0007\u0005C\u0006\u00024\u0001\u0001\r\u00111A\u0005\n\u0005U\u0012AC5oaV$8\u000b^1uKV\u0011\u0011q\u0007\t\bc\u0006eB#_A\u001f\u0013\r\tYD\u001d\u0002\u000e\u0017\u0016LX\rZ'baN#\u0018\r^3\u0011\u000b\u0005}\u00121\t\u000b\u000e\u0005\u0005\u0005#BA\u000f~\u0013\u0011\t)%!\u0011\u0003\t1K7\u000f\u001e\u0005\f\u0003\u0013\u0002\u0001\u0019!a\u0001\n\u0013\tY%\u0001\bj]B,Ho\u0015;bi\u0016|F%Z9\u0015\u0007\u0019\fi\u0005C\u0005k\u0003\u000f\n\t\u00111\u0001\u00028!A\u0011\u0011\u000b\u0001!B\u0013\t9$A\u0006j]B,Ho\u0015;bi\u0016\u0004\u0003bCA+\u0001\u0001\u0007\t\u0019!C\u0005\u0003/\n\u0001BZ;oGRLwN\\\u000b\u0003\u00033\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?\"\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\u0011\t\u0019'!\u0018\u0003%\u0005;wm\u001d%b]\u0012dWMR;oGRLwN\u001c\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0013\tI'\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002g\u0003WB\u0011B[A3\u0003\u0003\u0005\r!!\u0017\t\u0011\u0005=\u0004\u0001)Q\u0005\u00033\n\u0011BZ;oGRLwN\u001c\u0011\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v\u0005!q\u000e]3o)\r1\u0017q\u000f\u0005\t\u0003s\n\t\b1\u0001\u0002|\u0005\u00191\r\u001e=\u0011\t\u0005m\u0013QP\u0005\u0005\u0003\u007f\niF\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"9\u00111\u0011\u0001\u0005B\u0005\u0015\u0015A\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u000b\bM\u0006\u001d\u00151RAZ\u0011\u001d\tI)!!A\u0002Q\tQ!\u001b8qkRD\u0001\"!\u001f\u0002\u0002\u0002\u0007\u0011Q\u0012\t\u0005\u0003\u001f\u000biK\u0004\u0003\u0002\u0012\u0006%f\u0002BAJ\u0003OsA!!&\u0002&:!\u0011qSAR\u001d\u0011\tI*!)\u000f\t\u0005m\u0015q\u0014\b\u0004[\u0005u\u0015\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0019\u0011q\f\u0003\n\t\u0005-\u0016QL\u0001\u0010!J|7-Z:t\rVt7\r^5p]&!\u0011qVAY\u0005\u001d\u0019uN\u001c;fqRTA!a+\u0002^!A\u0011QWAA\u0001\u0004\t9,A\u0002pkR\u0004R!!/\u0002>Ri!!a/\u000b\u0005uA\u0011\u0002BA`\u0003w\u0013\u0011bQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005\r\u0007\u0001\"\u0011\u0002F\u00069qN\u001c+j[\u0016\u0014Hc\u00024\u0002H\u0006-\u00171\u001b\u0005\b\u0003\u0013\f\t\r1\u0001C\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0002z\u0005\u0005\u0007\u0019AAg!\u0011\ty)a4\n\t\u0005E\u0017\u0011\u0017\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011!\t),!1A\u0002\u0005]\u0006bBAl\u0001\u0011\u0005\u0013\u0011\\\u0001\u0006G2|7/\u001a\u000b\u0002M\u0002")
public class RowTimeBoundedRowsOver
extends ProcessFunctionWithCleanupState<BaseRow, BaseRow>
implements Logging {
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final Seq<InternalType> accTypes;
    private final Seq<InternalType> inputFieldTypes;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private JoinedRow output;
    private KeyedValueState<BaseRow, Long> lastTriggeringTsState;
    private KeyedValueState<BaseRow, Long> counterState;
    private KeyedValueState<BaseRow, BaseRow> accState;
    private KeyedMapState<BaseRow, Long, List<BaseRow>> inputState;
    private AggsHandleFunction function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRowsOver rowTimeBoundedRowsOver = this;
        synchronized (rowTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    private JoinedRow output() {
        return this.output;
    }

    private void output_$eq(JoinedRow x$1) {
        this.output = x$1;
    }

    private KeyedValueState<BaseRow, Long> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(KeyedValueState<BaseRow, Long> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private KeyedValueState<BaseRow, Long> counterState() {
        return this.counterState;
    }

    private void counterState_$eq(KeyedValueState<BaseRow, Long> x$1) {
        this.counterState = x$1;
    }

    private KeyedValueState<BaseRow, BaseRow> accState() {
        return this.accState;
    }

    private void accState_$eq(KeyedValueState<BaseRow, BaseRow> x$1) {
        this.accState = x$1;
    }

    private KeyedMapState<BaseRow, Long, List<BaseRow>> inputState() {
        return this.inputState;
    }

    private void inputState_$eq(KeyedMapState<BaseRow, Long, List<BaseRow>> x$1) {
        this.inputState = x$1;
    }

    private AggsHandleFunction function() {
        return this.function;
    }

    private void function_$eq(AggsHandleFunction x$1) {
        this.function = x$1;
    }

    @Override
    public void open(ExecutionContext ctx) {
        super.open(ctx);
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggsHandler.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggsHandler.code()}))).toString());
        this.function_$eq((AggsHandleFunction)this.genAggsHandler.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader()));
        this.function().open(ctx);
        this.output_$eq(new JoinedRow());
        ValueStateDescriptor<Long> lastTriggeringTsDescriptor = new ValueStateDescriptor<Long>("lastTriggeringTsState", Types$.MODULE$.LONG());
        this.lastTriggeringTsState_$eq(ctx.getKeyedValueState(lastTriggeringTsDescriptor));
        ValueStateDescriptor<Long> dataCountStateDescriptor = new ValueStateDescriptor<Long>("processedCountState", Types$.MODULE$.LONG());
        this.counterState_$eq(ctx.getKeyedValueState(dataCountStateDescriptor));
        BaseRowTypeInfo accTypeInfo = new BaseRowTypeInfo((TypeInformation[])((TraversableOnce)this.accTypes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(DataType t) {
                return TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(t);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class)));
        ValueStateDescriptor<BaseRow> accStateDesc = new ValueStateDescriptor<BaseRow>("accState", accTypeInfo);
        this.accState_$eq(ctx.getKeyedValueState(accStateDesc));
        BaseRowTypeInfo inputType = new BaseRowTypeInfo((TypeInformation[])((TraversableOnce)this.inputFieldTypes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(DataType t) {
                return TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(t);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class)));
        ListTypeInfo<BaseRow> rowListTypeInfo = new ListTypeInfo<BaseRow>(inputType);
        MapStateDescriptor<Long, BaseRow> inputStateDesc = new MapStateDescriptor<Long, BaseRow>("inputState", Types$.MODULE$.LONG(), (TypeInformation<BaseRow>)rowListTypeInfo);
        this.inputState_$eq(ctx.getKeyedMapState(inputStateDesc));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    @Override
    public void processElement(BaseRow input, ProcessFunction.Context ctx, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = input.getLong(this.rowTimeIdx);
        Long lastTriggeringTs = (Long)this.lastTriggeringTsState().get((Object)currentKey);
        if (lastTriggeringTs == null) {
            lastTriggeringTs = Predef$.MODULE$.long2Long(0L);
        }
        if (triggeringTs > Predef$.MODULE$.Long2long(lastTriggeringTs)) {
            List data = (List)this.inputState().get((Object)currentKey, (Object)Predef$.MODULE$.long2Long(triggeringTs));
            if (data == null) {
                ArrayList<BaseRow> data2 = new ArrayList<BaseRow>();
                data2.add(input);
                this.inputState().add((Object)currentKey, (Object)Predef$.MODULE$.long2Long(triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.inputState().add((Object)currentKey, (Object)Predef$.MODULE$.long2Long(triggeringTs), (Object)data);
            }
        }
    }

    @Override
    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.inputState().iterator((Object)currentKey);
                Long lastProcessedTime = (Long)this.lastTriggeringTsState().get((Object)currentKey);
                if (lastProcessedTime == null) {
                    lastProcessedTime = Predef$.MODULE$.long2Long(0L);
                }
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (Predef$.MODULE$.Long2long((Long)((Map.Entry)keysIt.next()).getKey()) <= Predef$.MODULE$.Long2long(lastProcessedTime)) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<KeyedState<BaseRow, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new KeyedState[]{this.inputState(), this.accState(), this.counterState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        List inputs = (List)this.inputState().get((Object)currentKey, (Object)Predef$.MODULE$.long2Long(timestamp));
        if (inputs != null) {
            BaseRow accumulators;
            Long dataCount = (Long)this.counterState().get((Object)currentKey);
            if (dataCount == null) {
                dataCount = Predef$.MODULE$.long2Long(0L);
            }
            if ((accumulators = (BaseRow)this.accState().get((Object)currentKey)) == null) {
                accumulators = this.function().createAccumulators();
            }
            this.function().setAccumulators(accumulators);
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                BaseRow input = (BaseRow)inputs.get(i);
                BaseRow retractRow = null;
                if (Predef$.MODULE$.Long2long(dataCount) >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.inputState().iterator((Object)currentKey);
                        while (dataTimestampIt.hasNext()) {
                            Map.Entry data = (Map.Entry)dataTimestampIt.next();
                            Long dataTs = (Long)data.getKey();
                            if (Predef$.MODULE$.Long2long(dataTs) >= retractTs) continue;
                            retractTs = Predef$.MODULE$.Long2long(dataTs);
                            retractList = (List)data.getValue();
                        }
                    }
                    retractRow = (BaseRow)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.inputState().remove((Object)currentKey, (Object)Predef$.MODULE$.long2Long(retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    dataCount = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(dataCount) + 1L);
                }
                if (retractRow != null) {
                    this.function().retract(retractRow);
                }
                this.function().accumulate(input);
                this.output().replace(input, this.function().getValue());
                out.collect(this.output());
            }
            if (this.inputState().contains((Object)currentKey, (Object)Predef$.MODULE$.long2Long(retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.inputState().add((Object)currentKey, (Object)Predef$.MODULE$.long2Long(retractTs), (Object)retractList);
            }
            this.counterState().put((Object)currentKey, (Object)dataCount);
            accumulators = this.function().getAccumulators();
            this.accState().put((Object)currentKey, (Object)accumulators);
        }
        this.lastTriggeringTsState().put((Object)currentKey, (Object)Predef$.MODULE$.long2Long(timestamp));
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
    }

    @Override
    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRowsOver(GeneratedAggsHandleFunction genAggsHandler, Seq<InternalType> accTypes, Seq<InternalType> inputFieldTypes, long precedingOffset, int rowTimeIdx, TableConfig tableConfig) {
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(tableConfig);
        Logging$class.$init$(this);
        Preconditions.checkNotNull(BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

