/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.fault.tolerant;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.runtime.fault.tolerant.NonnegligibleException;
import org.apache.flink.table.runtime.fault.tolerant.OutputProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamOperatorProxy<OUT>
implements StreamOperator<OUT> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractStreamOperatorProxy.class);
    protected transient Counter ignoreCnt;
    protected final String operatorName;
    protected final StreamOperator<OUT> operator;
    protected transient JobVertexID jobVertexId;

    public AbstractStreamOperatorProxy(String operatorName, StreamOperator<OUT> operator) {
        this.operatorName = operatorName;
        this.operator = operator;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output2) {
        this.jobVertexId = containingTask.getEnvironment().getJobVertexId();
        this.operator.setup(containingTask, config, new OutputProxy<StreamRecord<OUT>>(output2));
    }

    public void open() throws Exception {
        this.operator.open();
        this.ignoreCnt = this.getMetricGroup().counter("ignore_cnt");
    }

    public void close() throws Exception {
        try {
            this.operator.close();
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored when close operator [{}] of vertex [{}].\nThe output maybe discarded.", new Object[]{this.operatorName, this.jobVertexId, e2});
            this.ignoreCnt.inc();
        }
    }

    public void dispose() throws Exception {
        this.operator.dispose();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        try {
            this.operator.prepareSnapshotPreBarrier(checkpointId);
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored when prepare snapshot preBarrier operator [{}] of vertex [{}].\nThe output maybe discarded.", new Object[]{this.operatorName, this.jobVertexId, e2});
            this.ignoreCnt.inc();
        }
    }

    public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory storageLocation) throws Exception {
        return this.operator.snapshotState(checkpointId, timestamp, checkpointOptions, storageLocation);
    }

    public void initializeState() throws Exception {
        this.operator.initializeState();
    }

    public void setKeyContextElement1(StreamRecord<?> record) throws Exception {
        this.operator.setKeyContextElement1(record);
    }

    public void setKeyContextElement2(StreamRecord<?> record) throws Exception {
        this.operator.setKeyContextElement2(record);
    }

    public ChainingStrategy getChainingStrategy() {
        return this.operator.getChainingStrategy();
    }

    public void setChainingStrategy(ChainingStrategy strategy) {
        this.operator.setChainingStrategy(strategy);
    }

    public MetricGroup getMetricGroup() {
        return this.operator.getMetricGroup();
    }

    public OperatorID getOperatorID() {
        return this.operator.getOperatorID();
    }

    public boolean requireState() {
        return this.operator.requireState();
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.operator.notifyCheckpointComplete(checkpointId);
    }

    public void setCurrentKey(Object key) {
        this.operator.setCurrentKey(key);
    }

    public Object getCurrentKey() {
        return this.operator.getCurrentKey();
    }
}

