/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.fault.tolerant;

import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.runtime.SubstituteStreamOperator;
import org.apache.flink.table.runtime.fault.tolerant.FaultTolerantableAsyncWaitOperator;
import org.apache.flink.table.runtime.fault.tolerant.FaultTolerantableOperator;
import org.apache.flink.table.runtime.fault.tolerant.OneInputOperatorProxy;
import org.apache.flink.table.runtime.fault.tolerant.TwoInputOperatorProxy;

public class FaultTolerantUtil {
    public static final String IGNORE_CNT_METRIC_NAME = "ignore_cnt";

    public static <IN, OUT> OneInputStreamOperator<IN, OUT> addFaultTolerantProxyIfNeed(OneInputStreamOperator<IN, OUT> operator, String operatorName, TableConfig tableConfig) {
        return FaultTolerantUtil.addProxyIfNeed(operator, operatorName, tableConfig);
    }

    public static <IN1, IN2, OUT> TwoInputStreamOperator<IN1, IN2, OUT> addFaultTolerantProxyIfNeed(TwoInputStreamOperator<IN1, IN2, OUT> operator, String operatorName, TableConfig tableConfig) {
        return FaultTolerantUtil.addProxyIfNeed(operator, operatorName, tableConfig);
    }

    private static <OUT, T extends StreamOperator<OUT>> T addProxyIfNeed(T operator, String operatorName, TableConfig tableConfig) {
        boolean faultTolerantEnable = tableConfig.getConf().getBoolean(TableConfigOptions.SQL_EXEC_FAULT_TOLERANCE_ENABLED);
        if (!faultTolerantEnable) {
            return operator;
        }
        if (operator instanceof FaultTolerantableOperator) {
            ((FaultTolerantableOperator)operator).enableFaultTolerant();
        }
        if (operator instanceof SubstituteStreamOperator || operator instanceof FaultTolerantableAsyncWaitOperator) {
            return operator;
        }
        if (operator instanceof OneInputStreamOperator) {
            return (T)new OneInputOperatorProxy(operatorName, (OneInputStreamOperator)operator);
        }
        return (T)new TwoInputOperatorProxy(operatorName, (TwoInputStreamOperator)operator);
    }

    private FaultTolerantUtil() {
    }
}

