/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.fault.tolerant;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.runtime.fault.tolerant.AbstractStreamOperatorProxy;
import org.apache.flink.table.runtime.fault.tolerant.NonnegligibleException;

@Internal
public final class OneInputOperatorProxy<IN, OUT>
extends AbstractStreamOperatorProxy<OUT>
implements OneInputStreamOperator<IN, OUT>,
Serializable {
    private static final long serialVersionUID = 1L;

    public OneInputOperatorProxy(String operatorName, OneInputStreamOperator<IN, OUT> operator) {
        super(operatorName, operator);
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        try {
            ((OneInputStreamOperator)this.operator).processElement(element);
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored in operator [{}] of vertex [{}].\nThe output for input record [{}] maybe discard.", new Object[]{this.operatorName, this.jobVertexId, element, e2});
            this.ignoreCnt.inc();
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        try {
            ((OneInputStreamOperator)this.operator).processWatermark(mark);
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored when process watermark in operator [{}] of vertex [{}].\nThe output maybe discarded.", new Object[]{this.operatorName, this.jobVertexId, e2});
            this.ignoreCnt.inc();
        }
    }

    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        ((OneInputStreamOperator)this.operator).processLatencyMarker(latencyMarker);
    }

    public void endInput() throws Exception {
        ((OneInputStreamOperator)this.operator).endInput();
    }
}

