/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.fault.tolerant;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.TwoInputSelection;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.runtime.fault.tolerant.AbstractStreamOperatorProxy;
import org.apache.flink.table.runtime.fault.tolerant.NonnegligibleException;

@Internal
public final class TwoInputOperatorProxy<IN1, IN2, OUT>
extends AbstractStreamOperatorProxy<OUT>
implements TwoInputStreamOperator<IN1, IN2, OUT>,
Serializable {
    private static final long serialVersionUID = 1L;

    public TwoInputOperatorProxy(String operatorName, TwoInputStreamOperator<IN1, IN2, OUT> operator) {
        super(operatorName, operator);
    }

    public TwoInputSelection processElement1(StreamRecord<IN1> element) throws Exception {
        try {
            return ((TwoInputStreamOperator)this.operator).processElement1(element);
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored when process element1 in operator [{}] of vertex [{}].\nThe output for input record [{}] maybe discard.", new Object[]{this.operatorName, this.jobVertexId, element, e2});
            this.ignoreCnt.inc();
            return TwoInputSelection.ANY;
        }
    }

    public TwoInputSelection processElement2(StreamRecord<IN2> element) throws Exception {
        try {
            return ((TwoInputStreamOperator)this.operator).processElement2(element);
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored when process element2 in operator [{}] of vertex [{}].\nThe output for input record [{}] maybe discard.", new Object[]{this.operatorName, this.jobVertexId, element, e2});
            this.ignoreCnt.inc();
            return TwoInputSelection.ANY;
        }
    }

    public TwoInputSelection firstInputSelection() {
        return ((TwoInputStreamOperator)this.operator).firstInputSelection();
    }

    public void processWatermark1(Watermark mark) throws Exception {
        try {
            ((TwoInputStreamOperator)this.operator).processWatermark1(mark);
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored when process watermark1 in operator [{}] of vertex [{}].\nThe output maybe discarded.", new Object[]{this.operatorName, this.jobVertexId, e2});
            this.ignoreCnt.inc();
        }
    }

    public void processWatermark2(Watermark mark) throws Exception {
        try {
            ((TwoInputStreamOperator)this.operator).processWatermark2(mark);
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored when process watermark2 in operator [{}] of vertex [{}].\nThe output maybe discarded.", new Object[]{this.operatorName, this.jobVertexId, e2});
            this.ignoreCnt.inc();
        }
    }

    public void processLatencyMarker1(LatencyMarker latencyMarker) throws Exception {
        ((TwoInputStreamOperator)this.operator).processLatencyMarker1(latencyMarker);
    }

    public void processLatencyMarker2(LatencyMarker latencyMarker) throws Exception {
        ((TwoInputStreamOperator)this.operator).processLatencyMarker2(latencyMarker);
    }

    public void endInput1() throws Exception {
        try {
            ((TwoInputStreamOperator)this.operator).endInput1();
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored in operator [{}] of vertex [{}].\nThe output maybe discarded.", new Object[]{this.operatorName, this.jobVertexId, e2});
            this.ignoreCnt.inc();
        }
    }

    public void endInput2() throws Exception {
        try {
            ((TwoInputStreamOperator)this.operator).endInput2();
        }
        catch (Exception e2) {
            if (e2 instanceof NonnegligibleException) {
                throw e2;
            }
            LOG.error("An exception is ignored in operator [{}] of vertex [{}].\nThe output maybe discarded.", new Object[]{this.operatorName, this.jobVertexId, e2});
            this.ignoreCnt.inc();
        }
    }
}

