/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.functions.ThreadLocalCache;
import org.apache.flink.table.runtime.functions.utils.DecimalUtils;
import org.apache.flink.table.runtime.functions.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInScalarFunctions {
    public static final Logger LOG = LoggerFactory.getLogger(BuildInScalarFunctions.class);
    private static final Map<String, String> EMPTY_MAP = new HashMap<String, String>(0);
    private static ThreadLocalCache<String, Pattern> regexpPatternCache = new ThreadLocalCache<String, Pattern>(64){

        @Override
        public Pattern getNewInstance(String regex) {
            return Pattern.compile(regex);
        }
    };
    public static final long MILLIS_PER_DAY = 86400000L;

    public static Map<String, String> strToMap(String text) {
        return BuildInScalarFunctions.strToMap(text, ",", "=");
    }

    public static Map<String, String> strToMap(String text, String listDelimiter, String keyValueDelimiter) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return EMPTY_MAP;
        }
        String[] keyValuePairs = text.split(listDelimiter);
        HashMap<String, String> ret = new HashMap<String, String>(keyValuePairs.length);
        for (String keyValuePair : keyValuePairs) {
            String[] keyValue = keyValuePair.split(keyValueDelimiter, 2);
            if (keyValue.length < 2) {
                ret.put(keyValuePair, null);
                continue;
            }
            ret.put(keyValue[0], keyValue[1]);
        }
        return ret;
    }

    public static String jsonValue(String jsonString, String pathString) throws Exception {
        return JsonUtils.getInstance().getJsonObject(jsonString, pathString);
    }

    public static int sround(int b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static long sround(long b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static Decimal sround(Decimal b0) {
        return BuildInScalarFunctions.sround(b0, 0);
    }

    public static Decimal sround(Decimal b0, int b1) {
        return Decimal.sround(b0, b1);
    }

    public static Decimal sign(Decimal b0) {
        return Decimal.sign(b0);
    }

    public static double sround(double b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static boolean isDecimal(Object s) {
        return DecimalUtils.isDecimal(s);
    }

    public static boolean isDigit(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return true;
        }
        if (obj instanceof String) {
            String s = obj.toString();
            if (s == null || "".equals(s)) {
                return false;
            }
            return StringUtils.isNumeric((CharSequence)s);
        }
        return false;
    }

    public static boolean isAlpha(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        String s = obj.toString();
        if ("".equals(s)) {
            return false;
        }
        return StringUtils.isAlpha((CharSequence)s);
    }

    public static Integer hashCode(String str) {
        if (str == null) {
            return Integer.MIN_VALUE;
        }
        return Math.abs(str.hashCode());
    }

    public static Boolean regExp(String s, String regex) {
        if (s == null || regex == null) {
            return false;
        }
        if (regex.length() == 0) {
            return false;
        }
        try {
            return regexpPatternCache.get(regex).matcher(s).find(0);
        }
        catch (Exception e2) {
            LOG.error("Exception when compile and match regex:" + regex + " on: " + s, (Throwable)e2);
            return false;
        }
    }

    public static Byte bitAnd(Byte a, Byte b) {
        if (a == null || b == null) {
            return (byte)0;
        }
        return (byte)(a & b);
    }

    public static Short bitAnd(Short a, Short b) {
        if (a == null || b == null) {
            return (short)0;
        }
        return (short)(a & b);
    }

    public static Integer bitAnd(Integer a, Integer b) {
        if (a == null || b == null) {
            return 0;
        }
        return a & b;
    }

    public static Long bitAnd(Long a, Long b) {
        if (a == null || b == null) {
            return 0L;
        }
        return a & b;
    }

    public static Byte bitNot(Byte a) {
        if (a == null) {
            a = 0;
        }
        return ~a.byteValue();
    }

    public static Short bitNot(Short a) {
        if (a == null) {
            a = 0;
        }
        return ~a.shortValue();
    }

    public static Integer bitNot(Integer a) {
        if (a == null) {
            a = 0;
        }
        return ~a.intValue();
    }

    public static Long bitNot(Long a) {
        if (a == null) {
            a = 0L;
        }
        return a ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static Byte bitOr(Byte a, Byte b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (byte)(a | b);
    }

    public static Short bitOr(Short a, Short b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (short)(a | b);
    }

    public static Integer bitOr(Integer a, Integer b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return a | b;
    }

    public static Long bitOr(Long a, Long b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0L;
            }
            if (b == null) {
                b = 0L;
            }
        }
        return a | b;
    }

    public static Byte bitXor(Byte a, Byte b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (byte)(a ^ b);
    }

    public static Short bitXor(Short a, Short b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (short)(a ^ b);
    }

    public static Integer bitXor(Integer a, Integer b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return a ^ b;
    }

    public static Long bitXor(Long a, Long b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0L;
            }
            if (b == null) {
                b = 0L;
            }
        }
        return a ^ b;
    }

    public static byte divide(byte a, byte b) {
        return (byte)(a / b);
    }

    public static short divide(short a, short b) {
        return (short)(a / b);
    }

    public static int divide(int a, int b) {
        return a / b;
    }

    public static long divide(long a, long b) {
        return a / b;
    }

    public static float divide(float a, float b) {
        return a / b;
    }

    public static double divide(double a, double b) {
        return a / b;
    }

    public static String toBase64(byte[] b) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[b.length];
        System.arraycopy(b, 0, bytes, 0, b.length);
        String result = null;
        try {
            result = new String(Base64.encodeBase64((byte[])bytes));
        }
        catch (Exception e2) {
            LOG.error("Exception when encode base64:" + Hex.encodeHexString((byte[])b), (Throwable)e2);
        }
        return result;
    }

    public static byte[] fromBase64(String value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = new byte[value.getBytes().length];
        System.arraycopy(value.getBytes(), 0, bytes, 0, bytes.length);
        byte[] result = null;
        try {
            result = Base64.decodeBase64((byte[])bytes);
        }
        catch (Exception e2) {
            LOG.error("Exception when decode base64:" + value, (Throwable)e2);
        }
        return result;
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(byte[] b) {
        if (b == null) {
            return null;
        }
        String result = null;
        try {
            result = UUID.nameUUIDFromBytes(b).toString();
        }
        catch (Exception e2) {
            LOG.error("Exception when encode uuid:" + Hex.encodeHexString((byte[])b), (Throwable)e2);
        }
        return result;
    }

    public static long toLong(java.util.Date v) {
        return v.getTime();
    }

    public static int toInt(Time v) {
        return (int)(BuildInScalarFunctions.toLong(v) % 86400000L);
    }

    public static int toInt(java.util.Date v) {
        return (int)(BuildInScalarFunctions.toLong(v) / 86400000L);
    }

    public static Long safeToLong(java.util.Date v) {
        if (v == null) {
            return null;
        }
        return BuildInScalarFunctions.toLong(v);
    }

    public static Integer safeToInt(Time v) {
        if (v == null) {
            return null;
        }
        return BuildInScalarFunctions.toInt(v);
    }

    public static Integer safeToInt(java.util.Date v) {
        if (v == null) {
            return null;
        }
        return BuildInScalarFunctions.toInt(v);
    }

    public static Date internalToDate(int v) {
        long t = (long)v * 86400000L;
        return new Date(t);
    }

    public static Time internalToTime(int v) {
        return new Time(v);
    }

    public static Timestamp internalToTimestamp(long v) {
        return new Timestamp(v);
    }

    public static Date safeInternalToDate(Integer v) {
        if (v == null) {
            return null;
        }
        return BuildInScalarFunctions.internalToDate(v);
    }

    public static Time safeInternalToTime(Integer v) {
        if (v == null) {
            return null;
        }
        return BuildInScalarFunctions.internalToTime(v);
    }

    public static Timestamp safeInternalToTimestamp(Long v) {
        if (v == null) {
            return null;
        }
        return BuildInScalarFunctions.internalToTimestamp(v);
    }

    public static String unixTimeToString(int time) {
        return BuildInScalarFunctions.unixTimeToString(time, 0);
    }

    public static String unixTimeToString(int time, int precision) {
        StringBuilder buf = new StringBuilder(8);
        BuildInScalarFunctions.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    private static void unixTimeToString(StringBuilder buf, int time, int precision) {
        while (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        BuildInScalarFunctions.int2(buf, h);
        buf.append(':');
        BuildInScalarFunctions.int2(buf, m);
        buf.append(':');
        BuildInScalarFunctions.int2(buf, s);
        if (precision > 0) {
            buf.append('.');
            while (precision > 0) {
                buf.append((char)(48 + ms / 100));
                ms %= 100;
                ms *= 10;
                --precision;
            }
        }
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    public static BinaryString binaryDecode(byte[] src, String charset) {
        try {
            Charset toCharset = Charset.forName(charset);
            return BinaryString.fromString(new String(src, toCharset));
        }
        catch (UnsupportedCharsetException e2) {
            LOG.error("UnsupportedCharsetException when decode to '" + charset + "'");
            return null;
        }
    }

    public static byte[] binaryEncode(BinaryString src, String charset) {
        try {
            Charset toCharset = Charset.forName(charset);
            return src.toString().getBytes(toCharset);
        }
        catch (UnsupportedCharsetException e2) {
            LOG.error("UnsupportedCharsetException when encode to '" + charset + "'");
            return null;
        }
    }
}

