/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.SortedMapStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.SortedMapSerializer;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateDescriptor;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataview.KeyedStateListView;
import org.apache.flink.table.dataview.KeyedStateMapView;
import org.apache.flink.table.dataview.KeyedStateSortedMapView;
import org.apache.flink.table.dataview.NullAwareKeyedStateMapView;
import org.apache.flink.table.dataview.NullAwareSubKeyedStateMapView;
import org.apache.flink.table.dataview.StateDataView;
import org.apache.flink.table.dataview.StateListView;
import org.apache.flink.table.dataview.StateMapView;
import org.apache.flink.table.dataview.StateSortedMapView;
import org.apache.flink.table.dataview.SubKeyedStateListView;
import org.apache.flink.table.dataview.SubKeyedStateMapView;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.typeutils.ListViewTypeInfo;
import org.apache.flink.table.typeutils.MapViewTypeInfo;
import org.apache.flink.table.typeutils.SortedMapViewTypeInfo;
import org.apache.flink.util.Preconditions;

public final class ExecutionContextImpl
implements ExecutionContext {
    private static final String NULL_STATE_POSTFIX = "_null_state";
    private final AbstractStreamOperator<?> operator;
    private final RuntimeContext runtimeContext;
    private final TypeSerializer<?> namespaceSerializer;
    private final List<StateDataView<BaseRow>> registeredStateDataViews;

    public ExecutionContextImpl(AbstractStreamOperator<?> operator, RuntimeContext runtimeContext) {
        this(operator, runtimeContext, null);
    }

    public ExecutionContextImpl(AbstractStreamOperator<?> operator, RuntimeContext runtimeContext, TypeSerializer<?> namespaceSerializer) {
        this.operator = operator;
        this.runtimeContext = Preconditions.checkNotNull(runtimeContext);
        this.namespaceSerializer = namespaceSerializer;
        this.registeredStateDataViews = new ArrayList<StateDataView<BaseRow>>();
    }

    @Override
    public <K, V, S extends KeyedState<K, V>> S getKeyedState(KeyedStateDescriptor<K, V, S> descriptor) throws Exception {
        return (S)this.operator.getKeyedState(descriptor);
    }

    @Override
    public <K, N, V, S extends SubKeyedState<K, N, V>> S getSubKeyedState(SubKeyedStateDescriptor<K, N, V, S> descriptor) throws Exception {
        return (S)this.operator.getSubKeyedState(descriptor);
    }

    @Override
    public <K, V> KeyedValueState<K, V> getKeyedValueState(ValueStateDescriptor<V> descriptor) throws Exception {
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        return (KeyedValueState)this.operator.getKeyedState((KeyedStateDescriptor)new KeyedValueStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), descriptor.getSerializer()));
    }

    @Override
    public <K, V> KeyedListState<K, V> getKeyedListState(ListStateDescriptor<V> descriptor) throws Exception {
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        return (KeyedListState)this.operator.getKeyedState((KeyedStateDescriptor)new KeyedListStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), (ListSerializer)descriptor.getSerializer()));
    }

    @Override
    public <K, UK, UV> KeyedMapState<K, UK, UV> getKeyedMapState(MapStateDescriptor<UK, UV> descriptor) throws Exception {
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        return (KeyedMapState)this.operator.getKeyedState((KeyedStateDescriptor)new KeyedMapStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), (MapSerializer)descriptor.getSerializer()));
    }

    @Override
    public <K, UK, UV> KeyedSortedMapState<K, UK, UV> getKeyedSortedMapState(SortedMapStateDescriptor<UK, UV> descriptor) throws Exception {
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        return (KeyedSortedMapState)this.operator.getKeyedState((KeyedStateDescriptor)new KeyedSortedMapStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), (SortedMapSerializer)descriptor.getSerializer()));
    }

    @Override
    public <K, N, V> SubKeyedValueState<K, N, V> getSubKeyedValueState(ValueStateDescriptor<V> descriptor) throws Exception {
        if (this.namespaceSerializer == null) {
            throw new RuntimeException("The namespace serializer has not been initialized.");
        }
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        return (SubKeyedValueState)this.operator.getSubKeyedState((SubKeyedStateDescriptor)new SubKeyedValueStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), this.namespaceSerializer, descriptor.getSerializer()));
    }

    @Override
    public <K, N, V> SubKeyedListState<K, N, V> getSubKeyedListState(ListStateDescriptor<V> descriptor) throws Exception {
        if (this.namespaceSerializer == null) {
            throw new RuntimeException("The namespace serializer has not been initialized.");
        }
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        return (SubKeyedListState)this.operator.getSubKeyedState((SubKeyedStateDescriptor)new SubKeyedListStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), this.namespaceSerializer, ((ListSerializer)descriptor.getSerializer()).getElementSerializer()));
    }

    @Override
    public <K, N, UK, UV> SubKeyedMapState<K, N, UK, UV> getSubKeyedMapState(MapStateDescriptor<UK, UV> descriptor) throws Exception {
        if (this.namespaceSerializer == null) {
            throw new RuntimeException("The namespace serializer has not been initialized.");
        }
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        MapSerializer mapSerializer = (MapSerializer)descriptor.getSerializer();
        return (SubKeyedMapState)this.operator.getSubKeyedState((SubKeyedStateDescriptor)new SubKeyedMapStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), this.namespaceSerializer, mapSerializer.getKeySerializer(), mapSerializer.getValueSerializer()));
    }

    @Override
    public <K, N, UK, UV> SubKeyedSortedMapState<K, N, UK, UV> getSubKeyedSortedMapState(SortedMapStateDescriptor<UK, UV> descriptor) throws Exception {
        if (this.namespaceSerializer == null) {
            throw new RuntimeException("The namespace serializer has not been initialized.");
        }
        descriptor.initializeSerializerUnlessSet(this.operator.getExecutionConfig());
        TypeSerializer sortedMapSerializer = descriptor.getSerializer();
        return (SubKeyedSortedMapState)this.operator.getSubKeyedState((SubKeyedStateDescriptor)new SubKeyedSortedMapStateDescriptor(descriptor.getName(), this.operator.getKeySerializer(), this.namespaceSerializer, ((SortedMapSerializer)sortedMapSerializer).getComparator(), ((SortedMapSerializer)sortedMapSerializer).getKeySerializer(), ((SortedMapSerializer)sortedMapSerializer).getValueSerializer()));
    }

    @Override
    public <K, UK, UV> StateMapView<K, UK, UV> getStateMapView(String stateName, MapViewTypeInfo<UK, UV> mapViewTypeInfo, boolean hasNamespace) throws Exception {
        MapStateDescriptor<UK, UV> mapStateDescriptor = new MapStateDescriptor<UK, UV>(stateName, mapViewTypeInfo.keyType(), mapViewTypeInfo.valueType());
        ValueStateDescriptor<UV> nullStateDescriptor = new ValueStateDescriptor<UV>(stateName + NULL_STATE_POSTFIX, mapViewTypeInfo.valueType());
        if (hasNamespace) {
            SubKeyedMapState mapState = this.getSubKeyedMapState(mapStateDescriptor);
            if (mapViewTypeInfo.nullAware()) {
                SubKeyedValueState nullState = this.getSubKeyedValueState(nullStateDescriptor);
                return new NullAwareSubKeyedStateMapView(mapState, nullState);
            }
            return new SubKeyedStateMapView(mapState);
        }
        KeyedMapState<K, UK, UV> mapState = this.getKeyedMapState(mapStateDescriptor);
        if (mapViewTypeInfo.nullAware()) {
            KeyedValueState<K, UV> nullState = this.getKeyedValueState(nullStateDescriptor);
            return new NullAwareKeyedStateMapView<K, UK, UV>(mapState, nullState);
        }
        return new KeyedStateMapView<K, UK, UV>(mapState);
    }

    @Override
    public <K, UK, UV> StateSortedMapView<K, UK, UV> getStateSortedMapView(String stateName, SortedMapViewTypeInfo<UK, UV> sortedMapViewTypeInfo, boolean hasNamespace) throws Exception {
        SortedMapStateDescriptor sortedMapStateDesc = new SortedMapStateDescriptor(stateName, sortedMapViewTypeInfo.comparator, sortedMapViewTypeInfo.keyType, sortedMapViewTypeInfo.valueType);
        if (!hasNamespace) {
            KeyedSortedMapState mapState = this.getKeyedSortedMapState(sortedMapStateDesc);
            return new KeyedStateSortedMapView(mapState);
        }
        throw new UnsupportedOperationException("SubKeyedState SortedMapView is not supported currently");
    }

    @Override
    public <K, V> StateListView<K, V> getStateListView(String stateName, ListViewTypeInfo<V> listViewTypeInfo, boolean hasNamespace) throws Exception {
        ListStateDescriptor<V> listStateDesc = new ListStateDescriptor<V>(stateName, listViewTypeInfo.elementType());
        if (hasNamespace) {
            SubKeyedListState listState = this.getSubKeyedListState(listStateDesc);
            return new SubKeyedStateListView(listState);
        }
        KeyedListState<K, V> listState = this.getKeyedListState(listStateDesc);
        return new KeyedStateListView<K, V>(listState);
    }

    @Override
    public void registerStateDataView(StateDataView<BaseRow> stateDataView) {
        this.registeredStateDataViews.add(stateDataView);
    }

    @Override
    public <K> TypeSerializer<K> getKeySerializer() {
        return this.operator.getKeySerializer();
    }

    @Override
    public BaseRow currentKey() {
        return (BaseRow)this.operator.getCurrentKey();
    }

    @Override
    public void setCurrentKey(BaseRow key) {
        this.operator.setCurrentKey((Object)key);
        for (StateDataView<BaseRow> dataView : this.registeredStateDataViews) {
            dataView.setCurrentKey(key);
        }
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }
}

