/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.io.File;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.accumulators.DoubleCounter;
import org.apache.flink.api.common.accumulators.Histogram;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.functions.FunctionContext;

public class FunctionContextImpl
implements FunctionContext {
    private final RuntimeContext context;

    public FunctionContextImpl(RuntimeContext context) {
        this.context = context;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.context.getMetricGroup();
    }

    @Override
    public File getCachedFile(String name) {
        return this.context.getDistributedCache().getFile(name);
    }

    @Override
    public int getNumberOfParallelSubtasks() {
        return this.context.getNumberOfParallelSubtasks();
    }

    @Override
    public int getIndexOfThisSubtask() {
        return this.context.getIndexOfThisSubtask();
    }

    @Override
    public IntCounter getIntCounter(String name) {
        return this.context.getIntCounter(name);
    }

    @Override
    public LongCounter getLongCounter(String name) {
        return this.context.getLongCounter(name);
    }

    @Override
    public DoubleCounter getDoubleCounter(String name) {
        return this.context.getDoubleCounter(name);
    }

    @Override
    public Histogram getHistogram(String name) {
        return this.context.getHistogram(name);
    }

    @Override
    public String getJobParameter(String key, String voidaultValue) {
        ExecutionConfig.GlobalJobParameters conf = this.context.getExecutionConfig().getGlobalJobParameters();
        if (conf != null && conf.toMap().containsKey(key)) {
            return conf.toMap().get(key);
        }
        return voidaultValue;
    }
}

