/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.api.dataview.Order;
import org.apache.flink.table.api.dataview.SortedMapView;
import org.apache.flink.table.dataformat.GenericArray;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.functions.aggfunctions.percentile.HistogramUtils;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.TypeInfoWrappedDataType;

public class ApproximatePercentile {

    public static class ApproxMultiPercentileAggFunction
    extends ApproximatePercentileAggFunction<Double[]> {
        @Override
        public Double[] getValue(HistogramAcc acc) {
            double[] paras = acc.percentile.toDoubleArray();
            if (paras.length < 1) {
                return null;
            }
            Double[] percentiles = new Double[paras.length];
            for (int i = 0; i < percentiles.length; ++i) {
                percentiles[i] = HistogramUtils.query(acc.sketch, acc.siblingMap, acc.totalCount, paras[i]);
            }
            return percentiles;
        }
    }

    public static class ApproxSinglePercentileAggFunction
    extends ApproximatePercentileAggFunction<Double> {
        @Override
        public Double getValue(HistogramAcc acc) {
            double[] percents = acc.percentile.toDoubleArray();
            if (percents.length < 1) {
                return null;
            }
            return HistogramUtils.query(acc.sketch, acc.siblingMap, acc.totalCount, percents[0]);
        }
    }

    public static class HistogramAcc {
        public GenericArray percentile;
        public int maxBins;
        public long totalCount;
        public int usedBins;
        public SortedMapView<Double, Long> sketch;
        public SortedMapView<Double, List<Double>> intervalMap;
        public MapView<Double, List<Double>> siblingMap;
    }

    public static abstract class ApproximatePercentileAggFunction<T>
    extends AggregateFunction<T, HistogramAcc> {
        @Override
        public HistogramAcc createAccumulator() {
            HistogramAcc acc = new HistogramAcc();
            acc.percentile = new GenericArray(new double[0], 0, true);
            acc.maxBins = 0;
            acc.totalCount = 0L;
            acc.usedBins = 0;
            acc.sketch = new SortedMapView(Order.ASCENDING, DataTypes.DOUBLE, DataTypes.LONG);
            acc.intervalMap = new SortedMapView(Order.ASCENDING, DataTypes.DOUBLE, new TypeInfoWrappedDataType(new ListTypeInfo<Double>(Types.DOUBLE())));
            acc.siblingMap = new MapView(DataTypes.DOUBLE, new TypeInfoWrappedDataType(new ListTypeInfo<Double>(Types.DOUBLE())));
            return acc;
        }

        public void accumulate(HistogramAcc acc, Object value, BigDecimal p, Integer maxBins) throws Exception {
            this.accumulate(acc, value, new Double[]{p.doubleValue()}, maxBins);
        }

        public void accumulate(HistogramAcc acc, Object value, BigDecimal[] p, Integer maxBins) throws Exception {
            Double[] percentiles = new Double[p.length];
            for (int i = 0; i < p.length; ++i) {
                percentiles[i] = p[i].doubleValue();
            }
            this.accumulate(acc, value, percentiles, maxBins);
        }

        public void accumulate(HistogramAcc acc, Object value, Double[] p, Integer maxBins) throws Exception {
            if (value == null) {
                return;
            }
            Double[] doubleArray = p;
            int n = doubleArray.length;
            for (int i = 0; i < n; ++i) {
                double percent = doubleArray[i];
                if (!(percent < 0.0) && !(percent > 1.0)) continue;
                throw new IllegalArgumentException("Percentile of APPROX_PERCENTILE should be >= 0.0 and <= 1.0, but get [" + percent + "].");
            }
            HistogramUtils.insertBin(acc, HistogramUtils.cast2Double(value), 1L, ArrayUtils.toPrimitive((Double[])p), maxBins);
        }

        public void retract(HistogramAcc acc, Object value, BigDecimal[] p, Integer bin) throws Exception {
            Double[] percentiles = new Double[p.length];
            for (int i = 0; i < p.length; ++i) {
                percentiles[i] = p[i].doubleValue();
            }
            this.retract(acc, value, percentiles, bin);
        }

        public void retract(HistogramAcc acc, Object value, BigDecimal p, Integer bin) throws Exception {
            this.retract(acc, value, new Double[]{p.doubleValue()}, bin);
        }

        public void retract(HistogramAcc acc, Object value, Double[] p, Integer bin) throws Exception {
            if (value == null) {
                return;
            }
            Double[] doubleArray = p;
            int n = doubleArray.length;
            for (int i = 0; i < n; ++i) {
                double percent = doubleArray[i];
                if (!(percent < 0.0) && !(percent > 1.0)) continue;
                throw new IllegalArgumentException("Percentile of APPROX_PERCENTILE should be >= 0.0 and <= 1.0, but get [" + percent + "].");
            }
            --acc.totalCount;
            Tuple2<Double, Long> hitBin = HistogramUtils.getClosestBin(acc.sketch, acc.siblingMap, HistogramUtils.cast2Double(value));
            if ((Double)hitBin.f0 == Double.NEGATIVE_INFINITY) {
                HistogramUtils.insertBin(acc, HistogramUtils.cast2Double(value), -1L, ArrayUtils.toPrimitive((Double[])p), bin);
                return;
            }
            if ((Long)hitBin.f1 > 0L) {
                acc.sketch.put((Double)hitBin.f0, (Long)hitBin.f1);
                return;
            }
            --acc.usedBins;
            HistogramUtils.removeBin(acc.sketch, acc.intervalMap, acc.siblingMap, (Double)hitBin.f0);
        }

        public void merge(HistogramAcc acc, Iterable<HistogramAcc> itr) throws Exception {
            for (HistogramAcc mergedAcc : itr) {
                Iterator<Map.Entry<Double, Long>> binItr = mergedAcc.sketch.iterator();
                if (binItr == null) continue;
                while (binItr.hasNext()) {
                    Map.Entry<Double, Long> bin = binItr.next();
                    HistogramUtils.insertBin(acc, bin.getKey(), bin.getValue(), mergedAcc.percentile.toDoubleArray(), mergedAcc.maxBins);
                }
            }
        }
    }
}

