/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog.HyperLogLogPlusPlus;
import org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog.XxHash64Function;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.typeutils.DecimalTypeInfo;

public class BatchApproximateCountDistinct {

    public static class StringApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<BinaryString> {
        @Override
        public DataType getValueTypeInfo() {
            return new TypeInfoWrappedDataType(BinaryStringTypeInfo.INSTANCE);
        }

        @Override
        long getHashcode(BinaryString s) {
            MemorySegment[] segments = s.getSegments();
            if (segments.length == 1) {
                return XxHash64Function.hashUnsafeBytes(segments[0], s.getOffset(), s.numBytes(), XxHash64Function.DEFAULT_SEED());
            }
            return XxHash64Function.hashUnsafeBytes(MemorySegmentFactory.wrap(s.getBytes()), 0, s.numBytes(), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class TimestampApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Timestamp> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.TIMESTAMP;
        }

        @Override
        long getHashcode(Timestamp value) {
            return XxHash64Function.hashLong(value.getTime(), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class TimeApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Time> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.TIME;
        }

        @Override
        long getHashcode(Time value) {
            return XxHash64Function.hashLong(value.getTime(), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class DateApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Date> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.DATE;
        }

        @Override
        long getHashcode(Date value) {
            return XxHash64Function.hashLong(value.getTime(), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class BooleanApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Boolean> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.BOOLEAN;
        }

        @Override
        long getHashcode(Boolean value) {
            return XxHash64Function.hashInt(value != false ? 1 : 0, XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class ShortApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Short> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.SHORT;
        }

        @Override
        long getHashcode(Short value) {
            return XxHash64Function.hashInt(value.shortValue(), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class LongApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Long> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.LONG;
        }

        @Override
        long getHashcode(Long value) {
            return XxHash64Function.hashLong(value, XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class IntApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Integer> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.INT;
        }

        @Override
        long getHashcode(Integer value) {
            return XxHash64Function.hashInt(value, XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class FloatApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Float> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.FLOAT;
        }

        @Override
        long getHashcode(Float value) {
            return XxHash64Function.hashInt(Float.floatToIntBits(value.floatValue()), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class DoubleApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Double> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.DOUBLE;
        }

        @Override
        long getHashcode(Double value) {
            return XxHash64Function.hashLong(Double.doubleToLongBits(value), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class DecimalApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Decimal> {
        private final int precision;
        private final int scale;

        public DecimalApproximateCountDistinctAggFunction(DecimalType decimalType) {
            this.precision = decimalType.precision();
            this.scale = decimalType.scale();
        }

        @Override
        public DataType getValueTypeInfo() {
            return new TypeInfoWrappedDataType(new DecimalTypeInfo(this.precision, this.scale));
        }

        @Override
        long getHashcode(Decimal d) {
            if (this.precision <= 18) {
                return XxHash64Function.hashLong(d.toUnscaledLong(), XxHash64Function.DEFAULT_SEED());
            }
            byte[] bytes = d.toBigDecimal().unscaledValue().toByteArray();
            MemorySegment segment = MemorySegmentFactory.wrap(bytes);
            return XxHash64Function.hashUnsafeBytes(segment, 0, segment.size(), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class ByteApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction<Byte> {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.BYTE;
        }

        @Override
        long getHashcode(Byte value) {
            return XxHash64Function.hashInt(value.byteValue(), XxHash64Function.DEFAULT_SEED());
        }
    }

    public static class HllBuffer {
        public long[] array;
    }

    public static abstract class ApproximateCountDistinctAggFunction<T>
    extends AggregateFunction<Long, HllBuffer> {
        private static final Double RELATIVE_SD = 0.01;
        private HyperLogLogPlusPlus hyperLogLogPlusPlus;

        public abstract DataType getValueTypeInfo();

        @Override
        public HllBuffer createAccumulator() {
            this.hyperLogLogPlusPlus = new HyperLogLogPlusPlus(RELATIVE_SD);
            HllBuffer buffer = new HllBuffer();
            buffer.array = new long[this.hyperLogLogPlusPlus.numWords()];
            this.resetAccumulator(buffer);
            return buffer;
        }

        public void accumulate(HllBuffer buffer, Object input) throws Exception {
            if (input != null) {
                this.hyperLogLogPlusPlus.updateByHashcode(buffer, this.getHashcode(input));
            }
        }

        abstract long getHashcode(T var1);

        public void merge(HllBuffer buffer, Iterable<HllBuffer> it) throws Exception {
            for (HllBuffer tmpBuffer : it) {
                this.hyperLogLogPlusPlus.merge(buffer, tmpBuffer);
            }
        }

        public void resetAccumulator(HllBuffer buffer) {
            for (int word = 0; word < this.hyperLogLogPlusPlus.numWords(); ++word) {
                buffer.array[word] = 0L;
            }
        }

        @Override
        public Long getValue(HllBuffer buffer) {
            return this.hyperLogLogPlusPlus.query(buffer);
        }

        @Override
        public DataType[] getUserDefinedInputTypes(Class[] signature) {
            if (signature.length == 1) {
                return new DataType[]{this.getValueTypeInfo()};
            }
            if (signature.length == 0) {
                return new DataType[0];
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public DataType getAccumulatorType() {
            return new GenericType<HllBuffer>(new GenericTypeInfo<HllBuffer>(HllBuffer.class));
        }
    }
}

