/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.api.dataview.Order;
import org.apache.flink.table.api.dataview.SortedMapView;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.MapViewTypeInfo;
import org.apache.flink.table.typeutils.MapViewTypeInfo$;
import org.apache.flink.table.typeutils.SortedMapViewTypeInfo;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0003\u0003\t\"\u0001\t$jeN$h+\u00197vK^KG\u000f\u001b*fiJ\f7\r^!hO\u001a+hn\u0019;j_:T!a\u0001\u0003\u0002\u0019\u0005<wMZ;oGRLwN\\:\u000b\u0005\u00151\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001U\u0011!CG\n\u0003\u0001M\u0001B\u0001\u0006\f\u0019M5\tQC\u0003\u0002\u0006\u0011%\u0011q#\u0006\u0002\u0012\u0003\u001e<'/Z4bi\u00164UO\\2uS>t\u0007CA\r\u001b\u0019\u0001!Qa\u0007\u0001C\u0002q\u0011\u0011\u0001V\t\u0003;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011qAT8uQ&tw\r\u0005\u0002\u001fI%\u0011Qe\b\u0002\u0004\u0003:L\bCA\u0014+\u001b\u0005A#BA\u0015\t\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u0003W!\u0012!bR3oKJL7MU8x\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\tq\u0006E\u00021\u0001ai\u0011A\u0001\u0005\u0006e\u0001!\taM\u0001\u000bC\u000e\u001cW/\\;mCR,Gc\u0001\u001b8sA\u0011a$N\u0005\u0003m}\u0011A!\u00168ji\")\u0001(\ra\u0001M\u0005\u0019\u0011mY2\t\u000bi\n\u0004\u0019A\u0012\u0002\u000bY\fG.^3\t\u000bI\u0002A\u0011\u0001\u001f\u0015\tQjdh\u0010\u0005\u0006qm\u0002\rA\n\u0005\u0006um\u0002\ra\t\u0005\u0006\u0001n\u0002\r!Q\u0001\u0006_J$WM\u001d\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0011auN\\4\t\u000b)\u0003A\u0011A&\u0002\u000fI,GO]1diR\u0019A\u0007T'\t\u000baJ\u0005\u0019\u0001\u0014\t\u000biJ\u0005\u0019A\u0012\t\u000b)\u0003A\u0011A(\u0015\tQ\u0002\u0016K\u0015\u0005\u0006q9\u0003\rA\n\u0005\u0006u9\u0003\ra\t\u0005\u0006\u0001:\u0003\r!\u0011\u0005\u0006)\u0002!\t%V\u0001\tO\u0016$h+\u00197vKR\u0011\u0001D\u0016\u0005\u0006qM\u0003\rA\n\u0005\u00061\u0002!I!W\u0001\fkB$\u0017\r^3WC2,X\rF\u000255nCQ\u0001O,A\u0002\u0019BQ\u0001X,A\u0002u\u000b\u0011c]8si\u0016$G)\u0019;b\u001b\u0006\u0004h+[3x!\u0011q6-Q3\u000e\u0003}S!\u0001Y1\u0002\u0011\u0011\fG/\u0019<jK^T!A\u0019\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002e?\ni1k\u001c:uK\u0012l\u0015\r\u001d,jK^\u00042AZ5\u0019\u001b\u00059'B\u00015F\u0003\u0011)H/\u001b7\n\u0005)<'\u0001\u0002'jgRDQ\u0001\u001c\u0001\u0005\u00025\f\u0001C]3tKR\f5mY;nk2\fGo\u001c:\u0015\u0005Qr\u0007\"\u0002\u001dl\u0001\u00041\u0003\"\u00029\u0001\t\u0003\t\u0018aC5oSR$\u0015\r^1NCB,\u0012A\u001d\t\u0005=NDR/\u0003\u0002u?\n9Q*\u00199WS\u0016<\bc\u00014j\u0003\")q\u000f\u0001D\u0001q\u0006!r-\u001a;J]R,'O\\1m-\u0006dW/\u001a+za\u0016,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003y\"\tQ\u0001^=qKNL!A`>\u0003\u0019%sG/\u001a:oC2$\u0016\u0010]3\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005aq-\u001a;WC2,X\rV=qKV\u0011\u0011Q\u0001\t\u0004u\u0006\u001d\u0011bAA\u0005w\nAA)\u0019;b)f\u0004X\rC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u001b\u001d,GOU3tk2$H+\u001f9f)\t\t)\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\u00021\u001d,G/V:fe\u0012+g-\u001b8fI&s\u0007/\u001e;UsB,7\u000f\u0006\u0003\u0002\u0018\u0005u\u0001#\u0002\u0010\u0002\u001a\u0005\u0015\u0011bAA\u000e?\t)\u0011I\u001d:bs\"A\u0011qDA\t\u0001\u0004\t\t#A\u0005tS\u001et\u0017\r^;sKB)a$!\u0007\u0002$A\"\u0011QEA\u001b!\u0019\t9#!\f\u000249\u0019a$!\u000b\n\u0007\u0005-r$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tDA\u0003DY\u0006\u001c8OC\u0002\u0002,}\u00012!GA\u001b\t-\t9$!\b\u0002\u0002\u0003\u0005)\u0011\u0001\u000f\u0003\u0007}#\u0013\u0007C\u0004\u0002<\u0001!\t%!\u0010\u0002#\r\u0014X-\u0019;f\u0003\u000e\u001cW/\\;mCR|'\u000fF\u0001'\u0011\u001d\t\t\u0005\u0001C!\u0003\u001f\t!cZ3u\u0003\u000e\u001cW/\\;mCR|'\u000fV=qK\u0002")
public abstract class FirstValueWithRetractAggFunction<T>
extends AggregateFunction<T, GenericRow> {
    public void accumulate(GenericRow acc, Object value) {
        if (value != null) {
            long order = System.currentTimeMillis();
            Object v = value;
            MapView dataMapView = (MapView)acc.getField(2);
            ArrayList<Long> dataMapList = (ArrayList<Long>)dataMapView.get(v);
            if (dataMapList == null) {
                dataMapList = new ArrayList<Long>();
            }
            dataMapList.add(Predef$.MODULE$.long2Long(order));
            dataMapView.put(v, dataMapList);
            this.accumulate(acc, v, Predef$.MODULE$.long2Long(order));
        }
    }

    public void accumulate(GenericRow acc, Object value, Long order) {
        if (value != null && order != null) {
            SortedMapView sortedDataMapView;
            ArrayList<Object> sortedDataMapList;
            Object v = value;
            Long prevOrder = (Long)acc.getField(1);
            if (prevOrder == null || Predef$.MODULE$.Long2long(prevOrder) > Predef$.MODULE$.Long2long(order)) {
                acc.update(0, v);
                acc.update(1, order);
            }
            if ((sortedDataMapList = (ArrayList<Object>)(sortedDataMapView = (SortedMapView)acc.getField(3)).get(order)) == null) {
                sortedDataMapList = new ArrayList<Object>();
            }
            sortedDataMapList.add(v);
            sortedDataMapView.put(order, sortedDataMapList);
        }
    }

    public void retract(GenericRow acc, Object value) {
        if (value != null) {
            Object v = value;
            MapView dataMapView = (MapView)acc.getField(2);
            List dataMapList = (List)dataMapView.get(v);
            if (dataMapList != null && dataMapList.size() > 0) {
                Long order = (Long)dataMapList.get(0);
                dataMapList.remove(0);
                if (dataMapList.isEmpty()) {
                    dataMapView.remove(v);
                } else {
                    dataMapView.put(v, dataMapList);
                }
                this.retract(acc, v, order);
            }
        }
    }

    public void retract(GenericRow acc, Object value, Long order) {
        if (value != null && order != null) {
            Object v = value;
            SortedMapView sortedDataMapView = (SortedMapView)acc.getField(3);
            List dataList = (List)sortedDataMapView.get(order);
            if (dataList == null) {
                return;
            }
            int index = dataList.indexOf(v);
            if (index >= 0) {
                dataList.remove(index);
                if (dataList.isEmpty()) {
                    sortedDataMapView.remove(order);
                } else {
                    sortedDataMapView.put(order, dataList);
                }
            }
            if (BoxesRunTime.equals((Object)v, (Object)acc.getField(0))) {
                this.updateValue(acc, sortedDataMapView);
            }
        }
    }

    @Override
    public T getValue(GenericRow acc) {
        return (T)acc.getField(0);
    }

    private void updateValue(GenericRow acc, SortedMapView<Long, List<T>> sortedDataMapView) {
        Object v0;
        Long startKey = (Long)acc.getField(1);
        Iterator<Map.Entry<Long, List<T>>> itor = sortedDataMapView.tailEntries(startKey).iterator();
        if (itor.hasNext()) {
            Map.Entry<Long, List<T>> entry = itor.next();
            acc.update(1, entry.getKey());
            v0 = entry.getValue().get(0);
        } else {
            acc.update(1, null);
            v0 = null;
        }
        Object firstValue = v0;
        acc.update(0, firstValue);
    }

    public void resetAccumulator(GenericRow acc) {
        acc.update(0, null);
        acc.update(1, null);
        MapView dataMapView = (MapView)acc.getField(2);
        dataMapView.clear();
        SortedMapView sortedDataMapView = (SortedMapView)acc.getField(3);
        sortedDataMapView.clear();
    }

    public MapView<T, List<Long>> initDataMap() {
        return new MapView(this.getInternalValueType(), package$.MODULE$.typeInfo2DataType(new ListTypeInfo<Long>(Types$.MODULE$.LONG())));
    }

    public abstract InternalType getInternalValueType();

    public DataType getValueType() {
        return this.getInternalValueType();
    }

    @Override
    public DataType getResultType() {
        return this.getValueType();
    }

    @Override
    public DataType[] getUserDefinedInputTypes(Class<?>[] signature) {
        block4: {
            DataType[] dataTypeArray;
            block3: {
                block2: {
                    if (signature.length != 1) break block2;
                    dataTypeArray = (DataType[])((Object[])new DataType[]{this.getValueType()});
                    break block3;
                }
                if (signature.length != 2) break block4;
                dataTypeArray = (DataType[])((Object[])new DataType[]{this.getValueType(), DataTypes.LONG});
            }
            return dataTypeArray;
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GenericRow createAccumulator() {
        void var1_1;
        GenericRow acc = new GenericRow(4);
        acc.update(2, this.initDataMap());
        acc.update(3, new SortedMapView(Order.ASCENDING, DataTypes.LONG, package$.MODULE$.typeInfo2DataType(new ListTypeInfo(TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(this.getValueType())))));
        return var1_1;
    }

    @Override
    public DataType getAccumulatorType() {
        DataType[] fieldTypes2 = (DataType[])((Object[])new DataType[]{this.getInternalValueType(), DataTypes.LONG, DataTypes.createGenericType(new MapViewTypeInfo(package$.MODULE$.dataType2ExternalTypeInfo(this.getInternalValueType()), new ListTypeInfo<Long>(Types$.MODULE$.LONG()), MapViewTypeInfo$.MODULE$.$lessinit$greater$default$3(), MapViewTypeInfo$.MODULE$.$lessinit$greater$default$4())), DataTypes.createGenericType(new SortedMapViewTypeInfo(new SortedMapViewTypeInfo.ComparableComparator(true), package$.MODULE$.dataType2ExternalTypeInfo(DataTypes.LONG), new ListTypeInfo(TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(this.getValueType()))))});
        String[] fieldNames = (String[])((Object[])new String[]{"firstValue", "firstOrder", "dataMap", "sortedDataMap"});
        return new RowType(fieldTypes2, fieldNames);
    }
}

