/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog.HyperLogLogSketchHelper;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.typeutils.BinaryStringTypeInfo;

public class StreamApproximateCountDistinct {

    public static class StringApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return new TypeInfoWrappedDataType(BinaryStringTypeInfo.INSTANCE);
        }
    }

    public static class TimestampApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.TIMESTAMP;
        }
    }

    public static class TimeApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.TIME;
        }
    }

    public static class DateApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.DATE;
        }
    }

    public static class BooleanApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.BOOLEAN;
        }
    }

    public static class ShortApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.SHORT;
        }
    }

    public static class LongApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.LONG;
        }
    }

    public static class IntApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.INT;
        }
    }

    public static class FloatApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.FLOAT;
        }
    }

    public static class DoubleApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.DOUBLE;
        }
    }

    public static class DecimalApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        public final DecimalType decimalType;

        public DecimalApproximateCountDistinctAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getValueTypeInfo() {
            return this.decimalType;
        }
    }

    public static class ByteApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.BYTE;
        }
    }

    public static class HllAcc {
        public boolean oooFlag;
        public int zeroSlotNum;
        public double kxq0;
        public double kxq1;
        public double hipAccum;
        public MapView<Short, byte[]> sketch;
    }

    public static abstract class ApproximateCountDistinctAggFunction
    extends AggregateFunction<Long, HllAcc> {
        private static final long serialVersionUID = 264794740037091251L;

        public abstract DataType getValueTypeInfo();

        @Override
        public HllAcc createAccumulator() {
            HllAcc acc = new HllAcc();
            acc.oooFlag = false;
            acc.zeroSlotNum = 1 << HyperLogLogSketchHelper.LG_CONFIG_K;
            acc.kxq0 = 1 << HyperLogLogSketchHelper.LG_CONFIG_K;
            acc.kxq1 = 0.0;
            acc.hipAccum = 0.0;
            acc.sketch = new MapView(DataTypes.SHORT, DataTypes.BYTE_ARRAY);
            return acc;
        }

        public void accumulate(HllAcc acc, Object input) throws Exception {
            if (input == null) {
                return;
            }
            HyperLogLogSketchHelper.insert(acc, input);
        }

        public void merge(HllAcc acc, Iterable<HllAcc> itr) throws Exception {
            for (HllAcc sk : itr) {
                HyperLogLogSketchHelper.merge(acc, sk);
            }
        }

        @Override
        public Long getValue(HllAcc accumulator) {
            return HyperLogLogSketchHelper.getEstimate(accumulator);
        }

        @Override
        public DataType[] getUserDefinedInputTypes(Class[] signature) {
            if (signature.length == 1) {
                return new DataType[]{this.getValueTypeInfo()};
            }
            if (signature.length == 0) {
                return new DataType[0];
            }
            throw new UnsupportedOperationException();
        }
    }
}

