/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog;

import com.yahoo.sketches.hash.MurmurHash3;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.functions.aggfunctions.StreamApproximateCountDistinct;
import org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog.CompositeInterpolationXTable;
import org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog.CubicInterpolation;
import org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog.HarmonicNumbers;

public class HyperLogLogSketchHelper {
    public static final short LG_CONFIG_K = HyperLogLogSketchHelper.log2m(0.01);
    private static final int MIN_LOG_K = 4;
    private static final int CONFIG_K = 1 << LG_CONFIG_K;
    private static final int SLOTS_PER_ENTRY = 8;
    static final long DEFAULT_UPDATE_SEED = 9001L;
    static final int KEY_BITS_26 = 26;
    static final int KEY_MASK_26 = 0x3FFFFFF;

    public static void insert(StreamApproximateCountDistinct.HllAcc buffer, Object value) throws Exception {
        byte curVal;
        int coupon = HyperLogLogSketchHelper.calcCoupon(value);
        if (coupon < 0) {
            return;
        }
        int configKmask = CONFIG_K - 1;
        int slotNo = HyperLogLogSketchHelper.getLow26(coupon) & configKmask;
        short entryIdx = (short)(slotNo / 8);
        int slotIdx = slotNo % 8;
        byte newVal = HyperLogLogSketchHelper.getValue(coupon);
        assert (newVal > 0);
        byte[] bytesVal = buffer.sketch.get(entryIdx);
        if (bytesVal == null) {
            bytesVal = new byte[8];
        }
        if (newVal > (curVal = bytesVal[slotIdx])) {
            bytesVal[slotIdx] = newVal;
            buffer.sketch.put(entryIdx, bytesVal);
            HyperLogLogSketchHelper.updateHllStatistic(buffer, curVal, newVal);
        }
    }

    public static void merge(StreamApproximateCountDistinct.HllAcc buffer, StreamApproximateCountDistinct.HllAcc other) throws Exception {
        buffer.oooFlag = true;
        for (Short slot : other.sketch.keys()) {
            byte[] curVals = buffer.sketch.get(slot);
            byte[] newVals = other.sketch.get(slot);
            if (curVals == null) {
                curVals = new byte[8];
            }
            boolean updated = false;
            for (int i = 0; i < 8; ++i) {
                if (newVals[i] <= curVals[i]) continue;
                HyperLogLogSketchHelper.updateHllStatistic(buffer, curVals[i], newVals[i]);
                updated = true;
                curVals[i] = newVals[i];
            }
            if (!updated) continue;
            buffer.sketch.put(slot, curVals);
        }
        other.sketch.clear();
    }

    public static long getEstimate(StreamApproximateCountDistinct.HllAcc buffer) {
        double estimate = buffer.oooFlag ? HyperLogLogSketchHelper.hllCompositeEstimate(buffer.kxq0, buffer.kxq1, buffer.zeroSlotNum, LG_CONFIG_K) : buffer.hipAccum;
        return Math.round(estimate);
    }

    private static int calcCoupon(Object value) {
        int coupon;
        if (value instanceof Boolean) {
            byte[] data = new byte[]{(Byte)value};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((byte[])data, (long)9001L));
        } else if (value instanceof Byte) {
            byte[] data = new byte[]{(Byte)value};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((byte[])data, (long)9001L));
        } else if (value instanceof Short) {
            int[] data = new int[]{((Short)value).shortValue()};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((int[])data, (long)9001L));
        } else if (value instanceof Integer) {
            int[] data = new int[]{(Integer)value};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((int[])data, (long)9001L));
        } else if (value instanceof Long) {
            long[] data = new long[]{(Long)value};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((long[])data, (long)9001L));
        } else if (value instanceof Double) {
            value = (Double)value == 0.0 ? Double.valueOf(0.0) : value;
            long[] data = new long[]{Double.doubleToLongBits((Double)value)};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((long[])data, (long)9001L));
        } else if (value instanceof Float) {
            value = (double)((Float)value).floatValue() == 0.0 ? Float.valueOf(0.0f) : value;
            long[] data = new long[]{Double.doubleToLongBits(((Float)value).floatValue())};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((long[])data, (long)9001L));
        } else if (value instanceof BinaryString) {
            byte[] data = ((BinaryString)value).getBytes();
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((byte[])data, (long)9001L));
        } else if (value instanceof Date) {
            long[] data = new long[]{((Date)value).getTime()};
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((long[])data, (long)9001L));
        } else {
            String data = value.toString();
            if (data.length() == 0) {
                return -1;
            }
            byte[] datas = data.getBytes(StandardCharsets.UTF_8);
            coupon = HyperLogLogSketchHelper.coupon(MurmurHash3.hash((byte[])datas, (long)9001L));
        }
        return coupon;
    }

    private static int coupon(long[] hash) {
        int addr26 = (int)(hash[0] & 0x3FFFFFFL);
        int lz = Long.numberOfLeadingZeros(hash[1]);
        int value = (lz > 62 ? 62 : lz) + 1;
        return value << 26 | addr26;
    }

    private static double invPow2(int e2) {
        assert ((e2 | 1024 - e2 - 1) >= 0) : "e cannot be negative or greater than 1023: " + e2;
        return Double.longBitsToDouble(1023L - (long)e2 << 52);
    }

    private static void updateHllStatistic(StreamApproximateCountDistinct.HllAcc buffer, byte curVal, byte newVal) {
        if (curVal == 0) {
            --buffer.zeroSlotNum;
            assert (buffer.zeroSlotNum >= 0);
        }
        buffer.hipAccum += (double)CONFIG_K / (buffer.kxq0 + buffer.kxq1);
        if (curVal < 32) {
            buffer.kxq0 -= HyperLogLogSketchHelper.invPow2(curVal);
        } else {
            buffer.kxq1 -= HyperLogLogSketchHelper.invPow2(curVal);
        }
        if (newVal < 32) {
            buffer.kxq0 += HyperLogLogSketchHelper.invPow2(newVal);
        } else {
            buffer.kxq1 += HyperLogLogSketchHelper.invPow2(newVal);
        }
    }

    private static short log2m(double rsd) {
        return (short)(2.0 * Math.log(1.106 / rsd) / Math.log(2.0));
    }

    private static int getLow26(int coupon) {
        return coupon & 0x3FFFFFF;
    }

    public static byte getValue(int coupon) {
        return (byte)(coupon >>> 26);
    }

    private static double hllCompositeEstimate(double kxq0, double kxq1, int zeroBucketNum, int lgConfigK) {
        double rawEst = HyperLogLogSketchHelper.getHllRawEstimate(lgConfigK, kxq0 + kxq1);
        double[] xArr = CompositeInterpolationXTable.X_ARRS[lgConfigK - 4];
        double yStride = CompositeInterpolationXTable.Y_STRIDES[lgConfigK - 4];
        int xArrLen = xArr.length;
        if (rawEst < xArr[0]) {
            return 0.0;
        }
        int xArrLenM1 = xArrLen - 1;
        if (rawEst > xArr[xArrLenM1]) {
            double finalY = yStride * (double)xArrLenM1;
            double factor = finalY / xArr[xArrLenM1];
            return rawEst * factor;
        }
        double adjEst = CubicInterpolation.usingXArrAndYStride(xArr, yStride, rawEst);
        if (adjEst > (double)(3 << lgConfigK)) {
            return adjEst;
        }
        double linEst = HyperLogLogSketchHelper.getHllBitMapEstimate(lgConfigK, 0, zeroBucketNum);
        double avgEst = (adjEst + linEst) / 2.0;
        double crossOver = 0.64;
        if (lgConfigK == 4) {
            crossOver = 0.718;
        } else if (lgConfigK == 5) {
            crossOver = 0.672;
        }
        return avgEst > crossOver * (double)(1 << lgConfigK) ? adjEst : linEst;
    }

    private static final double getHllRawEstimate(int lgConfigK, double kxqSum) {
        int configK = 1 << lgConfigK;
        double correctionFactor = lgConfigK == 4 ? 0.673 : (lgConfigK == 5 ? 0.697 : (lgConfigK == 6 ? 0.709 : 0.7213 / (1.0 + 1.079 / (double)configK)));
        double hyperEst = correctionFactor * (double)configK * (double)configK / kxqSum;
        return hyperEst;
    }

    private static final double getHllBitMapEstimate(int lgConfigK, int curMin, int numAtCurMin) {
        int numUnhitBuckets;
        int configK = 1 << lgConfigK;
        int n = numUnhitBuckets = curMin == 0 ? numAtCurMin : 0;
        if (numUnhitBuckets == 0) {
            return (double)configK * Math.log((double)configK / 0.5);
        }
        int numHitBuckets = configK - numUnhitBuckets;
        return HarmonicNumbers.getBitMapEstimate(configK, numHitBuckets);
    }
}

