/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.core.memory.HeapMemorySegment;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.errorcode.TableErrors;
import org.apache.flink.table.util.hash.XXH64;
import scala.runtime.BoxesRunTime;

public final class XxHash64Function$ {
    public static final XxHash64Function$ MODULE$;
    private final long DEFAULT_SEED;

    static {
        new XxHash64Function$();
    }

    public long DEFAULT_SEED() {
        return this.DEFAULT_SEED;
    }

    public long hashInt(int i, long seed) {
        return XXH64.hashInt(i, seed);
    }

    public long hashLong(long l, long seed) {
        return XXH64.hashLong(l, seed);
    }

    public long hashUnsafeBytes(MemorySegment base, int offset, int length, long seed) {
        return XXH64.hashUnsafeBytes(base, offset, length, seed);
    }

    public long hash(Object value, long seed) {
        while (true) {
            Object object;
            block19: {
                long l;
                block7: {
                    block18: {
                        long l2;
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block11: {
                                                    block10: {
                                                        block9: {
                                                            block8: {
                                                                block6: {
                                                                    if ((object = value) != null) break block6;
                                                                    l = seed;
                                                                    break block7;
                                                                }
                                                                if (!(object instanceof Boolean)) break block8;
                                                                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                                                                l = this.hashInt(bl ? 1 : 0, seed);
                                                                break block7;
                                                            }
                                                            if (!(object instanceof Byte)) break block9;
                                                            byte by = BoxesRunTime.unboxToByte((Object)object);
                                                            l = this.hashInt(by, seed);
                                                            break block7;
                                                        }
                                                        if (!(object instanceof Short)) break block10;
                                                        short s = BoxesRunTime.unboxToShort((Object)object);
                                                        l = this.hashInt(s, seed);
                                                        break block7;
                                                    }
                                                    if (!(object instanceof Integer)) break block11;
                                                    int n = BoxesRunTime.unboxToInt((Object)object);
                                                    l = this.hashInt(n, seed);
                                                    break block7;
                                                }
                                                if (!(object instanceof Long)) break block12;
                                                long l3 = BoxesRunTime.unboxToLong((Object)object);
                                                l = this.hashLong(l3, seed);
                                                break block7;
                                            }
                                            if (!(object instanceof Float)) break block13;
                                            float f = BoxesRunTime.unboxToFloat((Object)object);
                                            l = this.hashInt(Float.floatToIntBits(f), seed);
                                            break block7;
                                        }
                                        if (!(object instanceof Double)) break block14;
                                        double d = BoxesRunTime.unboxToDouble((Object)object);
                                        l = this.hashLong(Double.doubleToLongBits(d), seed);
                                        break block7;
                                    }
                                    if (!(object instanceof Date)) break block15;
                                    Date date = (Date)object;
                                    l = this.hashLong(date.getTime(), seed);
                                    break block7;
                                }
                                if (!(object instanceof Time)) break block16;
                                Time time = (Time)object;
                                l = this.hashLong(time.getTime(), seed);
                                break block7;
                            }
                            if (!(object instanceof Timestamp)) break block17;
                            Timestamp timestamp = (Timestamp)object;
                            l = this.hashLong(timestamp.getTime(), seed);
                            break block7;
                        }
                        if (!(object instanceof BigDecimal)) break block18;
                        BigDecimal bigDecimal = (BigDecimal)object;
                        if (bigDecimal.precision() <= 18) {
                            l2 = this.hashLong(bigDecimal.unscaledValue().longValueExact(), seed);
                        } else {
                            byte[] bytes = bigDecimal.unscaledValue().toByteArray();
                            HeapMemorySegment hms = HeapMemorySegment.FACTORY.wrap(bytes);
                            l2 = this.hashUnsafeBytes(hms, 0, hms.size(), seed);
                        }
                        l = l2;
                        break block7;
                    }
                    if (!(object instanceof BinaryString)) break block19;
                    BinaryString binaryString = (BinaryString)object;
                    MemorySegment[] segments = binaryString.getSegments();
                    l = segments.length == 1 ? this.hashUnsafeBytes(segments[0], binaryString.getOffset(), binaryString.numBytes(), seed) : this.hashUnsafeBytes(MemorySegmentFactory.wrap(binaryString.getBytes()), 0, binaryString.numBytes(), seed);
                }
                return l;
            }
            if (!(object instanceof String)) break;
            String string = (String)object;
            value = BinaryString.fromString(string);
        }
        throw new TableException(TableErrors.INST.sqlAggExecDataTypeNotSupported("Approximate Count Distinct", value.toString()));
    }

    private XxHash64Function$() {
        MODULE$ = this;
        this.DEFAULT_SEED = 42L;
    }
}

