/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions.percentile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.api.dataview.SortedMapView;
import org.apache.flink.table.dataformat.GenericArray;
import org.apache.flink.table.runtime.functions.aggfunctions.ApproximatePercentile;

public class HistogramUtils {
    public static final double NIL = Double.NEGATIVE_INFINITY;

    public static void insertBin(ApproximatePercentile.HistogramAcc acc, double value, long height, double[] p, int maxBins) throws Exception {
        acc.percentile = new GenericArray(p, p.length, true);
        acc.maxBins = maxBins;
        acc.totalCount += height;
        Long binHeight = acc.sketch.get(value);
        if (binHeight != null) {
            long mergeHeight = binHeight + height;
            if (mergeHeight == 0L) {
                HistogramUtils.removeBin(acc.sketch, acc.intervalMap, acc.siblingMap, value);
            } else {
                acc.sketch.put(value, binHeight + height);
            }
            return;
        }
        HistogramUtils.updateAuxiliaryData(acc.sketch, acc.intervalMap, acc.siblingMap, value, height);
        ++acc.usedBins;
        if (acc.usedBins <= maxBins) {
            return;
        }
        HistogramUtils.compressBins(acc.sketch, acc.intervalMap, acc.siblingMap);
        --acc.usedBins;
    }

    public static Tuple2<Double, Long> getClosestBin(SortedMapView<Double, Long> sketch, MapView<Double, List<Double>> siblingMap, double binVal) throws Exception {
        double hitBin = binVal;
        Long binHeight = sketch.get(hitBin);
        if (binHeight != null) {
            Long l = binHeight;
            Long l2 = binHeight = Long.valueOf(binHeight - 1L);
        } else {
            Iterator<Map.Entry<Double, Long>> itr = sketch.tailEntries(hitBin).iterator();
            if (itr.hasNext()) {
                double nextEntry = itr.next().getKey();
                List<Double> nextSiblings = siblingMap.get(nextEntry);
                Double prevEntry = nextSiblings.get(0);
                hitBin = prevEntry == Double.NEGATIVE_INFINITY ? nextEntry : (hitBin - prevEntry > nextEntry - hitBin ? nextEntry : prevEntry);
                binHeight = sketch.get(hitBin) - 1L;
            } else {
                Map.Entry<Double, Long> a = sketch.lastEntry();
                if (a == null) {
                    return Tuple2.of(Double.NEGATIVE_INFINITY, 0L);
                }
                hitBin = a.getKey();
                binHeight = a.getValue() - 1L;
            }
        }
        return Tuple2.of(hitBin, binHeight);
    }

    public static void removeBin(SortedMapView<Double, Long> sketch, SortedMapView<Double, List<Double>> intervalMap, MapView<Double, List<Double>> siblingMap, double bin) throws Exception {
        sketch.remove(bin);
        List<Double> siblings = siblingMap.get(bin);
        Double prev = siblings.get(0);
        Double next = siblings.get(1);
        if (prev != Double.NEGATIVE_INFINITY) {
            HistogramUtils.updateSibling(prev, next, 1, siblingMap);
            HistogramUtils.removeIntervalEntry(bin - prev, prev, intervalMap);
        }
        if (next != Double.NEGATIVE_INFINITY) {
            HistogramUtils.updateSibling(next, prev, 0, siblingMap);
            HistogramUtils.removeIntervalEntry(next - bin, bin, intervalMap);
        }
        if (prev != Double.NEGATIVE_INFINITY && next != Double.NEGATIVE_INFINITY) {
            double interval = next - prev;
            HistogramUtils.addIntervalEntry(interval, prev, intervalMap);
        }
        siblingMap.remove(bin);
    }

    private static void updateAuxiliaryData(SortedMapView<Double, Long> sketch, SortedMapView<Double, List<Double>> intervalMap, MapView<Double, List<Double>> siblingMap, double inputVal, long height) throws Exception {
        Iterator<Map.Entry<Double, Long>> itr = sketch.tailEntries(inputVal).iterator();
        Double nextEntry = Double.NEGATIVE_INFINITY;
        Double prevEntry = Double.NEGATIVE_INFINITY;
        if (itr.hasNext()) {
            nextEntry = itr.next().getKey();
        }
        if (nextEntry == Double.NEGATIVE_INFINITY) {
            Map.Entry<Double, Long> last = sketch.lastEntry();
            Map.Entry<Double, Long> first = sketch.firstEntry();
            if (first != null && last != null) {
                prevEntry = last.getKey();
            }
        } else {
            prevEntry = siblingMap.get(nextEntry).get(0);
        }
        sketch.put(inputVal, height);
        siblingMap.put(inputVal, Arrays.asList(prevEntry, nextEntry));
        if (prevEntry != Double.NEGATIVE_INFINITY) {
            HistogramUtils.updateSibling(prevEntry, inputVal, 1, siblingMap);
            HistogramUtils.addIntervalEntry(inputVal - prevEntry, prevEntry, intervalMap);
        }
        if (nextEntry != Double.NEGATIVE_INFINITY) {
            HistogramUtils.updateSibling(nextEntry, inputVal, 0, siblingMap);
            HistogramUtils.addIntervalEntry(nextEntry - inputVal, inputVal, intervalMap);
        }
        if (prevEntry != Double.NEGATIVE_INFINITY && nextEntry != Double.NEGATIVE_INFINITY) {
            double interval = nextEntry - prevEntry;
            HistogramUtils.removeIntervalEntry(interval, prevEntry, intervalMap);
        }
    }

    private static void compressBins(SortedMapView<Double, Long> sketch, SortedMapView<Double, List<Double>> intervalMap, MapView<Double, List<Double>> siblingMap) throws Exception {
        Map.Entry<Double, List<Double>> firstEntry = intervalMap.firstEntry();
        List<Double> keysList = firstEntry.getValue();
        Double compressBin = keysList.remove(new Random().nextInt(keysList.size()));
        List<Double> siblings = siblingMap.get(compressBin);
        double prevEntry = siblings.get(0);
        double nextEntry = siblings.get(1);
        assert (nextEntry != Double.NEGATIVE_INFINITY);
        long h1 = sketch.get(compressBin);
        long h2 = sketch.get(nextEntry);
        List<Double> nextSiblings = siblingMap.get(nextEntry);
        Double nextNextEntry = nextSiblings.get(1);
        sketch.remove(compressBin);
        sketch.remove(nextEntry);
        if (keysList.isEmpty()) {
            intervalMap.remove(firstEntry.getKey());
        } else {
            intervalMap.put(firstEntry.getKey(), keysList);
        }
        siblingMap.remove(compressBin);
        siblingMap.remove(nextEntry);
        double mergedVal = (compressBin * (double)h1 + nextEntry * (double)h2) / (double)(h1 + h2);
        sketch.put(mergedVal, h1 + h2);
        if (prevEntry != Double.NEGATIVE_INFINITY) {
            HistogramUtils.removeIntervalEntry(compressBin - prevEntry, prevEntry, intervalMap);
            HistogramUtils.addIntervalEntry(mergedVal - prevEntry, prevEntry, intervalMap);
            HistogramUtils.updateSibling(prevEntry, mergedVal, 1, siblingMap);
        }
        if (nextNextEntry != Double.NEGATIVE_INFINITY) {
            HistogramUtils.removeIntervalEntry(nextNextEntry - nextEntry, nextEntry, intervalMap);
            HistogramUtils.addIntervalEntry(nextNextEntry - mergedVal, mergedVal, intervalMap);
            HistogramUtils.updateSibling(nextNextEntry, mergedVal, 0, siblingMap);
        }
        siblingMap.put(mergedVal, Arrays.asList(prevEntry, nextNextEntry));
    }

    public static Double query(SortedMapView<Double, Long> sketch, MapView<Double, List<Double>> siblingMap, long totalCnt, double percent) {
        try {
            Iterator<Map.Entry<Double, Long>> itr = sketch.iterator();
            double qSum = 0.0;
            while (itr.hasNext()) {
                Map.Entry<Double, Long> a = itr.next();
                if (!((qSum += (double)a.getValue().longValue()) / (double)totalCnt >= percent)) continue;
                double binValue = a.getKey();
                Double prev = siblingMap.get(binValue).get(0);
                if (prev == Double.NEGATIVE_INFINITY) {
                    return binValue;
                }
                return prev + (percent * (double)totalCnt - (qSum -= (double)a.getValue().longValue())) * (binValue - prev) / (double)a.getValue().longValue();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private static void updateSibling(double binVal, double newSibling, int index, MapView<Double, List<Double>> siblingMap) throws Exception {
        List<Double> siblings = siblingMap.get(binVal);
        siblings.set(index, newSibling);
        siblingMap.put(binVal, siblings);
    }

    private static void removeIntervalEntry(double interval, double binVal, SortedMapView<Double, List<Double>> intervalMap) throws Exception {
        List<Double> entries = intervalMap.get(interval);
        entries.remove(binVal);
        if (entries.isEmpty()) {
            intervalMap.remove(interval);
        } else {
            intervalMap.put(interval, entries);
        }
    }

    private static void addIntervalEntry(double interval, double binVal, SortedMapView<Double, List<Double>> intervalMap) throws Exception {
        List<Double> entries = intervalMap.get(interval);
        if (entries == null) {
            entries = new ArrayList<Double>();
        }
        entries.add(binVal);
        intervalMap.put(interval, entries);
    }

    public static double cast2Double(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).doubleValue();
        }
        if (value instanceof Short) {
            return ((Short)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        return 0.0;
    }
}

