/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.python;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.flink.table.errorcode.TableErrors;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.runtime.functions.python.PythonUDFUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonScalarFunction
extends ScalarFunction {
    private static final Logger LOG = LoggerFactory.getLogger(PythonScalarFunction.class);
    private String moduleName;
    private String funcName;
    private InternalType returnType;
    private Socket worker;
    private final int bufferSize = 8192;

    public PythonScalarFunction(String funcName, String moduleName, InternalType returnType2) {
        this.moduleName = moduleName;
        this.funcName = funcName;
        this.returnType = returnType2;
    }

    @Override
    public void open(FunctionContext context) {
        this.worker = PythonUDFUtil.createWorkerSocket(context);
    }

    public Object eval(Object ... args) {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.worker.getOutputStream(), 8192));
            PythonUDFUtil.sendCallRequest(this.moduleName, out, args);
            DataInputStream in = new DataInputStream(new BufferedInputStream(this.worker.getInputStream()));
            int protocol = in.readInt();
            assert (protocol == 1);
            int ctrlFlag = in.readInt();
            Object res = PythonUDFUtil.getResult(in);
            if (ctrlFlag == 2) {
                return res;
            }
            if (ctrlFlag == 3) {
                String err = res.toString();
                LOG.error(err);
                throw new RuntimeException(TableErrors.INST.sqlPythonUDFRunTimeError(this.funcName, this.moduleName, err));
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage());
            throw new RuntimeException(TableErrors.INST.sqlPythonUDFSocketIOError(this.funcName, this.moduleName, ioe.getMessage()), ioe);
        }
        return null;
    }

    @Override
    public void close() {
        if (this.worker != null) {
            try {
                this.worker.close();
            }
            catch (IOException e2) {
                LOG.warn(e2.getMessage());
            }
        }
    }

    @Override
    public DataType getResultType(Object[] arguments, Class[] argTypes) {
        return this.returnType;
    }

    @Override
    public String toString() {
        return this.moduleName;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }
}

