/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterators;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    public static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    public final Pattern patternKey = Pattern.compile("^([a-zA-Z0-9_\\-\\:\\s]+).*");
    public final Pattern patternIndex = Pattern.compile("\\[([0-9]+|\\*)\\]");
    public static final JsonFactory JSON_FACTORY = new JsonFactory();
    public static final ObjectMapper MAPPER;
    public static final JavaType MAP_TYPE;
    public static final JavaType LIST_TYPE;
    public static ThreadLocalHashCache<String, Object> extractObjectCache;
    public static ThreadLocalHashCache<String, String[]> pathExprCache;
    public static ThreadLocalHashCache<String, ArrayList<String>> indexListCache;
    public static ThreadLocalHashCache<String, String> mKeyGroup1Cache;
    public static ThreadLocalHashCache<String, Boolean> mKeyMatchesCache;
    private static ThreadLocal<JsonUtils> instance;
    private AddingList jsonList = new AddingList();

    public static void remove() {
        instance.remove();
    }

    public static JsonUtils getInstance() {
        if (null == instance.get()) {
            instance.set(new JsonUtils());
        }
        return instance.get();
    }

    public String getJsonObject(String jsonString, String pathString) throws Exception {
        Object extractObject;
        String[] pathExpr;
        if (jsonString == null || jsonString.isEmpty() || pathString == null || pathString.isEmpty() || pathString.charAt(0) != '$') {
            LOG.debug("jsonString is null or empty, or path is null or empty, or path is not start with '$'! jsonString: " + jsonString + ", path: " + pathString);
            return null;
        }
        String result = new String();
        int pathExprStart = 1;
        boolean isRootArray = false;
        if (pathString.length() > 1) {
            if (pathString.charAt(1) == '[') {
                pathExprStart = 0;
                isRootArray = true;
            } else if (pathString.charAt(1) == '.') {
                isRootArray = pathString.length() > 2 && pathString.charAt(2) == '[';
            } else {
                LOG.debug("path String illegal! path String: " + pathString);
                return null;
            }
        }
        if ((pathExpr = pathExprCache.get(pathString)) == null) {
            pathExpr = pathString.split("\\.", -1);
            pathExprCache.put(pathString, pathExpr);
        }
        if ((extractObject = extractObjectCache.get(jsonString)) == null) {
            JavaType javaType = isRootArray ? LIST_TYPE : MAP_TYPE;
            extractObject = MAPPER.readValue(jsonString, javaType);
            extractObjectCache.put(jsonString, extractObject);
        }
        for (int i = pathExprStart; i < pathExpr.length; ++i) {
            if (extractObject == null) {
                LOG.debug("path look up fail at: " + pathExpr[i - 1 >= 0 ? i - 1 : 0] + ", pathString: " + pathString + "json: " + jsonString);
                return null;
            }
            extractObject = this.extract(extractObject, pathExpr[i], i == pathExprStart && isRootArray);
        }
        if (extractObject instanceof Map || extractObject instanceof List) {
            result = MAPPER.writeValueAsString(extractObject);
        } else if (extractObject != null) {
            result = extractObject.toString();
        } else {
            LOG.debug("path look up fail at: " + (pathExpr.length - 1 >= 0 ? pathExpr[pathExpr.length - 1] : null) + ", pathString: " + pathString + "json: " + jsonString);
            return null;
        }
        return result;
    }

    public String[] getJsonObjectsWithoutDollar(String jsonString, String[] pathStrings) {
        if (jsonString == null || jsonString.isEmpty() || pathStrings == null || pathStrings.length == 0) {
            LOG.debug("jsonString is null or empty, or path is null or empty! jsonString: " + jsonString);
            return new String[0];
        }
        int pathExprStart = 1;
        boolean isRootArray = false;
        Object rootExtractObject = extractObjectCache.get(jsonString);
        if (rootExtractObject == null) {
            JavaType javaType = isRootArray ? LIST_TYPE : MAP_TYPE;
            try {
                rootExtractObject = MAPPER.readValue(jsonString, javaType);
            }
            catch (Exception e2) {
                LOG.debug("Exception when read json value with type :" + javaType.toString() + ", and json string: " + jsonString, (Throwable)e2);
                return new String[0];
            }
            extractObjectCache.put(jsonString, rootExtractObject);
        }
        String[] result = new String[pathStrings.length];
        for (int i = 0; i < pathStrings.length; ++i) {
            Object extractObject;
            String[] pathExpr;
            String pathString = "$." + pathStrings[i];
            if (pathString == null || pathString.length() == 0) {
                result[i] = null;
                LOG.debug(i + "th path String is null or empty! pathString: " + pathString);
                continue;
            }
            if (pathString.length() > 1) {
                if (pathString.charAt(1) == '[') {
                    pathExprStart = 0;
                    isRootArray = true;
                } else if (pathString.charAt(1) == '.') {
                    isRootArray = pathString.length() > 2 && pathString.charAt(2) == '[';
                } else {
                    result[i] = null;
                    LOG.debug(i + "th path String illegal! path String: " + pathString);
                    continue;
                }
            }
            if ((pathExpr = pathExprCache.get(pathString)) == null) {
                pathExpr = pathString.split("\\.", -1);
                pathExprCache.put(pathString, pathExpr);
            }
            if ((extractObject = rootExtractObject) == null) {
                JavaType javaType = isRootArray ? LIST_TYPE : MAP_TYPE;
                try {
                    extractObject = MAPPER.readValue(jsonString, javaType);
                }
                catch (Exception e3) {
                    LOG.debug("Exception when read json value with type :" + javaType.toString() + ", and json string: " + jsonString, (Throwable)e3);
                    result[i] = null;
                    continue;
                }
                extractObjectCache.put(jsonString, extractObject);
            }
            for (int j2 = pathExprStart; j2 < pathExpr.length; ++j2) {
                if (extractObject == null) {
                    result[i] = null;
                    LOG.debug(i + "th path look up fail at: " + pathExpr[j2 - 1 >= 0 ? j2 - 1 : 0] + ", pathString: " + pathString + "json: " + jsonString);
                    continue;
                }
                extractObject = this.extract(extractObject, pathExpr[j2], j2 == pathExprStart && isRootArray);
            }
            if (extractObject instanceof Map || extractObject instanceof List) {
                try {
                    result[i] = MAPPER.writeValueAsString(extractObject);
                }
                catch (Exception e4) {
                    LOG.debug("Exception when MAPPER.writeValueAsString :" + extractObject.toString(), (Throwable)e4);
                    result[i] = null;
                }
                continue;
            }
            if (extractObject != null) {
                result[i] = extractObject.toString();
                continue;
            }
            result[i] = null;
            LOG.debug(i + "th path look up fail at: " + (pathExpr.length - 1 >= 0 ? pathExpr[pathExpr.length - 1] : null) + ", pathString: " + pathString + "json: " + jsonString);
        }
        return result;
    }

    protected Object extract(Object json, String path, boolean skipMapProc) {
        ArrayList<String> indexList;
        if (!skipMapProc) {
            Matcher mKey = null;
            Boolean mKeyMatches = mKeyMatchesCache.get(path);
            if (mKeyMatches == null) {
                mKey = this.patternKey.matcher(path);
                mKeyMatches = mKey.matches() ? Boolean.TRUE : Boolean.FALSE;
                mKeyMatchesCache.put(path, mKeyMatches);
            }
            if (!mKeyMatches.booleanValue()) {
                return null;
            }
            String mKeyGroup1 = mKeyGroup1Cache.get(path);
            if (mKeyGroup1 == null) {
                if (mKey == null) {
                    mKey = this.patternKey.matcher(path);
                    mKeyMatches = mKey.matches() ? Boolean.TRUE : Boolean.FALSE;
                    mKeyMatchesCache.put(path, mKeyMatches);
                    if (!mKeyMatches.booleanValue()) {
                        return null;
                    }
                }
                mKeyGroup1 = mKey.group(1);
                mKeyGroup1Cache.put(path, mKeyGroup1);
            }
            json = this.extractJsonWithkey(json, mKeyGroup1);
        }
        if ((indexList = indexListCache.get(path)) == null) {
            Matcher mIndex = this.patternIndex.matcher(path);
            indexList = new ArrayList();
            while (mIndex.find()) {
                indexList.add(mIndex.group(1));
            }
            indexListCache.put(path, indexList);
        }
        if (indexList.size() > 0) {
            json = this.extractJsonWithIndex(json, indexList);
        }
        return json;
    }

    protected Object extractJsonWithIndex(Object json, ArrayList<String> indexList) {
        this.jsonList.clear();
        this.jsonList.add(json);
        AddingList tempJsonList = new AddingList();
        for (String index : indexList) {
            int targets = this.jsonList.size();
            if (index.equalsIgnoreCase("*")) {
                for (Object array2 : this.jsonList) {
                    if (!(array2 instanceof List)) continue;
                    for (int j2 = 0; j2 < ((List)array2).size(); ++j2) {
                        this.jsonList.add(((List)array2).get(j2));
                    }
                }
            } else {
                for (Object array2 : this.jsonList) {
                    List list;
                    int indexValue = Integer.parseInt(index);
                    if (!(array2 instanceof List) || indexValue >= (list = (List)array2).size()) continue;
                    tempJsonList.add(list.get(indexValue));
                }
                this.jsonList.addAll(tempJsonList);
            }
            if (this.jsonList.size() == targets) {
                return null;
            }
            this.jsonList.removeRange(0, targets);
        }
        if (this.jsonList.isEmpty()) {
            return null;
        }
        return this.jsonList.size() > 1 ? new ArrayList<Object>(this.jsonList) : this.jsonList.get(0);
    }

    protected Object extractJsonWithkey(Object json, String path) {
        if (json instanceof List) {
            ArrayList jsonArray = new ArrayList();
            for (int i = 0; i < ((List)json).size(); ++i) {
                Object jsonElem = ((List)json).get(i);
                Object jsonObj = null;
                if (!(jsonElem instanceof Map)) continue;
                jsonObj = ((Map)jsonElem).get(path);
                if (jsonObj instanceof List) {
                    for (int j2 = 0; j2 < ((List)jsonObj).size(); ++j2) {
                        jsonArray.add(((List)jsonObj).get(j2));
                    }
                    continue;
                }
                if (jsonObj == null) continue;
                jsonArray.add(jsonObj);
            }
            return jsonArray.size() == 0 ? null : jsonArray;
        }
        if (json instanceof Map) {
            return ((Map)json).get(path);
        }
        return null;
    }

    static {
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        MAPPER = new ObjectMapper(JSON_FACTORY);
        MAP_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, Object.class, Object.class);
        LIST_TYPE = TypeFactory.defaultInstance().constructRawCollectionType(List.class);
        extractObjectCache = new ThreadLocalHashCache();
        pathExprCache = new ThreadLocalHashCache();
        indexListCache = new ThreadLocalHashCache();
        mKeyGroup1Cache = new ThreadLocalHashCache();
        mKeyMatchesCache = new ThreadLocalHashCache();
        instance = new ThreadLocal();
    }

    private static class AddingList
    extends ArrayList<Object> {
        private AddingList() {
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.forArray(this.toArray());
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }

    public static class ThreadLocalHashCache<K, V> {
        private ThreadLocal<HashCache<K, V>> cache = new ThreadLocal();

        public V get(K key) {
            HashCache<K, V> m = this.cache.get();
            if (m == null) {
                m = new HashCache();
                this.cache.set(m);
            }
            return m.get(key);
        }

        public V put(K key, V value) {
            HashCache<K, V> m = this.cache.get();
            if (m == null) {
                m = new HashCache();
                this.cache.set(m);
            }
            return m.put(key, value);
        }

        public void remove() {
            this.cache.remove();
        }
    }

    public static class HashCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int CACHE_SIZE = 16;
        private static final int INIT_SIZE = 32;
        private static final float LOAD_FACTOR = 0.6f;
        private static final long serialVersionUID = 1L;

        HashCache() {
            super(32, 0.6f);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 16;
        }
    }
}

