/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5Utils {
    public static final Logger LOG = LoggerFactory.getLogger(Md5Utils.class);
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_CHAR[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_CHAR[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String md5sum(byte[] b) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(b, 0, b.length);
            return Md5Utils.toHexString(md5.digest());
        }
        catch (NoSuchAlgorithmException var3) {
            LOG.error("No such algorithm: MD5", (Throwable)var3);
            return "";
        }
    }

    public static String md5sum(String str) {
        if (str != null && !"".equals(str)) {
            byte[] b1;
            Object b = null;
            try {
                b1 = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException var5) {
                LOG.error("Unsupported encoding: UTF-8", (Throwable)var5);
                return null;
            }
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(b1, 0, b1.length);
                return Md5Utils.toHexString(md5.digest());
            }
            catch (NoSuchAlgorithmException var4) {
                LOG.error("No such algorithm: MD5", (Throwable)var4);
                return null;
            }
        }
        return "";
    }
}

