/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.utils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;

public class Murmur3Utils {
    private static final int C1_32 = -862048943;
    private static final int C2_32 = 461845907;
    private static final int R1_32 = 15;
    private static final int R2_32 = 13;
    private static final int M_32 = 5;
    private static final int N_32 = -430675100;
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final int R1 = 31;
    private static final int R2 = 27;
    private static final int M = 5;
    private static final int N1 = 1390208809;
    public static final int DEFAULT_SEED = 104729;

    public static int hash32(Object l0) {
        if (l0 instanceof Boolean) {
            long val = 0L;
            if (((Boolean)l0).booleanValue()) {
                val = 1L;
            }
            return Murmur3Utils.hash32(val);
        }
        if (l0 instanceof Float) {
            return Murmur3Utils.hash32(Float.floatToIntBits(((Float)l0).floatValue()));
        }
        if (l0 instanceof Double) {
            return Murmur3Utils.hash32(Double.doubleToLongBits((Double)l0));
        }
        if (l0 instanceof Decimal) {
            return Murmur3Utils.hash32(((Decimal)l0).toUnscaledBytes());
        }
        if (l0 instanceof Date || l0 instanceof Time || l0 instanceof Timestamp) {
            return Murmur3Utils.hash32(((Date)l0).getTime());
        }
        if (l0 instanceof BinaryString) {
            return Murmur3Utils.hash32(((BinaryString)l0).getBytes());
        }
        throw new IllegalArgumentException("MURMUR_HASH: Unsupported operand type: " + l0.getClass());
    }

    public static long hash64(Object l0) {
        if (l0 instanceof Boolean) {
            short val = 0;
            if (((Boolean)l0).booleanValue()) {
                val = 1;
            }
            return Murmur3Utils.hash64(val);
        }
        if (l0 instanceof Float) {
            return Murmur3Utils.hash64(Float.floatToIntBits(((Float)l0).floatValue()));
        }
        if (l0 instanceof Double) {
            return Murmur3Utils.hash64(Double.doubleToLongBits((Double)l0));
        }
        if (l0 instanceof Decimal) {
            return Murmur3Utils.hash64(((Decimal)l0).toUnscaledBytes());
        }
        if (l0 instanceof Date || l0 instanceof Time || l0 instanceof Timestamp) {
            return Murmur3Utils.hash64(((Date)l0).getTime());
        }
        if (l0 instanceof BinaryString) {
            return Murmur3Utils.hash64(((BinaryString)l0).getBytes());
        }
        throw new IllegalArgumentException("MURMUR_HASH: Unsupported operand type: " + l0.getClass());
    }

    public static int hash32(long l0) {
        return Murmur3Utils.hash32(l0, 104729);
    }

    public static int hash32(long l0, int seed) {
        int hash = seed;
        long r0 = Long.reverseBytes(l0);
        hash = Murmur3Utils.mix32((int)r0, hash);
        hash = Murmur3Utils.mix32((int)(r0 >>> 32), hash);
        return Murmur3Utils.fmix32(8, hash);
    }

    public static int hash32(byte[] data) {
        return Murmur3Utils.hash32(data, 0, data.length, 104729);
    }

    public static int hash32(byte[] data, int length) {
        return Murmur3Utils.hash32(data, 0, length, 104729);
    }

    public static int hash32(byte[] data, int length, int seed) {
        return Murmur3Utils.hash32(data, 0, length, seed);
    }

    public static int hash32(byte[] data, int offset, int length, int seed) {
        int hash = seed;
        int nblocks = length >> 2;
        for (int i = 0; i < nblocks; ++i) {
            int i4 = i << 2;
            int k = data[offset + i4] & 0xFF | (data[offset + i4 + 1] & 0xFF) << 8 | (data[offset + i4 + 2] & 0xFF) << 16 | (data[offset + i4 + 3] & 0xFF) << 24;
            hash = Murmur3Utils.mix32(k, hash);
        }
        int idx = nblocks << 2;
        int k1 = 0;
        int tailLen = length - idx;
        if (tailLen > 2) {
            k1 ^= data[offset + idx + 2] << 16;
        }
        if (tailLen > 1) {
            k1 ^= data[offset + idx + 1] << 8;
        }
        if (tailLen > 0) {
            k1 ^= data[offset + idx];
            k1 *= -862048943;
            k1 = Integer.rotateLeft(k1, 15);
            hash ^= (k1 *= 461845907);
        }
        return Murmur3Utils.fmix32(length, hash);
    }

    private static int mix32(int k, int hash) {
        k *= -862048943;
        k = Integer.rotateLeft(k, 15);
        return Integer.rotateLeft(hash ^= (k *= 461845907), 13) * 5 + -430675100;
    }

    private static int fmix32(int length, int hash) {
        hash ^= length;
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return hash;
    }

    public static long hash64(byte[] data) {
        return Murmur3Utils.hash64(data, 0, data.length, 104729);
    }

    public static long hash64(long data) {
        long hash = 104729L;
        long k = Long.reverseBytes(data);
        int length = 8;
        k *= -8663945395140668459L;
        k = Long.rotateLeft(k, 31);
        hash ^= (k *= 5545529020109919103L);
        hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
        hash ^= (long)length;
        hash = Murmur3Utils.fmix64(hash);
        return hash;
    }

    public static long hash64(int data) {
        long k1 = (long)Integer.reverseBytes(data) & 0xFFFFFFFFL;
        int length = 4;
        long hash = 104729L;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        hash ^= (k1 *= 5545529020109919103L);
        hash ^= (long)length;
        hash = Murmur3Utils.fmix64(hash);
        return hash;
    }

    public static long hash64(short data) {
        long hash = 104729L;
        long k1 = 0L;
        k1 ^= ((long)data & 0xFFL) << 8;
        k1 ^= (long)((data & 0xFF00) >> 8) & 0xFFL;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        hash ^= (k1 *= 5545529020109919103L);
        hash ^= 2L;
        hash = Murmur3Utils.fmix64(hash);
        return hash;
    }

    public static long hash64(byte[] data, int offset, int length) {
        return Murmur3Utils.hash64(data, offset, length, 104729);
    }

    public static long hash64(byte[] data, int offset, int length, int seed) {
        long hash = seed;
        int nblocks = length >> 3;
        for (int i = 0; i < nblocks; ++i) {
            int i8 = i << 3;
            long k = (long)data[offset + i8] & 0xFFL | ((long)data[offset + i8 + 1] & 0xFFL) << 8 | ((long)data[offset + i8 + 2] & 0xFFL) << 16 | ((long)data[offset + i8 + 3] & 0xFFL) << 24 | ((long)data[offset + i8 + 4] & 0xFFL) << 32 | ((long)data[offset + i8 + 5] & 0xFFL) << 40 | ((long)data[offset + i8 + 6] & 0xFFL) << 48 | ((long)data[offset + i8 + 7] & 0xFFL) << 56;
            k *= -8663945395140668459L;
            k = Long.rotateLeft(k, 31);
            hash ^= (k *= 5545529020109919103L);
            hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
        }
        long k1 = 0L;
        int tailStart = nblocks << 3;
        int tailLen = length - tailStart;
        if (tailLen > 6) {
            k1 ^= ((long)data[offset + tailStart + 6] & 0xFFL) << 48;
        }
        if (tailLen > 5) {
            k1 ^= ((long)data[offset + tailStart + 5] & 0xFFL) << 40;
        }
        if (tailLen > 4) {
            k1 ^= ((long)data[offset + tailStart + 4] & 0xFFL) << 32;
        }
        if (tailLen > 3) {
            k1 ^= ((long)data[offset + tailStart + 3] & 0xFFL) << 24;
        }
        if (tailLen > 2) {
            k1 ^= ((long)data[offset + tailStart + 2] & 0xFFL) << 16;
        }
        if (tailLen > 1) {
            k1 ^= ((long)data[offset + tailStart + 1] & 0xFFL) << 8;
        }
        if (tailLen > 0) {
            k1 ^= (long)data[offset + tailStart] & 0xFFL;
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= 5545529020109919103L);
        }
        hash ^= (long)length;
        hash = Murmur3Utils.fmix64(hash);
        return hash;
    }

    private static long fmix64(long h) {
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return h;
    }
}

