/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.runtime.functions.ThreadLocalCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseUrlUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ParseUrlUtils.class);
    public static ThreadLocalCache urlCache = new ThreadLocalCache<String, URL>(64){

        @Override
        public URL getNewInstance(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException e2) {
                throw new RuntimeException(e2);
            }
        }
    };

    public static String parseUrl(String urlStr, String partToExtract) {
        if (urlStr == null || partToExtract == null) {
            return null;
        }
        URL url = (URL)urlCache.get(urlStr);
        if ("HOST".equals(partToExtract)) {
            return url.getHost();
        }
        if ("PATH".equals(partToExtract)) {
            return url.getPath();
        }
        if ("QUERY".equals(partToExtract)) {
            return url.getQuery();
        }
        if ("REF".equals(partToExtract)) {
            return url.getRef();
        }
        if ("PROTOCOL".equals(partToExtract)) {
            return url.getProtocol();
        }
        if ("FILE".equals(partToExtract)) {
            return url.getFile();
        }
        if ("AUTHORITY".equals(partToExtract)) {
            return url.getAuthority();
        }
        if ("USERINFO".equals(partToExtract)) {
            return url.getUserInfo();
        }
        return null;
    }

    public static String parseUrl(String urlStr, String partToExtract, String key) {
        if (!"QUERY".equals(partToExtract)) {
            return null;
        }
        String query = ParseUrlUtils.parseUrl(urlStr, partToExtract);
        if (query == null) {
            return null;
        }
        Pattern p = Pattern.compile("(&|^)" + Pattern.quote(key) + "=([^&]*)");
        Matcher m = p.matcher(query);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }
}

