/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.plan.FlinkJoinRelType;
import org.apache.flink.table.runtime.join.TimeBoundedStreamJoin;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0005=\u0011\u0001DU8x)&lWMQ8v]\u0012,Gm\u0015;sK\u0006l'j\\5o\u0015\t\u0019A!\u0001\u0003k_&t'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0016)&lWMQ8v]\u0012,Gm\u0015;sK\u0006l'j\\5o\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u00036pS:$\u0016\u0010]3\u0011\u0005]QR\"\u0001\r\u000b\u0005e1\u0011\u0001\u00029mC:L!a\u0007\r\u0003!\u0019c\u0017N\\6K_&t'+\u001a7UsB,\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001d1,g\r\u001e'po\u0016\u0014(i\\;oIB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t!Aj\u001c8h\u0011!)\u0003A!A!\u0002\u0013q\u0012A\u00047fMR,\u0006\u000f]3s\u0005>,h\u000e\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005=\u0005y\u0011\r\u001c7po\u0016$G*\u0019;f]\u0016\u001c8\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003!aWM\u001a;UsB,\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0007\u0003%!\u0018\u0010]3vi&d7/\u0003\u00020Y\ty!)Y:f%><H+\u001f9f\u0013:4w\u000e\u0003\u00052\u0001\t\u0005\t\u0015!\u0003+\u0003%\u0011\u0018n\u001a5u)f\u0004X\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003=9WM\u001c&pS:4UO\\2OC6,\u0007CA\u001b9\u001d\tyb'\u0003\u00028A\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9\u0004\u0005\u0003\u0005=\u0001\t\u0005\t\u0015!\u00035\u0003=9WM\u001c&pS:4UO\\2D_\u0012,\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002\u00171,g\r\u001e+j[\u0016LE\r\u001f\t\u0003?\u0001K!!\u0011\u0011\u0003\u0007%sG\u000f\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003@\u00031\u0011\u0018n\u001a5u)&lW-\u00133y\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}QYq\tS%K\u00172kej\u0014)R!\t\t\u0002\u0001C\u0003\u0016\t\u0002\u0007a\u0003C\u0003\u001e\t\u0002\u0007a\u0004C\u0003&\t\u0002\u0007a\u0004C\u0003(\t\u0002\u0007a\u0004C\u0003*\t\u0002\u0007!\u0006C\u00032\t\u0002\u0007!\u0006C\u00034\t\u0002\u0007A\u0007C\u0003=\t\u0002\u0007A\u0007C\u0003?\t\u0002\u0007q\bC\u0003D\t\u0002\u0007q\bC\u0003T\u0001\u0011\u0005A+A\thKRl\u0015\r_(viB,H\u000fR3mCf,\u0012A\b\u0005\u0006-\u0002!\teV\u0001\u0013kB$\u0017\r^3Pa\u0016\u0014\u0018\r^8s)&lW\r\u0006\u0002Y7B\u0011q$W\u0005\u00035\u0002\u0012A!\u00168ji\")A,\u0016a\u0001;\u0006\u00191\r\u001e=\u0011\u0005y\u0003\b#B0iU*TW\"\u00011\u000b\u0005\u0005\u0014\u0017AA2p\u0015\t\u0019G-A\u0005gk:\u001cG/[8og*\u0011QMZ\u0001\u0004CBL'BA4\t\u0003%\u0019HO]3b[&tw-\u0003\u0002jA\n\t2i\u001c)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u0011\u0005-tW\"\u00017\u000b\u000554\u0011A\u00033bi\u00064wN]7bi&\u0011q\u000e\u001c\u0002\b\u0005\u0006\u001cXMU8x\u0013\t\t\bNA\u0004D_:$X\r\u001f;\t\u000bM\u0004A\u0011\t;\u0002)\u001d,G\u000fV5nK\u001a{'\u000fT3giN#(/Z1n)\rqRO\u001e\u0005\u00069J\u0004\r!\u0018\u0005\u0006oJ\u0004\rA[\u0001\u0004e><\b\"B=\u0001\t\u0003R\u0018!F4fiRKW.\u001a$peJKw\r\u001b;TiJ,\u0017-\u001c\u000b\u0004=md\b\"\u0002/y\u0001\u0004i\u0006\"B<y\u0001\u0004Q\u0007\"\u0002@\u0001\t\u0003z\u0018!\u0004:fO&\u001cH/\u001a:US6,'\u000fF\u0003Y\u0003\u0003\t\u0019\u0001C\u0003]{\u0002\u0007Q\f\u0003\u0004\u0002\u0006u\u0004\rAH\u0001\fG2,\u0017M\\;q)&lW\r")
public final class RowTimeBoundedStreamJoin
extends TimeBoundedStreamJoin {
    private final long allowedLateness;
    private final int leftTimeIdx;
    private final int rightTimeIdx;

    public long getMaxOutputDelay() {
        return Math.max(this.leftRelativeSize(), this.rightRelativeSize()) + this.allowedLateness;
    }

    @Override
    public void updateOperatorTime(CoProcessFunction.Context ctx) {
        this.leftOperatorTime_$eq(ctx.timerService().currentWatermark() > 0L ? ctx.timerService().currentWatermark() : 0L);
        this.rightOperatorTime_$eq(this.leftOperatorTime());
    }

    @Override
    public long getTimeForLeftStream(CoProcessFunction.Context ctx, BaseRow row2) {
        return row2.getLong(this.leftTimeIdx);
    }

    @Override
    public long getTimeForRightStream(CoProcessFunction.Context ctx, BaseRow row2) {
        return row2.getLong(this.rightTimeIdx);
    }

    @Override
    public void registerTimer(CoProcessFunction.Context ctx, long cleanupTime) {
        ctx.timerService().registerEventTimeTimer(cleanupTime);
    }

    public RowTimeBoundedStreamJoin(FlinkJoinRelType joinType, long leftLowerBound, long leftUpperBound, long allowedLateness, BaseRowTypeInfo leftType, BaseRowTypeInfo rightType, String genJoinFuncName, String genJoinFuncCode, int leftTimeIdx, int rightTimeIdx) {
        this.allowedLateness = allowedLateness;
        this.leftTimeIdx = leftTimeIdx;
        this.rightTimeIdx = rightTimeIdx;
        super(joinType, leftLowerBound, leftUpperBound, allowedLateness, leftType, rightType, genJoinFuncName, genJoinFuncCode);
    }
}

